/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.repairinguser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.blok.common.core.CurrentProxyFactory;
import ru.blok.common.core.InitializedVariable;
import ru.infor.beanviewer.core.UIFactory;
import ru.infor.beanviewer.viewer.DefaultTableCellViewer;
import ru.infor.beanviewer.viewer.simple.BaseDirectoryViewer;
import ru.infor.client.soap.proxy.vms.RepairingUser2GroupLinkWSProxy;
import ru.infor.ws.objects.core.entities.RightsOwner;
import ru.infor.ws.objects.vms.entities.RepairingUser2GroupLink;

public class RepairingUserViewer<T>
extends BaseDirectoryViewer<T> {
    private static Map<RightsOwner, String> map = new HashMap<RightsOwner, String>();

    public Class getTableCellViewerClass() {
        return UsersAndGroupViewerCellViewer.class;
    }

    public RepairingUserViewer(UIFactory<T> factory) {
        super(factory);
        map.clear();
        RepairingUser2GroupLinkWSProxy proxy = (RepairingUser2GroupLinkWSProxy)CurrentProxyFactory.getProxy(RepairingUser2GroupLink.class);
        RightsOwner[] list = proxy.getRepairingUserList(InitializedVariable.context);
        if (list != null && list.length > 0) {
            RightsOwner[] rightsOwnerArray = list;
            int n = list.length;
            int n2 = 0;
            while (n2 < n) {
                RightsOwner rightsOwner = rightsOwnerArray[n2];
                map.put(rightsOwner, rightsOwner.getName());
                ++n2;
            }
        }
    }

    protected List<?> getDirectoryItems() {
        ArrayList<String> listOut = new ArrayList<String>(map.values());
        Collections.sort(listOut);
        return listOut;
    }

    public Object getValue() {
        String s = (String)super.getValue();
        for (RightsOwner i : map.keySet()) {
            if (!map.get(i).equals(s)) continue;
            return i;
        }
        return null;
    }

    public void setValue(Object object) {
        if (object == null) {
            super.setValue(null);
            return;
        }
        super.setValue((Object)map.get(object));
    }

    public static class UsersAndGroupViewerCellViewer<T>
    extends DefaultTableCellViewer<T> {
        public UsersAndGroupViewerCellViewer(UIFactory<T> factory) {
            super(factory);
        }

        public Object getValue() {
            return super.getValue();
        }

        public void setValue(Object object) {
            super.setValue(map.get(object));
        }
    }
}

