/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.roadmaintenancebylot;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import ru.blok.common.core.CurrentProxyFactory;
import ru.blok.common.core.InitializedVariable;
import ru.blok.common.core.ResourceStrings;
import ru.infor.beanviewer.dialog.MessageCancelButton;
import ru.infor.beanviewer.dialog.MessageOKButton;
import ru.infor.beanviewer.dialog.WarningMessage;
import ru.infor.beanviewer.viewer.BeanViewerAction;
import ru.infor.beanviewer.viewer.action.PanelContext;
import ru.infor.beanviewer.viewer.action.ViewerContext;
import ru.infor.client.soap.proxy.vms.RoadJobKindWSProxy;
import ru.infor.ws.objects.vms.entities.DeviceParameterNames;
import ru.infor.ws.objects.vms.entities.RoadJobKind;
import ru.infor.ws.objects.vms.entities.RoadMaintenanceByLot;
import ru.infor.ws.proxy.interfaces.InvocationContext;

public class ExportButtonRoadMaintenanceByLot
extends BeanViewerAction<ViewerContext> {
    RoadJobKindWSProxy roadJobKindWSProxy = (RoadJobKindWSProxy)CurrentProxyFactory.getProxy(RoadJobKind.class);
    static final String dpnSeparator = "~#";

    public void actionPerformed(Object arg0) {
        List listImportSelect = ((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getPanel().getPresentatorForName("items").getSelectedItems();
        if (listImportSelect == null || listImportSelect.isEmpty()) {
            InitializedVariable.factory.runMessageEx((Object)new WarningMessage(" \u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d\u043e \u043d\u0438 \u043e\u0434\u043d\u043e\u0433\u043e \u0437\u0430\u0434\u0430\u043d\u0438\u044f. "), new BeanViewerAction[]{new MessageOKButton()});
            return;
        }
        FileFilter ff = new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                return f.getName().endsWith(".csv");
            }

            @Override
            public String getDescription() {
                return null;
            }
        };
        ((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getPanel().updateMainObject();
        JFileChooser jfc = new JFileChooser();
        jfc.setMultiSelectionEnabled(false);
        jfc.setFileSelectionMode(0);
        jfc.setFileFilter(ff);
        File file = null;
        String fileName = null;
        if (jfc.showDialog(null, "\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u0444\u0430\u0439\u043b \u043a\u0430\u043a") == 0) {
            file = jfc.getSelectedFile();
            if (file != null) {
                fileName = file.getAbsolutePath();
            } else {
                return;
            }
        }
        if (fileName != null) {
            String ext = ExportButtonRoadMaintenanceByLot.getFileExtention(file.getAbsolutePath());
            if ("".equals(ext)) {
                fileName = String.valueOf(fileName) + ".csv";
                file = new File(fileName);
            }
            if (file.exists()) {
                String msg = "   \u0424\u0430\u0439\u043b \u0441 \u0438\u043c\u0435\u043d\u0435\u043c \"" + file.getName() + "\" \u0443\u0436\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442. \u041f\u0435\u0440\u0435\u0437\u0430\u043f\u0438\u0441\u0430\u0442\u044c \u0435\u0433\u043e?   ";
                if (InitializedVariable.getFactory((String)((ViewerContext)this.getContext()).getKeyPage()).runMessage("\u0418\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f", msg, new BeanViewerAction[]{new MessageOKButton(), new MessageCancelButton()}) != 0) {
                    return;
                }
            }
            ArrayList<String> strOut = new ArrayList<String>();
            int i = 0;
            while (i < listImportSelect.size()) {
                RoadMaintenanceByLot r = (RoadMaintenanceByLot)listImportSelect.get(i);
                RoadJobKind jobKind = null;
                if (r.getJobKind() != null) {
                    jobKind = (RoadJobKind)this.roadJobKindWSProxy._universalGetCurrentObject((InvocationContext)InitializedVariable.context, r.getJobKind().getId());
                }
                String str = String.valueOf(r.getStartAt() != null ? new SimpleDateFormat("dd.MM.yyyy").format(r.getStartAt()) : "null") + "\t" + (r.getEndAt() != null ? new SimpleDateFormat("dd.MM.yyyy").format(r.getEndAt()) : "null") + "\t" + r.getQuantity() + "\t" + (r.getLot() != null ? r.getLot().getCode() : "null") + "\t" + (r.getLot() != null ? r.getLot().getDescription() : "null") + "\t" + (r.getLot() != null && r.getLot().getBeginDate() != null ? new SimpleDateFormat("dd.MM.yyyy").format(r.getLot().getBeginDate()) : "null") + "\t" + (r.getLot() != null && r.getLot().getEndDate() != null ? new SimpleDateFormat("dd.MM.yyyy").format(r.getLot().getEndDate()) : "null") + "\t" + (r.getLot() != null && r.getLot().getContractor() != null ? r.getLot().getContractor().getName() : "null") + "\t" + (jobKind != null ? jobKind.getCode() : "null") + "\t" + (jobKind != null ? jobKind.getDescription() : "null") + "\t" + (jobKind != null ? Integer.valueOf(jobKind.getColor()) : "null") + "\t" + (jobKind != null ? Double.valueOf(jobKind.getKoof()) : "null") + "\t" + (jobKind != null ? Double.valueOf(jobKind.getMinSpeed()) : "null") + "\t" + (jobKind != null ? Double.valueOf(jobKind.getMaxSpeed()) : "null") + "\t" + (jobKind != null && jobKind.getUnit() != null ? jobKind.getUnit().getCode() : "null") + "\t" + (jobKind != null && jobKind.getUnit() != null ? jobKind.getUnit().getDescription() : "null");
                if (jobKind != null) {
                    DeviceParameterNames[] m = jobKind.getParameterNamesList();
                    if (m != null && m.length > 0) {
                        String spar = "\t";
                        DeviceParameterNames[] deviceParameterNamesArray = m;
                        int n = m.length;
                        int n2 = 0;
                        while (n2 < n) {
                            DeviceParameterNames dpm = deviceParameterNamesArray[n2];
                            spar = String.valueOf(spar) + dpm.getCode() + dpnSeparator + dpm.getDescription() + dpnSeparator + dpm.getColor() + dpnSeparator;
                            ++n2;
                        }
                        str = String.valueOf(str) + spar;
                    } else {
                        str = String.valueOf(str) + "\tnull";
                    }
                } else {
                    str = String.valueOf(str) + "\tnull";
                }
                strOut.add(str);
                ++i;
            }
            this.StringsSaveToFile(strOut, file);
        }
    }

    private static String getFileExtention(String fullPath) {
        int sepPos = fullPath.lastIndexOf(File.separator);
        String nameAndExt = fullPath.substring(sepPos + 1, fullPath.length());
        int dotPos = nameAndExt.lastIndexOf(".");
        return dotPos != -1 ? nameAndExt.substring(dotPos + 1) : "";
    }

    private void StringsSaveToFile(ArrayList<String> strings, File fileOut) {
        String line_separator = System.getProperty("line.separator");
        BufferedWriter outputStream = null;
        try {
            try {
                outputStream = new BufferedWriter(new FileWriter(fileOut, false));
                for (String sline : strings) {
                    outputStream.write(String.valueOf(sline) + line_separator);
                }
            }
            finally {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getHint() {
        return "\u042d\u043a\u0441\u043f\u043e\u0440\u0442";
    }

    public String getIcon() {
        return ResourceStrings.btExportXML;
    }

    public boolean isNotEnableWithEmptySelection() {
        return true;
    }
}

