/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.roadmaintenancebylot;

import java.util.Calendar;
import java.util.Date;
import ru.blok.common.core.CurrentProxyFactory;
import ru.blok.common.core.InitializedVariable;
import ru.blok.common.ui.buttons.OkWithSave;
import ru.infor.beanviewer.dialog.InfoMessage;
import ru.infor.beanviewer.dialog.MessageOKButton;
import ru.infor.beanviewer.viewer.BeanViewerAction;
import ru.infor.beanviewer.viewer.action.PanelContext;
import ru.infor.client.soap.proxy.vms.RoadMaintenanceByLotWSProxy;
import ru.infor.ws.objects.vms.RoadMaintenanceByLotSearchCriteria;
import ru.infor.ws.objects.vms.entities.RoadMaintenanceByLot;

public class OkWithSaveRoadMaintenanceByLot
extends OkWithSave {
    public void actionPerformed(Object message) {
        ((PanelContext)this.getContext()).getPanel().stopCellEditor();
        ((PanelContext)this.getContext()).getPanel().updateMainObject();
        RoadMaintenanceByLot roadMaintenanceByLot = (RoadMaintenanceByLot)this.getObject();
        if (OkWithSaveRoadMaintenanceByLot.checkLotPeriodError(roadMaintenanceByLot)) {
            InitializedVariable.factory.runMessageEx((Object)new InfoMessage(" Info ", new String[]{" \u041d\u0435\u043b\u044c\u0437\u044f \u043d\u0430\u0437\u043d\u0430\u0447\u0438\u0442\u044c \u0440\u0430\u0431\u043e\u0442\u0443 \u0441 \u043f\u0435\u0440\u0438\u043e\u0434\u043e\u043c \u0437\u0430 \u043f\u0440\u0435\u0434\u0435\u043b\u0430\u043c\u0438 \u0432\u0440\u0435\u043c\u0435\u043d\u0438 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f \u043b\u043e\u0442\u0430! "}), new BeanViewerAction[]{new MessageOKButton()});
            return;
        }
        if (OkWithSaveRoadMaintenanceByLot.checkRmblError(roadMaintenanceByLot)) {
            InitializedVariable.factory.runMessageEx((Object)new InfoMessage(" Info ", new String[]{" \u041d\u0435\u043b\u044c\u0437\u044f \u0434\u043b\u044f \u043e\u0434\u043d\u043e\u0433\u043e \u043b\u043e\u0442\u0430 \u043d\u0430\u0437\u043d\u0430\u0447\u0438\u0442\u044c \u043e\u0434\u043d\u0443 \u0438 \u0442\u0443 \u0436\u0435 \u0440\u0430\u0431\u043e\u0442\u0443 \u0432 \u043e\u0434\u0438\u043d \u0438 \u0442\u043e\u0442 \u0436\u0435 \u043f\u0435\u0440\u0438\u043e\u0434! "}), new BeanViewerAction[]{new MessageOKButton()});
            return;
        }
        this.update(roadMaintenanceByLot);
        this.close();
    }

    protected static boolean checkLotPeriodError(RoadMaintenanceByLot r) {
        return !OkWithSaveRoadMaintenanceByLot.getCrossPeriod(r.getStartAt(), r.getEndAt(), r.getLot().getBeginDate(), r.getLot().getEndDate());
    }

    protected static boolean checkRmblError(RoadMaintenanceByLot r) {
        boolean error = false;
        RoadMaintenanceByLotWSProxy roadMaintenanceByLotWSProxy = (RoadMaintenanceByLotWSProxy)CurrentProxyFactory.getProxy(RoadMaintenanceByLot.class);
        RoadMaintenanceByLotSearchCriteria sc = new RoadMaintenanceByLotSearchCriteria();
        sc.setCount(Integer.valueOf(Integer.MAX_VALUE));
        sc.setLotIdList(new Long[]{r.getLot().getId()});
        sc.setJobKindIdList(new Long[]{r.getJobKind().getId()});
        RoadMaintenanceByLotWSProxy.SearchResultListRoadMaintenanceByLot srList = roadMaintenanceByLotWSProxy.getList(InitializedVariable.context, sc);
        if (!srList.isEmpty()) {
            int i = 0;
            while (i < srList.getObjList().length) {
                RoadMaintenanceByLot re = (RoadMaintenanceByLot)srList.getObjList()[i];
                if (!re.getId().equals(r.getId())) {
                    error = error || OkWithSaveRoadMaintenanceByLot.getCrossPeriod(r.getStartAt(), r.getEndAt(), re.getStartAt(), re.getEndAt());
                }
                ++i;
            }
        }
        return error;
    }

    protected static boolean getCrossPeriod(Date start1, Date finish1, Date start2, Date finish2) {
        start1 = OkWithSaveRoadMaintenanceByLot.beginOfDay(start1);
        finish1 = OkWithSaveRoadMaintenanceByLot.beginOfDay(finish1);
        start2 = OkWithSaveRoadMaintenanceByLot.beginOfDay(start2);
        finish2 = OkWithSaveRoadMaintenanceByLot.beginOfDay(finish2);
        return start1.compareTo(start2) <= 0 && start2.compareTo(finish1) <= 0 || start1.compareTo(finish2) <= 0 && finish2.compareTo(finish1) <= 0 || start2.compareTo(start1) <= 0 && start1.compareTo(finish2) <= 0 || start2.compareTo(finish1) <= 0 && finish1.compareTo(finish2) <= 0;
    }

    private static Date beginOfDay(Date date) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return new Date(calendar.getTime().getTime());
    }
}

