/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.roadmaintenancebylot;

import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.persistence.ManyToOne;
import ru.blok.common.core.CurrentProxyFactory;
import ru.blok.common.core.InitializedVariable;
import ru.blok.common.ui.importutils.Object4Import;
import ru.infor.beanviewer.annotation.ActionViewer;
import ru.infor.beanviewer.annotation.ListView;
import ru.infor.beanviewer.annotation.View;
import ru.infor.beanviewer.viewer.action.PanelContext;
import ru.infor.client.soap.proxy.core.UsersGroupWSProxy;
import ru.infor.ws.objects.core.UsersGroupSearchCriteria;
import ru.infor.ws.objects.core.entities.UsersGroup;
import ru.infor.ws.objects.vms.entities.DeviceParameterNames;
import ru.infor.ws.objects.vms.entities.Lot;
import ru.infor.ws.objects.vms.entities.MeasurementUnits;
import ru.infor.ws.objects.vms.entities.RoadJobKind;
import ru.infor.ws.objects.vms.entities.RoadMaintenanceByLot;

@ListView(views={@View(title="\u0418\u043c\u043f\u043e\u0440\u0442\u0438\u0440\u0443\u0435\u043c\u044b\u0435 \u0437\u0430\u0434\u0430\u043d\u0438\u044f", keyView="", layoutKeys={"tabSplitPercentLayoutManager"}, actions={@ActionViewer(clazz=PanelContext.CancelButton.class)}), @View(title="\u0418\u043c\u043f\u043e\u0440\u0442\u0438\u0440\u0443\u0435\u043c\u044b\u0435 \u0437\u0430\u0434\u0430\u043d\u0438\u044f", keyView="list", layoutKeys={"tabSplitPercentLayoutManager"}, actions={@ActionViewer(clazz=PanelContext.CancelButton.class)})})
public class RoadMaintenanceByLot4Import
implements Object4Import {
    private static final int fieldsCount = 17;
    private RoadMaintenanceByLot roadMaintenanceByLot = new RoadMaintenanceByLot();
    private ArrayList<String> errors = new ArrayList();
    private String status = "";
    private String res = "";
    private ArrayList<String> warnings = new ArrayList();

    public RoadMaintenanceByLot getRoadMaintenanceByLot() {
        return this.roadMaintenanceByLot;
    }

    public ArrayList<String> getWarnings() {
        return this.warnings;
    }

    public void setWarnings(ArrayList<String> warnings) {
        this.warnings = warnings;
    }

    public int getWarningsCount() {
        return this.warnings != null ? this.warnings.size() : 0;
    }

    public void addWarnings(String warning) {
        this.warnings.add(warning);
    }

    public Date getStartAt() {
        return this.roadMaintenanceByLot.getStartAt();
    }

    public void setStartAt(Date startDateTime) {
        this.roadMaintenanceByLot.setStartAt(startDateTime);
    }

    public Date getEndAt() {
        return this.roadMaintenanceByLot.getEndAt();
    }

    public void setEndAt(Date endDateTime) {
        this.roadMaintenanceByLot.setEndAt(endDateTime);
    }

    @ManyToOne
    public Lot getLot() {
        return this.roadMaintenanceByLot.getLot();
    }

    public void setLot(Lot lot) {
        this.roadMaintenanceByLot.setLot(lot);
    }

    @ManyToOne
    public RoadJobKind getJobKind() {
        return this.roadMaintenanceByLot.getJobKind();
    }

    public void setJobKind(RoadJobKind jobKind) {
        this.roadMaintenanceByLot.setJobKind(jobKind);
    }

    public Double getQuantity() {
        return this.roadMaintenanceByLot.getQuantity();
    }

    public void setQuantity(Double quantity) {
        this.roadMaintenanceByLot.setQuantity(quantity);
    }

    public String getErrorExtension() {
        String errorExtension = "";
        int i = 0;
        while (i < this.errors.size()) {
            errorExtension = String.valueOf(errorExtension) + (i == 0 ? "" : "\n") + (i + 1) + ". " + this.errors.get(i);
            ++i;
        }
        return errorExtension;
    }

    public ArrayList<String> getErrors() {
        return this.errors;
    }

    public void setErrors(ArrayList<String> errors) {
        this.errors = errors;
    }

    public void addErrors(String err) {
        this.errors.add(err);
    }

    public int getErrCount() {
        return this.errors != null ? this.errors.size() : 0;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getRes() {
        return this.res;
    }

    public void setRes(String res) {
        this.res = res;
    }

    public static RoadMaintenanceByLot4Import parse(String line) {
        if (line != null && line != "") {
            String[] sfields = line.split("\t");
            RoadMaintenanceByLot4Import r = new RoadMaintenanceByLot4Import();
            if (sfields.length >= 17) {
                DecimalFormatSymbols dcSymbols = new DecimalFormatSymbols();
                char dc = dcSymbols.getDecimalSeparator();
                char newdc = '.' == dc ? (char)',' : '.';
                Lot lot = new Lot();
                RoadJobKind job = new RoadJobKind();
                MeasurementUnits munit = new MeasurementUnits();
                int i = 0;
                while (i < 17) {
                    String sfield = sfields[i];
                    switch (i) {
                        case 0: {
                            Date date = null;
                            if (!"null".equals(sfield)) {
                                try {
                                    date = new SimpleDateFormat("dd.MM.yyyy").parse(sfield);
                                }
                                catch (ParseException e) {
                                    e.printStackTrace();
                                }
                            }
                            r.setStartAt(date);
                            break;
                        }
                        case 1: {
                            Date date = null;
                            if (!"null".equals(sfield)) {
                                try {
                                    date = new SimpleDateFormat("dd.MM.yyyy").parse(sfield);
                                }
                                catch (ParseException e) {
                                    e.printStackTrace();
                                }
                            }
                            r.setEndAt(date);
                            break;
                        }
                        case 2: {
                            Double q = null;
                            try {
                                q = Double.parseDouble(sfield);
                            }
                            catch (Exception exception) {
                                try {
                                    q = Double.parseDouble(sfields[2].replaceAll(String.valueOf(dc), String.valueOf(newdc)));
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                            r.setQuantity(q);
                            break;
                        }
                        case 3: {
                            String code = !"null".equals(sfield) ? sfield : null;
                            lot.setCode(code);
                            break;
                        }
                        case 4: {
                            String description = !"null".equals(sfield) ? sfield : null;
                            lot.setDescription(description);
                            break;
                        }
                        case 5: {
                            Date date = null;
                            if (!"null".equals(sfield)) {
                                try {
                                    date = new SimpleDateFormat("dd.MM.yyyy").parse(sfield);
                                }
                                catch (ParseException e) {
                                    e.printStackTrace();
                                }
                            }
                            lot.setBeginDate(date);
                            break;
                        }
                        case 6: {
                            Date date = null;
                            if (!"null".equals(sfield)) {
                                try {
                                    date = new SimpleDateFormat("dd.MM.yyyy").parse(sfield);
                                }
                                catch (ParseException e) {
                                    e.printStackTrace();
                                }
                            }
                            lot.setEndDate(date);
                            break;
                        }
                        case 7: {
                            String userGroupName = null;
                            userGroupName = !"null".equals(sfield) ? sfield : null;
                            if (userGroupName != null) {
                                UsersGroupWSProxy ugProxy = (UsersGroupWSProxy)CurrentProxyFactory.getProxy(UsersGroup.class);
                                UsersGroupSearchCriteria sc = new UsersGroupSearchCriteria();
                                sc.setCount(Integer.valueOf(1));
                                sc.setName("*" + userGroupName + "*");
                                UsersGroupWSProxy.SearchResultListUsersGroup srList = ugProxy.getUsersGroupList(InitializedVariable.context, sc);
                                if (!srList.isEmpty()) {
                                    lot.setContractor((UsersGroup)srList.getObjList()[0]);
                                } else {
                                    lot.setContractor(null);
                                }
                            } else {
                                lot.setContractor(null);
                            }
                            if (lot.getCode() == null || lot.getCode().isEmpty()) {
                                r.setLot(null);
                                break;
                            }
                            r.setLot(lot);
                            break;
                        }
                        case 8: {
                            if (!"null".equals(sfield)) {
                                job.setCode(sfield);
                                break;
                            }
                            job.setCode(null);
                            break;
                        }
                        case 9: {
                            if (!"null".equals(sfield)) {
                                job.setDescription(sfield);
                                break;
                            }
                            job.setDescription(null);
                            break;
                        }
                        case 10: {
                            int color = 0;
                            if (!"null".equals(sfield)) {
                                try {
                                    color = Integer.parseInt(sfield);
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                            job.setColor(color);
                            break;
                        }
                        case 11: {
                            Double kc = null;
                            try {
                                kc = Double.parseDouble(sfield);
                            }
                            catch (Exception exception) {
                                try {
                                    kc = Double.parseDouble(sfields[2].replaceAll(String.valueOf(dc), String.valueOf(newdc)));
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                            job.setKoof(kc.doubleValue());
                            break;
                        }
                        case 12: {
                            Double minSpeed = null;
                            try {
                                minSpeed = Double.parseDouble(sfield);
                            }
                            catch (Exception exception) {
                                try {
                                    minSpeed = Double.parseDouble(sfields[2].replaceAll(String.valueOf(dc), String.valueOf(newdc)));
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                            job.setMinSpeed(minSpeed.doubleValue());
                            break;
                        }
                        case 13: {
                            Double mamSpeed = null;
                            try {
                                mamSpeed = Double.parseDouble(sfield);
                            }
                            catch (Exception exception) {
                                try {
                                    mamSpeed = Double.parseDouble(sfields[2].replaceAll(String.valueOf(dc), String.valueOf(newdc)));
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                            job.setMaxSpeed(mamSpeed.doubleValue());
                            break;
                        }
                        case 14: {
                            if (!"null".equals(sfield)) {
                                munit.setCode(sfield);
                                break;
                            }
                            munit.setCode(null);
                            break;
                        }
                        case 15: {
                            if (!"null".equals(sfield)) {
                                munit.setDescription(sfield);
                            } else {
                                munit.setDescription(null);
                            }
                            if (munit.getCode() == null || munit.getCode().isEmpty()) {
                                job.setUnit(null);
                                break;
                            }
                            job.setUnit(munit);
                            break;
                        }
                        case 16: {
                            String[] sdnp;
                            if (!"null".equals(sfield) && (sdnp = sfield.split(";")) != null && sdnp.length >= 3) {
                                DeviceParameterNames[] dpn = new DeviceParameterNames[sdnp.length / 3];
                                int j = 0;
                                while (j < dpn.length) {
                                    DeviceParameterNames dp = new DeviceParameterNames();
                                    if (!"null".equals(sdnp[j])) {
                                        dp.setCode(sdnp[j]);
                                    } else {
                                        dp.setCode(null);
                                    }
                                    if (!"null".equals(sdnp[j + 1])) {
                                        dp.setDescription(sdnp[j + 1]);
                                    } else {
                                        dp.setDescription(null);
                                    }
                                    int colorDP = 0;
                                    if (!"null".equals(sdnp[j + 2])) {
                                        try {
                                            colorDP = Integer.parseInt(sfield);
                                        }
                                        catch (Exception e) {
                                            e.printStackTrace();
                                        }
                                    }
                                    dp.setColor(Integer.valueOf(colorDP));
                                    dpn[j] = dp;
                                    j += 3;
                                }
                                job.setParameterNamesList(dpn);
                            }
                            if (job.getCode() == null || job.getCode().isEmpty()) {
                                r.setJobKind(null);
                                break;
                            }
                            r.setJobKind(job);
                        }
                    }
                    ++i;
                }
            }
            return r;
        }
        return null;
    }

    public void setStatusRec(String statusRec) {
    }
}

