/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.roads;

import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.util.List;
import javax.swing.JComponent;
import org.jxmapviewer.JXMapViewer;
import org.jxmapviewer.viewer.GeoPosition;
import org.postgis.MultiLineString;
import ru.blok.vms.ui.mapviewer.MapViewer;
import ru.blok.vms.ui.roads.MapValue;
import ru.blok.vms.ui.roads.NewRoadPainter;
import ru.infor.beanviewer.core.UIFactory;
import ru.infor.beanviewer.viewer.action.PanelContext;
import ru.infor.ws.objects.vms.entities.RouteElement;

public class MapViewerPeriods
extends MapViewer {
    NewRoadPainter<JXMapViewer> routePainter2;

    public MapViewerPeriods(UIFactory<JComponent> factory) {
        super(factory);
    }

    @Override
    protected void init() {
        super.init();
        this.routePainter2 = new NewRoadPainter();
        this.painter.addPainter(this.routePainter2);
    }

    @Override
    protected boolean canGoToData() {
        return true;
    }

    @Override
    protected void mouseClickedOnMap(double x, double y, GeoPosition gp, MouseEvent e) {
        super.mouseClickedOnMap(x, y, gp, e);
        if (e.isControlDown()) {
            ((MapValue)this.getValue()).addDoubleClick(gp);
            this.repaint();
            ((PanelContext)this.getViewerContext().getParentContext()).getPanel().updateUIForPresentatorName("lists");
        } else if (e.getClickCount() == 1) {
            ((MapValue)this.getValue()).getRoadWAExt().addState(gp, (PanelContext)this.getViewerContext().getParentContext());
            this.repaint();
        }
    }

    @Override
    protected MapValue getNewInstance(double lat, double lon, int zoom) {
        return new MapValue(this.coord[0], this.coord[1], this.coord[2].intValue());
    }

    @Override
    protected void mouseMovedN(MouseEvent e) {
    }

    @Override
    protected void mouseWheelMovedN(MouseWheelEvent e) {
    }

    @Override
    protected Double[] getMinMax() {
        List<RouteElement> l;
        int i;
        MultiLineString lineString;
        Double minLat = null;
        Double maxLat = null;
        Double minLon = null;
        Double maxLon = null;
        if (this.routePainter2.getRoadWAExt() != null && this.routePainter2.getRoadWAExt().getCurrentLine() != null) {
            lineString = this.routePainter2.getRoadWAExt().getCurrentLine();
            i = 0;
            while (i < lineString.numPoints()) {
                double lat = lineString.getPoint(i).getY();
                double lon = lineString.getPoint(i).getX();
                if (minLat == null || lat < minLat) {
                    minLat = lat;
                }
                if (maxLat == null || lat > maxLat) {
                    maxLat = lat;
                }
                if (minLon == null || lon < minLon) {
                    minLon = lon;
                }
                if (maxLon == null || lon > maxLon) {
                    maxLon = lon;
                }
                ++i;
            }
        } else if (this.routePainter2.getRoadWAExt() != null && this.routePainter2.getRoadWAExt().getCurrentPolygon() != null) {
            lineString = this.routePainter2.getRoadWAExt().getCurrentPolygon();
            i = 0;
            while (i < lineString.numPoints()) {
                double lat = lineString.getPoint(i).getY();
                double lon = lineString.getPoint(i).getX();
                if (minLat == null || lat < minLat) {
                    minLat = lat;
                }
                if (maxLat == null || lat > maxLat) {
                    maxLat = lat;
                }
                if (minLon == null || lon < minLon) {
                    minLon = lon;
                }
                if (maxLon == null || lon > maxLon) {
                    maxLon = lon;
                }
                ++i;
            }
        }
        if (this.getValue() != null && ((MapValue)this.getValue()).getRoadWAExt() != null && (l = ((MapValue)this.getValue()).getRoadWAExt().getLists()) != null && l.size() > 0) {
            double lat = l.get(0).getLat();
            double lon = l.get(0).getLon();
            if (minLat == null || lat < minLat) {
                minLat = lat;
            }
            if (maxLat == null || lat > maxLat) {
                maxLat = lat;
            }
            if (minLon == null || lon < minLon) {
                minLon = lon;
            }
            if (maxLon == null || lon > maxLon) {
                maxLon = lon;
            }
            lat = l.get(l.size() - 1).getLat();
            lon = l.get(l.size() - 1).getLon();
            if (minLat == null || lat < minLat) {
                minLat = lat;
            }
            if (maxLat == null || lat > maxLat) {
                maxLat = lat;
            }
            if (minLon == null || lon < minLon) {
                minLon = lon;
            }
            if (maxLon == null || lon > maxLon) {
                maxLon = lon;
            }
        }
        if (minLat == null) {
            return null;
        }
        return new Double[]{minLat, maxLat, minLon, maxLon};
    }

    @Override
    public void setValue(Object arg0) {
        super.setValue(arg0);
        if (this.getValue() != null) {
            this.routePainter2.setRoadWAExt(((MapValue)this.getValue()).getRoadWAExt());
        }
        this.zoomToTracks();
    }
}

