/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.roads;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKTReader;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jxmapviewer.JXMapViewer;
import org.jxmapviewer.viewer.GeoPosition;
import org.postgis.MultiLineString;
import ru.blok.vms.ui.route.routegeom.NewRoutePainter;
import ru.infor.ws.objects.vms.entities.RouteElement;
import ru.infor.ws.objects.vms.entities.ext.RoadWAExt;

public class NewRoadPainter<T extends JXMapViewer>
extends NewRoutePainter<JXMapViewer> {
    private static final GeometryFactory gf = new GeometryFactory();
    private RoadWAExt roadWAExt;
    private static WKTReader wkt = new WKTReader();
    private static Map<Long, Geometry> path_cache = new HashMap<Long, Geometry>();
    private static Logger logger = Logger.getLogger(NewRoadPainter.class);

    public RoadWAExt getRoadWAExt() {
        return this.roadWAExt;
    }

    public void setRoadWAExt(RoadWAExt roadWAExt) {
        this.roadWAExt = roadWAExt;
    }

    @Override
    public void doPaint(Graphics2D g, JXMapViewer map, int width, int height) {
        block16: {
            Rectangle viewportBounds = map.getViewportBounds();
            int zoom = map.getZoom();
            Dimension sizeInTiles = map.getTileFactory().getMapSize(zoom);
            int tileSize = map.getTileFactory().getTileSize(zoom);
            Dimension sizeInPixels = new Dimension(sizeInTiles.width * tileSize, sizeInTiles.height * tileSize);
            double vpx = viewportBounds.getX();
            while (vpx < 0.0) {
                vpx += sizeInPixels.getWidth();
            }
            while (vpx > sizeInPixels.getWidth()) {
                vpx -= sizeInPixels.getWidth();
            }
            Rectangle2D.Double vp2 = new Rectangle2D.Double(vpx, viewportBounds.getY(), viewportBounds.getWidth(), viewportBounds.getHeight());
            Rectangle2D.Double vp3 = new Rectangle2D.Double(vpx - sizeInPixels.getWidth(), viewportBounds.getY(), viewportBounds.getWidth(), viewportBounds.getHeight());
            if (this.getRoadWAExt() != null && this.getRoadWAExt().getCurrentPolygon() != null) {
                NewRoadPainter.paintPolygon(this.getRoadWAExt().getCurrentPolygon(), map, g, (Rectangle2D)vp2, Color.RED, 50);
            }
            if (this.getRoadWAExt() != null) {
                RouteElement select = this.getRoadWAExt().getSelect();
                List<RouteElement> lists = this.getRoadWAExt().getLists();
                if (this.getRoadWAExt().getLists() != null && this.getRoadWAExt().getLists().size() > 0) {
                    int from = 0;
                    while (from < lists.size()) {
                        if (lists.get(from).getType() > 0) {
                            Point2D point = map.getTileFactory().geoToPixel(new GeoPosition(lists.get(from).getLat().doubleValue(), lists.get(from).getLon().doubleValue()), map.getZoom());
                            boolean sel = select != null && select.getNum().equals(lists.get(from).getNum());
                            this.paintPoint(g, map, vp2, vp3, point, lists.get(from), sel);
                        }
                        ++from;
                    }
                }
                if (this.roadWAExt.getCurrentLine() != null) {
                    MultiLineString lineString1 = this.roadWAExt.getCurrentLine();
                    try {
                        Geometry path;
                        if (path_cache.containsKey(lineString1.hashCode())) {
                            path = path_cache.get(lineString1.hashCode());
                        } else {
                            path = wkt.read(String.valueOf(lineString1.getTypeString()) + lineString1.getValue());
                            LineString[] ls = new LineString[path.getNumGeometries()];
                            int i = 0;
                            while (i < path.getNumGeometries()) {
                                Coordinate[] cc = path.getGeometryN(i).getCoordinates();
                                Coordinate[] cc1 = new Coordinate[cc.length];
                                int j = 0;
                                while (j < cc.length) {
                                    cc1[j] = new Coordinate(cc[j].x, cc[j].y);
                                    ++j;
                                }
                                ls[i] = gf.createLineString(cc1);
                                ++i;
                            }
                            path = gf.createMultiLineString(ls);
                            path_cache.put(Long.valueOf(lineString1.hashCode()), path);
                        }
                        this.paint(path, map, g, vp2, vp3, c.darker(), true);
                        if (select == null) break block16;
                        int i = 0;
                        while (i < lists.size() - 1) {
                            if (select.getNum().equals(lists.get(i).getNum()) && i != 0 && lists.get(i).getType() == 0) {
                                LineString selected = gf.createLineString(new Coordinate[]{new Coordinate(lists.get(i).getLat().doubleValue(), lists.get(i).getLon().doubleValue()), new Coordinate(lists.get(i + 1).getLat().doubleValue(), lists.get(i + 1).getLon().doubleValue())});
                                this.paint((Geometry)selected, map, g, vp2, vp3, Color.BLUE.darker(), true);
                                break;
                            }
                            ++i;
                        }
                    }
                    catch (ParseException e) {
                        logger.error((Object)"Error while translate geometry from postgis to geotools", (Throwable)e);
                    }
                }
            }
        }
    }
}

