/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.roads;

import java.util.logging.Logger;
import ru.blok.common.ui.directories.FRCAsyncDirectoryViewer;
import ru.blok.common.ui.list.ObjectUIList;
import ru.blok.vms.ui.roads.RoadList;
import ru.infor.beanviewer.core.UIFactory;
import ru.infor.beanviewer.viewer.DefaultTableCellViewer;
import ru.infor.beanviewer.viewer.simple.ExtendedDirectoryViewer;
import ru.infor.ws.objects.CommonSearchCriteria;
import ru.infor.ws.objects.vms.RoadWASearchCriteria;
import ru.infor.ws.objects.vms.RoadWAUI;
import ru.infor.ws.objects.vms.entities.RoadWA;
import ru.infor.ws.objects.vms.entities.ext.RoadWAExt;

public class RoadDirectoryViewer<T>
extends FRCAsyncDirectoryViewer<T> {
    protected RoadList list;

    public RoadDirectoryViewer(UIFactory<T> factory) {
        super(factory);
    }

    public Class getTableCellViewerClass() {
        return RoadDirectoryCellViewer.class;
    }

    public CommonSearchCriteria updateSearchCriteria(CommonSearchCriteria sc, String value) {
        ((RoadWASearchCriteria)sc).setName(value);
        return sc;
    }

    public void setContentClass(Class<?> cls) {
        super.setContentClass(RoadWAExt.class);
    }

    public String objectToString(Object o) {
        if (o == null) {
            return super.objectToString(o);
        }
        return ((RoadWA)o).getName();
    }

    public void buttonActionPerfomed() {
        try {
            if (this.list == null) {
                this.list = new RoadList(this.getViewerContext().getKeyPage());
            }
            this.getFactory().newPage(RoadWA.class, RoadList.class, (Object)this.list, this.getViewerContext(), "filterInList");
            Object o = this.getValue();
            if (o instanceof RoadWA) {
                RoadWAUI t = new RoadWAUI();
                t.setId(((RoadWA)o).getId());
                ((ObjectUIList)this.list.getItems()).setSelection((Object)t);
            } else if (o instanceof Long) {
                RoadWAUI t = new RoadWAUI();
                t.setId((Long)o);
                ((ObjectUIList)this.list.getItems()).setSelection((Object)t);
            }
        }
        catch (Exception exception) {
            Logger.getLogger(ExtendedDirectoryViewer.class.getName()).severe("Can't create directory presentation " + this.getPresentationClass().getName());
        }
    }

    public static class RoadDirectoryCellViewer<T>
    extends DefaultTableCellViewer<T> {
        public RoadDirectoryCellViewer(UIFactory<T> factory) {
            super(factory);
        }

        public void setValue(Object object) {
            super.setValue((Object)(object == null ? "" : ((RoadWA)object).getName()));
        }
    }
}

