/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.roads.actions;

import java.util.ArrayList;
import java.util.List;
import ru.blok.common.core.InitializedVariable;
import ru.blok.vms.core.ResourceStrings;
import ru.blok.vms.ui.roads.MapViewerPeriods;
import ru.blok.vms.ui.route.routegeom.CreateGeomRoute;
import ru.blok.vms.ui.tracks.json.LoaderFromInternet;
import ru.infor.beanviewer.dialog.MessageOKButton;
import ru.infor.beanviewer.dialog.WarningMessage;
import ru.infor.beanviewer.viewer.BeanViewerAction;
import ru.infor.beanviewer.viewer.action.PanelContext;
import ru.infor.beanviewer.viewer.action.ViewerContext;
import ru.infor.ws.objects.vms.NavigationPoint;
import ru.infor.ws.objects.vms.RouteNavigationParam;
import ru.infor.ws.objects.vms.entities.RouteElement;
import ru.infor.ws.objects.vms.entities.ext.RoadWAExt;

public class BuildRoute
extends BeanViewerAction<ViewerContext> {
    public static String wkt4326 = "GEOGCS[\"WGS 84\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994328,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]]";
    public static String wkt3395 = "PROJCS[\"WGS 84 / World Mercator\",GEOGCS[\"WGS 84\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994328,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"Mercator_1SP\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\",0],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easting\",0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AUTHORITY[\"EPSG\",\"3395\"]]";

    public String getIcon() {
        return ResourceStrings.btBuildRoute;
    }

    public String getHint() {
        return "\u041f\u043e\u0441\u0442\u0440\u043e\u0438\u0442\u044c \u043c\u0430\u0440\u0448\u0440\u0443\u0442 \u0447\u0435\u0440\u0435\u0437 \u0441\u0438\u0441\u0442\u0435\u043c\u0443 \u043c\u0430\u0440\u0448\u0440\u0443\u0442\u0438\u0437\u0430\u0446\u0438\u0438";
    }

    public void actionPerformed(Object message) {
        ((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getPanel().updateMainObject();
        RoadWAExt r = (RoadWAExt)((Object)((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getObject());
        if (r.getLists().size() < 2) {
            InitializedVariable.factory.runMessageEx((Object)new WarningMessage("\u041d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0434\u0432\u043e\u0439\u043d\u044b\u043c \u0449\u0435\u043b\u0447\u043a\u043e\u043c c \u043d\u0430\u0436\u0430\u0442\u044b\u043c CTRL \u043d\u0430 \u043a\u0430\u0440\u0442\u0435 \u0437\u0430\u0434\u0430\u0442\u044c \u043d\u0430\u0447\u0430\u043b\u044c\u043d\u044b\u0435 \u0438 \u043a\u043e\u043d\u0435\u0447\u043d\u044b\u0435 \u0442\u043e\u0447\u043a\u0438"), new BeanViewerAction[]{new MessageOKButton()});
            return;
        }
        this.buildRoute(r);
        ((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getPanel().updateUI();
        ((MapViewerPeriods)((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getPanel().getPresentatorForName("value").getViewer()).zoomToTracks();
    }

    public void buildRoute(RoadWAExt roadWAExt) {
        ArrayList<NavigationPoint> list = new ArrayList<NavigationPoint>();
        ArrayList<RouteElement> listStat = new ArrayList<RouteElement>();
        if (roadWAExt.getLists() != null) {
            for (RouteElement r : roadWAExt.getLists()) {
                if (r.getType() <= 0 || r.getType() == 5 || r.getType() == 6) continue;
                NavigationPoint p = new NavigationPoint();
                p.setLat(r.getLat());
                p.setLon(r.getLon());
                list.add(p);
                listStat.add(r);
            }
        }
        double length = 0.0;
        NavigationPoint from = new NavigationPoint();
        from.setLat(roadWAExt.getLists().get(0).getLat());
        from.setLon(roadWAExt.getLists().get(0).getLon());
        NavigationPoint to = new NavigationPoint();
        to.setLat(roadWAExt.getLists().get(roadWAExt.getLists().size() - 1).getLat());
        to.setLon(roadWAExt.getLists().get(roadWAExt.getLists().size() - 1).getLon());
        RouteElement beginS = roadWAExt.getLists().get(0);
        RouteElement endS = roadWAExt.getLists().get(roadWAExt.getLists().size() - 1);
        RouteNavigationParam param = new RouteNavigationParam();
        param.setFrom(from);
        param.setTo(to);
        param.setLimitRange(null);
        param.setFintessID(Long.valueOf(1L));
        NavigationPoint[] points = LoaderFromInternet.getRouteWithPoints(InitializedVariable.context, param, list.toArray(new NavigationPoint[0]));
        CreateGeomRoute createGeomRoute = new CreateGeomRoute();
        if (roadWAExt.getReadWidth() == null || roadWAExt.getReadWidth() == 0.0) {
            roadWAExt.setReadWidth(20.0);
        }
        createGeomRoute.setWidthRoute(roadWAExt.getReadWidth());
        createGeomRoute.create(points);
        List<RouteElement> lists = createGeomRoute.getLists();
        roadWAExt.setCurrentLine(createGeomRoute.getCurrentLine());
        roadWAExt.setCurrentPolygon(createGeomRoute.getCurrentPolygon());
        for (RouteElement e : listStat) {
            double d = Double.MAX_VALUE;
            int k = -1;
            int i = 0;
            while (i < lists.size()) {
                double dd;
                if (lists.get(i).getType() == 0 && (dd = Math.sqrt(Math.pow(lists.get(i).getLon() - e.getLon(), 2.0) + Math.pow(lists.get(i).getLat() - e.getLat(), 2.0))) < d) {
                    k = i;
                    d = dd;
                }
                ++i;
            }
            lists.add(k, e);
        }
        lists.add(0, beginS);
        lists.add(endS);
        int i = 0;
        while (i < lists.size()) {
            lists.get(i).setNum(Integer.valueOf(i + 1));
            ++i;
        }
        roadWAExt.setLists(lists);
        roadWAExt.setLength(length);
    }
}

