/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.roads.actions;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.util.ArrayList;
import org.geotools.geometry.GeneralDirectPosition;
import org.geotools.referencing.CRS;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.postgis.Geometry;
import org.postgis.LineString;
import org.postgis.MultiLineString;
import org.postgis.MultiPolygon;
import ru.blok.common.core.InitializedVariable;
import ru.blok.vms.core.ResourceStrings;
import ru.blok.vms.ui.roads.actions.BuildRoute;
import ru.blok.vms.ui.route.routegeom.RouteGeomBuilder;
import ru.infor.beanviewer.dialog.MessageOKButton;
import ru.infor.beanviewer.dialog.WarningMessage;
import ru.infor.beanviewer.viewer.BeanViewerAction;
import ru.infor.ws.objects.vms.entities.RouteElement;
import ru.infor.ws.objects.vms.entities.ext.RoadWAExt;
import ru.infor.ws.objects.vms.entities.ext.RouteElementExt;

public class BuildRoute2
extends BuildRoute {
    @Override
    public String getIcon() {
        return ResourceStrings.btBuildPoint;
    }

    @Override
    public String getHint() {
        return "\u041f\u043e\u0441\u0442\u0440\u043e\u0438\u0442\u044c \u043c\u0430\u0440\u0448\u0440\u0443\u0442 \u0447\u0435\u0440\u0435\u0437 \u0442\u043e\u0447\u043a\u0438 \u043f\u0440\u043e\u0445\u043e\u0436\u0434\u0435\u043d\u0438\u044f";
    }

    @Override
    public void buildRoute(RoadWAExt roadWAExt) {
        ArrayList<RouteElement> listStat = new ArrayList<RouteElement>();
        if (roadWAExt.getLists() != null) {
            for (RouteElement r : roadWAExt.getLists()) {
                if (r.getType() <= 0) continue;
                listStat.add(r);
            }
        }
        RouteElement beginS = roadWAExt.getLists().get(0);
        double length = 0.0;
        ArrayList<RouteElement> lists = new ArrayList<RouteElement>();
        GeometryFactory f = new GeometryFactory();
        try {
            CoordinateReferenceSystem sourceCRS = CRS.parseWKT((String)wkt4326);
            CoordinateReferenceSystem targetCRS = CRS.parseWKT((String)wkt3395);
            MathTransform math = CRS.findMathTransform((CoordinateReferenceSystem)sourceCRS, (CoordinateReferenceSystem)targetCRS);
            MathTransform math2 = CRS.findMathTransform((CoordinateReferenceSystem)targetCRS, (CoordinateReferenceSystem)sourceCRS);
            if (roadWAExt.getReadWidth() == null || roadWAExt.getReadWidth() == 0.0) {
                roadWAExt.setReadWidth(20.0);
            }
            lists.add(beginS);
            RouteElementExt e0 = new RouteElementExt();
            e0.setLat(((RouteElement)listStat.get(0)).getLat());
            e0.setLon(((RouteElement)listStat.get(0)).getLon());
            e0.setType(0);
            lists.add(e0);
            GeneralDirectPosition pt1 = new GeneralDirectPosition(e0.getLon().doubleValue(), e0.getLat().doubleValue());
            DirectPosition pt2 = math.transform((DirectPosition)pt1, null);
            Coordinate c = new Coordinate(pt2.getCoordinate()[0], pt2.getCoordinate()[1]);
            Point p_old = f.createPoint(c);
            Coordinate c_old = c;
            Coordinate[] cc = new Coordinate[listStat.size()];
            Coordinate[] src = new Coordinate[listStat.size()];
            cc[0] = c;
            src[0] = c = new Coordinate(e0.getLon().doubleValue(), e0.getLat().doubleValue());
            ArrayList<Polygon> listsP = new ArrayList<Polygon>();
            int i = 1;
            while (i < listStat.size()) {
                lists.add((RouteElement)listStat.get(i));
                RouteElementExt e = new RouteElementExt();
                e.setLat(((RouteElement)listStat.get(i)).getLat());
                e.setLon(((RouteElement)listStat.get(i)).getLon());
                e.setType(0);
                src[i] = c = new Coordinate(e.getLon().doubleValue(), e.getLat().doubleValue());
                pt1 = new GeneralDirectPosition(e.getLon().doubleValue(), e.getLat().doubleValue());
                pt2 = math.transform((DirectPosition)pt1, null);
                cc[i] = c = new Coordinate(pt2.getCoordinate()[0], pt2.getCoordinate()[1]);
                Point pp = f.createPoint(c);
                e0.setLength(p_old.distance((com.vividsolutions.jts.geom.Geometry)pp) / 1000.0 / 2.0);
                length += e0.getLength().doubleValue();
                Object[] oo = RouteGeomBuilder.createPolygonByCoordinate3395(new Coordinate[]{c_old, c}, f, math2, roadWAExt.getReadWidth());
                org.postgis.Polygon p2 = (org.postgis.Polygon)oo[0];
                e0.setAreaGeom(p2.toString());
                listsP.add((Polygon)oo[1]);
                lists.add(e);
                e0 = e;
                p_old = pp;
                c_old = c;
                ++i;
            }
            com.vividsolutions.jts.geom.LineString s = f.createLineString(src);
            roadWAExt.setCurrentLine(new MultiLineString(new LineString[]{new LineString(s.toString())}));
            roadWAExt.setCurrentPolygon(null);
            Object[] oo = RouteGeomBuilder.createPolygonByCoordinate3395(cc, f, math2, roadWAExt.getReadWidth());
            if (oo != null) {
                roadWAExt.setCurrentPolygon((Geometry)oo[0]);
            } else {
                com.vividsolutions.jts.geom.MultiPolygon g = f.createMultiPolygon(listsP.toArray(new Polygon[0]));
                MultiPolygon p1 = new MultiPolygon(g.toString());
                roadWAExt.setCurrentPolygon((Geometry)p1);
            }
            if (roadWAExt.getCurrentPolygon() == null) {
                InitializedVariable.factory.runMessageEx((Object)new WarningMessage("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u043e\u0441\u0442\u0440\u043e\u0435\u043d\u0438\u0438 \u043f\u043e\u043b\u0438\u0433\u043e\u043d\u0430. \u0412\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043f\u0440\u043e\u0431\u043b\u0435\u043c\u0430 \u0441\u0432\u044f\u0437\u0430\u043d\u044b \u0441 \u043f\u043e\u0440\u044f\u0434\u043a\u043e\u043c \u043f\u0440\u043e\u0445\u043e\u0436\u0434\u0435\u043d\u0438\u044f \u0442\u043e\u0447\u0435\u043a"), new BeanViewerAction[]{new MessageOKButton()});
            }
            int i2 = 0;
            while (i2 < lists.size()) {
                ((RouteElement)lists.get(i2)).setNum(Integer.valueOf(i2 + 1));
                ++i2;
            }
            roadWAExt.setLists(lists);
            roadWAExt.setLength(length);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

