/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.roads.controls;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Polygon;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import org.geotools.geometry.GeneralDirectPosition;
import org.geotools.referencing.CRS;
import org.jxmapviewer.viewer.GeoPosition;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.postgis.Geometry;
import org.postgis.MultiLineString;
import org.postgis.MultiPolygon;
import org.postgis.Point;
import ru.blok.common.core.CommonObjectWithKey;
import ru.blok.common.core.CurrentProxyFactory;
import ru.blok.common.core.InitializedVariable;
import ru.blok.common.core.ResourceStrings;
import ru.blok.common.ui.directories.FRCBaseDirectoryViewer;
import ru.blok.common.utils.CoordinatesDownTown;
import ru.blok.vms.ui.VMSAsyncDirectoryViewerForID;
import ru.blok.vms.ui.building.AdvancedItemDirectoryViewer;
import ru.blok.vms.ui.roads.RoadDirectoryViewer;
import ru.blok.vms.ui.roads.RoadList;
import ru.blok.vms.ui.roads.actions.BuildRoute;
import ru.blok.vms.ui.roads.controls.MapValueAllControl;
import ru.blok.vms.ui.roads.roadsonmap.MapValueAll;
import ru.blok.vms.ui.roads.roadsonmap.MapViewerAll;
import ru.blok.vms.ui.route.routegeom.RouteGeomBuilder;
import ru.infor.beanviewer.annotation.Field;
import ru.infor.beanviewer.annotation.ListField;
import ru.infor.beanviewer.annotation.ListView;
import ru.infor.beanviewer.annotation.View;
import ru.infor.beanviewer.dialog.InfoMessage;
import ru.infor.beanviewer.dialog.MessageOKButton;
import ru.infor.beanviewer.swing.viewers.TimeFormatViewer;
import ru.infor.beanviewer.viewer.ActionButton;
import ru.infor.beanviewer.viewer.AsyncBVA;
import ru.infor.beanviewer.viewer.BeanViewerAction;
import ru.infor.beanviewer.viewer.action.PanelContext;
import ru.infor.beanviewer.viewer.action.ViewerContext;
import ru.infor.beanviewer.viewer.simple.date.DateWithoutButton;
import ru.infor.client.soap.proxy.vms.BuildingWSProxy;
import ru.infor.client.soap.proxy.vms.RoadWAWSProxy;
import ru.infor.ws.objects.vms.AdvancedSearchItem;
import ru.infor.ws.objects.vms.RoadWAUI;
import ru.infor.ws.objects.vms.TransportSearchCriteria;
import ru.infor.ws.objects.vms.entities.Building;
import ru.infor.ws.objects.vms.entities.RoadWA;
import ru.infor.ws.objects.vms.entities.TransportGroup;
import ru.infor.ws.objects.vms.entities.ext.RoadWAExt;

@ListView(views={@View(title="\u041a\u043e\u043d\u0442\u0440\u043e\u043b\u044c \u0438 \u0430\u043d\u0430\u043b\u0438\u0437 \u043e\u0431\u0441\u043b\u0443\u0436\u0438\u0432\u0430\u043d\u0438\u044f \u0434\u043e\u0440\u043e\u0433", actions={}, layoutKeys={"tabSplitPercentLayoutManager"})})
public class RoadControls
extends CommonObjectWithKey {
    private Date dateFrom;
    private Date dateTill;
    TransportGroup transportGroup;
    private Long[] roadList;
    Double[] coord;
    static Double wightRoad = 100.0;
    HashMap<String, String> sp = null;
    MapValueAll mapValueAll;
    static CoordinateReferenceSystem sourceCRS;
    static CoordinateReferenceSystem targetCRS;
    static MathTransform math;
    static MathTransform math2;
    static GeometryFactory f;
    RoadWAWSProxy proxy = (RoadWAWSProxy)CurrentProxyFactory.getProxy(RoadWA.class);
    BeanViewerAction<ViewerContext> sv = new AsyncBVA<RoadWA[], ViewerContext>((o, c) -> {
        ((PanelContext)c.getParentContext()).getPanel().updateMainObject();
        TransportSearchCriteria sc = new TransportSearchCriteria();
        sc.setDateFrom(this.dateFrom);
        sc.setDateTill(this.dateTill);
        if (this.transportGroup != null) {
            sc.setGroupIdList(new Long[]{this.transportGroup.getId()});
        }
        sc.setRoadIdList(this.roadList);
        sc.setCount(Integer.valueOf(Integer.MAX_VALUE));
        RoadWA[] obj = this.proxy.servedRoad(InitializedVariable.context, sc);
        if (obj == null || obj.length == 0) {
            throw new Error();
        }
        return obj;
    }, (obj, ctx) -> {
        ArrayList<RoadWAExt> ll = new ArrayList<RoadWAExt>();
        RoadWA[] roadWAArray = obj;
        int n = ((RoadWA[])obj).length;
        int n2 = 0;
        while (n2 < n) {
            RoadWA w = roadWAArray[n2];
            RoadList.updateObjectGeom((RoadWAExt)w);
            try {
                MultiLineString s = ((RoadWAExt)w).getCurrentLine();
                Coordinate[] cc = new Coordinate[s.getLine(0).getPoints().length];
                int i = 0;
                while (i < cc.length) {
                    Coordinate c;
                    GeneralDirectPosition pt1 = new GeneralDirectPosition(s.getLine(0).getPoint(i).getX(), s.getLine(0).getPoint(i).getY());
                    DirectPosition pt2 = math.transform((DirectPosition)pt1, null);
                    cc[i] = c = new Coordinate(pt2.getCoordinate()[0], pt2.getCoordinate()[1]);
                    ++i;
                }
                ((RoadWAExt)w).setCurrentPolygon(null);
                ((RoadWAExt)w).setReadWidth(wightRoad);
                Object[] oo = RouteGeomBuilder.createPolygonByCoordinate3395(cc, f, math2, ((RoadWAExt)w).getReadWidth() * 2.0);
                if (oo != null) {
                    ((RoadWAExt)w).setCurrentPolygon((Geometry)oo[0]);
                } else {
                    ArrayList<Polygon> listsP = new ArrayList<Polygon>();
                    int i2 = 1;
                    while (i2 < cc.length) {
                        oo = RouteGeomBuilder.createPolygonByCoordinate3395(new Coordinate[]{cc[i2 - 1], cc[i2]}, f, math2, ((RoadWAExt)w).getReadWidth() * 2.0);
                        listsP.add((Polygon)oo[1]);
                        ++i2;
                    }
                    com.vividsolutions.jts.geom.MultiPolygon g = f.createMultiPolygon(listsP.toArray(new Polygon[0]));
                    MultiPolygon p1 = new MultiPolygon(g.toString());
                    ((RoadWAExt)w).setCurrentPolygon((Geometry)p1);
                }
            }
            catch (Exception exception) {}
            ll.add((RoadWAExt)w);
            ++n2;
        }
        this.mapValueAll.setList(ll);
        ((PanelContext)ctx.getParentContext()).getPanel().updateUI();
    }, (e, c) -> ((PanelContext)c.getParentContext()).getPanel().getFactory().runMessageEx((Object)new InfoMessage("\u041d\u0435\u0442 \u0434\u0430\u043d\u043d\u044b\u0445 \u0434\u043b\u044f \u043e\u0442\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u044f"), new BeanViewerAction[]{new MessageOKButton()})){

        public String getName() {
            return "\u0421\u0432\u043e\u0434\u043a\u0430";
        }
    };
    private AdvancedSearchItem advancedItem;
    BeanViewerAction<ViewerContext> btGoToHouse = new BeanViewerAction<ViewerContext>(){

        public void actionPerformed(Object arg0) {
            ((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getPanel().updateMainObject();
            if (RoadControls.this.getAdvancedItem() != null && RoadControls.this.getAdvancedItem().getId() != null) {
                BuildingWSProxy buildingProxy = (BuildingWSProxy)CurrentProxyFactory.getProxy(Building.class);
                Building building = buildingProxy.getCurrentObject(InitializedVariable.context, RoadControls.this.getAdvancedItem().getId());
                if (building != null && building.getLat() != null && building.getLon() != null) {
                    RoadControls.this.setNewAlarmPoint(building.getLat(), building.getLon(), RoadControls.this.getAdvancedItem());
                } else {
                    RoadControls.this.mapValueAll.setAlarm(null);
                }
                ((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getPanel().updateUIForPresentatorName("mapValueAll");
            }
        }

        public String getIcon() {
            return ResourceStrings.btChangeStatusInvoice;
        }

        public String getHint() {
            return "\u041f\u0435\u0440\u0435\u0439\u0442\u0438 \u043a \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u043e\u043c\u0443 \u0430\u0434\u0440\u0435\u0441\u0443";
        }
    };
    private RoadWA roadWA;
    BeanViewerAction<ViewerContext> btGoToHouse2 = new BeanViewerAction<ViewerContext>(){

        public void actionPerformed(Object arg0) {
            ((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getPanel().updateMainObject();
            if (RoadControls.this.getRoadWA() != null) {
                RoadWAWSProxy proxy = (RoadWAWSProxy)CurrentProxyFactory.getProxy(RoadWA.class);
                RoadWAExt r = (RoadWAExt)proxy.getCurrentObject(InitializedVariable.context, RoadControls.this.getRoadWA().getId());
                RoadList.updateObjectGeom(r);
                Point p = null;
                if (r.getCurrentLine() != null) {
                    p = r.getCurrentLine().getPoint(0);
                } else if (r.getCurrentPolygon() != null) {
                    p = r.getCurrentPolygon().getPoint(0);
                }
                if (p != null) {
                    RoadControls.this.setNewAlarmPoint(p.getY(), p.getX(), null);
                } else {
                    RoadControls.this.mapValueAll.setAlarm(null);
                }
                ((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getPanel().updateUIForPresentatorName("mapValueAll");
            }
        }

        public String getIcon() {
            return ResourceStrings.btChangeStatusInvoice;
        }

        public String getHint() {
            return "\u041f\u0435\u0440\u0435\u0439\u0442\u0438 \u043a \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u043e\u0439 \u0434\u043e\u0440\u043e\u0433\u0435";
        }
    };

    static {
        f = new GeometryFactory();
        try {
            sourceCRS = CRS.parseWKT((String)BuildRoute.wkt4326);
            targetCRS = CRS.parseWKT((String)BuildRoute.wkt3395);
            math = CRS.findMathTransform((CoordinateReferenceSystem)sourceCRS, (CoordinateReferenceSystem)targetCRS);
            math2 = CRS.findMathTransform((CoordinateReferenceSystem)targetCRS, (CoordinateReferenceSystem)sourceCRS);
        }
        catch (FactoryException e) {
            e.printStackTrace();
        }
    }

    public RoadControls(String keyPage) {
        super(keyPage);
        if (InitializedVariable.getWorkplaceId((String)this.getKeyPage()) != null) {
            this.sp = InitializedVariable.runtimeParameters((Long)InitializedVariable.getWorkplaceId((String)this.getKeyPage()));
            if (this.sp.get("WidthOfRoadInAnalysis") != null) {
                try {
                    wightRoad = new Double(this.sp.get("WidthOfRoadInAnalysis"));
                }
                catch (NumberFormatException numberFormatException) {}
            }
            this.coord = CoordinatesDownTown.getCoordinatesDownTown(this.sp);
        } else {
            this.coord = CoordinatesDownTown.getCoordinatesDownTown((Long)InitializedVariable.getWorkplaceId((String)this.getKeyPage()));
        }
        Calendar c2 = Calendar.getInstance();
        c2.setTime(new Date());
        c2.set(11, 7);
        c2.set(12, 0);
        c2.set(13, 0);
        c2.set(14, 0);
        this.dateFrom = c2.getTime();
        c2.add(11, 11);
        this.dateTill = c2.getTime();
        this.mapValueAll = new MapValueAllControl(this.coord[0], this.coord[1], this.coord[2].intValue());
    }

    @ListField(fields={@Field(title="\u0421  ", order=10, viewer={DateWithoutButton.class}, propertiesLayout="Split1/h/l/0.3:00/fillx, wrap 2:0/fillx/\u041f\u0435\u0440\u0438\u043e\u0434 \u0434\u0430\u0442/spanx# w 100", propertiesUI={"format=dd.MM.yyyy"})})
    public Date getDateFrom() {
        return this.dateFrom;
    }

    public void setDateFrom(Date dateFrom) {
        this.dateFrom = dateFrom;
    }

    @ListField(fields={@Field(title="", order=20, viewer={TimeFormatViewer.class}, propertiesLayout="Split1/h/l/0.3:00:0# w 105, wrap", propertiesUI={"format=HH:mm:ss"})})
    public Date getTimeFrom() {
        return this.dateFrom;
    }

    public void setTimeFrom(Date dateFrom) {
        Calendar c1 = Calendar.getInstance();
        Calendar c2 = Calendar.getInstance();
        c1.setTime(this.getDateFrom());
        c2.setTime(dateFrom);
        c1.set(11, c2.get(11));
        c1.set(12, c2.get(12));
        c1.set(13, c2.get(13));
        this.dateFrom = c1.getTime();
    }

    @ListField(fields={@Field(title="\u043f\u043e ", order=30, viewer={DateWithoutButton.class}, propertiesLayout="Split1/h/l/0.3:00:0# w 100", propertiesUI={"format=dd.MM.yyyy"})})
    public Date getDateTill() {
        return this.dateTill;
    }

    public void setDateTill(Date dateTill) {
        this.dateTill = dateTill;
    }

    @ListField(fields={@Field(title="", order=40, viewer={TimeFormatViewer.class}, propertiesLayout="Split1/h/l/0.3:00:0# w 105", propertiesUI={"format=HH:mm:ss"})})
    public Date getTimeTill() {
        return this.dateTill;
    }

    public void setTimeTill(Date dateTill) {
        Calendar c1 = Calendar.getInstance();
        Calendar c2 = Calendar.getInstance();
        c1.setTime(this.getDateTill());
        c2.setTime(dateTill);
        c1.set(11, c2.get(11));
        c1.set(12, c2.get(12));
        c1.set(13, c2.get(13));
        this.dateTill = c1.getTime();
    }

    @ListField(fields={@Field(title="\u0413\u0440\u0443\u043f\u043f\u0430 \u0422\u0421", order=60, propertiesLayout="Split1/h/l/0.3:00", content=TransportGroup.class, viewer={FRCBaseDirectoryViewer.class})})
    public TransportGroup getTransportGroup() {
        return this.transportGroup;
    }

    public void setTransportGroup(TransportGroup transportGroup) {
        this.transportGroup = transportGroup;
    }

    @ListField(fields={@Field(title="\u0421\u043f\u0438\u0441\u043e\u043a \u0434\u043e\u0440\u043e\u0433", order=80, content=RoadWAUI.class, viewer={VMSAsyncDirectoryViewerForID.class}, propertiesLayout="Split1/h/l/0.3:00")})
    public Long[] getRoadList() {
        return this.roadList;
    }

    public void setRoadList(Long[] roadList) {
        this.roadList = roadList;
    }

    @ListField(fields={@Field(title="", order=1000, viewer={ActionButton.class}, propertiesLayout="Split1/h/l/0.3:00/spanx 2")})
    public BeanViewerAction<ViewerContext> getSv() {
        return this.sv;
    }

    @ListField(fields={@Field(title="", propertiesLayout="Split1/h/r/0.3", order=0, viewer={MapViewerAll.class})})
    public MapValueAll getMapValueAll() {
        return this.mapValueAll;
    }

    @ListField(fields={@Field(title="\u0410\u0434\u0440\u0435\u0441 ", readOnly=false, content=AdvancedSearchItem.class, order=10045, propertiesLayout="Split1/h/l/0.3:00:06/fillx/n/spanx#w 200, cell 1 1 3# cell 0 1", viewer={AdvancedItemDirectoryViewer.class})})
    public AdvancedSearchItem getAdvancedItem() {
        return this.advancedItem;
    }

    public void setAdvancedItem(AdvancedSearchItem advancedItem) {
        this.advancedItem = advancedItem;
    }

    @ListField(fields={@Field(title="", order=10060, propertiesLayout="Split1/h/l/0.3:00:06#cell 4 1#cell 4 1", viewer={ActionButton.class})})
    public BeanViewerAction<ViewerContext> getbtGoToHouse() {
        return this.btGoToHouse;
    }

    protected void setNewAlarmPoint(Double lat, Double lon, AdvancedSearchItem item) {
        GeoPosition gp = new GeoPosition(lat.doubleValue(), lon.doubleValue());
        this.mapValueAll.setAlarm(gp);
        this.mapValueAll.setLat(lat);
        this.mapValueAll.setLon(lon);
    }

    @ListField(fields={@Field(title="\u0414\u043e\u0440\u043e\u0433\u0430", order=20000, content=RoadWA.class, viewer={RoadDirectoryViewer.class}, propertiesLayout="Split1/h/l/0.3:00:06/fillx/n/spanx#w 200, cell 1 2 3# cell 0 2")})
    public RoadWA getRoadWA() {
        return this.roadWA;
    }

    public void setRoadWA(RoadWA roadWA) {
        this.roadWA = roadWA;
    }

    @ListField(fields={@Field(title="", order=10060, propertiesLayout="Split1/h/l/0.3:00:06#cell 4 2#cell 4 2", viewer={ActionButton.class})})
    public BeanViewerAction<ViewerContext> getbtGoToHouse2() {
        return this.btGoToHouse2;
    }
}

