/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.roads.controls;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import ru.blok.common.core.CommonObjectWithKey;
import ru.blok.common.core.CurrentProxyFactory;
import ru.blok.common.core.InitializedVariable;
import ru.blok.common.ui.directories.FRCAsyncViewerForIdSingle;
import ru.blok.common.ui.directories.FRCBaseDirectoryViewer;
import ru.blok.common.utils.CoordinatesDownTown;
import ru.blok.vms.ui.VMSAsyncDirectoryViewerForID;
import ru.blok.vms.ui.roads.RoadList;
import ru.blok.vms.ui.roads.controls.MapValuePercent;
import ru.blok.vms.ui.roads.controls.MapViewerUiColor;
import ru.blok.vms.ui.roads.roadsonmap.MapValueAll;
import ru.infor.beanviewer.annotation.Field;
import ru.infor.beanviewer.annotation.ListField;
import ru.infor.beanviewer.annotation.ListView;
import ru.infor.beanviewer.annotation.View;
import ru.infor.beanviewer.dialog.InfoMessage;
import ru.infor.beanviewer.dialog.MessageOKButton;
import ru.infor.beanviewer.swing.viewers.TimeFormatViewer;
import ru.infor.beanviewer.viewer.ActionButton;
import ru.infor.beanviewer.viewer.AsyncBVA;
import ru.infor.beanviewer.viewer.BeanViewerAction;
import ru.infor.beanviewer.viewer.action.PanelContext;
import ru.infor.beanviewer.viewer.action.ViewerContext;
import ru.infor.beanviewer.viewer.list.ListViewer;
import ru.infor.beanviewer.viewer.simple.date.DateWithoutButton;
import ru.infor.client.soap.proxy.vms.RoadMaintenanceWSProxy;
import ru.infor.ws.objects.vms.RoadMaintenanceStatistic;
import ru.infor.ws.objects.vms.RoadMaintenanceStatisticSearchCriteria;
import ru.infor.ws.objects.vms.RoadWAUI;
import ru.infor.ws.objects.vms.entities.RoadJobKind;
import ru.infor.ws.objects.vms.entities.RoadMaintenance;
import ru.infor.ws.objects.vms.entities.RoadWA;
import ru.infor.ws.objects.vms.entities.TransportGroup;
import ru.infor.ws.objects.vms.entities.WatchAreaType;
import ru.infor.ws.objects.vms.entities.ext.RoadWAExt;

@ListView(views={@View(title="\u0421\u0432\u043e\u0434\u043a\u0430 \u043e \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0438 \u0437\u0430\u0434\u0430\u043d\u0438\u0439", actions={}, layoutKeys={"tabSplitPercentLayoutManager"})})
public class RoadControlsMaintence
extends CommonObjectWithKey {
    private Date dateFrom;
    private Date dateTill;
    TransportGroup transportGroup;
    private Long[] roadList;
    private Long primaryGroupId;
    private Long[] jobKindIds;
    private Long[] roadOrganizationIdList;
    private Long[] typeIdList;
    private String typeRoad;
    Double[] coord;
    MapValuePercent mapValueAll;
    List<RoadsStatistic> list;
    RoadMaintenanceWSProxy proxy = (RoadMaintenanceWSProxy)CurrentProxyFactory.getProxy(RoadMaintenance.class);
    BeanViewerAction<ViewerContext> sv = new AsyncBVA<RoadMaintenanceStatistic[], ViewerContext>((o, c) -> {
        ((PanelContext)c.getParentContext()).getPanel().updateMainObject();
        RoadMaintenanceStatisticSearchCriteria sc = new RoadMaintenanceStatisticSearchCriteria();
        sc.setDateFrom(this.dateFrom);
        sc.setDateTill(this.dateTill);
        sc.setRoadOrganizationIdList(this.roadOrganizationIdList);
        sc.setRoadJobKindIdList(this.jobKindIds);
        sc.setRoadIdList(this.roadList);
        sc.setCount(Integer.valueOf(Integer.MAX_VALUE));
        sc.setTypeIdList(this.typeIdList);
        sc.setTypeRoad(this.typeRoad);
        RoadMaintenanceStatistic[] ob = this.proxy.getStatistic(InitializedVariable.context, sc);
        if (ob == null || ob.length == 0) {
            throw new Error();
        }
        return ob;
    }, (s, c) -> {
        this.list = new ArrayList<RoadsStatistic>();
        RoadMaintenanceStatistic[] roadMaintenanceStatisticArray = s;
        int n = ((RoadMaintenanceStatistic[])s).length;
        int n2 = 0;
        while (n2 < n) {
            RoadMaintenanceStatistic o = roadMaintenanceStatisticArray[n2];
            RoadList.updateObjectGeom((RoadWAExt)o.getRoad());
            this.list.add(new RoadsStatistic(o));
            ++n2;
        }
        this.mapValueAll.setListStat(this.list);
        ((PanelContext)c.getParentContext()).getPanel().updateUI();
    }, (e, c) -> c.getPresentator().getViewer().getFactory().runMessageEx((Object)new InfoMessage("\u041d\u0435\u0442 \u0434\u0430\u043d\u043d\u044b\u0445 \u0434\u043b\u044f \u043e\u0442\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u044f"), new BeanViewerAction[]{new MessageOKButton()})){

        public String getName() {
            return "\u0421\u0432\u043e\u0434\u043a\u0430";
        }
    };

    public RoadControlsMaintence(String keyPage) {
        super(keyPage);
        Calendar c2 = Calendar.getInstance();
        c2.setTime(new Date());
        c2.set(11, 7);
        c2.set(12, 0);
        c2.set(13, 0);
        c2.set(14, 0);
        this.dateFrom = c2.getTime();
        c2.add(11, 11);
        this.dateTill = c2.getTime();
        this.coord = CoordinatesDownTown.getCoordinatesDownTown((Long)InitializedVariable.getWorkplaceId((String)keyPage));
        this.mapValueAll = new MapValuePercent(this.coord[0], this.coord[1], this.coord[2].intValue());
    }

    @ListField(fields={@Field(title="\u0421  ", order=10, viewer={DateWithoutButton.class}, propertiesLayout="Split1/h/l/0.3:00/fillx, wrap 2:0/fillx/\u041f\u0435\u0440\u0438\u043e\u0434 \u0434\u0430\u0442/spanx# w 100", propertiesUI={"format=dd.MM.yyyy"})})
    public Date getDateFrom() {
        return this.dateFrom;
    }

    public void setDateFrom(Date dateFrom) {
        this.dateFrom = dateFrom;
    }

    @ListField(fields={@Field(title="", order=20, viewer={TimeFormatViewer.class}, propertiesLayout="Split1/h/l/0.3:00:0# w 105, wrap", propertiesUI={"format=HH:mm:ss"})})
    public Date getTimeFrom() {
        return this.dateFrom;
    }

    public void setTimeFrom(Date dateFrom) {
        Calendar c1 = Calendar.getInstance();
        Calendar c2 = Calendar.getInstance();
        c1.setTime(this.getDateFrom());
        c2.setTime(dateFrom);
        c1.set(11, c2.get(11));
        c1.set(12, c2.get(12));
        c1.set(13, c2.get(13));
        this.dateFrom = c1.getTime();
    }

    @ListField(fields={@Field(title="\u043f\u043e ", order=30, viewer={DateWithoutButton.class}, propertiesLayout="Split1/h/l/0.3:00:0# w 100", propertiesUI={"format=dd.MM.yyyy"})})
    public Date getDateTill() {
        return this.dateTill;
    }

    public void setDateTill(Date dateTill) {
        this.dateTill = dateTill;
    }

    @ListField(fields={@Field(title="", order=40, viewer={TimeFormatViewer.class}, propertiesLayout="Split1/h/l/0.3:00:0# w 105", propertiesUI={"format=HH:mm:ss"})})
    public Date getTimeTill() {
        return this.dateTill;
    }

    public void setTimeTill(Date dateTill) {
        Calendar c1 = Calendar.getInstance();
        Calendar c2 = Calendar.getInstance();
        c1.setTime(this.getDateTill());
        c2.setTime(dateTill);
        c1.set(11, c2.get(11));
        c1.set(12, c2.get(12));
        c1.set(13, c2.get(13));
        this.dateTill = c1.getTime();
    }

    @ListField(fields={@Field(title="\u0413\u0440\u0443\u043f\u043f\u0430 \u0422\u0421", order=60, propertiesLayout="Split1/h/l/0.3:00", content=TransportGroup.class, viewer={FRCBaseDirectoryViewer.class})})
    public TransportGroup getTransportGroup() {
        return this.transportGroup;
    }

    public void setTransportGroup(TransportGroup transportGroup) {
        this.transportGroup = transportGroup;
    }

    @ListField(fields={@Field(title="\u0420\u0430\u0439\u043e\u043d", order=200, content=WatchAreaType.class, viewer={VMSAsyncDirectoryViewerForID.class}, propertiesLayout="Split1/h/l/0.3:00")})
    public Long[] getTypeIdList() {
        return this.typeIdList;
    }

    @ListField(fields={@Field(title="\u0421\u043f\u0438\u0441\u043e\u043a \u0434\u043e\u0440\u043e\u0433", order=80, content=RoadWAUI.class, viewer={VMSAsyncDirectoryViewerForID.class}, propertiesLayout="Split1/h/l/0.3:00")})
    public void setTypeIdList(Long[] typeIdList) {
        this.typeIdList = typeIdList;
    }

    @ListField(fields={@Field(title="\u0422\u0438\u043f \u0434\u043e\u0440\u043e\u0433\u0438", order=200, propertiesLayout="Split1/h/l/0.3:00")})
    public String getTypeRoad() {
        return this.typeRoad;
    }

    public void setTypeRoad(String typeRoad) {
        this.typeRoad = typeRoad;
    }

    @ListField(fields={@Field(title="\u0421\u043f\u0438\u0441\u043e\u043a \u0434\u043e\u0440\u043e\u0433", order=80, content=RoadWAUI.class, viewer={VMSAsyncDirectoryViewerForID.class}, propertiesLayout="Split1/h/l/0.3:00")})
    public Long[] getRoadList() {
        return this.roadList;
    }

    public void setRoadList(Long[] roadList) {
        this.roadList = roadList;
    }

    @ListField(fields={@Field(title="", order=1000, viewer={ActionButton.class}, propertiesLayout="Split1/h/l/0.3:00/spanx 2")})
    public BeanViewerAction<ViewerContext> getSv() {
        return this.sv;
    }

    @ListField(fields={@Field(title="\u041f\u0440\u0438\u043e\u0440\u0438\u0442\u0435\u0442\u043d\u0430\u044f \u0433\u0440\u0443\u043f\u043f\u0430", order=900, viewer={FRCAsyncViewerForIdSingle.class}, propertiesLayout="Split1/h/l/0.3:00/spanx 2", propertiesField={"contentclazz=ru.infor.ws.objects.core.entities.UsersGroup"})})
    public Long getPrimaryGroupId() {
        return this.primaryGroupId;
    }

    public void setPrimaryGroupId(Long primaryGroupId) {
        this.primaryGroupId = primaryGroupId;
    }

    @ListField(fields={@Field(title="\u0412\u0438\u0434 \u0440\u0430\u0431\u043e\u0442", order=910, content=RoadJobKind.class, viewer={VMSAsyncDirectoryViewerForID.class}, propertiesLayout="Split1/h/l/0.3:00")})
    public Long[] getJobKindIds() {
        return this.jobKindIds;
    }

    public void setJobKindIds(Long[] jobKindIds) {
        this.jobKindIds = jobKindIds;
    }

    public Long[] getRoadOrganizationIdList() {
        return this.roadOrganizationIdList;
    }

    public void setRoadOrganizationIdList(Long[] roadOrganizationIdList) {
        this.roadOrganizationIdList = roadOrganizationIdList;
    }

    @ListField(fields={@Field(title="", propertiesLayout="Split1/h/r/0.3:Tab1/\u041a\u0430\u0440\u0442\u0430", order=0, viewer={MapViewerUiColor.class})})
    public MapValueAll getMapValueAll() {
        return this.mapValueAll;
    }

    @ListField(fields={@Field(title="", propertiesLayout="Split1/h/r/0.3:Tab1/\u0414\u0430\u043d\u043d\u044b\u0435", order=10, viewer={ListViewer.class}, content=RoadsStatistic.class)})
    public List<RoadsStatistic> getList() {
        return this.list;
    }

    @ListView(views={@View(title="")})
    public static class RoadsStatistic {
        RoadMaintenanceStatistic statistic;
        int percent;

        public RoadsStatistic(RoadMaintenanceStatistic statistic) {
            this.statistic = statistic;
            this.percent = this.getFactVolume() == null || this.getPlanVolume() == null ? 0 : new Double(this.getFactVolume() / this.getPlanVolume() * 100.0).intValue();
        }

        @ListField(fields={@Field(title="\u0424\u0430\u043a\u0442\u0438\u0447\u0435\u0441\u043a\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435", order=400)})
        public Double getFactVolume() {
            return this.statistic.getFactVolume();
        }

        @ListField(fields={@Field(title="\u041a\u043e\u0434 \u0412\u0438\u0434\u0430 \u0440\u0430\u0431\u043e\u0442", order=100)})
        public String getJobKindCode() {
            return this.statistic.getJobKindCode();
        }

        @ListField(fields={@Field(title="\u0412\u0438\u0434 \u0440\u0430\u0431\u043e\u0442", order=200)})
        public String getJobKindDescription() {
            return this.statistic.getJobKindDescription();
        }

        public Long getJobKindId() {
            return this.statistic.getJobKindId();
        }

        @ListField(fields={@Field(title="\u041f\u043b\u0430\u043d\u043e\u0432\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435", order=300)})
        public Double getPlanVolume() {
            return this.statistic.getPlanVolume();
        }

        public RoadWA getRoad() {
            return this.statistic.getRoad();
        }

        @ListField(fields={@Field(title="\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0434\u043e\u0440\u043e\u0433\u0438", order=250)})
        public String getRoadName() {
            return this.statistic.getRoad().getName();
        }

        public Long getRoadId() {
            return this.statistic.getRoadId();
        }

        @ListField(fields={@Field(title="\u041f\u0440\u043e\u0446\u0435\u043d\u0442 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f", order=500)})
        public int getPersent() {
            return this.percent;
        }
    }
}

