/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.roads.crashdataimport;

import java.awt.Cursor;
import java.util.HashMap;
import java.util.List;
import javax.swing.JPanel;
import ru.blok.common.core.CurrentProxyFactory;
import ru.blok.common.core.InitializedVariable;
import ru.blok.vms.core.ResourceStrings;
import ru.blok.vms.ui.roads.crashdataimport.CrashDataImportForm;
import ru.blok.vms.ui.roads.crashdataimport.InputCrashData;
import ru.infor.beanviewer.core.BeanPanel;
import ru.infor.beanviewer.core.FieldPresentation;
import ru.infor.beanviewer.core.UISetter;
import ru.infor.beanviewer.dialog.InfoMessage;
import ru.infor.beanviewer.dialog.MessageOKButton;
import ru.infor.beanviewer.dialog.WarningMessage;
import ru.infor.beanviewer.viewer.BeanViewerAction;
import ru.infor.beanviewer.viewer.action.PanelContext;
import ru.infor.beanviewer.viewer.action.ViewerContext;
import ru.infor.client.soap.proxy.vms.BuildingWSProxy;
import ru.infor.client.soap.proxy.vms.CrashDataWSProxy;
import ru.infor.client.soap.proxy.vms.GravityOfCrashWSProxy;
import ru.infor.client.soap.proxy.vms.RoadWAWSProxy;
import ru.infor.ws.objects.core.DirectoriesSearchCriteria;
import ru.infor.ws.objects.vms.BuildingSearchCriteria;
import ru.infor.ws.objects.vms.CrashDataSearchCriteria;
import ru.infor.ws.objects.vms.GPSPoint;
import ru.infor.ws.objects.vms.Road4Web;
import ru.infor.ws.objects.vms.entities.Building;
import ru.infor.ws.objects.vms.entities.CrashData;
import ru.infor.ws.objects.vms.entities.GravityOfCrash;
import ru.infor.ws.objects.vms.entities.RoadWA;

public class ImportSelectCrashData
extends BeanViewerAction<ViewerContext> {
    HashMap<String, String> sp = null;
    Double deltaLat = delta / 111111.111111;
    CrashDataWSProxy proxy = (CrashDataWSProxy)CurrentProxyFactory.getProxy(CrashData.class);
    CrashDataSearchCriteria sc = new CrashDataSearchCriteria();
    BuildingWSProxy bProxy = (BuildingWSProxy)CurrentProxyFactory.getProxy(Building.class);
    BuildingSearchCriteria buildingSC = new BuildingSearchCriteria();
    RoadWAWSProxy rProxy = (RoadWAWSProxy)CurrentProxyFactory.getProxy(RoadWA.class);
    static Double delta = 500.0;

    public void actionPerformed(Object message) {
        UISetter panel = ((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getPanel();
        panel.updateMainObject();
        CrashDataImportForm form = (CrashDataImportForm)((Object)panel.getObject());
        RoadWA roadDefault = form.getRoadWA();
        if (roadDefault == null) {
            InitializedVariable.factory.runMessageEx((Object)new WarningMessage(" \u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d\u0430 \u0434\u043e\u0440\u043e\u0433\u0430 \u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e "), new BeanViewerAction[]{new MessageOKButton()});
            return;
        }
        List listImportSelect = panel.getPresentatorForName("items").getSelectedItems();
        int recCount = 0;
        if (listImportSelect != null && listImportSelect.size() > 0) {
            this.sp = InitializedVariable.runtimeParameters(null);
            if (this.sp.get("DistanceFromAddrToRoad") != null) {
                try {
                    delta = Double.parseDouble(this.sp.get("DistanceFromAddrToRoad"));
                }
                catch (Exception exception) {}
            }
            JPanel jpanel = (JPanel)((BeanPanel)InitializedVariable.getFactory((String)((ViewerContext)this.getContext()).getKeyPage()).getCurrentPanel(((ViewerContext)this.getContext()).getKeyPage())).getPanel();
            jpanel.setCursor(Cursor.getPredefinedCursor(3));
            try {
                recCount = this.importData(listImportSelect, roadDefault.getId());
                FieldPresentation fp = panel.getPresentatorForName("items");
                panel.updateField(fp);
                panel.updateUIForPresentatorName("items");
            }
            finally {
                jpanel.setCursor(Cursor.getPredefinedCursor(0));
            }
            InitializedVariable.factory.runMessageEx((Object)new InfoMessage(" Info ", new String[]{" \u0418\u043c\u043f\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u043e \u0441\u0442\u0440\u043e\u043a : " + recCount + " \u0438\u0437 \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0445 : " + listImportSelect.size()}), new BeanViewerAction[]{new MessageOKButton()});
        } else {
            InitializedVariable.factory.runMessageEx((Object)new WarningMessage(" \u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d\u044b \u0441\u0442\u0440\u043e\u043a\u0438 \u0434\u043b\u044f \u0438\u043c\u043f\u043e\u0440\u0442\u0430 "), new BeanViewerAction[]{new MessageOKButton()});
        }
    }

    private int importData(List<Object> listImportSelect, Long roadDefId) {
        int objImportCount = 0;
        HashMap<String, GravityOfCrash> listGravityOfCrash = this.getGravityOfCrashMap(listImportSelect);
        this.gravityOfCrashAdd2Dir(listGravityOfCrash);
        for (Object obj : listImportSelect) {
            InputCrashData inputCrashData = (InputCrashData)obj;
            CrashData crash = null;
            boolean bImport = true;
            try {
                crash = inputCrashData.mapCrashData();
                crash.setGravityOfCrash(listGravityOfCrash.get(inputCrashData.getField08().trim()));
                GPSPoint point = this.calcPoint(inputCrashData.getField03(), inputCrashData.getStreet(), inputCrashData.getNumHouse());
                if (point != null) {
                    crash.setLat(point.getLat());
                    crash.setLon(point.getLon());
                    Long id = this.getRoadId(point.getLat(), point.getLon(), point.getLat() + this.deltaLat, point.getLon());
                    if (id == null) {
                        id = roadDefId;
                    }
                    crash.setRoadId(id);
                }
                this.sc.setGravityOfCrashIdList(new Long[]{crash.getGravityOfCrash().getId()});
                this.sc.setDescription(crash.getDescription());
                this.sc.setCount(Integer.valueOf(1));
                this.sc.setCrashDateFrom(crash.getCrashDate());
                this.sc.setCrashDateTill(crash.getCrashDate());
                CrashDataWSProxy.SearchResultListCrashData srList = this.proxy.getList(InitializedVariable.context, this.sc);
                if (srList != null && !srList.isEmpty()) {
                    crash.setId(((CrashData)srList.getObjList()[0]).getId());
                }
                if (crash.getRoadId() != null) {
                    crash = this.proxy.save(InitializedVariable.context, crash);
                }
            }
            catch (Exception e) {
                bImport = false;
                e.printStackTrace();
            }
            if (!bImport || crash == null || crash.getRoadId() == null) continue;
            ++objImportCount;
            inputCrashData.setImportRes("\u0412\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u043e");
        }
        return objImportCount;
    }

    private HashMap<String, GravityOfCrash> getGravityOfCrashMap(List<Object> objects) {
        HashMap<String, GravityOfCrash> map = new HashMap<String, GravityOfCrash>();
        for (Object obj : objects) {
            InputCrashData tcRec = (InputCrashData)obj;
            map.put(tcRec.getField08().trim(), null);
        }
        return map;
    }

    private void gravityOfCrashAdd2Dir(HashMap<String, GravityOfCrash> map) {
        GravityOfCrashWSProxy gcProxy = (GravityOfCrashWSProxy)CurrentProxyFactory.getProxy(GravityOfCrash.class);
        DirectoriesSearchCriteria dSc = new DirectoriesSearchCriteria();
        dSc.setCount(Integer.valueOf(1));
        for (String objKey : map.keySet()) {
            dSc.setDescription("*" + objKey + "*");
            GravityOfCrash obj = null;
            try {
                GravityOfCrashWSProxy.SearchResultListGravityOfCrash srList = gcProxy.getList(InitializedVariable.context, dSc);
                if (srList != null && !srList.isEmpty()) {
                    obj = (GravityOfCrash)srList.getObjList()[0];
                } else {
                    obj = new GravityOfCrash();
                    obj.setCode(objKey);
                    obj.setDescription(objKey);
                    obj = gcProxy.save(InitializedVariable.context, obj);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (obj == null) continue;
            map.put(objKey, obj);
        }
    }

    private GPSPoint calcPoint(String cityName, String street, String houseNumber) {
        this.buildingSC.setCityName(cityName);
        this.buildingSC.setStreet(street);
        this.buildingSC.setHouseNumber("*" + houseNumber + "*");
        GPSPoint point = this.bProxy.calculateCoordinatesAt(InitializedVariable.context, this.buildingSC);
        return point;
    }

    private Long getRoadId(Double latc, Double lonc, Double latr, Double lonr) {
        Road4Web[] r = this.rProxy.findNearestRoads(InitializedVariable.context, latc, lonc, latr, lonr);
        if (r.length > 0) {
            return r[0].getId();
        }
        return null;
    }

    public String getHint() {
        return "\u0418\u043c\u043f\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0435";
    }

    public String getName() {
        return "\u0418\u043c\u043f\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0435";
    }

    public String getIcon() {
        return ResourceStrings.btPageAdd;
    }
}

