/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.roads.crashdataimport;

import java.awt.Cursor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;
import org.postgis.Geometry;
import org.postgis.Point;
import ru.blok.common.core.CurrentProxyFactory;
import ru.blok.common.core.InitializedVariable;
import ru.blok.vms.core.ResourceStrings;
import ru.blok.vms.ui.geo.GeoUtils;
import ru.blok.vms.ui.roads.crashdataimport.CrashDataImportForm4Stationing;
import ru.blok.vms.ui.roads.crashdataimport.InputCrashData4Stationing;
import ru.infor.beanviewer.core.BeanPanel;
import ru.infor.beanviewer.core.FieldPresentation;
import ru.infor.beanviewer.core.UISetter;
import ru.infor.beanviewer.dialog.InfoMessage;
import ru.infor.beanviewer.dialog.MessageOKButton;
import ru.infor.beanviewer.dialog.WarningMessage;
import ru.infor.beanviewer.viewer.BeanViewerAction;
import ru.infor.beanviewer.viewer.action.PanelContext;
import ru.infor.beanviewer.viewer.action.ViewerContext;
import ru.infor.client.soap.proxy.vms.BuildingWSProxy;
import ru.infor.client.soap.proxy.vms.CrashDataWSProxy;
import ru.infor.client.soap.proxy.vms.GravityOfCrashWSProxy;
import ru.infor.client.soap.proxy.vms.StationingWSProxy;
import ru.infor.ws.objects.core.DirectoriesSearchCriteria;
import ru.infor.ws.objects.vms.BuildingSearchCriteria;
import ru.infor.ws.objects.vms.CrashDataSearchCriteria;
import ru.infor.ws.objects.vms.StationingData;
import ru.infor.ws.objects.vms.entities.Building;
import ru.infor.ws.objects.vms.entities.CrashData;
import ru.infor.ws.objects.vms.entities.GravityOfCrash;
import ru.infor.ws.objects.vms.entities.RoadWA;
import ru.infor.ws.objects.vms.entities.Stationing;

public class ImportSelectCrashData4Stationing
extends BeanViewerAction<ViewerContext> {
    CrashDataWSProxy proxy = (CrashDataWSProxy)CurrentProxyFactory.getProxy(CrashData.class);
    CrashDataSearchCriteria sc = new CrashDataSearchCriteria();
    BuildingWSProxy bProxy = (BuildingWSProxy)CurrentProxyFactory.getProxy(Building.class);
    BuildingSearchCriteria buildingSC = new BuildingSearchCriteria();

    public void actionPerformed(Object message) {
        UISetter panel = ((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getPanel();
        panel.updateMainObject();
        CrashDataImportForm4Stationing form = (CrashDataImportForm4Stationing)((Object)panel.getObject());
        RoadWA roadDefault = form.getRoadWA();
        if (roadDefault == null) {
            InitializedVariable.factory.runMessageEx((Object)new WarningMessage(" \u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d\u0430 \u0434\u043e\u0440\u043e\u0433\u0430 \u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e "), new BeanViewerAction[]{new MessageOKButton()});
            return;
        }
        List listImportSelect = panel.getPresentatorForName("items").getSelectedItems();
        int recCount = 0;
        if (listImportSelect != null && listImportSelect.size() > 0) {
            JPanel jpanel = (JPanel)((BeanPanel)InitializedVariable.getFactory((String)((ViewerContext)this.getContext()).getKeyPage()).getCurrentPanel(((ViewerContext)this.getContext()).getKeyPage())).getPanel();
            jpanel.setCursor(Cursor.getPredefinedCursor(3));
            try {
                recCount = this.importData(listImportSelect, roadDefault);
                FieldPresentation fp = panel.getPresentatorForName("items");
                panel.updateField(fp);
                panel.updateUIForPresentatorName("items");
            }
            finally {
                jpanel.setCursor(Cursor.getPredefinedCursor(0));
            }
            InitializedVariable.factory.runMessageEx((Object)new InfoMessage(" Info ", new String[]{" \u0418\u043c\u043f\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u043e \u0441\u0442\u0440\u043e\u043a : " + recCount + " \u0438\u0437 \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0445 : " + listImportSelect.size()}), new BeanViewerAction[]{new MessageOKButton()});
        } else {
            InitializedVariable.factory.runMessageEx((Object)new WarningMessage(" \u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d\u044b \u0441\u0442\u0440\u043e\u043a\u0438 \u0434\u043b\u044f \u0438\u043c\u043f\u043e\u0440\u0442\u0430 "), new BeanViewerAction[]{new MessageOKButton()});
        }
    }

    private int importData(List<Object> listImportSelect, RoadWA roadDef) {
        Point[] points;
        int objImportCount = 0;
        HashMap<String, GravityOfCrash> listGravityOfCrash = this.getGravityOfCrashMap(listImportSelect);
        this.gravityOfCrashAdd2Dir(listGravityOfCrash);
        CrashDataImportForm4Stationing form = (CrashDataImportForm4Stationing)((Object)((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getObject());
        Map<String, Long> allRoads = form.getRoadsMap();
        StationingWSProxy sProxy = (StationingWSProxy)CurrentProxyFactory.getProxy(Stationing.class);
        Point pointDef = null;
        Geometry p = GeoUtils.buildGeometryFromString(roadDef.getRoadgeom());
        if (p != null && (points = GeoUtils.getAllPoints(p)).length > 0) {
            pointDef = new Point(points[0].getX(), points[0].getY());
        }
        for (Object obj : listImportSelect) {
            InputCrashData4Stationing inputCrashData = (InputCrashData4Stationing)obj;
            CrashData crash = null;
            boolean bImport = true;
            try {
                crash = inputCrashData.mapCrashData();
                crash.setGravityOfCrash(listGravityOfCrash.get(inputCrashData.getField08().trim()));
                String roadName = form.getRightString(inputCrashData.getField02());
                Long roadId = allRoads.get(roadName);
                if (roadId != null) {
                    crash.setRoadId(roadId);
                    try {
                        Stationing stationing = new Stationing();
                        stationing.setRoad_id(roadId);
                        stationing.setNum(Integer.valueOf(Integer.parseInt(inputCrashData.getField03())));
                        StationingData sd = new StationingData();
                        sd.setLength(Double.valueOf(Double.parseDouble(inputCrashData.getField04())));
                        sd.setStationing(stationing);
                        sd = sProxy.nearStationing(InitializedVariable.context, sd);
                        if (sd != null && sd.getLat() != null && sd.getLon() != null) {
                            crash.setLat(sd.getLat());
                            crash.setLon(sd.getLon());
                        }
                    }
                    catch (Exception exception) {}
                } else {
                    crash.setRoadId(roadDef.getId());
                    if (pointDef != null) {
                        crash.setLon(Double.valueOf(pointDef.getX()));
                        crash.setLat(Double.valueOf(pointDef.getY()));
                    }
                }
                this.sc.setGravityOfCrashIdList(new Long[]{crash.getGravityOfCrash().getId()});
                this.sc.setDescription(crash.getDescription());
                this.sc.setCount(Integer.valueOf(1));
                CrashDataWSProxy.SearchResultListCrashData srList = this.proxy.getList(InitializedVariable.context, this.sc);
                if (srList != null && !srList.isEmpty()) {
                    crash.setId(((CrashData)srList.getObjList()[0]).getId());
                }
                if (crash.getRoadId() != null) {
                    crash = this.proxy.save(InitializedVariable.context, crash);
                }
            }
            catch (Exception e) {
                bImport = false;
                e.printStackTrace();
            }
            if (!bImport || crash == null || crash.getRoadId() == null) continue;
            ++objImportCount;
            inputCrashData.setImportRes("\u0412\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u043e");
        }
        return objImportCount;
    }

    private HashMap<String, GravityOfCrash> getGravityOfCrashMap(List<Object> objects) {
        HashMap<String, GravityOfCrash> map = new HashMap<String, GravityOfCrash>();
        for (Object obj : objects) {
            InputCrashData4Stationing tcRec = (InputCrashData4Stationing)obj;
            map.put(tcRec.getField08().trim(), null);
        }
        return map;
    }

    private void gravityOfCrashAdd2Dir(HashMap<String, GravityOfCrash> map) {
        if (map != null) {
            GravityOfCrashWSProxy gcProxy = (GravityOfCrashWSProxy)CurrentProxyFactory.getProxy(GravityOfCrash.class);
            DirectoriesSearchCriteria dSc = new DirectoriesSearchCriteria();
            dSc.setCount(Integer.valueOf(1));
            for (String objKey : map.keySet()) {
                dSc.setDescription("*" + objKey + "*");
                GravityOfCrash obj = null;
                try {
                    GravityOfCrashWSProxy.SearchResultListGravityOfCrash srList = gcProxy.getList(InitializedVariable.context, dSc);
                    if (srList != null && !srList.isEmpty()) {
                        obj = (GravityOfCrash)srList.getObjList()[0];
                    } else {
                        obj = new GravityOfCrash();
                        obj.setCode(objKey);
                        obj.setDescription(objKey);
                        obj = gcProxy.save(InitializedVariable.context, obj);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                map.put(objKey, obj);
            }
        }
    }

    public String getHint() {
        return "\u0418\u043c\u043f\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0435";
    }

    public String getName() {
        return "\u0418\u043c\u043f\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0435";
    }

    public String getIcon() {
        return ResourceStrings.btPageAdd;
    }
}

