/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.roads.josm;

import java.awt.Component;
import java.sql.SQLException;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;
import ru.blok.common.core.CurrentProxyFactory;
import ru.blok.common.core.InitializedVariable;
import ru.blok.vms.ui.josm.CommonDataSet;
import ru.blok.vms.ui.roads.josm.WidthDialog;
import ru.infor.client.soap.proxy.vms.RoadWAWSProxy;
import ru.infor.ws.objects.vms.entities.RoadWA;
import ru.infor.ws.objects.vms.ext.Geozone;

public class ZoneDataSet
extends CommonDataSet {
    RoadWAWSProxy proxy = (RoadWAWSProxy)CurrentProxyFactory.getProxy(RoadWA.class);
    RoadWA w1;
    Way track;

    public ZoneDataSet(Geozone w, String keyPage) throws SQLException {
        super(keyPage);
        this.analysGeom(w.getGeom());
    }

    public ZoneDataSet(RoadWA w, String keyPage) throws SQLException {
        super(keyPage);
        this.w1 = this.proxy.getCurrentObject(InitializedVariable.context, w.getId());
        String geom = this.w1.getRoadgeom();
        this.analysGeom(geom);
    }

    @Override
    protected String getSRID() {
        return "";
    }

    @Override
    protected boolean saveObject(String geom) {
        if (this.w1.getReadWidth() == null || this.w1.getReadWidth() == 0.0) {
            this.w1.setReadWidth(Double.valueOf(20.0));
        }
        WidthDialog dlg = new WidthDialog(this.w1.getReadWidth());
        ExtendedDialog d = new ExtendedDialog(Main.parent, "\u0414\u0430\u043d\u043d\u044b\u0435", new String[]{I18n.tr((String)"Apply", (Object[])new Object[]{""}), I18n.tr((String)"Cancel", (Object[])new Object[]{""})});
        d.setContent((Component)dlg);
        d.showDialog();
        int answer = d.getValue();
        if (answer == 1 && (OsmDataLayer)Main.map.mapView.getActiveLayer() != null) {
            Double z = dlg.getThickness();
            this.w1.setReadWidth(z);
            if (this.w1.getReadWidth() == null || this.w1.getReadWidth() == 0.0) {
                this.w1.setReadWidth(Double.valueOf(20.0));
            }
            this.w1.setRoadgeom(geom);
            this.proxy.buildAreaAroundTheRoad(InitializedVariable.context, this.w1, null);
        }
        return true;
    }
}

