/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.roads.roadsonmap;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jxmapviewer.JXMapViewer;
import org.jxmapviewer.viewer.GeoPosition;
import org.postgis.Geometry;
import org.postgis.MultiLineString;
import ru.blok.vms.ui.mapviewer.MapValue;
import ru.blok.vms.ui.mapviewer.MapViewer;
import ru.blok.vms.ui.roads.roadsonmap.MapValueAll;
import ru.blok.vms.ui.roads.roadsonmap.PainterAll;
import ru.blok.vms.ui.roads.roadsonmap.PainterStationing;
import ru.infor.beanviewer.core.UIFactory;
import ru.infor.ws.objects.vms.entities.ext.RoadWAExt;

public class MapViewerAll
extends MapViewer {
    PainterAll<JXMapViewer> routePainter2;
    PainterStationing<JXMapViewer> painterStationing;
    JCheckBox showStationing;

    public MapViewerAll(UIFactory<JComponent> factory) {
        super(factory);
    }

    @Override
    protected void init() {
        super.init();
        this.routePainter2 = new PainterAll();
        this.painter.addPainter(this.routePainter2);
        this.painterStationing = new PainterStationing();
    }

    @Override
    protected boolean canGoToData() {
        return true;
    }

    @Override
    protected void mouseClickedOnMap(double x, double y, GeoPosition gp, MouseEvent e) {
    }

    @Override
    protected MapValue getNewInstance(double lat, double lon, int zoom) {
        return new MapValueAll(this.coord[0], this.coord[1], this.coord[2].intValue());
    }

    @Override
    protected Double[] getMinMax() {
        Double minLat = null;
        Double maxLat = null;
        Double minLon = null;
        Double maxLon = null;
        if (this.routePainter2.getValueAll() != null && this.routePainter2.getValueAll().getList() != null && this.routePainter2.getValueAll().getList().size() > 0) {
            for (RoadWAExt r : this.routePainter2.getValueAll().getList()) {
                MultiLineString lineString = r.getCurrentLine();
                if (lineString != null) {
                    int i = 0;
                    while (i < lineString.numPoints()) {
                        double lat = lineString.getPoint(i).getY();
                        double lon = lineString.getPoint(i).getX();
                        if (minLat == null || lat < minLat) {
                            minLat = lat;
                        }
                        if (maxLat == null || lat > maxLat) {
                            maxLat = lat;
                        }
                        if (minLon == null || lon < minLon) {
                            minLon = lon;
                        }
                        if (maxLon == null || lon > maxLon) {
                            maxLon = lon;
                        }
                        ++i;
                    }
                    continue;
                }
                Geometry g = r.getCurrentPolygon();
                if (g == null) continue;
                int i = 0;
                while (i < g.numPoints()) {
                    double lat = g.getPoint(i).getY();
                    double lon = g.getPoint(i).getX();
                    if (minLat == null || lat < minLat) {
                        minLat = lat;
                    }
                    if (maxLat == null || lat > maxLat) {
                        maxLat = lat;
                    }
                    if (minLon == null || lon < minLon) {
                        minLon = lon;
                    }
                    if (maxLon == null || lon > maxLon) {
                        maxLon = lon;
                    }
                    ++i;
                }
            }
        }
        if (minLat == null) {
            return null;
        }
        return new Double[]{minLat, maxLat, minLon, maxLon};
    }

    @Override
    public void setValue(Object arg0) {
        super.setValue(arg0);
        if (this.getValue() != null) {
            this.routePainter2.setValueAll((MapValueAll)this.getValue());
            this.painterStationing.setListR(((MapValueAll)this.getValue()).getList());
        }
        this.zoomToTracks();
    }

    public boolean isShowStationing() {
        return this.showStationing.isSelected();
    }

    @Override
    protected void addPanelBttn(JPanel p2) {
        this.showStationing = new JCheckBox("\u041e\u0442\u043e\u0431\u0440\u0430\u0437\u0438\u0442\u044c \u043f\u0438\u043a\u0435\u0442\u0430\u0436");
        this.showStationing.setSelected(false);
        p2.add(this.showStationing);
        this.showStationing.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MapViewerAll.this.showStationing.isSelected()) {
                    MapViewerAll.this.painter.addPainter(MapViewerAll.this.painterStationing);
                } else {
                    MapViewerAll.this.painter.removePainter(MapViewerAll.this.painterStationing);
                }
                MapViewerAll.this.repaint();
            }
        });
        super.addPanelBttn(p2);
    }
}

