/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.roads.roadsonmap;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import org.apache.log4j.Logger;
import org.jxmapviewer.JXMapViewer;
import org.jxmapviewer.viewer.GeoPosition;
import org.postgis.Point;
import ru.blok.vms.ui.roads.roadsonmap.MapValueAll;
import ru.blok.vms.ui.route.routegeom.NewRoutePainter;
import ru.infor.ws.objects.vms.entities.ext.RoadWAExt;

public class PainterAll<T extends JXMapViewer>
extends NewRoutePainter<JXMapViewer> {
    private static Logger logger = Logger.getLogger(PainterAll.class);
    private MapValueAll valueAll;

    public MapValueAll getValueAll() {
        return this.valueAll;
    }

    public void setValueAll(MapValueAll valueAll) {
        this.valueAll = valueAll;
    }

    @Override
    public void doPaint(Graphics2D g, JXMapViewer map, int width, int height) {
        Rectangle viewportBounds = map.getViewportBounds();
        int zoom = map.getZoom();
        Dimension sizeInTiles = map.getTileFactory().getMapSize(zoom);
        int tileSize = map.getTileFactory().getTileSize(zoom);
        Dimension sizeInPixels = new Dimension(sizeInTiles.width * tileSize, sizeInTiles.height * tileSize);
        double vpx = viewportBounds.getX();
        while (vpx < 0.0) {
            vpx += sizeInPixels.getWidth();
        }
        while (vpx > sizeInPixels.getWidth()) {
            vpx -= sizeInPixels.getWidth();
        }
        Rectangle2D.Double vp2 = new Rectangle2D.Double(vpx, viewportBounds.getY(), viewportBounds.getWidth(), viewportBounds.getHeight());
        if (this.valueAll != null && this.valueAll.getList() != null && this.valueAll.getList().size() > 0) {
            for (RoadWAExt r : this.valueAll.getList()) {
                if (r.getCurrentPolygon() == null) continue;
                Color c = this.valueAll.getColor(r);
                PainterAll.paintPolygon(r.getCurrentPolygon(), map, g, (Rectangle2D)vp2, c, 150);
                if (map.getZoom() >= 12) continue;
                Point p = null;
                if (r.getCurrentLine() != null) {
                    p = r.getCurrentLine().getPoint(0);
                } else if (r.getCurrentPolygon() != null) {
                    p = r.getCurrentPolygon().getPoint(0);
                }
                if (p == null) continue;
                Point2D point = map.getTileFactory().geoToPixel(new GeoPosition(p.getY(), p.getX()), map.getZoom());
                int x = (int)(point.getX() - ((RectangularShape)vp2).getX());
                int y = (int)(point.getY() - ((RectangularShape)vp2).getY());
                g.translate(x, y);
                g.setColor(Color.BLACK);
                g.drawString(r.getName(), 0, 0);
                g.translate(-x, -y);
            }
        }
        if (this.valueAll.getAlarm() != null) {
            Point2D point = map.getTileFactory().geoToPixel(this.valueAll.getAlarm(), map.getZoom());
            int x = (int)(point.getX() - ((RectangularShape)vp2).getX());
            int y = (int)(point.getY() - ((RectangularShape)vp2).getY());
            g.translate(x, y);
            g.setColor(Color.BLACK);
            this.paintNode(g, map);
            g.translate(-x, -y);
        }
    }

    public boolean paintNode(Graphics2D g, JXMapViewer ma) {
        Polygon p = new Polygon();
        p.addPoint(0, -15);
        p.addPoint(-15, -15);
        p.addPoint(-15, -25);
        p.addPoint(1, -25);
        p.addPoint(1, 0);
        g.setColor(Color.BLACK);
        g.drawPolygon(p);
        g.setColor(Color.RED);
        g.fillPolygon(p);
        return false;
    }
}

