/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.roads.roadsonmap;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.jxmapviewer.JXMapViewer;
import org.jxmapviewer.viewer.GeoPosition;
import ru.blok.vms.ui.route.routegeom.NewRoutePainter;
import ru.infor.ws.objects.vms.entities.Stationing;
import ru.infor.ws.objects.vms.entities.ext.RoadWAExt;

public class PainterStationing<T extends JXMapViewer>
extends NewRoutePainter<JXMapViewer> {
    private static Logger logger = Logger.getLogger(PainterStationing.class);
    List<RoadWAExt> listR = new ArrayList<RoadWAExt>();

    public void setListR(List<RoadWAExt> listR) {
        this.listR = listR;
    }

    public List<RoadWAExt> getListR() {
        return this.listR;
    }

    public void addRoad(RoadWAExt w) {
        this.listR.add(w);
    }

    public void clear() {
        this.listR.clear();
    }

    @Override
    public void doPaint(Graphics2D g, JXMapViewer map, int width, int height) {
        Rectangle viewportBounds = map.getViewportBounds();
        int zoom = map.getZoom();
        Dimension sizeInTiles = map.getTileFactory().getMapSize(zoom);
        int tileSize = map.getTileFactory().getTileSize(zoom);
        Dimension sizeInPixels = new Dimension(sizeInTiles.width * tileSize, sizeInTiles.height * tileSize);
        double vpx = viewportBounds.getX();
        while (vpx < 0.0) {
            vpx += sizeInPixels.getWidth();
        }
        while (vpx > sizeInPixels.getWidth()) {
            vpx -= sizeInPixels.getWidth();
        }
        Rectangle2D.Double vp2 = new Rectangle2D.Double(vpx, viewportBounds.getY(), viewportBounds.getWidth(), viewportBounds.getHeight());
        for (RoadWAExt r : this.listR) {
            if (r.getListStationings() == null) continue;
            for (Stationing st : r.getListStationings()) {
                Point2D point = map.getTileFactory().geoToPixel(new GeoPosition(st.getLat().doubleValue(), st.getLon().doubleValue()), map.getZoom());
                int x = (int)(point.getX() - ((RectangularShape)vp2).getX());
                int y = (int)(point.getY() - ((RectangularShape)vp2).getY());
                g.setColor(Color.decode("#dc8181"));
                g.fillOval(x - 10, y - 10, 20, 20);
                g.setColor(Color.decode("#782121"));
                g.drawOval(x - 10, y - 10, 20, 20);
                g.setColor(Color.BLACK);
                int dx = g.getFontMetrics().stringWidth(st.getNum().toString());
                int dh = g.getFontMetrics().getHeight();
                g.drawString(st.getNum().toString(), x - dx / 2, y + dh / 2 - 3);
            }
        }
    }
}

