/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.roads.roadspoint;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.io.WKTWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.geotools.geometry.jts.JTS;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.postgis.LineString;
import org.postgis.MultiLineString;
import org.postgis.Polygon;
import ru.blok.common.core.CommonObjectWithKey;
import ru.blok.common.core.CurrentProxyFactory;
import ru.blok.common.core.InitializedVariable;
import ru.blok.common.core.ResourceStrings;
import ru.blok.vms.ui.conductor.statistic.OKButtonLocateUpdateUI;
import ru.infor.beanviewer.annotation.ActionViewer;
import ru.infor.beanviewer.annotation.Field;
import ru.infor.beanviewer.annotation.ListField;
import ru.infor.beanviewer.annotation.ListView;
import ru.infor.beanviewer.annotation.View;
import ru.infor.beanviewer.viewer.ActionButton;
import ru.infor.beanviewer.viewer.AsyncBVA;
import ru.infor.beanviewer.viewer.BeanViewerAction;
import ru.infor.beanviewer.viewer.action.PanelContext;
import ru.infor.beanviewer.viewer.action.ViewerContext;
import ru.infor.beanviewer.viewer.simple.PasswordViewer;
import ru.infor.client.soap.proxy.vms.RoadWAWSProxy;
import ru.infor.ws.objects.vms.entities.RoadWA;
import ru.infor.ws.objects.vms.entities.ext.RoadWAExt;

@ListView(views={@View(title="\u0418\u043c\u043f\u043e\u0440\u0442 \u0434\u043e\u0440\u043e\u0433 \u0438\u0437 OSM", layoutKeys={"tabSplitPercentLayoutManager"}, actions={@ActionViewer(clazz=OKButtonLocateUpdateUI.class)})})
public class ImportFromOsm
extends CommonObjectWithKey {
    String database = "servera/osm";
    String user = "openstreetmap";
    char[] passwd = "openstreetmap".toCharArray();
    private BeanViewerAction<ViewerContext> con = new BeanViewerAction<ViewerContext>(){

        public String getName() {
            return "\u041f\u043e\u0434\u043a\u043b\u044e\u0447\u0438\u0442\u044c\u0441\u044f";
        }

        public void actionPerformed(Object message) {
            ((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getPanel().updateMainObject();
            ImportFromOsm.this.connect(ImportFromOsm.this.database, ImportFromOsm.this.user, new String(ImportFromOsm.this.passwd));
        }
    };
    BeanViewerAction<ViewerContext> run = new AsyncBVA<Object, ViewerContext>((o, ctx) -> {
        ((PanelContext)ctx.getParentContext()).getPanel().updateMainObject();
        this.runImport();
        return null;
    }, (o, ctx) -> {}, (o, c) -> {}){

        public String getHint() {
            return "\u0412\u044b\u043f\u043e\u043b\u043d\u0438\u0442\u044c \u0438\u043c\u043f\u043e\u0440\u0442";
        }

        public String getIcon() {
            return ResourceStrings.btImportRM;
        }
    };
    Connection connection = null;
    private static MathTransform polar2flat;
    private static MathTransform flat2polar;
    private static WKTWriter wkt;

    static {
        wkt = new WKTWriter();
        try {
            polar2flat = CRS.findMathTransform((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, (CoordinateReferenceSystem)CRS.decode((String)"EPSG:3857"), (boolean)true);
            flat2polar = CRS.findMathTransform((CoordinateReferenceSystem)CRS.decode((String)"EPSG:3857"), (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, (boolean)true);
        }
        catch (FactoryException e) {
            e.printStackTrace();
        }
    }

    public ImportFromOsm(String keyPage) {
        super(keyPage);
    }

    @ListField(fields={@Field(title="\u0411\u0430\u0437\u0430 \u0434\u0430\u043d\u043d\u044b\u0445", order=10, propertiesLayout="1//\u041f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0435# w 300")})
    public String getDatabase() {
        return this.database;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    @ListField(fields={@Field(title="\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c", order=20, propertiesLayout="1# w 300")})
    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    @ListField(fields={@Field(title="\u041f\u0430\u0440\u043e\u043b\u044c", order=30, viewer={PasswordViewer.class}, propertiesLayout="1# w 300")})
    public char[] getPasswd() {
        return this.passwd;
    }

    public void setPasswd(char[] passwd) {
        this.passwd = passwd;
    }

    @ListField(fields={@Field(title="", order=40, viewer={ActionButton.class}, propertiesLayout="1# w 300")})
    public BeanViewerAction<ViewerContext> getCon() {
        return this.con;
    }

    @ListField(fields={@Field(title="", order=1500, viewer={ActionButton.class}, propertiesLayout="1# w 300")})
    public BeanViewerAction<ViewerContext> getrunImport() {
        return this.run;
    }

    public void connect(String database, String user, String passwd) {
        try {
            if (this.connection != null) {
                this.connection.close();
            }
            Class.forName("org.postgresql.Driver");
            this.connection = DriverManager.getConnection("jdbc:postgresql://" + database, user, passwd);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void runImport() {
        try {
            Statement stmt1 = this.connection.createStatement();
            ResultSet rs = stmt1.executeQuery("\tSELECT id FROM ways w join way_tags t on w.id = t.way_id and t.k = 'highway'");
            this.saveWayFromRS(rs);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void saveWayFromRS(ResultSet rs) throws SQLException, MismatchedDimensionException, TransformException {
        Statement stmt2 = this.connection.createStatement();
        RoadWAWSProxy proxy = (RoadWAWSProxy)CurrentProxyFactory.getProxy(RoadWA.class);
        int i = 0;
        while (rs.next()) {
            Polygon p1;
            ++i;
            String id = rs.getString("id");
            RoadWAExt road = new RoadWAExt();
            ResultSet rs2 = stmt2.executeQuery(" select ST_X(n.geom) as lon , ST_Y(n.geom) as lat, n.id from way_nodes wn join nodes n on wn.node_id = n.id  where way_id = " + id + " order by sequence_id");
            ArrayList<Coordinate> lsrc = new ArrayList<Coordinate>();
            while (rs2.next()) {
                Coordinate c = new Coordinate(rs2.getDouble("lon"), rs2.getDouble("lat"));
                lsrc.add(c);
            }
            rs2.close();
            Coordinate[] src = lsrc.toArray(new Coordinate[lsrc.size()]);
            GeometryFactory f = new GeometryFactory();
            com.vividsolutions.jts.geom.LineString s = f.createLineString(src);
            MultiLineString currentLine = new MultiLineString(new LineString[]{new LineString(s.toString())});
            currentLine.setSrid(4326);
            Polygon currentPolygon = null;
            road.setReadWidth(20.0);
            currentPolygon = p1 = new Polygon(wkt.write(JTS.transform((Geometry)JTS.transform((Geometry)s, (MathTransform)polar2flat).buffer(road.getReadWidth().doubleValue()), (MathTransform)flat2polar)));
            currentPolygon.setSrid(4326);
            road.setRoadgeom(currentLine.toString());
            road.setAreageom(currentPolygon.toString());
            rs2 = stmt2.executeQuery(" select * from way_tags where way_id = " + id);
            while (rs2.next()) {
                String key = rs2.getString("k");
                String value = rs2.getString("v");
                if (!"name".equals(key)) continue;
                road.setName(value);
            }
            rs2.close();
            if (road.getName() == null || "".equals(road.getName())) {
                road.setName("\u0414\u043e\u0440\u043e\u0433\u0430 " + id);
            }
            road.setInvNum(id);
            proxy.save(InitializedVariable.context, (RoadWA)road);
            System.out.println("save " + i);
        }
        rs.close();
        stmt2.close();
    }
}

