/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.roads.roadspoint;

import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Point2D;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import org.jxmapviewer.JXMapViewer;
import org.jxmapviewer.viewer.GeoPosition;
import org.postgis.Geometry;
import org.postgis.MultiLineString;
import ru.blok.common.core.CurrentProxyFactory;
import ru.blok.common.core.InitializedVariable;
import ru.blok.common.ui.list.ObjectUIList;
import ru.blok.common.utils.CoordinatesDownTown;
import ru.blok.vms.ui.HelpUtils;
import ru.blok.vms.ui.mapviewer.MapValue;
import ru.blok.vms.ui.mapviewer.mapviewerwithtrack.view.IconPainter;
import ru.blok.vms.ui.roads.RoadList;
import ru.blok.vms.ui.roads.roadsonmap.PainterStationing;
import ru.blok.vms.ui.roads.roadspoint.RoadList3;
import ru.blok.vms.ui.roads.roadspoint.roadobject.PainterRoad;
import ru.blok.vms.ui.roads.roadspoint.roadobject.PainterTraffic;
import ru.infor.beanviewer.core.BeanPanel;
import ru.infor.beanviewer.core.UIFactory;
import ru.infor.beanviewer.dialog.ErrorMessage;
import ru.infor.beanviewer.dialog.MessageOKButton;
import ru.infor.beanviewer.viewer.BeanViewerAction;
import ru.infor.beanviewer.viewer.DefaultTableCellViewer;
import ru.infor.beanviewer.viewer.action.PanelContext;
import ru.infor.beanviewer.viewer.action.ViewerContext;
import ru.infor.client.soap.proxy.core.SecurityWSProxy;
import ru.infor.client.soap.proxy.vms.RoadWAWSProxy;
import ru.infor.ws.objects.vms.PhotoDataSearchCriteria;
import ru.infor.ws.objects.vms.entities.CrashData;
import ru.infor.ws.objects.vms.entities.GravityOfCrash;
import ru.infor.ws.objects.vms.entities.PhotoData;
import ru.infor.ws.objects.vms.entities.PointWeightControl;
import ru.infor.ws.objects.vms.entities.RoadObject;
import ru.infor.ws.objects.vms.entities.RoadRepair;
import ru.infor.ws.objects.vms.entities.RoadWA;
import ru.infor.ws.objects.vms.entities.StationAsudd;
import ru.infor.ws.objects.vms.entities.TrafficObject;
import ru.infor.ws.objects.vms.entities.ext.RoadDefectExt;
import ru.infor.ws.objects.vms.entities.ext.RoadWAExt;

public class MapViewer
extends ru.blok.vms.ui.mapviewer.MapViewer {
    HashMap<String, String> sp = null;
    Integer diametrdtp = 15;
    JInternalFrame f;
    JTextPane textPane;
    JLayeredPane pane;
    ViewerContext vc = new ViewerContext();
    JInternalFrame ffoto;
    BeanPanel<JComponent> pageContainerpanel;
    PainterStationing<JXMapViewer> painterStationing;
    protected Double[] coord;
    MapValue value;
    IconPainter<JXMapViewer> iconPainter;
    PainterRoad<JXMapViewer> roadpainter;
    PainterTraffic<JXMapViewer> trafficPainter;
    PainterTraffic<JXMapViewer> repairPainter;
    RoadList3 roadlist3;
    RoadWAWSProxy proxy = (RoadWAWSProxy)CurrentProxyFactory.getProxy(RoadWA.class);
    HashMap<Long, RoadWAExt> cache = new HashMap();
    public static SimpleDateFormat dfYMDS = new SimpleDateFormat("dd.MM.yy HH:mm:ss");
    JCheckBox showStationing;

    public void setViewerContext(ViewerContext viewerContext) {
        super.setViewerContext(viewerContext);
        if (InitializedVariable.getWorkplaceId((String)viewerContext.getKeyPage()) != null) {
            this.sp = InitializedVariable.runtimeParameters((Long)InitializedVariable.getWorkplaceId((String)viewerContext.getKeyPage()));
            if (this.sp.get("DiametrDTPonMap") != null) {
                this.diametrdtp = Integer.valueOf(this.sp.get("DiametrDTPonMap"));
            }
        }
    }

    public MapViewer(UIFactory<JComponent> factory) {
        super(factory);
        this.roadpainter = new PainterRoad();
        this.painter.addPainter(this.roadpainter);
        this.iconPainter = new IconPainter();
        this.painter.addPainter(this.iconPainter);
        this.trafficPainter = new PainterTraffic();
        this.trafficPainter.setColor(Color.BLUE);
        this.painter.addPainter(this.trafficPainter);
        this.repairPainter = new PainterTraffic();
        this.repairPainter.setColor(Color.ORANGE);
        this.painter.addPainter(this.repairPainter);
        this.painterStationing = new PainterStationing();
        this.coord = CoordinatesDownTown.getCoordinatesDownTown((Long)InitializedVariable.getWorkplaceId((String)""));
        this.value = new MapValue(this.coord[0], this.coord[1], this.coord[2].intValue());
        this.map.getMainMap().addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                MapViewer.this.mouseClickedOnMap(e);
            }
        });
        this.main.setSize(this.main.getPreferredSize());
        this.f = new JInternalFrame();
        this.f.setSize(new Dimension(250, 100));
        this.f.setClosable(true);
        this.f.setDefaultCloseOperation(1);
        this.textPane = new JTextPane();
        this.f.getContentPane().add(new JScrollPane(this.textPane));
        this.textPane.setEditable(false);
        this.ffoto = new JInternalFrame();
        this.ffoto.setSize(new Dimension(500, 500));
        this.ffoto.setClosable(true);
        this.ffoto.setDefaultCloseOperation(1);
        this.pageContainerpanel = this.getFactory().createPanel(RoadDefectExt.class, RoadDefectExt.class, null, this.vc, "list");
        ((JComponent)this.pageContainerpanel.getPanel()).setVisible(true);
        this.ffoto.getContentPane().add(new JScrollPane((Component)this.pageContainerpanel.getPanel()));
        this.pane = new JDesktopPane();
        this.pane.add((Component)this.main, JLayeredPane.DEFAULT_LAYER);
        this.pane.add((Component)this.f, JLayeredPane.PALETTE_LAYER);
        this.pane.add((Component)this.ffoto, JLayeredPane.PALETTE_LAYER);
        this.pane.setVisible(true);
        this.pane.addComponentListener(new ComponentListener(){

            @Override
            public void componentShown(ComponentEvent e) {
            }

            @Override
            public void componentResized(ComponentEvent e) {
                MapViewer.this.main.setSize(MapViewer.this.pane.getSize());
                MapViewer.this.main.revalidate();
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentHidden(ComponentEvent e) {
            }
        });
    }

    @Override
    public JComponent getComponent(boolean arg0, boolean arg1) {
        return this.pane;
    }

    protected void mouseClickedOnMap(MouseEvent e) {
        if (e.getClickCount() == 1) {
            double x = this.map.getMainMap().getCenter().getX() + e.getPoint().getX() - (double)(this.map.getMainMap().getWidth() / 2);
            double y = this.map.getMainMap().getCenter().getY() + e.getPoint().getY() - (double)(this.map.getMainMap().getHeight() / 2);
            Point2D.Double pClick = new Point2D.Double(x, y);
            for (IconPainter.IconOnMap t : this.iconPainter.getListIcons()) {
                Point2D pPark = this.map.getMainMap().getTileFactory().geoToPixel(t.getPoint(), this.map.getMainMap().getZoom());
                if (!IconPainter.include(pPark, pClick, t)) continue;
                String[] s = this.getText(t.getObj());
                if (t.getObj() instanceof RoadDefectExt) {
                    RoadDefectExt d = (RoadDefectExt)((Object)t.getObj());
                    ObjectUIList lists = new ObjectUIList(PhotoData.class);
                    PhotoDataSearchCriteria sc = (PhotoDataSearchCriteria)lists.getSearchCriteria();
                    sc.setLoadWithCurrentObject(Integer.valueOf(1));
                    sc.setDeviceIdList(new Long[]{d.getId()});
                    sc.setCount(Integer.valueOf(Integer.MAX_VALUE));
                    d.setLists((List<PhotoData>)lists);
                    if (d.getLists().size() == 1) {
                        try {
                            Desktop.getDesktop().browse(new URI(d.getLists().get(0).getFileName()));
                        }
                        catch (Exception e1) {
                            e1.printStackTrace();
                            InitializedVariable.factory.runMessageEx((Object)new ErrorMessage("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0442\u043a\u0440\u044b\u0442\u0438\u0438 url,\n " + d.getLists().get(0).getFileName()), new BeanViewerAction[]{new MessageOKButton()});
                        }
                        continue;
                    }
                    if (d.getLists().size() > 1) {
                        this.vc.setObject((Object)this);
                        this.ffoto.setTitle(s[0]);
                        this.pageContainerpanel.setObject((Object)d);
                        this.ffoto.setLocation(e.getX(), e.getY());
                        this.ffoto.setVisible(true);
                        continue;
                    }
                    if (s == null) continue;
                    this.f.setTitle(s[0]);
                    this.textPane.setText(s[1]);
                    this.f.setLocation(e.getX(), e.getY());
                    this.f.setVisible(true);
                    continue;
                }
                if (s == null) continue;
                this.f.setTitle(s[0]);
                this.textPane.setText(s[1]);
                this.f.setLocation(e.getX(), e.getY());
                this.f.setVisible(true);
            }
        }
    }

    @Override
    public Object getValue() {
        return null;
    }

    @Override
    public void setValue(Object arg0) {
        this.main.setSize(this.pane.getSize());
        if (this.getViewerContext() != null) {
            this.roadlist3 = (RoadList3)((Object)((PanelContext)this.getViewerContext().getParentContext()).getObject());
            this.updateMap();
            this.updateRoad();
        }
        super.setValue(this.value);
        this.zoomToTracks();
    }

    public void update() {
        this.updateMap();
        this.updateRoad();
        this.zoomToTracks();
    }

    public void updateRoad() {
        this.roadpainter.clear();
        this.painterStationing.clear();
        if (this.roadlist3 != null) {
            for (Long id : this.roadlist3.current2) {
                if (id <= 0L) continue;
                RoadWAExt r = this.cache.get(id);
                if (r == null) {
                    r = (RoadWAExt)this.proxy.getCurrentObject(InitializedVariable.context, id);
                    RoadList.updateObjectGeom(r);
                    this.cache.put(id, r);
                }
                this.roadpainter.addRoad(r);
                this.painterStationing.addRoad(r);
            }
        }
    }

    @Override
    protected boolean canGoToData() {
        return true;
    }

    @Override
    protected Double[] getMinMax() {
        Double minLat = null;
        Double maxLat = null;
        Double minLon = null;
        Double maxLon = null;
        for (RoadWAExt current : this.roadpainter.getListR()) {
            MultiLineString lineString = current.getCurrentLine();
            if (lineString != null) {
                int i = 0;
                while (i < lineString.numPoints()) {
                    double lat = lineString.getPoint(i).getY();
                    double lon = lineString.getPoint(i).getX();
                    if (minLat == null || lat < minLat) {
                        minLat = lat;
                    }
                    if (maxLat == null || lat > maxLat) {
                        maxLat = lat;
                    }
                    if (minLon == null || lon < minLon) {
                        minLon = lon;
                    }
                    if (maxLon == null || lon > maxLon) {
                        maxLon = lon;
                    }
                    ++i;
                }
                continue;
            }
            Geometry g = current.getCurrentPolygon();
            if (g == null) continue;
            int i = 0;
            while (i < g.numPoints()) {
                double lat = g.getPoint(i).getY();
                double lon = g.getPoint(i).getX();
                if (minLat == null || lat < minLat) {
                    minLat = lat;
                }
                if (maxLat == null || lat > maxLat) {
                    maxLat = lat;
                }
                if (minLon == null || lon < minLon) {
                    minLon = lon;
                }
                if (maxLon == null || lon > maxLon) {
                    maxLon = lon;
                }
                ++i;
            }
        }
        for (IconPainter.IconOnMap i : this.iconPainter.getListIcons()) {
            double lat = i.getPoint().getLatitude();
            double lon = i.getPoint().getLongitude();
            if (minLat == null || lat < minLat) {
                minLat = lat;
            }
            if (maxLat == null || lat > maxLat) {
                maxLat = lat;
            }
            if (minLon == null || lon < minLon) {
                minLon = lon;
            }
            if (maxLon != null && !(lon > maxLon)) continue;
            maxLon = lon;
        }
        if (minLat == null) {
            return null;
        }
        return new Double[]{minLat, maxLat, minLon, maxLon};
    }

    public String getURL(String filename) {
        if (filename.startsWith("http")) {
            return filename;
        }
        return new SecurityWSProxy(CurrentProxyFactory.getCurrentSOAPConnection()).getURLForDownload(InitializedVariable.context, filename);
    }

    public String[] getText(Object obj) {
        ArrayList<String> l = new ArrayList<String>();
        if (obj instanceof RoadObject) {
            RoadObject ro = (RoadObject)obj;
            l.add(ro.getName());
            StringBuilder st = new StringBuilder(ro.getType().getDescription());
            st.append("\n");
            st.append("\u041f\u0440\u043e\u0442\u044f\u0436\u0435\u043d\u043d\u043e\u0441\u0442\u044c: ");
            st.append(ro.getLength() == null ? "" : ro.getLength());
            st.append("\n");
            st.append("\u0413\u0430\u0431\u0430\u0440\u0438\u0442\u044b: ");
            st.append(ro.getDimensions() == null ? "" : ro.getDimensions());
            st.append("\n");
            st.append("\u0413\u043e\u0434 \u043f\u043e\u0441\u0442\u0440\u043e\u0439\u043a\u0438: ");
            st.append(ro.getYearConstr() == null ? "" : ro.getYearConstr());
            st.append("\n");
            st.append("\u0413\u043e\u0434 \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0435\u0433\u043e \u0440\u0435\u043c\u043e\u043d\u0442\u0430: ");
            st.append(ro.getYearRepair() == null ? "" : ro.getYearRepair());
            st.append("\n");
            st.append("\u0428\u0438\u0440\u043e\u0442\u0430: ");
            st.append(HelpUtils.convertLatLon(ro.getLat(), this.getTemplConvertLatLon()));
            st.append("\n");
            st.append("\u0414\u043e\u043b\u0433\u043e\u0442\u0430: ");
            st.append(HelpUtils.convertLatLon(ro.getLon(), this.getTemplConvertLatLon()));
            l.add(st.toString());
        } else if (obj instanceof TrafficObject) {
            TrafficObject ro = (TrafficObject)obj;
            l.add(ro.getType().getDescription());
            StringBuilder st = new StringBuilder("");
            st.append("\u0428\u0438\u0440\u043e\u0442\u0430: ");
            st.append(HelpUtils.convertLatLon(ro.getLat(), this.getTemplConvertLatLon()));
            st.append("\n");
            st.append("\u0414\u043e\u043b\u0433\u043e\u0442\u0430: ");
            st.append(HelpUtils.convertLatLon(ro.getLon(), this.getTemplConvertLatLon()));
            l.add(st.toString());
        } else if (obj instanceof PointWeightControl) {
            PointWeightControl ro = (PointWeightControl)obj;
            l.add(ro.getTypeControlObject().getDescription());
            StringBuilder st = new StringBuilder(ro.getTypeRoadObject() == null ? "" : ro.getTypeRoadObject().getDescription());
            st.append("\n");
            st.append("\u0428\u0438\u0440\u043e\u0442\u0430: ");
            st.append(HelpUtils.convertLatLon(ro.getLat(), this.getTemplConvertLatLon()));
            st.append("\n");
            st.append("\u0414\u043e\u043b\u0433\u043e\u0442\u0430: ");
            st.append(HelpUtils.convertLatLon(ro.getLon(), this.getTemplConvertLatLon()));
            l.add(st.toString());
        } else if (obj instanceof CrashData) {
            CrashData ro = (CrashData)obj;
            l.add(ro.getDescription());
            StringBuilder st = new StringBuilder(ro.getCrashDate() == null ? "" : dfYMDS.format(ro.getCrashDate()));
            st.append("\n");
            st.append("\u0428\u0438\u0440\u043e\u0442\u0430: ");
            st.append(HelpUtils.convertLatLon(ro.getLat(), this.getTemplConvertLatLon()));
            st.append("\n");
            st.append("\u0414\u043e\u043b\u0433\u043e\u0442\u0430: ");
            st.append(HelpUtils.convertLatLon(ro.getLon(), this.getTemplConvertLatLon()));
            st.append("\n");
            st.append("\u0422\u044f\u0436\u0435\u0441\u0442\u044c: ");
            st.append(ro.getGravityOfCrash() == null ? "" : ro.getGravityOfCrash().getDescription());
            l.add(st.toString());
        } else if (obj instanceof RoadDefectExt) {
            RoadDefectExt ro = (RoadDefectExt)((Object)obj);
            l.add(ro.getName());
            StringBuilder st = new StringBuilder(ro.getTypeRoadDefect() == null ? "" : ro.getTypeRoadDefect().getDescription());
            st.append("\n");
            st.append("\u0428\u0438\u0440\u043e\u0442\u0430: ");
            st.append(HelpUtils.convertLatLon(ro.getLat(), this.getTemplConvertLatLon()));
            st.append("\n");
            st.append("\u0414\u043e\u043b\u0433\u043e\u0442\u0430: ");
            st.append(HelpUtils.convertLatLon(ro.getLon(), this.getTemplConvertLatLon()));
            st.append("\u041f\u0440\u043e\u0442\u044f\u0436\u0435\u043d\u043d\u043e\u0441\u0442\u044c: ");
            st.append(ro.getLength() == null ? "" : ro.getLength());
            l.add(st.toString());
        } else if (obj instanceof StationAsudd) {
            StationAsudd ro = (StationAsudd)obj;
            l.add(ro.getName());
            StringBuilder st = new StringBuilder(String.valueOf(ro.getCode()) + " - " + ro.getName());
            st.append("\n");
            st.append("\u0428\u0438\u0440\u043e\u0442\u0430: ");
            st.append(HelpUtils.convertLatLon(ro.getLat(), this.getTemplConvertLatLon()));
            st.append("\n");
            st.append("\u0414\u043e\u043b\u0433\u043e\u0442\u0430: ");
            st.append(HelpUtils.convertLatLon(ro.getLon(), this.getTemplConvertLatLon()));
            st.append("\n");
            st.append("\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u0410: ");
            st.append(ro.getDirectionNameA());
            st.append("\n");
            st.append("\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u0412: ");
            st.append(ro.getDirectionNameB());
            l.add(st.toString());
        }
        return l.toArray(new String[l.size()]);
    }

    public void updateMap() {
        this.iconPainter.getListIcons().clear();
        this.trafficPainter.clear();
        this.repairPainter.clear();
        if (this.roadlist3 != null) {
            IconPainter.IconOnMap i;
            GeoPosition g;
            IconPainter.IconOnMap i2;
            GeoPosition g2;
            String icon;
            for (RoadObject roadObject : this.roadlist3.getListRoadObject()) {
                if (roadObject.getLat() == null) continue;
                icon = null;
                icon = this.getURL(roadObject.getType().getName());
                GeoPosition g22 = new GeoPosition(roadObject.getLat().doubleValue(), roadObject.getLon().doubleValue());
                if (icon == null) {
                    icon = "/data/icons/question.png";
                }
                IconPainter.IconOnMap i22 = new IconPainter.IconOnMap(icon, g22);
                i22.setObj(roadObject);
                this.iconPainter.addIconOnMap(i22);
            }
            for (TrafficObject trafficObject : this.roadlist3.getListTrafficObject()) {
                if (trafficObject.getLat() == null) continue;
                icon = null;
                icon = this.getURL(trafficObject.getType().getName());
                g2 = new GeoPosition(trafficObject.getLat().doubleValue(), trafficObject.getLon().doubleValue());
                if (icon == null) {
                    icon = "/data/icons/question.png";
                }
                i2 = new IconPainter.IconOnMap(icon, g2);
                i2.setObj(trafficObject);
                this.iconPainter.addIconOnMap(i2);
                this.trafficPainter.addObject(trafficObject.getGeomRoadSection());
            }
            for (PointWeightControl pointWeightControl : this.roadlist3.getListPointWeightControl()) {
                if (pointWeightControl.getLat() == null) continue;
                icon = null;
                icon = this.getURL(pointWeightControl.getTypeControlObject().getName());
                g2 = new GeoPosition(pointWeightControl.getLat().doubleValue(), pointWeightControl.getLon().doubleValue());
                if (icon == null) {
                    icon = "/data/icons/question.png";
                }
                i2 = new IconPainter.IconOnMap(icon, g2);
                i2.setObj(pointWeightControl);
                this.iconPainter.addIconOnMap(i2);
            }
            for (RoadRepair roadRepair : this.roadlist3.getListRoadRepair()) {
                this.repairPainter.addObject(roadRepair.getGeomRepairArea());
            }
            for (RoadDefectExt roadDefectExt : this.roadlist3.getListRoadDefects()) {
                if (roadDefectExt.getLat() == null) continue;
                icon = null;
                icon = roadDefectExt.getFileNameIcon() != null ? roadDefectExt.getFileNameIcon() : this.getURL(roadDefectExt.getType().getName());
                g2 = new GeoPosition(roadDefectExt.getLat().doubleValue(), roadDefectExt.getLon().doubleValue());
                if (icon == null) {
                    icon = "/data/icons/question.png";
                }
                i2 = new IconPainter.IconOnMap(icon, g2);
                i2.setObj((Object)roadDefectExt);
                this.iconPainter.addIconOnMap(i2);
            }
            for (CrashData crashData : this.roadlist3.getListCrashDatas()) {
                if (crashData.getLat() == null) continue;
                g = new GeoPosition(crashData.getLat().doubleValue(), crashData.getLon().doubleValue());
                i = new IconPainter.IconOnMap(null, g);
                i.setColor(Color.RED.getRGB());
                GravityOfCrash gr = crashData.getGravityOfCrash();
                if (gr != null && gr.getColor() != null) {
                    i.setColor(gr.getColor());
                }
                i.setObj(crashData);
                i.setD(this.diametrdtp);
                this.iconPainter.addIconOnMap(i);
            }
            for (StationAsudd stationAsudd : this.roadlist3.getListStationAsudd()) {
                if (stationAsudd.getLat() == null) continue;
                g = new GeoPosition(stationAsudd.getLat().doubleValue(), stationAsudd.getLon().doubleValue());
                i = new IconPainter.IconOnMap("/data/icons/asydd.png", g);
                i.setObj(stationAsudd);
                this.iconPainter.addIconOnMap(i);
            }
            this.repaint();
        }
    }

    public Class getTableCellViewerClass() {
        return CellViewer.class;
    }

    public boolean isShowStationing() {
        return this.showStationing.isSelected();
    }

    @Override
    protected void addPanelBttn(JPanel p2) {
        this.showStationing = new JCheckBox("\u041e\u0442\u043e\u0431\u0440\u0430\u0437\u0438\u0442\u044c \u043f\u0438\u043a\u0435\u0442\u0430\u0436");
        this.showStationing.setSelected(false);
        p2.add(this.showStationing);
        this.showStationing.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MapViewer.this.showStationing.isSelected()) {
                    MapViewer.this.painter.addPainter(MapViewer.this.painterStationing);
                } else {
                    MapViewer.this.painter.removePainter(MapViewer.this.painterStationing);
                }
                MapViewer.this.repaint();
            }
        });
        super.addPanelBttn(p2);
    }

    public static class CellViewer<T>
    extends DefaultTableCellViewer<T> {
        public CellViewer(UIFactory<T> factory) {
            super(factory);
        }

        public void setValue(Object object) {
            super.setValue((Object)"---");
        }
    }
}

