/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.roads.roadspoint;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import org.jxmapviewer.JXMapViewer;
import org.jxmapviewer.viewer.GeoPosition;
import ru.blok.common.core.CurrentProxyFactory;
import ru.blok.common.core.InitializedVariable;
import ru.blok.common.utils.CoordinatesDownTown;
import ru.blok.vms.ui.HelpUtils;
import ru.blok.vms.ui.mapviewer.MapValue;
import ru.blok.vms.ui.mapviewer.MapViewer;
import ru.blok.vms.ui.mapviewer.mapviewerwithtrack.view.IconPainter;
import ru.blok.vms.ui.roads.roadspoint.StationAsuddList;
import ru.infor.beanviewer.core.UIFactory;
import ru.infor.beanviewer.viewer.DefaultTableCellViewer;
import ru.infor.beanviewer.viewer.action.PanelContext;
import ru.infor.beanviewer.viewer.action.ViewerContext;
import ru.infor.client.soap.proxy.core.SecurityWSProxy;
import ru.infor.ws.objects.vms.StationAsuddUI;

public class MapViewerStationAsudd
extends MapViewer {
    HashMap<String, String> sp = null;
    JInternalFrame f;
    JTextPane textPane;
    JLayeredPane pane;
    ViewerContext vc = new ViewerContext();
    protected Double[] coord;
    MapValue value;
    IconPainter<JXMapViewer> iconPainter = new IconPainter();
    StationAsuddList list;

    public void setViewerContext(ViewerContext viewerContext) {
        super.setViewerContext(viewerContext);
    }

    public MapViewerStationAsudd(UIFactory<JComponent> factory) {
        super(factory);
        this.painter.addPainter(this.iconPainter);
        this.coord = CoordinatesDownTown.getCoordinatesDownTown((Long)InitializedVariable.getWorkplaceId((String)""));
        this.value = new MapValue(this.coord[0], this.coord[1], this.coord[2].intValue());
        this.map.getMainMap().addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                MapViewerStationAsudd.this.mouseClickedOnMap(e);
            }
        });
        this.main.setSize(this.main.getPreferredSize());
        this.f = new JInternalFrame();
        this.f.setSize(new Dimension(250, 100));
        this.f.setClosable(true);
        this.f.setDefaultCloseOperation(1);
        this.textPane = new JTextPane();
        this.f.getContentPane().add(new JScrollPane(this.textPane));
        this.textPane.setEditable(false);
        this.pane = new JDesktopPane();
        this.pane.add((Component)this.main, JLayeredPane.DEFAULT_LAYER);
        this.pane.add((Component)this.f, JLayeredPane.PALETTE_LAYER);
        this.pane.setVisible(true);
        this.pane.addComponentListener(new ComponentListener(){

            @Override
            public void componentShown(ComponentEvent e) {
            }

            @Override
            public void componentResized(ComponentEvent e) {
                MapViewerStationAsudd.this.main.setSize(MapViewerStationAsudd.this.pane.getSize());
                MapViewerStationAsudd.this.main.revalidate();
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentHidden(ComponentEvent e) {
            }
        });
    }

    @Override
    public JComponent getComponent(boolean arg0, boolean arg1) {
        return this.pane;
    }

    protected void mouseClickedOnMap(MouseEvent e) {
        if (e.getClickCount() == 1) {
            double x = this.map.getMainMap().getCenter().getX() + e.getPoint().getX() - (double)(this.map.getMainMap().getWidth() / 2);
            double y = this.map.getMainMap().getCenter().getY() + e.getPoint().getY() - (double)(this.map.getMainMap().getHeight() / 2);
            Point2D.Double pClick = new Point2D.Double(x, y);
            for (IconPainter.IconOnMap t : this.iconPainter.getListIcons()) {
                String[] s;
                Point2D pPark = this.map.getMainMap().getTileFactory().geoToPixel(t.getPoint(), this.map.getMainMap().getZoom());
                if (!IconPainter.include(pPark, pClick, t) || (s = this.getText(t.getObj())) == null) continue;
                this.f.setTitle(s[0]);
                this.textPane.setText(s[1]);
                this.f.setLocation(e.getX(), e.getY());
                this.f.setVisible(true);
            }
        }
    }

    @Override
    public Object getValue() {
        return null;
    }

    @Override
    public void setValue(Object arg0) {
        this.main.setSize(this.pane.getSize());
        if (this.getViewerContext() != null) {
            this.list = (StationAsuddList)((Object)((PanelContext)this.getViewerContext().getParentContext()).getObject());
            this.updateMap();
        }
        super.setValue(this.value);
        this.zoomToTracks();
    }

    public void update() {
        this.updateMap();
        this.zoomToTracks();
    }

    @Override
    protected boolean canGoToData() {
        return true;
    }

    @Override
    protected Double[] getMinMax() {
        Double minLat = null;
        Double maxLat = null;
        Double minLon = null;
        Double maxLon = null;
        for (IconPainter.IconOnMap i : this.iconPainter.getListIcons()) {
            double lat = i.getPoint().getLatitude();
            double lon = i.getPoint().getLongitude();
            if (minLat == null || lat < minLat) {
                minLat = lat;
            }
            if (maxLat == null || lat > maxLat) {
                maxLat = lat;
            }
            if (minLon == null || lon < minLon) {
                minLon = lon;
            }
            if (maxLon != null && !(lon > maxLon)) continue;
            maxLon = lon;
        }
        if (minLat == null) {
            return null;
        }
        return new Double[]{minLat, maxLat, minLon, maxLon};
    }

    public String getURL(String filename) {
        if (filename.startsWith("http")) {
            return filename;
        }
        return new SecurityWSProxy(CurrentProxyFactory.getCurrentSOAPConnection()).getURLForDownload(InitializedVariable.context, filename);
    }

    public String[] getText(Object obj) {
        ArrayList<String> l = new ArrayList<String>();
        if (obj instanceof StationAsuddUI) {
            StationAsuddUI ro = (StationAsuddUI)obj;
            l.add(ro.getName());
            StringBuilder st = new StringBuilder(String.valueOf(ro.getCode()) + " - " + ro.getName());
            st.append("\n");
            st.append("\u0428\u0438\u0440\u043e\u0442\u0430: ");
            st.append(HelpUtils.convertLatLon(ro.getLat(), this.getTemplConvertLatLon()));
            st.append("\n");
            st.append("\u0414\u043e\u043b\u0433\u043e\u0442\u0430: ");
            st.append(HelpUtils.convertLatLon(ro.getLon(), this.getTemplConvertLatLon()));
            st.append("\n");
            st.append("\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u0410: ");
            st.append(ro.getDirectionNameA());
            st.append("\n");
            st.append("\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u0412: ");
            st.append(ro.getDirectionNameB());
            l.add(st.toString());
        }
        return l.toArray(new String[l.size()]);
    }

    public void updateMap() {
        this.iconPainter.getListIcons().clear();
        if (this.list != null && this.list.getSelect() != null) {
            for (Object o : this.list.getSelect()) {
                StationAsuddUI ro = (StationAsuddUI)o;
                if (ro.getLat() == null) continue;
                GeoPosition g = new GeoPosition(ro.getLat().doubleValue(), ro.getLon().doubleValue());
                IconPainter.IconOnMap i = new IconPainter.IconOnMap("/data/icons/asydd.png", g);
                i.setObj(ro);
                this.iconPainter.addIconOnMap(i);
            }
            this.repaint();
        }
    }

    public Class getTableCellViewerClass() {
        return CellViewer.class;
    }

    public static class CellViewer<T>
    extends DefaultTableCellViewer<T> {
        public CellViewer(UIFactory<T> factory) {
            super(factory);
        }

        public void setValue(Object object) {
            super.setValue((Object)"---");
        }
    }
}

