/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.roads.roadspoint.roadobject;

import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import ru.blok.common.core.CurrentProxyFactory;
import ru.blok.common.core.InitializedVariable;
import ru.blok.common.ui.ManagerBD;
import ru.blok.common.ui.buttons.AdderButtonInAsyncList;
import ru.blok.common.ui.list.ObjectUIList;
import ru.infor.beanviewer.dialog.ErrorMessage;
import ru.infor.beanviewer.dialog.MessageOKButton;
import ru.infor.beanviewer.viewer.BeanViewerAction;
import ru.infor.beanviewer.viewer.action.PanelContext;
import ru.infor.beanviewer.viewer.action.ViewerContext;
import ru.infor.client.soap.proxy.core.SecurityWSProxy;
import ru.infor.client.soap.proxy.vms.RoadDefectWSProxy;
import ru.infor.common.FileUtils;
import ru.infor.ws.objects.vms.PhotoDataSearchCriteria;
import ru.infor.ws.objects.vms.entities.PhotoData;
import ru.infor.ws.objects.vms.entities.RoadDefect;
import ru.infor.ws.objects.vms.entities.ext.RoadDefectExt;
import ru.infor.ws.proxy.UniversalProxy;

public class AdderFoto
extends AdderButtonInAsyncList {
    SecurityWSProxy securityProxy = new SecurityWSProxy(CurrentProxyFactory.getCurrentSOAPConnection());
    RoadDefectWSProxy roadDefectWSProxy = (RoadDefectWSProxy)CurrentProxyFactory.getProxy(RoadDefectExt.class);
    String localPath = null;
    public static SimpleDateFormat dfYMDS = new SimpleDateFormat("SSS");

    public void actionPerformed(Object message) {
        File f;
        if (this.localPath == null) {
            try {
                this.localPath = Files.createTempDirectory("tmp", new FileAttribute[0]).toAbsolutePath().toUri().getPath();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (!((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getPanel().isValidate()) {
            ((ViewerContext)this.getContext()).getPresentator().getViewer().getFactory().runMessageEx((Object)new ErrorMessage("\u041d\u0435\u043b\u044c\u0437\u044f \u0434\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u0444\u043e\u0442\u043e \u0434\u043b\u044f \u043e\u0431\u044a\u0435\u043a\u0442\u0430 \u0441 \u043d\u0435\u0437\u0430\u043f\u043e\u043b\u043d\u0435\u043d\u043d\u044b\u043c\u0438 \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u043c\u0438 \u043f\u043e\u043b\u044f\u043c\u0438"), new BeanViewerAction[]{new MessageOKButton()});
            return;
        }
        RoadDefectExt t = (RoadDefectExt)((Object)((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getObject());
        if (!t.isStored()) {
            ((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getPanel().updateMainObject();
            t = (RoadDefectExt)((Object)ManagerBD.universalSave((UniversalProxy)this.roadDefectWSProxy, (Object)((Object)t)));
            ((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getPanel().setObject((Object)t);
            ObjectUIList lists = new ObjectUIList(PhotoData.class);
            PhotoDataSearchCriteria sc = (PhotoDataSearchCriteria)lists.getSearchCriteria();
            sc.setDeviceIdList(new Long[]{t.getId()});
            sc.setCount(Integer.valueOf(Integer.MAX_VALUE));
            t.setLists((List<PhotoData>)lists);
            ((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getPanel().updateUI();
        }
        FileFilter ff = new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                if (f.getName().endsWith(".png")) {
                    return true;
                }
                if (f.getName().endsWith(".jpg")) {
                    return true;
                }
                return f.getName().endsWith(".jpeg");
            }

            @Override
            public String getDescription() {
                return null;
            }
        };
        ((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getPanel().updateMainObject();
        int type = 0;
        JFileChooser jfc = new JFileChooser();
        jfc.setFileSelectionMode(type);
        jfc.setFileFilter(ff);
        int i = jfc.showDialog(null, "\u0412\u044b\u0431\u043e\u0440 \u0444\u0430\u0439\u043b\u0430");
        if (i == 0 && (f = jfc.getSelectedFile()) != null) {
            if (f.length() <= 0L || f.length() > 1018429440L) {
                ((ViewerContext)this.getContext()).getPresentator().getViewer().getFactory().runMessageEx((Object)new ErrorMessage("\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0439 \u0440\u0430\u0437\u043c\u0435\u0440 \u0444\u0430\u0439\u043b\u0430"), new BeanViewerAction[]{new MessageOKButton()});
                return;
            }
            PhotoData obj = this.loadFotoFromFile(f, t);
            ((ViewerContext)this.getContext()).getPresentator().getViewer().getFactory().newPage(null, obj.getClass(), (Object)obj, (ViewerContext)this.getContext(), this.getKeyView(), (BeanViewerAction)this);
        }
    }

    public PhotoData loadFotoFromFile(File f, RoadDefect rd) {
        PhotoData phd = new PhotoData();
        String urlString = this.securityProxy.getUploadURL(InitializedVariable.context);
        if (f.getName() != null) {
            String name = String.valueOf(f.getName().substring(0, f.getName().indexOf("."))) + "____" + rd.getId() + "_" + dfYMDS.format(new Date());
            if (f.getName().indexOf(".") > -1) {
                name = String.valueOf(name) + f.getName().substring(f.getName().indexOf("."), f.getName().length());
            }
            String urlStr = String.valueOf(urlString) + "/?name=" + name;
            try {
                URL url = new URL(urlStr);
                HttpURLConnection conn = (HttpURLConnection)InitializedVariable.getCurrentConnection((URL)url);
                conn.setRequestMethod("PUT");
                conn.setDoInput(true);
                conn.setDoOutput(true);
                conn.connect();
                OutputStream out = conn.getOutputStream();
                FileUtils.copy((File)f.getAbsoluteFile(), (OutputStream)new BufferedOutputStream(out));
                conn.getInputStream();
                conn.disconnect();
                phd.setLat(rd.getLat());
                phd.setLon(rd.getLon());
                phd.setDeviceId(rd.getId());
                phd.setCreatedDateTime(new Date());
                phd.setFileName(name);
                phd.setFileExt(f.getName().substring(f.getName().indexOf(".") + 1, f.getName().length()));
                File f2 = this.processImage(32, 32, f, f.getName().substring(f.getName().indexOf(".") + 1));
                if (f2 != null) {
                    String name2 = String.valueOf(f.getName().substring(0, f.getName().indexOf("."))) + "____ico" + rd.getId() + "_" + dfYMDS.format(new Date());
                    if (f.getName().indexOf(".") > -1) {
                        name2 = String.valueOf(name2) + f.getName().substring(f.getName().indexOf("."), f.getName().length());
                    }
                    urlStr = String.valueOf(urlString) + "/?name=" + name2;
                    url = new URL(urlStr);
                    conn = (HttpURLConnection)InitializedVariable.getCurrentConnection((URL)url);
                    conn.setRequestMethod("PUT");
                    conn.setDoInput(true);
                    conn.setDoOutput(true);
                    conn.connect();
                    out = conn.getOutputStream();
                    FileUtils.copy((File)f2.getAbsoluteFile(), (OutputStream)new BufferedOutputStream(out));
                    conn.getInputStream();
                    conn.disconnect();
                    phd.setFileNameIcon(name2);
                }
                return phd;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private File processImage(int maxWidth, int maxHeight, File src, String ext) throws Exception {
        BufferedImage bi = null;
        try {
            bi = ImageIO.read(src);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        double max = 0.0;
        int size = 0;
        int ww = maxWidth - bi.getWidth();
        int hh = maxHeight - bi.getHeight();
        if (ww < 0 || hh < 0) {
            if (ww < hh) {
                max = maxWidth;
                size = bi.getWidth();
            } else {
                max = maxHeight;
                size = bi.getHeight();
            }
            if (size > 0 && (double)size > max) {
                double trans = 1.0 / ((double)size / max);
                AffineTransform tr = new AffineTransform();
                tr.scale(trans, trans);
                AffineTransformOp op = new AffineTransformOp(tr, 2);
                Double w = new Double((double)bi.getWidth() * trans);
                Double h = new Double((double)bi.getHeight() * trans);
                BufferedImage bi2 = new BufferedImage(w.intValue(), h.intValue(), bi.getType());
                op.filter(bi, bi2);
                try {
                    File f = new File(String.valueOf(this.localPath) + "__temp." + ext);
                    ImageIO.write((RenderedImage)bi2, ext, f);
                    return f;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
            }
        }
        return src;
    }
}

