/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.roads.roadspoint.roadobject;

import java.awt.Color;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Point2D;
import java.util.HashMap;
import javax.swing.JComponent;
import org.jxmapviewer.JXMapViewer;
import org.jxmapviewer.viewer.GeoPosition;
import org.postgis.Geometry;
import org.postgis.MultiLineString;
import ru.blok.common.core.CurrentProxyFactory;
import ru.blok.common.core.InitializedVariable;
import ru.blok.common.utils.CoordinatesDownTown;
import ru.blok.vms.ui.mapviewer.MapValue;
import ru.blok.vms.ui.mapviewer.mapviewerwithtrack.view.IconPainter;
import ru.blok.vms.ui.roads.RoadList;
import ru.blok.vms.ui.roads.roadspoint.roadobject.PainterRoad;
import ru.infor.beanviewer.core.UIFactory;
import ru.infor.beanviewer.viewer.DefaultTableCellViewer;
import ru.infor.beanviewer.viewer.action.PanelContext;
import ru.infor.beanviewer.viewer.action.ViewerContext;
import ru.infor.client.soap.proxy.core.SecurityWSProxy;
import ru.infor.client.soap.proxy.vms.RoadWAWSProxy;
import ru.infor.ws.objects.vms.entities.AbstractRoadObject;
import ru.infor.ws.objects.vms.entities.CrashData;
import ru.infor.ws.objects.vms.entities.GravityOfCrash;
import ru.infor.ws.objects.vms.entities.PointWeightControl;
import ru.infor.ws.objects.vms.entities.RoadDefect;
import ru.infor.ws.objects.vms.entities.RoadObject;
import ru.infor.ws.objects.vms.entities.RoadWA;
import ru.infor.ws.objects.vms.entities.StationAsudd;
import ru.infor.ws.objects.vms.entities.TrafficObject;
import ru.infor.ws.objects.vms.entities.ext.RoadWAExt;

public class MapViewer
extends ru.blok.vms.ui.mapviewer.MapViewer {
    HashMap<String, String> sp = null;
    Integer diametrdtp = 15;
    protected Double[] coord;
    MapValue value;
    IconPainter<JXMapViewer> iconPainter;
    PainterRoad<JXMapViewer> roadpainter;
    AbstractRoadObject roadObject;
    RoadWAExt current = null;
    RoadWAWSProxy proxy = (RoadWAWSProxy)CurrentProxyFactory.getProxy(RoadWA.class);

    public void setViewerContext(ViewerContext viewerContext) {
        super.setViewerContext(viewerContext);
        if (InitializedVariable.getWorkplaceId((String)viewerContext.getKeyPage()) != null) {
            this.sp = InitializedVariable.runtimeParameters((Long)InitializedVariable.getWorkplaceId((String)viewerContext.getKeyPage()));
            if (this.sp.get("DiametrDTPonMap") != null) {
                this.diametrdtp = Integer.valueOf(this.sp.get("DiametrDTPonMap"));
            }
        }
    }

    public MapViewer(UIFactory<JComponent> factory) {
        super(factory);
        this.roadpainter = new PainterRoad();
        this.painter.addPainter(this.roadpainter);
        this.iconPainter = new IconPainter();
        this.painter.addPainter(this.iconPainter);
        this.map.getMainMap().addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                MapViewer.this.mouseClickedOnMap(e);
            }
        });
        this.coord = CoordinatesDownTown.getCoordinatesDownTown((Long)InitializedVariable.getWorkplaceId((String)""));
        this.value = new MapValue(this.coord[0], this.coord[1], this.coord[2].intValue());
    }

    @Override
    public Object getValue() {
        return null;
    }

    @Override
    public void setValue(Object arg0) {
        if (this.getViewerContext() != null) {
            this.roadObject = (AbstractRoadObject)((PanelContext)this.getViewerContext().getParentContext()).getObject();
            this.updateMap();
            this.updateRoad();
        }
        super.setValue(this.value);
        this.zoomToTracks();
    }

    public void updateRoad() {
        if (this.current != null && this.current.getId().equals(this.roadObject.getRoadId())) {
            return;
        }
        if (this.roadObject != null && this.roadObject.getRoadId() != null) {
            this.current = (RoadWAExt)this.proxy.getCurrentObject(InitializedVariable.context, this.roadObject.getRoadId());
            RoadList.updateObjectGeom(this.current);
            this.roadpainter.setRoad(this.current);
        } else {
            this.current = null;
            this.roadpainter.clear();
        }
    }

    @Override
    protected boolean canGoToData() {
        return true;
    }

    @Override
    protected Double[] getMinMax() {
        double lon;
        double lat;
        Double minLat = null;
        Double maxLat = null;
        Double minLon = null;
        Double maxLon = null;
        if (this.current != null) {
            MultiLineString lineString = this.current.getCurrentLine();
            if (lineString != null) {
                int i = 0;
                while (i < lineString.numPoints()) {
                    lat = lineString.getPoint(i).getY();
                    lon = lineString.getPoint(i).getX();
                    if (minLat == null || lat < minLat) {
                        minLat = lat;
                    }
                    if (maxLat == null || lat > maxLat) {
                        maxLat = lat;
                    }
                    if (minLon == null || lon < minLon) {
                        minLon = lon;
                    }
                    if (maxLon == null || lon > maxLon) {
                        maxLon = lon;
                    }
                    ++i;
                }
            } else {
                Geometry g = this.current.getCurrentPolygon();
                if (g != null) {
                    int i = 0;
                    while (i < g.numPoints()) {
                        double lat2 = g.getPoint(i).getY();
                        double lon2 = g.getPoint(i).getX();
                        if (minLat == null || lat2 < minLat) {
                            minLat = lat2;
                        }
                        if (maxLat == null || lat2 > maxLat) {
                            maxLat = lat2;
                        }
                        if (minLon == null || lon2 < minLon) {
                            minLon = lon2;
                        }
                        if (maxLon == null || lon2 > maxLon) {
                            maxLon = lon2;
                        }
                        ++i;
                    }
                }
            }
        }
        for (IconPainter.IconOnMap i : this.iconPainter.getListIcons()) {
            lat = i.getPoint().getLatitude();
            lon = i.getPoint().getLongitude();
            if (minLat == null || lat < minLat) {
                minLat = lat;
            }
            if (maxLat == null || lat > maxLat) {
                maxLat = lat;
            }
            if (minLon == null || lon < minLon) {
                minLon = lon;
            }
            if (maxLon != null && !(lon > maxLon)) continue;
            maxLon = lon;
        }
        if (minLat == null) {
            return null;
        }
        return new Double[]{minLat, maxLat, minLon, maxLon};
    }

    protected void mouseClickedOnMap(MouseEvent e) {
        if (e.getClickCount() == 1 && e.isControlDown()) {
            double x = this.map.getMainMap().getCenter().getX() + e.getPoint().getX() - (double)(this.map.getMainMap().getWidth() / 2);
            double y = this.map.getMainMap().getCenter().getY() + e.getPoint().getY() - (double)(this.map.getMainMap().getHeight() / 2);
            GeoPosition gp = this.map.getMainMap().getTileFactory().pixelToGeo((Point2D)new Point2D.Double(x, y), this.map.getMainMap().getZoom());
            this.roadObject.setLat(Double.valueOf(gp.getLatitude()));
            this.roadObject.setLon(Double.valueOf(gp.getLongitude()));
            ((PanelContext)this.getViewerContext().getParentContext()).getPanel().updateUIForPresentatorName("lat");
            ((PanelContext)this.getViewerContext().getParentContext()).getPanel().updateUIForPresentatorName("lon");
            this.updateMap();
        }
    }

    public String getURL(String filename) {
        if (filename.startsWith("http")) {
            return filename;
        }
        return new SecurityWSProxy(CurrentProxyFactory.getCurrentSOAPConnection()).getURLForDownload(InitializedVariable.context, filename);
    }

    public void updateMap() {
        this.iconPainter.getListIcons().clear();
        if (this.roadObject.getLat() != null) {
            String icon = null;
            if (this.roadObject instanceof RoadObject) {
                if (((RoadObject)this.roadObject).getType() != null) {
                    icon = this.getURL(((RoadObject)this.roadObject).getType().getName());
                }
            } else if (this.roadObject instanceof TrafficObject) {
                if (((TrafficObject)this.roadObject).getType() != null) {
                    icon = this.getURL(((TrafficObject)this.roadObject).getType().getName());
                }
            } else if (this.roadObject instanceof PointWeightControl) {
                if (((PointWeightControl)this.roadObject).getTypeControlObject() != null) {
                    icon = this.getURL(((PointWeightControl)this.roadObject).getTypeControlObject().getName());
                }
            } else if (this.roadObject instanceof RoadDefect) {
                if (((RoadDefect)this.roadObject).getType() != null) {
                    icon = this.getURL(((RoadDefect)this.roadObject).getType().getName());
                }
            } else if (this.roadObject instanceof StationAsudd) {
                icon = "/data/icons/asydd.png";
            }
            GeoPosition g = new GeoPosition(this.roadObject.getLat().doubleValue(), this.roadObject.getLon().doubleValue());
            if (icon == null) {
                icon = "/data/icons/question.png";
            }
            IconPainter.IconOnMap i = new IconPainter.IconOnMap(icon, g);
            if (this.roadObject instanceof CrashData) {
                i.setImage(null);
                i.setColor(Color.RED.getRGB());
                GravityOfCrash gr = ((CrashData)this.roadObject).getGravityOfCrash();
                if (gr != null && gr.getColor() != null) {
                    i.setColor(gr.getColor());
                }
                i.setD(this.diametrdtp);
            }
            this.iconPainter.addIconOnMap(i);
        }
        this.repaint();
    }

    public Class getTableCellViewerClass() {
        return CellViewer.class;
    }

    public static class CellViewer<T>
    extends DefaultTableCellViewer<T> {
        public CellViewer(UIFactory<T> factory) {
            super(factory);
        }

        public void setValue(Object object) {
            super.setValue((Object)"---");
        }
    }
}

