/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.roads.roadspoint.roadobject;

import javax.swing.JComponent;
import org.jxmapviewer.JXMapViewer;
import org.postgis.Geometry;
import org.postgis.MultiLineString;
import ru.blok.common.core.CurrentProxyFactory;
import ru.blok.common.core.InitializedVariable;
import ru.blok.common.utils.CoordinatesDownTown;
import ru.blok.vms.ui.mapviewer.MapValue;
import ru.blok.vms.ui.mapviewer.MapViewer;
import ru.blok.vms.ui.roads.RoadList;
import ru.blok.vms.ui.roads.roadspoint.roadobject.PainterRoad;
import ru.blok.vms.ui.roads.roadspoint.roadobject.PainterTraffic;
import ru.infor.beanviewer.core.UIFactory;
import ru.infor.beanviewer.viewer.DefaultTableCellViewer;
import ru.infor.beanviewer.viewer.action.PanelContext;
import ru.infor.client.soap.proxy.core.SecurityWSProxy;
import ru.infor.client.soap.proxy.vms.RoadWAWSProxy;
import ru.infor.ws.objects.vms.entities.RoadRepair;
import ru.infor.ws.objects.vms.entities.RoadWA;
import ru.infor.ws.objects.vms.entities.ext.RoadWAExt;

public class MapViewerRepair
extends MapViewer {
    PainterTraffic<JXMapViewer> trafficPainter;
    PainterRoad<JXMapViewer> roadpainter;
    RoadRepair roadObject;
    RoadWAExt current = null;
    RoadWAWSProxy proxy = (RoadWAWSProxy)CurrentProxyFactory.getProxy(RoadWA.class);

    public MapViewerRepair(UIFactory<JComponent> factory) {
        super(factory);
        this.roadpainter = new PainterRoad();
        this.painter.addPainter(this.roadpainter);
        this.trafficPainter = new PainterTraffic();
        this.painter.addPainter(this.trafficPainter);
        this.coord = CoordinatesDownTown.getCoordinatesDownTown((Long)InitializedVariable.getWorkplaceId((String)""));
        this.value = new MapValue(this.coord[0], this.coord[1], this.coord[2].intValue());
    }

    @Override
    public Object getValue() {
        return null;
    }

    @Override
    public void setValue(Object arg0) {
        this.trafficPainter.setObject((String)arg0);
        if (this.getViewerContext() != null) {
            this.roadObject = (RoadRepair)((PanelContext)this.getViewerContext().getParentContext()).getObject();
            this.updateRoad();
        }
        super.setValue(this.value);
        this.zoomToTracks();
    }

    public void updateRoad() {
        if (this.current != null && this.current.getId().equals(this.roadObject.getRoadId())) {
            return;
        }
        if (this.roadObject != null && this.roadObject.getRoadId() != null) {
            this.current = (RoadWAExt)this.proxy.getCurrentObject(InitializedVariable.context, this.roadObject.getRoadId());
            RoadList.updateObjectGeom(this.current);
            this.roadpainter.setRoad(this.current);
        }
    }

    @Override
    protected boolean canGoToData() {
        return true;
    }

    @Override
    protected Double[] getMinMax() {
        Double minLat = null;
        Double maxLat = null;
        Double minLon = null;
        Double maxLon = null;
        if (this.current != null) {
            MultiLineString lineString = this.current.getCurrentLine();
            if (lineString != null) {
                int i = 0;
                while (i < lineString.numPoints()) {
                    double lat = lineString.getPoint(i).getY();
                    double lon = lineString.getPoint(i).getX();
                    if (minLat == null || lat < minLat) {
                        minLat = lat;
                    }
                    if (maxLat == null || lat > maxLat) {
                        maxLat = lat;
                    }
                    if (minLon == null || lon < minLon) {
                        minLon = lon;
                    }
                    if (maxLon == null || lon > maxLon) {
                        maxLon = lon;
                    }
                    ++i;
                }
            } else {
                Geometry g = this.current.getCurrentPolygon();
                if (g != null) {
                    int i = 0;
                    while (i < g.numPoints()) {
                        double lat = g.getPoint(i).getY();
                        double lon = g.getPoint(i).getX();
                        if (minLat == null || lat < minLat) {
                            minLat = lat;
                        }
                        if (maxLat == null || lat > maxLat) {
                            maxLat = lat;
                        }
                        if (minLon == null || lon < minLon) {
                            minLon = lon;
                        }
                        if (maxLon == null || lon > maxLon) {
                            maxLon = lon;
                        }
                        ++i;
                    }
                }
            }
        }
        if (minLat == null) {
            return null;
        }
        return new Double[]{minLat, maxLat, minLon, maxLon};
    }

    public String getURL(String filename) {
        if (filename.startsWith("http")) {
            return filename;
        }
        return new SecurityWSProxy(CurrentProxyFactory.getCurrentSOAPConnection()).getURLForDownload(InitializedVariable.context, filename);
    }

    public Class getTableCellViewerClass() {
        return CellViewer.class;
    }

    public static class CellViewer<T>
    extends DefaultTableCellViewer<T> {
        public CellViewer(UIFactory<T> factory) {
            super(factory);
        }

        public void setValue(Object object) {
            super.setValue((Object)"---");
        }
    }
}

