/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.roads.roadspoint.roadobject;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.List;
import org.jxmapviewer.JXMapViewer;
import org.jxmapviewer.viewer.GeoPosition;
import org.postgis.Geometry;
import org.postgis.Point;
import ru.blok.vms.ui.route.routegeom.NewRoutePainter;
import ru.infor.ws.objects.vms.entities.ext.RoadWAExt;

public class PainterRoad<T extends JXMapViewer>
extends NewRoutePainter<JXMapViewer> {
    List<RoadWAExt> listR = new ArrayList<RoadWAExt>();

    public void setRoad(RoadWAExt road) {
        this.listR.clear();
        this.listR.add(road);
    }

    public List<RoadWAExt> getListR() {
        return this.listR;
    }

    public void addRoad(RoadWAExt w) {
        this.listR.add(w);
    }

    public void clear() {
        this.listR.clear();
    }

    @Override
    public void doPaint(Graphics2D g, JXMapViewer map, int width, int height) {
        Rectangle viewportBounds = map.getViewportBounds();
        int zoom = map.getZoom();
        Dimension sizeInTiles = map.getTileFactory().getMapSize(zoom);
        int tileSize = map.getTileFactory().getTileSize(zoom);
        Dimension sizeInPixels = new Dimension(sizeInTiles.width * tileSize, sizeInTiles.height * tileSize);
        double vpx = viewportBounds.getX();
        while (vpx < 0.0) {
            vpx += sizeInPixels.getWidth();
        }
        while (vpx > sizeInPixels.getWidth()) {
            vpx -= sizeInPixels.getWidth();
        }
        Rectangle2D.Double vp2 = new Rectangle2D.Double(vpx, viewportBounds.getY(), viewportBounds.getWidth(), viewportBounds.getHeight());
        for (RoadWAExt road : this.listR) {
            if (road.getCurrentPolygon() == null) continue;
            Color c = Color.RED;
            PainterRoad.paintPolygon(road.getCurrentPolygon(), map, g, (Rectangle2D)vp2, c, 150);
            this.paintLine((Geometry)road.getCurrentLine(), g, map, vp2, null, c);
            if (map.getZoom() >= 12) continue;
            Point p = null;
            if (road.getCurrentLine() != null) {
                p = road.getCurrentLine().getPoint(0);
            } else if (road.getCurrentPolygon() != null) {
                p = road.getCurrentPolygon().getPoint(0);
            }
            if (p == null) continue;
            Point2D point = map.getTileFactory().geoToPixel(new GeoPosition(p.getY(), p.getX()), map.getZoom());
            int x = (int)(point.getX() - ((RectangularShape)vp2).getX());
            int y = (int)(point.getY() - ((RectangularShape)vp2).getY());
            g.translate(x, y);
            g.setColor(Color.BLACK);
            g.drawString(road.getName(), 0, 0);
            g.translate(-x, -y);
        }
    }
}

