/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.roads.roadspoint.roadobject;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.List;
import org.jxmapviewer.JXMapViewer;
import org.jxmapviewer.viewer.GeoPosition;
import org.postgis.Geometry;
import org.postgis.LineString;
import org.postgis.Point;
import org.postgis.Polygon;
import ru.blok.vms.ui.route.routegeom.NewRoutePainter;

public class PainterTraffic<T extends JXMapViewer>
extends NewRoutePainter<JXMapViewer> {
    String object;
    List<Geometry> listP = new ArrayList<Geometry>();
    Color color = Color.BLUE;

    public String getObject() {
        return this.object;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setObject(String object) {
        this.object = object;
        this.listP.clear();
        try {
            if (object.toUpperCase().contains("POLYGON")) {
                Polygon p = new Polygon(object);
                this.listP.add((Geometry)p);
            } else if (object.toUpperCase().contains("LINESTRING")) {
                LineString p = new LineString(object);
                this.listP.add((Geometry)p);
            } else {
                Point p = new Point(object);
                this.listP.add((Geometry)p);
            }
        }
        catch (Exception exception) {}
    }

    public void clear() {
        this.listP.clear();
    }

    public void addObject(String object) {
        try {
            if (object.toUpperCase().contains("POLYGON")) {
                Polygon p = new Polygon(object);
                this.listP.add((Geometry)p);
            } else if (object.toUpperCase().contains("LINESTRING")) {
                LineString p = new LineString(object);
                this.listP.add((Geometry)p);
            } else {
                Point p = new Point(object);
                this.listP.add((Geometry)p);
            }
        }
        catch (Exception exception) {}
    }

    @Override
    public void doPaint(Graphics2D g, JXMapViewer map, int width, int height) {
        Rectangle viewportBounds = map.getViewportBounds();
        int zoom = map.getZoom();
        Dimension sizeInTiles = map.getTileFactory().getMapSize(zoom);
        int tileSize = map.getTileFactory().getTileSize(zoom);
        Dimension sizeInPixels = new Dimension(sizeInTiles.width * tileSize, sizeInTiles.height * tileSize);
        double vpx = viewportBounds.getX();
        while (vpx < 0.0) {
            vpx += sizeInPixels.getWidth();
        }
        while (vpx > sizeInPixels.getWidth()) {
            vpx -= sizeInPixels.getWidth();
        }
        Rectangle2D.Double vp2 = new Rectangle2D.Double(vpx, viewportBounds.getY(), viewportBounds.getWidth(), viewportBounds.getHeight());
        Rectangle2D.Double vp3 = new Rectangle2D.Double(vpx - sizeInPixels.getWidth(), viewportBounds.getY(), viewportBounds.getWidth(), viewportBounds.getHeight());
        for (Geometry p : this.listP) {
            if (p instanceof Polygon) {
                PainterTraffic.paintPolygon(p, map, g, (Rectangle2D)vp2, this.color, 50);
                continue;
            }
            if (p instanceof LineString) {
                this.paintLine(p, g, map, vp2, vp3, this.color);
                continue;
            }
            Point pp = (Point)p;
            Point2D point = map.getTileFactory().geoToPixel(new GeoPosition(pp.y, pp.x), map.getZoom());
            if (!vp2.contains(point)) continue;
            int x = (int)(point.getX() - ((RectangularShape)vp2).getX());
            int y = (int)(point.getY() - ((RectangularShape)vp2).getY());
            g.translate(x, y);
            this.paintNode(g, map, zoom);
            g.translate(-x, -y);
        }
    }

    public boolean paintNode(Graphics2D g, JXMapViewer ma, int zoom) {
        int radius = 25 - zoom * 3;
        g.setColor(this.color);
        g.fillOval(-radius / 2, -radius / 2, radius, radius);
        g.setColor(Color.WHITE);
        g.fillRect((int)((double)(-radius) * 0.3), (int)((double)(-radius) * 0.1), (int)((double)radius * 0.6), (int)((double)radius * 0.2));
        return false;
    }
}

