/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.route;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Polygon;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.geotools.geometry.GeneralDirectPosition;
import org.geotools.referencing.CRS;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.postgis.LineString;
import org.postgis.LinearRing;
import org.postgis.MultiLineString;
import org.postgis.Point;
import ru.blok.common.core.CommonObjectWithKey;
import ru.blok.common.core.CurrentProxyFactory;
import ru.blok.common.core.InitializedVariable;
import ru.blok.vms.core.ResourceStrings;
import ru.blok.vms.ui.josm.JosmMainApp;
import ru.blok.vms.ui.route.routegeom.CreateGeomRoute;
import ru.infor.beanviewer.annotation.Field;
import ru.infor.beanviewer.annotation.ListField;
import ru.infor.beanviewer.annotation.ListView;
import ru.infor.beanviewer.annotation.View;
import ru.infor.beanviewer.viewer.ActionButton;
import ru.infor.beanviewer.viewer.AsyncBVA;
import ru.infor.beanviewer.viewer.BeanViewerAction;
import ru.infor.beanviewer.viewer.FilePathViewer;
import ru.infor.beanviewer.viewer.TextViewer;
import ru.infor.beanviewer.viewer.action.PanelContext;
import ru.infor.beanviewer.viewer.action.ViewerContext;
import ru.infor.client.soap.proxy.vms.CheckPointTypeWSProxy;
import ru.infor.client.soap.proxy.vms.CheckPointWSProxy;
import ru.infor.client.soap.proxy.vms.Route2CheckPointLinkWSProxy;
import ru.infor.client.soap.proxy.vms.RouteWSProxy;
import ru.infor.client.soap.proxy.vms.TransportStopWSProxy;
import ru.infor.ws.objects.core.DirectoriesSearchCriteria;
import ru.infor.ws.objects.vms.CheckPointSearchCriteria;
import ru.infor.ws.objects.vms.RouteSearchCriteria;
import ru.infor.ws.objects.vms.entities.CheckPoint;
import ru.infor.ws.objects.vms.entities.CheckPointType;
import ru.infor.ws.objects.vms.entities.Route;
import ru.infor.ws.objects.vms.entities.Route2CheckPointLink;
import ru.infor.ws.objects.vms.entities.TransportStop;
import ru.infor.ws.objects.vms.entities.ext.Route2CheckPointLinkExt;

@ListView(views={@View(title="\u0418\u043c\u043f\u043e\u0440\u0442 \u043c\u0430\u0440\u0448\u0440\u0443\u0442\u043e\u0432", keyView="", layoutKeys={"tabSplitPercentLayoutManager"})})
public class ImportRoutes
extends CommonObjectWithKey {
    private String importFileName;
    PanelContext pc;
    String log = new String();
    BeanViewerAction<ViewerContext> runImport = new AsyncBVA<Object, ViewerContext>((ctx, o) -> {
        this.pc.getPanel().updateMainObject();
        this.RunImport();
        return null;
    }, (o, ctx) -> {}, (o, c) -> {}){

        public String getHint() {
            return "\u0418\u043c\u043f\u043e\u0440\u0442";
        }

        public String getName() {
            return "\u0418\u043c\u043f\u043e\u0440\u0442";
        }

        public String getIcon() {
            return ResourceStrings.btPageExcel;
        }
    };
    RouteWSProxy proxy = (RouteWSProxy)CurrentProxyFactory.getProxy(Route.class);
    private String importFileName2;
    String log2 = new String();
    BeanViewerAction<ViewerContext> runImport2 = new AsyncBVA<Object, ViewerContext>((ctx, o) -> {
        this.pc.getPanel().updateMainObject();
        this.RunImport2();
        return null;
    }, (o, ctx) -> {}, (o, c) -> {}){

        public String getHint() {
            return "\u0418\u043c\u043f\u043e\u0440\u0442";
        }

        public String getName() {
            return "\u0418\u043c\u043f\u043e\u0440\u0442";
        }

        public String getIcon() {
            return ResourceStrings.btPageExcel;
        }
    };
    TransportStopWSProxy transportStopWSProxy = (TransportStopWSProxy)CurrentProxyFactory.getProxy(TransportStop.class, (String)this.getKeyPage());
    CheckPointWSProxy checkPointWSProxy = (CheckPointWSProxy)CurrentProxyFactory.getProxy(CheckPoint.class, (String)this.getKeyPage());
    CheckPointTypeWSProxy checkPointTypeWSProxy = (CheckPointTypeWSProxy)CurrentProxyFactory.getProxy(CheckPointType.class);
    Route2CheckPointLinkWSProxy checkPointLinkWSProxy = (Route2CheckPointLinkWSProxy)CurrentProxyFactory.getProxy(Route2CheckPointLinkExt.class, (String)this.getKeyPage());

    public ImportRoutes(String keyPage) {
        super(keyPage);
    }

    @ListField(fields={@Field(title="\u0424\u0430\u0439\u043b", order=30, propertiesLayout="Tab1/\u041c\u0430\u0440\u0448\u0440\u0443\u0442\u044b:0# w 1500", viewer={FilePathViewer.class}, propertiesField={"type=file", "extension=csv,CSV,Csv"})})
    public String getImportFileName() {
        return this.importFileName;
    }

    public void setImportFileName(String importFileName) {
        this.importFileName = importFileName;
    }

    public void beforeShow(PanelContext pc) {
        this.pc = pc;
    }

    @ListField(fields={@Field(title="\u041b\u043e\u0433", order=150, readOnly=true, propertiesLayout="Tab1/\u041c\u0430\u0440\u0448\u0440\u0443\u0442\u044b:0#newline,  w 1500, h 800,span#newline", viewer={TextViewer.class}, propertiesUI={"toolbar=false"})})
    public String getLog() {
        return this.log;
    }

    @ListField(fields={@Field(title="", order=100, propertiesLayout="Tab1/\u041c\u0430\u0440\u0448\u0440\u0443\u0442\u044b:0", viewer={ActionButton.class})})
    public BeanViewerAction<ViewerContext> getRunImport() {
        return this.runImport;
    }

    public void addLog(String s) {
        this.log = String.valueOf(this.log) + s + "\n";
        new Thread(new Runnable(){

            @Override
            public void run() {
                ImportRoutes.this.pc.getPanel().updateUIForPresentatorName("log");
            }
        }).start();
    }

    private void save(Route r, List<LineString> list) {
        ArrayList<Point> points = new ArrayList<Point>();
        Point[] pointArray = list.get(0).getPoints();
        int n = pointArray.length;
        int n2 = 0;
        while (n2 < n) {
            Point p = pointArray[n2];
            points.add(p);
            ++n2;
        }
        int i = 1;
        while (i < list.size()) {
            LineString pred = list.get(i - 1);
            Point ppred = pred.getLastPoint();
            LineString cur = list.get(i);
            double d1 = cur.getFirstPoint().distance(ppred);
            double d2 = cur.getLastPoint().distance(ppred);
            if (d2 < d1) {
                Point[] p1 = cur.getPoints();
                int k = p1.length - 1;
                while (k >= 0) {
                    points.add(p1[k]);
                    --k;
                }
            } else {
                Point[] pointArray2 = cur.getPoints();
                int n3 = pointArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    Point p = pointArray2[n4];
                    points.add(p);
                    ++n4;
                }
            }
            ++i;
        }
        LineString s = new LineString(points.toArray(new Point[points.size()]));
        MultiLineString m = new MultiLineString(new LineString[]{s});
        r.setRouteGeom(m.toString());
        CreateGeomRoute createGeomRoute = new CreateGeomRoute();
        createGeomRoute.setWidthRoute(r.getWidthRoute());
        r.setAreaRouteGeom(createGeomRoute.createPolygon(r.getRouteGeom()));
        r = this.proxy.save(InitializedVariable.context, r);
        this.addLog("save " + r.getNum() + "==>" + r.getName());
    }

    public void RunImport() {
        try {
            this.addLog("Read file " + this.importFileName);
            try {
                BufferedReader r2 = new BufferedReader(new InputStreamReader(new FileInputStream(this.importFileName)));
                String s = r2.readLine();
                Route route = null;
                ArrayList<LineString> list = null;
                String oldid = null;
                while ((s = r2.readLine()) != null) {
                    String geom = s.substring(0, s.indexOf("\",") + 1);
                    String s1 = s.substring(geom.length() + 1);
                    String[] ss = s1.split(",");
                    Integer part = Integer.parseInt(ss[0]);
                    String name = ss[1];
                    String cfr_ignored_0 = ss[2];
                    String arrowS = ss[3];
                    String id = "";
                    if (ss.length > 4) {
                        id = ss[4];
                    }
                    if (">".equals(arrowS) && !id.equals(oldid)) {
                        if (part.equals(1)) {
                            if (route != null) {
                                this.save(route, list);
                            }
                            route = new Route();
                            route.setWidthRoute(Double.valueOf(20.0));
                            route.setName(name);
                            route.setShowInInforming(Integer.valueOf(1));
                            list = new ArrayList<LineString>();
                            String[] nn = name.split(" ");
                            route.setNum(String.valueOf(nn[0]) + " " + nn[1] + "(" + id + ")");
                        }
                        if (geom.indexOf("EMPTY") <= 0) {
                            LineString l = new LineString(geom.replaceAll("\"", ""));
                            list.add(l);
                        }
                    }
                    oldid = id;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @ListField(fields={@Field(title="\u0424\u0430\u0439\u043b", order=30, propertiesLayout="Tab1/\u041e\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0438:0# w 1500", viewer={FilePathViewer.class}, propertiesField={"type=file", "extension=csv,CSV,Csv"})})
    public String getImportFileName2() {
        return this.importFileName2;
    }

    public void setImportFileName2(String importFileName2) {
        this.importFileName2 = importFileName2;
    }

    @ListField(fields={@Field(title="\u041b\u043e\u0433", order=150, readOnly=true, propertiesLayout="Tab1/\u041e\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0438:0#newline,  w 1500, h 800,span#newline", viewer={TextViewer.class}, propertiesUI={"toolbar=false"})})
    public String getLog2() {
        return this.log2;
    }

    @ListField(fields={@Field(title="", order=100, propertiesLayout="Tab1/\u041e\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0438:0", viewer={ActionButton.class})})
    public BeanViewerAction<ViewerContext> getRunImport2() {
        return this.runImport2;
    }

    public void addLog2(String s) {
        this.log2 = String.valueOf(this.log2) + s + "\n";
        new Thread(new Runnable(){

            @Override
            public void run() {
                ImportRoutes.this.pc.getPanel().updateUIForPresentatorName("log2");
            }
        }).start();
    }

    public Route getRoute(String name) {
        RouteSearchCriteria sc = new RouteSearchCriteria();
        sc.setName("*" + name + "*");
        Object[] oo = this.proxy.getList(InitializedVariable.context, sc).getObjList();
        if (oo == null || oo.length == 0) {
            Route r = new Route();
            r.setName(name);
            String[] ss = name.split(" ");
            r.setNum(String.valueOf(ss[0]) + " " + ss[1]);
            r = this.proxy.save(InitializedVariable.context, r);
            this.addLog2(String.valueOf(name) + " Not found. Create route ");
            return r;
        }
        Route r = (Route)oo[0];
        return r;
    }

    public TransportStop getStations(String name) {
        DirectoriesSearchCriteria sc = new DirectoriesSearchCriteria();
        sc.setDescription("*" + name + "*");
        Object[] oo = this.transportStopWSProxy.getList(InitializedVariable.context, sc).getObjList();
        if (oo == null || oo.length == 0) {
            TransportStop stop = new TransportStop();
            stop.setDescription(name);
            stop.setCode(name);
            stop = this.transportStopWSProxy.save(InitializedVariable.context, stop);
            return stop;
        }
        return (TransportStop)oo[0];
    }

    public CheckPoint getCheckPoint(String name, String direction, Double lat, Double lon) {
        String n1 = ">".equals(direction) ? String.valueOf(name) + "(\u0441\u043f\u0440\u0430\u0432\u0430)" : String.valueOf(name) + "(\u0441\u043b\u0435\u0432\u0430)";
        CheckPointSearchCriteria sc = new CheckPointSearchCriteria();
        sc.setName("*" + n1 + "*");
        Object[] oo = this.checkPointWSProxy.getList(InitializedVariable.context, sc).getObjList();
        if (oo != null && oo.length > 0) {
            Object[] objectArray = oo;
            int n = oo.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                CheckPoint p = (CheckPoint)o;
                if (p.getLat().equals(lat) && p.getLon().equals(lon)) {
                    return p;
                }
                ++n2;
            }
        }
        CheckPoint p = new CheckPoint();
        p.setName(n1);
        p.setCode(String.valueOf(n1) + lat.toString() + lon.toString());
        p.setLat(lat);
        p.setLon(lon);
        p.setRadius(Integer.valueOf(50));
        p = this.checkPointWSProxy.save(InitializedVariable.context, p);
        GeometryFactory f = new GeometryFactory();
        try {
            CoordinateReferenceSystem sourceCRS = CRS.parseWKT((String)JosmMainApp.wkt4326);
            CoordinateReferenceSystem targetCRS = CRS.parseWKT((String)JosmMainApp.wkt3395);
            MathTransform math = CRS.findMathTransform((CoordinateReferenceSystem)sourceCRS, (CoordinateReferenceSystem)targetCRS);
            MathTransform math2 = CRS.findMathTransform((CoordinateReferenceSystem)targetCRS, (CoordinateReferenceSystem)sourceCRS);
            GeneralDirectPosition pt1 = new GeneralDirectPosition(lon.doubleValue(), lat.doubleValue());
            DirectPosition pt2 = math.transform((DirectPosition)pt1, null);
            com.vividsolutions.jts.geom.Point p1 = f.createPoint(new Coordinate(pt2.getCoordinate()[0], pt2.getCoordinate()[1]));
            Geometry buffer = p1.buffer((double)p.getRadius().intValue());
            ArrayList<Point> ll = new ArrayList<Point>();
            if (buffer instanceof Polygon) {
                Polygon pol = (Polygon)buffer;
                int i = 0;
                while (i < pol.getCoordinates().length - 1) {
                    Coordinate c = pol.getCoordinates()[i];
                    GeneralDirectPosition pt11 = new GeneralDirectPosition(c.x, c.y);
                    DirectPosition pt22 = math2.transform((DirectPosition)pt11, null);
                    Point pp = new Point(pt22.getCoordinate()[0], pt22.getCoordinate()[1]);
                    ll.add(pp);
                    ++i;
                }
                ll.add((Point)ll.get(0));
            }
            org.postgis.Polygon pol1 = new org.postgis.Polygon(new LinearRing[]{new LinearRing(ll.toArray(new Point[ll.size()]))});
            p.setGeom(pol1.toString());
            p = this.checkPointWSProxy.save(InitializedVariable.context, p);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return p;
    }

    public void RunImport2() {
        try {
            this.addLog2("Read file " + this.importFileName2);
            Object[] oo = this.checkPointTypeWSProxy.getList(InitializedVariable.context, new DirectoriesSearchCriteria()).getObjList();
            CheckPointType begin = null;
            CheckPointType end = null;
            Object[] objectArray = oo;
            int n = oo.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                if ("\u043d\u0430\u0447\u0430\u043b\u044c\u043d\u0430\u044f".equals(((CheckPointType)o).getDescription().toLowerCase())) {
                    begin = (CheckPointType)o;
                } else if ("\u043a\u043e\u043d\u0435\u0447\u043d\u0430\u044f".equals(((CheckPointType)o).getDescription().toLowerCase())) {
                    end = (CheckPointType)o;
                }
                ++n2;
            }
            try {
                BufferedReader r2 = new BufferedReader(new InputStreamReader(new FileInputStream(this.importFileName2)));
                String s = r2.readLine();
                Route2CheckPointLinkExt link_old = null;
                int ii = 0;
                while ((s = r2.readLine()) != null) {
                    ++ii;
                    String[] ss = s.split(";");
                    Route r = this.getRoute(ss[0]);
                    TransportStop stop = this.getStations(ss[4]);
                    CheckPoint point = this.getCheckPoint(ss[4], ss[2], Double.parseDouble(ss[6].replaceAll(",", ".")), Double.parseDouble(ss[5].replaceAll(",", ".")));
                    Route2CheckPointLinkExt link = new Route2CheckPointLinkExt();
                    link.setRoute(r);
                    link.setStop(stop);
                    link.setPoint(point);
                    link.setDirection(">".equals(ss[2]) ? 0 : 1);
                    Integer num = Integer.parseInt(ss[3]);
                    link.setPointIndex(num);
                    if (num.equals(1)) {
                        if (link_old != null) {
                            link_old.setType(end);
                            link_old = (Route2CheckPointLinkExt)this.checkPointLinkWSProxy.save(InitializedVariable.context, (Route2CheckPointLink)link_old);
                        }
                        link.setType(begin);
                    }
                    link_old = (Route2CheckPointLinkExt)this.checkPointLinkWSProxy.save(InitializedVariable.context, (Route2CheckPointLink)link);
                }
                if (link_old != null) {
                    link_old.setType(end);
                    link_old = (Route2CheckPointLinkExt)this.checkPointLinkWSProxy.save(InitializedVariable.context, link_old);
                }
                this.addLog2("save " + ii + " record");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

