/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.route;

import java.awt.Color;
import java.util.ArrayList;
import javax.swing.JComponent;
import org.jxmapviewer.JXMapViewer;
import org.postgis.Point;
import ru.blok.vms.ui.mapviewer.MapViewer;
import ru.blok.vms.ui.mapviewer.mapviewerwithtrack.view.RoutePainter;
import ru.blok.vms.ui.route.MapValueRoutes;
import ru.infor.beanviewer.core.UIFactory;
import ru.infor.ws.objects.vms.entities.ext.RouteExt;
import ru.infor.ws.objects.vms.ext.RouteUIExt;

public class MapViewerRoutes
extends MapViewer {
    RoutePainter<JXMapViewer> routePainter2;
    MapValueRoutes value = null;

    public MapViewerRoutes(UIFactory<JComponent> factory) {
        super(factory);
    }

    @Override
    protected void init() {
        super.init();
        this.routePainter2 = new RoutePainter();
        this.painter.addPainter(this.routePainter2);
    }

    @Override
    protected boolean canGoToData() {
        return true;
    }

    @Override
    protected Double[] getMinMax() {
        Double minLat = null;
        Double maxLat = null;
        Double minLon = null;
        Double maxLon = null;
        if (this.routePainter2 != null && this.routePainter2.getRoutes() != null) {
            for (RouteExt r : this.routePainter2.getRoutes()) {
                if (r.getCurrentPolygon() == null) continue;
                int i = 0;
                while (i < r.getCurrentPolygon().numPoints()) {
                    Point d = r.getCurrentPolygon().getPoint(i);
                    if (minLat == null || d.getY() < minLat) {
                        minLat = d.getY();
                    }
                    if (maxLat == null || d.getY() > maxLat) {
                        maxLat = d.getY();
                    }
                    if (minLon == null || d.getX() < minLon) {
                        minLon = d.getX();
                    }
                    if (maxLon == null || d.getX() > maxLon) {
                        maxLon = d.getX();
                    }
                    ++i;
                }
            }
        }
        if (minLat == null) {
            return null;
        }
        return new Double[]{minLat, maxLat, minLon, maxLon};
    }

    @Override
    public Object getValue() {
        return null;
    }

    @Override
    public void setValue(Object arg0) {
        super.setValue(arg0);
        this.value = (MapValueRoutes)arg0;
        ArrayList<RouteExt> lists = new ArrayList<RouteExt>();
        if (this.value != null) {
            for (RouteUIExt r : this.value.getList()) {
                if (r.getRoute() == null) {
                    RouteExt rr = new RouteExt();
                    rr.setId(r.getId());
                    rr.setColor(Color.RED.getRGB());
                    rr.setAreaRouteGeom(r.getAreaRouteGeom());
                    r.setRoute(rr);
                }
                lists.add(r.getRoute());
            }
        }
        this.routePainter2.setRoutes(lists);
        this.zoomToTracks();
        this.repaint();
    }

    public void setSelected(RouteUIExt r) {
        this.routePainter2.getRoutes().stream().forEach(r1 -> r1.setColor(Color.RED.getRGB()));
        r.getRoute().setColor(Color.BLUE.getRGB());
        Double minLat = null;
        Double maxLat = null;
        Double minLon = null;
        Double maxLon = null;
        if (r.getRoute().getCurrentPolygon() != null) {
            int i = 0;
            while (i < r.getRoute().getCurrentPolygon().numPoints()) {
                Point d = r.getRoute().getCurrentPolygon().getPoint(i);
                if (minLat == null || d.getY() < minLat) {
                    minLat = d.getY();
                }
                if (maxLat == null || d.getY() > maxLat) {
                    maxLat = d.getY();
                }
                if (minLon == null || d.getX() < minLon) {
                    minLon = d.getX();
                }
                if (maxLon == null || d.getX() > maxLon) {
                    maxLon = d.getX();
                }
                ++i;
            }
        }
        if (minLat != null) {
            this.zoomToTracks(new Double[]{minLat, maxLat, minLon, maxLon});
        }
    }
}

