/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.route.editjosmlayer;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import ru.blok.vms.ui.route.editjosmlayer.DataSet;
import uk.co.wilson.xml.MinML2;

public class DataReader {
    private Map<OsmPrimitive, Collection<Long>> ways = new HashMap<OsmPrimitive, Collection<Long>>();
    private DataSet ds;
    private HashSet<String> allowedVersions = new HashSet();
    private HashMap<Long, Node> nodes = new HashMap();
    private HashMap<Long, List<Long>> nodesToWay = new HashMap();

    public DataReader(DataSet ds) {
        this.ds = ds;
    }

    private long getLong(Attributes atts, String value) throws SAXException {
        String s = atts.getValue(value);
        if (s == null) {
            throw new SAXException(I18n.tr((String)"Missing required attribute \"{0}\".", (Object[])new Object[]{value}));
        }
        return Long.parseLong(s);
    }

    void readCommon(Attributes atts, OsmPrimitive current) throws SAXException {
        Integer d;
        Integer must_accept;
        current.setOsmId(this.getLong(atts, "id"), 1);
        if (current.getId() == 0L) {
            throw new SAXException(I18n.tr((String)"Illegal object with id=0", (Object[])new Object[0]));
        }
        String ma = atts.getValue("acceptedEntry");
        if (ma != null && (must_accept = Integer.valueOf(Integer.parseInt(ma))) == 0) {
            current.put("must_accept", "yes");
        }
        if ((ma = atts.getValue("deleted")) != null && (d = Integer.valueOf(Integer.parseInt(ma))) == 1) {
            current.put("deleted", "yes");
        }
    }

    private Node findNode(long id) {
        Node n = this.nodes.get(id);
        if (n != null) {
            return n;
        }
        for (Node node : this.ds.getNodes()) {
            if (node.getId() != id) continue;
            return node;
        }
        return null;
    }

    private void createWays() {
        for (Map.Entry<OsmPrimitive, Collection<Long>> e : this.ways.entrySet()) {
            Way w = (Way)e.getKey();
            String v = w.get("must_accept");
            boolean mu = "yes".equals(v);
            boolean first = true;
            for (long id : e.getValue()) {
                Node n = this.findNode(id);
                if (n != null) {
                    if (first) {
                        if (mu) {
                            n.put("must_accept", "yes");
                        } else {
                            n.remove("must_accept");
                        }
                        first = false;
                    } else if (!n.equals((Object)w.getNode(0))) {
                        n.remove("must_accept");
                    }
                }
                w.addNode(n);
                List<Long> l = this.nodesToWay.get(id);
                if (l == null) {
                    l = new ArrayList<Long>();
                    this.nodesToWay.put(id, l);
                }
                l.add(w.getId());
            }
            this.ds.addPrimitive((OsmPrimitive)w);
            this.ds.listNodes.put(w.getId(), w.getNodes());
        }
        this.ds.nodesToWay = this.nodesToWay;
    }

    public static DataSet parseDataSet(InputStream source) throws SAXException, IOException {
        DataReader osm;
        DataReader dataReader = osm = new DataReader(new DataSet());
        dataReader.getClass();
        dataReader.new Parser().parse(new InputStreamReader(source, "UTF-8"));
        for (Node n : osm.nodes.values()) {
            osm.ds.addPrimitive((OsmPrimitive)n);
        }
        try {
            osm.createWays();
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            throw new SAXException(I18n.tr((String)"Illformed Node id", (Object[])new Object[]{""}));
        }
        return osm.ds;
    }

    public static class OsmPrimitiveData {
    }

    private class Parser
    extends MinML2 {
        private OsmPrimitive current;

        private Parser() {
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            try {
                if (!qName.equals("osm")) {
                    if (qName.equals("node")) {
                        Node n = new Node();
                        DataReader.this.readCommon(atts, (OsmPrimitive)n);
                        n.setCoor(new LatLon(this.getDouble(atts, "lat"), this.getDouble(atts, "lon")));
                        this.current = n;
                        DataReader.this.nodes.put(this.current.getId(), (Node)this.current);
                    } else if (qName.equals("way")) {
                        this.current = new Way();
                        DataReader.this.readCommon(atts, this.current);
                        DataReader.this.ways.put(this.current, new LinkedList());
                    } else if (qName.equals("nd")) {
                        Collection list = (Collection)DataReader.this.ways.get(this.current);
                        if (list == null) {
                            throw new SAXException(I18n.tr((String)"Found <seg> tag on non-way.", (Object[])new Object[0]));
                        }
                        long id = DataReader.this.getLong(atts, "ref");
                        if (id == 0L) {
                            throw new SAXException(I18n.tr((String)"Incomplete segment with id=0", (Object[])new Object[0]));
                        }
                        list.add(id);
                    } else if (qName.equals("tag")) {
                        this.current.put(atts.getValue("k"), atts.getValue("v"));
                    }
                }
            }
            catch (NumberFormatException x) {
                x.printStackTrace();
                throw new SAXException(x.getMessage(), x);
            }
            catch (NullPointerException x) {
                x.printStackTrace();
                throw new SAXException(I18n.tr((String)"NullPointerException, Possibly some missing tags.", (Object[])new Object[0]), x);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        private double getDouble(Attributes atts, String value) {
            return Double.parseDouble(atts.getValue(value));
        }
    }
}

