/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.route.editjosmlayer;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import org.jxmapviewer.viewer.GeoPosition;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSource;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.io.OsmTransferCanceledException;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.SAXException;
import ru.blok.common.core.CurrentProxyFactory;
import ru.blok.common.core.InitializedVariable;
import ru.blok.vms.ui.route.editjosmlayer.DataReader;
import ru.infor.client.ServicesConnection;
import ru.infor.client.soap.SOAPException;
import ru.infor.client.soap.proxy.cartography.GeometryDownloadWSProxy;
import ru.infor.client.soap.proxy.cartography.NodeWSProxy;
import ru.infor.client.soap.proxy.cartography.WayWSProxy;
import ru.infor.ws.objects.InvocationContext;
import ru.infor.ws.objects.cartography.AbstractGeometrySearchCriteria;
import ru.infor.ws.objects.cartography.NodeSearchCriteria;
import ru.infor.ws.objects.cartography.Tag;
import ru.infor.ws.objects.cartography.WaySearchCriteria;
import ru.infor.ws.objects.cartography.entities.Node;
import ru.infor.ws.objects.cartography.entities.Way;

public class DataSet
extends org.openstreetmap.josm.data.osm.DataSet {
    protected Bounds currentBoundsView;
    static InvocationContext ctx;
    WayWSProxy wsProxy = (WayWSProxy)CurrentProxyFactory.getProxy(Way.class);
    NodeWSProxy nodeWSProxy = (NodeWSProxy)CurrentProxyFactory.getProxy(Node.class);
    public HashMap<Long, List<Long>> nodesToWay = new HashMap();
    public HashMap<Long, List<org.openstreetmap.josm.data.osm.Node>> listNodes = new HashMap();
    private HashMap<Long, Node> nodes = new HashMap();
    List<Long> rebGeom = new ArrayList<Long>();
    boolean ok;

    public DataSet() {
        InvocationContext contextCart;
        HashMap sp = InitializedVariable.runtimeParameters(null);
        ctx = contextCart = InitializedVariable.checkCreateInvocationContext((String)((String)sp.get("cart.user.name")), (String)((String)sp.get("cart.user.password")), (ServicesConnection)ServicesConnection.getConnection((String)"cartography-ws"));
    }

    public void load(GeoPosition point1, GeoPosition point2, final boolean newLayer) {
        final StringBuilder st = new StringBuilder();
        if (point1 != null && point2 != null) {
            st.append("POLYGON((").append(point1.getLongitude()).append(" ").append(point1.getLatitude()).append(", ").append(point2.getLongitude()).append(" ").append(point1.getLatitude()).append(", ").append(point2.getLongitude()).append(" ").append(point2.getLatitude()).append(", ").append(point1.getLongitude()).append(" ").append(point2.getLatitude()).append(", ").append(point1.getLongitude()).append(" ").append(point1.getLatitude()).append("))");
        }
        System.out.println(st);
        this.currentBoundsView = new Bounds(new LatLon(point1.getLatitude(), point1.getLongitude()), new LatLon(point2.getLatitude(), point2.getLongitude()));
        PleaseWaitRunnable downloadTask = new PleaseWaitRunnable(I18n.tr((String)"Downloading data", (Object[])new Object[]{""})){
            private boolean canceled;
            private boolean failed;
            protected DataSet dataSet;
            protected DataSet downloadedData;
            protected OsmDataLayer targetLayer;
            protected Bounds currentBounds;
            {
                super($anonymous0);
                this.canceled = false;
                this.failed = false;
            }

            protected DataSet parseDataSet() throws OsmTransferException {
                try {
                    GeometryDownloadWSProxy proxy = new GeometryDownloadWSProxy(ServicesConnection.getConnection((String)"cartography-ws"));
                    AbstractGeometrySearchCriteria sc = new AbstractGeometrySearchCriteria();
                    sc.setAcceptedEntries(null);
                    sc.setGeom(st.toString());
                    DataSet ds = null;
                    String url = proxy.getDownloadURL(ctx, sc);
                    InputStream in = null;
                    try {
                        try {
                            in = new URL(url).openStream();
                            ds = DataReader.parseDataSet(in);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            try {
                                in.close();
                            }
                            catch (IOException e2) {
                                e2.printStackTrace();
                            }
                        }
                    }
                    finally {
                        try {
                            in.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    return ds;
                }
                catch (SOAPException e) {
                    e.printStackTrace();
                    JOptionPane.showMessageDialog(Main.parent, "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u044f \u043a \u0431\u0430\u0437\u0435", "\u041e\u0448\u0438\u0431\u043a\u0430", -1);
                    return null;
                }
            }

            public boolean isCanceled() {
                return this.canceled;
            }

            public void setCanceled(boolean canceled) {
                this.canceled = canceled;
            }

            public boolean isFailed() {
                return this.failed;
            }

            public void setFailed(boolean failed) {
                this.failed = failed;
            }

            public void realRun() throws IOException, SAXException, OsmTransferException {
                try {
                    if (this.isCanceled()) {
                        return;
                    }
                    this.dataSet = this.parseDataSet();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (this.isCanceled()) {
                        System.out.println(I18n.tr((String)"Ignoring exception because download has been canceled. Exception was: {0}", (Object[])new Object[]{e.toString()}));
                        return;
                    }
                    if (e instanceof OsmTransferCanceledException) {
                        this.setCanceled(true);
                        return;
                    }
                    boolean cfr_ignored_0 = e instanceof OsmTransferException;
                }
            }

            protected void rememberDownloadedData(DataSet ds) {
                this.downloadedData = ds;
            }

            public DataSet getDownloadedData() {
                return this.downloadedData;
            }

            protected int getNumDataLayers() {
                int count = 0;
                if (!Main.isDisplayingMapView()) {
                    return 0;
                }
                Collection layers = Main.map.mapView.getAllLayers();
                for (Layer layer : layers) {
                    if (!(layer instanceof OsmDataLayer)) continue;
                    ++count;
                }
                return count;
            }

            protected OsmDataLayer getEditLayer() {
                if (!Main.isDisplayingMapView()) {
                    return null;
                }
                return Main.map.mapView.getEditLayer();
            }

            protected OsmDataLayer getFirstDataLayer() {
                if (!Main.isDisplayingMapView()) {
                    return null;
                }
                List layers = Main.map.mapView.getAllLayersAsList();
                for (Layer layer : layers) {
                    if (!(layer instanceof OsmDataLayer)) continue;
                    return (OsmDataLayer)layer;
                }
                return null;
            }

            protected OsmDataLayer createNewLayer() {
                return new OsmDataLayer((org.openstreetmap.josm.data.osm.DataSet)this.dataSet, OsmDataLayer.createNewName(), null);
            }

            protected void finish() {
                if (this.isFailed() || this.isCanceled()) {
                    return;
                }
                if (this.dataSet == null) {
                    return;
                }
                if (this.dataSet.allPrimitives().isEmpty()) {
                    this.dataSet.dataSources.add(new DataSource(this.currentBounds != null ? this.currentBounds : new Bounds(new LatLon(0.0, 0.0)), "OpenStreetMap server"));
                }
                this.rememberDownloadedData(this.dataSet);
                int numDataLayers = this.getNumDataLayers();
                if (newLayer || numDataLayers == 0 || numDataLayers > 1 && this.getEditLayer() == null) {
                    this.targetLayer = this.createNewLayer();
                    boolean isDisplayingMapView = Main.isDisplayingMapView();
                    Main.main.addLayer((Layer)this.targetLayer);
                    if (isDisplayingMapView) {
                        this.computeBboxAndCenterScale();
                    }
                } else {
                    this.targetLayer = this.getEditLayer();
                    if (this.targetLayer == null) {
                        this.targetLayer = this.getFirstDataLayer();
                    }
                    this.targetLayer.mergeFrom((org.openstreetmap.josm.data.osm.DataSet)this.dataSet);
                    this.computeBboxAndCenterScale();
                    this.targetLayer.onPostDownloadFromServer();
                }
            }

            protected void computeBboxAndCenterScale() {
                BoundingXYVisitor v = new BoundingXYVisitor();
                if (this.currentBounds != null) {
                    v.visit(this.currentBounds);
                } else {
                    v.computeBoundingBox(this.dataSet.getNodes());
                }
                Main.map.mapView.zoomTo(DataSet.this.currentBoundsView);
            }

            protected void cancel() {
                this.setCanceled(true);
            }
        };
        Main.worker.execute((Runnable)downloadTask);
    }

    private Way saveWay(org.openstreetmap.josm.data.osm.Way ww) {
        Way w = new Way();
        if (ww.getId() > 0L) {
            w.setId(Long.valueOf(ww.getId()));
            w.setRootId(Long.valueOf(ww.getId()));
        }
        ArrayList<Node> nlist = new ArrayList<Node>();
        for (org.openstreetmap.josm.data.osm.Node nn : ww.getNodes()) {
            Node n = this.getNode(nn.getId());
            nlist.add(n);
        }
        w.setNodes(nlist.toArray(new Node[0]));
        if (ww.isTagged()) {
            ArrayList<Tag> ltag = new ArrayList<Tag>();
            for (Map.Entry entry : ww.getKeys().entrySet()) {
                if (((String)entry.getKey()).equals("must_accept")) continue;
                Tag t = new Tag();
                t.setKey((String)entry.getKey());
                t.setValue((String)entry.getValue());
                ltag.add(t);
            }
            w.setTags(ltag.toArray(new Tag[0]));
        }
        w.setCurrentVersion(Integer.valueOf(1));
        w = this.wsProxy.save(ctx, w);
        ww.setOsmId(w.getId().longValue(), 1);
        this.rebGeom.add(w.getId());
        this.listNodes.put(w.getId(), ww.getNodes());
        for (org.openstreetmap.josm.data.osm.Node nn : ww.getNodes()) {
            List<Long> l = this.nodesToWay.get(nn.getId());
            if (l == null) {
                l = new ArrayList<Long>();
                this.nodesToWay.put(nn.getId(), l);
            }
            l.add(ww.getId());
        }
        return w;
    }

    private void deleteWayFromBase(org.openstreetmap.josm.data.osm.Way ww) {
        this.wsProxy.delete(ctx, Long.valueOf(ww.getId()));
        if (this.rebGeom.contains(ww.getId())) {
            this.rebGeom.remove(ww.getId());
        }
    }

    private Node getNode(Long id) {
        Node n = this.nodes.get(id);
        if (n == null) {
            n = this.nodeWSProxy.getCurrentObject(ctx, id);
            this.nodes.put(n.getId(), n);
        }
        return n;
    }

    private Node saveNode(org.openstreetmap.josm.data.osm.Node n) {
        Node nn = new Node();
        if (n.getId() != 0L) {
            nn.setId(Long.valueOf(n.getId()));
            nn.setRootId(Long.valueOf(n.getId()));
        }
        nn.setLat(n.getCoor().getY());
        nn.setLon(n.getCoor().getX());
        nn.setCurrentVersion(Integer.valueOf(1));
        if (n.isTagged()) {
            ArrayList<Tag> ltag = new ArrayList<Tag>();
            for (Map.Entry e : n.getKeys().entrySet()) {
                if (((String)e.getKey()).equals("must_accept")) continue;
                Tag t = new Tag();
                t.setKey((String)e.getKey());
                t.setValue((String)e.getValue());
                ltag.add(t);
            }
            nn.setTags(ltag.toArray(new Tag[0]));
        }
        nn = this.nodeWSProxy.save(ctx, nn);
        this.nodeWSProxy.rebuildGeom(ctx, nn.getId());
        this.nodes.put(nn.getId(), nn);
        List<Long> l = this.nodesToWay.get(n.getId());
        if (l != null) {
            for (Long id : l) {
                if (this.rebGeom.contains(id)) continue;
                this.rebGeom.add(id);
            }
        }
        return nn;
    }

    private void delNode(org.openstreetmap.josm.data.osm.Node n) {
        if (n.getId() > 0L) {
            this.nodeWSProxy._universalDelete((ru.infor.ws.proxy.interfaces.InvocationContext)ctx, Long.valueOf(n.getId()));
            List<Long> l = this.nodesToWay.get(n.getId());
            if (l != null) {
                for (Long id : l) {
                    if (this.rebGeom.contains(id)) continue;
                    this.rebGeom.add(id);
                }
            }
        }
    }

    private org.openstreetmap.josm.data.osm.Way findWay(long id) {
        for (org.openstreetmap.josm.data.osm.Way w : this.getWays()) {
            if (w.getId() != id) continue;
            return w;
        }
        return null;
    }

    private void saveToServer(LinkedList<org.openstreetmap.josm.data.osm.Node> modnode, LinkedList<org.openstreetmap.josm.data.osm.Way> modway, LinkedList<org.openstreetmap.josm.data.osm.Node> delnode, LinkedList<org.openstreetmap.josm.data.osm.Way> delway) {
        this.rebGeom.clear();
        this.nodes.clear();
        for (org.openstreetmap.josm.data.osm.Node n : modnode) {
            Node nn = this.saveNode(n);
            n.setOsmId(nn.getId().longValue(), 1);
            if (nn.getAcceptedEntry() != 0) continue;
            n.put("must_accept", "yes");
        }
        for (org.openstreetmap.josm.data.osm.Way w : modway) {
            Way ww = this.saveWay(w);
            w.setOsmId(ww.getId().longValue(), 1);
            if (ww.getAcceptedEntry() != 0) continue;
            w.put("must_accept", "yes");
            if (w.getNodesCount() <= 0) continue;
            w.getNode(0).put("must_accept", "yes");
        }
        ArrayList<Long> delWayId = new ArrayList<Long>();
        for (org.openstreetmap.josm.data.osm.Way w : delway) {
            this.deleteWayFromBase(w);
            w.setDeleted(false);
            delWayId.add(w.getId());
            List<org.openstreetmap.josm.data.osm.Node> ln = this.listNodes.get(w.getId());
            if (ln != null && ln.size() > 0) {
                for (org.openstreetmap.josm.data.osm.Node n : ln) {
                    n.setDeleted(false);
                }
            }
            w.setNodes(ln);
            w.put("must_accept", "yes");
            w.put("deleted", "yes");
            if (w.getNodesCount() <= 0) continue;
            w.getNode(0).put("must_accept", "yes");
            w.getNode(0).put("deleted", "yes");
        }
        for (org.openstreetmap.josm.data.osm.Node n : delnode) {
            boolean sn = true;
            this.nodesToWay.get(n.getId());
            if (this.nodesToWay.get(n.getId()) != null) {
                for (Long l : this.nodesToWay.get(n.getId())) {
                    if (!delWayId.contains(l)) continue;
                    sn = false;
                    break;
                }
            }
            if (!sn) continue;
            this.delNode(n);
            n.put("must_accept", "yes");
            n.put("deleted", "yes");
            n.setDeleted(false);
        }
        this.wsProxy.rebuildGeomList(ctx, this.rebGeom.toArray(new Long[0]));
        for (Long id : this.rebGeom) {
            boolean mu;
            org.openstreetmap.josm.data.osm.Way w = this.findWay(id);
            if (w == null) continue;
            Way ww = this.wsProxy.getCurrentObject(ctx, id);
            boolean bl = mu = ww.getAcceptedEntry() == 0;
            if (mu) {
                w.put("must_accept", "yes");
            } else {
                w.remove("must_accept");
            }
            boolean first = true;
            for (org.openstreetmap.josm.data.osm.Node n : w.getNodes()) {
                if (first) {
                    if (mu) {
                        n.put("must_accept", "yes");
                    } else {
                        n.remove("must_accept");
                    }
                    first = false;
                    continue;
                }
                if (n.equals((Object)w.getNode(0))) continue;
                n.remove("must_accept");
            }
        }
    }

    public void save() {
        if (ctx != null) {
            final ArrayList all = new ArrayList();
            final LinkedList<org.openstreetmap.josm.data.osm.Node> modnode = new LinkedList<org.openstreetmap.josm.data.osm.Node>();
            final LinkedList<org.openstreetmap.josm.data.osm.Way> modway = new LinkedList<org.openstreetmap.josm.data.osm.Way>();
            final LinkedList<org.openstreetmap.josm.data.osm.Node> delnode = new LinkedList<org.openstreetmap.josm.data.osm.Node>();
            final LinkedList<org.openstreetmap.josm.data.osm.Way> delway = new LinkedList<org.openstreetmap.josm.data.osm.Way>();
            for (OsmPrimitive osm : this.allPrimitives()) {
                if (osm instanceof org.openstreetmap.josm.data.osm.Node) {
                    if ((osm.getId() <= 0L || osm.isModified()) && !osm.isDeleted()) {
                        modnode.add((org.openstreetmap.josm.data.osm.Node)osm);
                        continue;
                    }
                    if (!osm.isDeleted()) continue;
                    delnode.add((org.openstreetmap.josm.data.osm.Node)osm);
                    continue;
                }
                if (!(osm instanceof org.openstreetmap.josm.data.osm.Way)) continue;
                if ((osm.getId() <= 0L || osm.isModified()) && !osm.isDeleted()) {
                    modway.add((org.openstreetmap.josm.data.osm.Way)osm);
                    continue;
                }
                if (!osm.isDeleted()) continue;
                delway.add((org.openstreetmap.josm.data.osm.Way)osm);
            }
            if (modnode.isEmpty() && modway.isEmpty() && delnode.isEmpty() && delway.isEmpty()) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"No changes to upload.", (Object[])new Object[0]));
                return;
            }
            all.addAll(modway);
            all.addAll(modnode);
            all.addAll(delway);
            all.addAll(delnode);
            PleaseWaitRunnable uploadTask = new PleaseWaitRunnable(I18n.tr((String)"Uploading data", (Object[])new Object[0])){

                protected void realRun() throws SAXException {
                    DataSet.this.ok = true;
                    try {
                        DataSet.this.saveToServer(modnode, modway, delnode, delway);
                    }
                    catch (SOAPException se) {
                        se.printStackTrace();
                        DataSet.this.ok = false;
                        JOptionPane.showMessageDialog(null, "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u0438. \u0423 \u0412\u0430\u0441 \u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043e\u0447\u043d\u043e \u043f\u0440\u0430\u0432 \u0434\u043b\u044f \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u044f");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        DataSet.this.ok = false;
                        JOptionPane.showMessageDialog(null, "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u0438");
                        e.printStackTrace();
                    }
                }

                protected void finish() {
                    if (DataSet.this.ok) {
                        Main.main.getEditLayer().cleanupAfterUpload(all);
                        Main.main.getEditLayer().onPostUploadToServer();
                        Main.map.repaint();
                    }
                }

                protected void cancel() {
                }
            };
            Main.worker.execute((Runnable)uploadTask);
        }
    }

    private void acceptToServer(LinkedList<Long> lnode, LinkedList<Long> lway) {
        if (lnode.size() > 0) {
            NodeSearchCriteria sc = (NodeSearchCriteria)this.nodeWSProxy._getSearchCriteriaTemplate();
            sc.setIdList(lnode.toArray(new Long[0]));
            this.nodeWSProxy.acceptEntries(ctx, sc);
        }
        if (lway.size() > 0) {
            WaySearchCriteria scw = (WaySearchCriteria)this.wsProxy._getSearchCriteriaTemplate();
            scw.setIdList(lway.toArray(new Long[0]));
            this.wsProxy.acceptEntries(ctx, scw);
        }
    }

    public void accept() {
        if (ctx != null) {
            final ArrayList<OsmPrimitive> all = new ArrayList<OsmPrimitive>();
            final LinkedList<Long> lnodeIds = new LinkedList<Long>();
            final LinkedList<Long> lwayIds = new LinkedList<Long>();
            for (OsmPrimitive osm : this.getSelected()) {
                if (osm instanceof org.openstreetmap.josm.data.osm.Node) {
                    if (!"yes".equals(osm.get("must_accept"))) continue;
                    lnodeIds.add(((org.openstreetmap.josm.data.osm.Node)osm).getId());
                    all.add(osm);
                    continue;
                }
                if (!(osm instanceof org.openstreetmap.josm.data.osm.Way) || !"yes".equals(osm.get("must_accept"))) continue;
                lwayIds.add(((org.openstreetmap.josm.data.osm.Way)osm).getId());
                all.add(osm);
            }
            if (lnodeIds.isEmpty() && lwayIds.isEmpty()) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"No changes to upload.", (Object[])new Object[0]));
                return;
            }
            PleaseWaitRunnable uploadTask = new PleaseWaitRunnable(I18n.tr((String)"Uploading data", (Object[])new Object[0])){

                protected void realRun() throws SAXException {
                    DataSet.this.ok = true;
                    try {
                        DataSet.this.acceptToServer(lnodeIds, lwayIds);
                    }
                    catch (SOAPException se) {
                        se.printStackTrace();
                        DataSet.this.ok = false;
                        JOptionPane.showMessageDialog(null, "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0443\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u0438. \u0423 \u0412\u0430\u0441 \u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043e\u0447\u043d\u043e \u043f\u0440\u0430\u0432 \u0434\u043b\u044f \u0443\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u044f");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        DataSet.this.ok = false;
                        JOptionPane.showMessageDialog(null, "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0443\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u0438");
                    }
                }

                protected void finish() {
                    if (DataSet.this.ok) {
                        for (IPrimitive osm : all) {
                            osm.remove("must_accept");
                            boolean d = "yes".equals(osm.get("deleted"));
                            if (d) {
                                osm.setDeleted(true);
                            }
                            if (!(osm instanceof org.openstreetmap.josm.data.osm.Way)) continue;
                            for (org.openstreetmap.josm.data.osm.Node n : ((org.openstreetmap.josm.data.osm.Way)osm).getNodes()) {
                                n.remove("must_accept");
                                if (!d) continue;
                                n.setDeleted(true);
                            }
                        }
                        Main.main.getEditLayer().cleanupAfterUpload(all);
                        Main.main.getCurrentDataSet().clearSelection();
                    }
                }

                protected void cancel() {
                }
            };
            Main.worker.execute((Runnable)uploadTask);
        }
    }
}

