/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.route.editjosmlayer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.net.URI;
import java.util.Properties;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.jxmapviewer.JXMapKit;
import org.jxmapviewer.painter.Painter;
import org.jxmapviewer.viewer.AbstractTileFactory;
import org.jxmapviewer.viewer.GeoPosition;
import org.jxmapviewer.viewer.TileCache;
import org.jxmapviewer.viewer.TileFactory;
import ru.blok.vms.ui.josm.JosmMainApp;
import ru.blok.vms.ui.mapviewer.cache.TileCacheFile;
import ru.blok.vms.ui.mapviewer.mapviewerwithtrack.view.RectanglePainter;
import ru.blok.vms.ui.mapviewer.ui.DefaultProvider;
import ru.blok.vms.ui.mapviewer.ui.ProviderInfo;
import ru.infor.common.SysProperties;

public class GetData
extends JPanel {
    private static final long serialVersionUID = 4857862093588052777L;
    private static double latc = 57.6224702;
    private static double lonc = 39.8869553;
    public Double lat = null;
    public Double lon = null;
    public int zoom;
    JPanel main;
    GeoPosition gp1 = null;
    GeoPosition gp2 = null;
    private int state = 0;
    public JXMapKit map = new JXMapKit();
    private AbstractTileFactory tf;
    RectanglePainter rectanglePainter;

    public GeoPosition getPoint1() {
        return this.gp1;
    }

    public GeoPosition getPoint2() {
        return this.gp2;
    }

    public void setPoints(GeoPosition gp1, GeoPosition gp2) {
        this.gp1 = gp1;
        this.gp2 = gp2;
        if (this.rectanglePainter != null) {
            this.rectanglePainter.setPoint1(gp1);
            this.rectanglePainter.setPoint2(gp2);
        }
        this.lat = (gp1.getLatitude() + gp2.getLatitude()) / 2.0;
        this.lon = (gp1.getLongitude() + gp2.getLongitude()) / 2.0;
        this.map.getMainMap().setCenterPosition(new GeoPosition(this.lat.doubleValue(), this.lon.doubleValue()));
        this.map.repaint();
    }

    private synchronized int getState() {
        return this.state;
    }

    private synchronized void setState(int state) {
        this.state = state;
    }

    public void saveToFile(File f, Double lat, Double lon, Integer zoom) {
        Properties p = new Properties();
        p.setProperty("map.lat", lat.toString());
        p.setProperty("map.lon", lon.toString());
        p.setProperty("map.zoom", zoom.toString());
        try {
            p.store(new FileOutputStream(f), "cartography");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void saveProrerties() {
        this.lat = this.map.getMainMap().getCenterPosition().getLatitude();
        this.lon = this.map.getMainMap().getCenterPosition().getLongitude();
        this.zoom = this.map.getMainMap().getZoom();
        String folder = System.getProperty("common.props.folder", "config");
        File file = new File(folder);
        if (file.isDirectory()) {
            FileFilter ff = new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.getAbsolutePath().endsWith("_map.prop");
                }
            };
            if (file.listFiles(ff).length == 0) {
                File f = new File(String.valueOf(file.getPath()) + File.separator + "config_map.prop");
                this.saveToFile(f, this.lat, this.lon, this.zoom);
            } else {
                File[] fileArray = file.listFiles(ff);
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File f = fileArray[n2];
                    this.saveToFile(f, this.lat, this.lon, this.zoom);
                    ++n2;
                }
            }
        } else {
            this.saveToFile(file, this.lat, this.lon, this.zoom);
        }
    }

    public GetData() {
        this.map.setAddressLocationShown(false);
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                GetData.this.lat = GetData.this.map.getMainMap().getCenterPosition().getLatitude();
                GetData.this.lon = GetData.this.map.getMainMap().getCenterPosition().getLongitude();
                GetData.this.zoom = GetData.this.map.getMainMap().getZoom();
                GetData.this.map.setAddressLocation(new GeoPosition(GetData.this.lat.doubleValue(), GetData.this.lon.doubleValue()));
                GetData.this.map.setZoom(GetData.this.zoom);
                GetData.this.saveProrerties();
            }
        }));
        this.map.getMainMap().addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent e) {
                GetData.this.saveProrerties();
                super.mouseReleased(e);
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 1 && e.isControlDown()) {
                    double x = GetData.this.map.getMainMap().getCenter().getX() + e.getPoint().getX() - GetData.this.map.getMainMap().getVisibleRect().getMaxX() / 2.0;
                    double y = GetData.this.map.getMainMap().getCenter().getY() + e.getPoint().getY() - GetData.this.map.getMainMap().getVisibleRect().getMaxY() / 2.0;
                    GeoPosition gp = GetData.this.map.getMainMap().getTileFactory().pixelToGeo((Point2D)new Point2D.Double(x, y), GetData.this.map.getMainMap().getZoom());
                    if (GetData.this.getState() == 0) {
                        GetData.this.gp1 = new GeoPosition(gp.getLatitude(), gp.getLongitude());
                        GetData.this.gp2 = null;
                        GetData.this.rectanglePainter.setPoint2(null);
                        GetData.this.setState(1);
                    } else if (GetData.this.getState() == 1) {
                        GetData.this.gp2 = new GeoPosition(gp.getLatitude(), gp.getLongitude());
                        GetData.this.rectanglePainter.setPoint1(GetData.this.gp1);
                        GetData.this.rectanglePainter.setPoint2(GetData.this.gp2);
                        GetData.this.setState(0);
                    }
                    GetData.this.map.getMainMap().repaint();
                    GetData.this.saveProrerties();
                }
            }
        });
        this.map.setPreferredSize(new Dimension(800, 500));
        DefaultProvider provider = new DefaultProvider((ProviderInfo)JosmMainApp.layer2.getUIProperties());
        this.tf = provider.getTileFactory();
        this.map.setTileFactory((TileFactory)this.tf);
        this.tf.setTileCache((TileCache)new TileCacheFile("data/TileCacheFile/"));
        this.main = new JPanel(new BorderLayout());
        this.main.add((Component)this.map, "Center");
        JPanel p2 = new JPanel((LayoutManager)new MigLayout("fillx,ins 0"));
        JPanel p3 = new JPanel((LayoutManager)new MigLayout("ins 0"));
        JPanel p = new JPanel((LayoutManager)new MigLayout(" ins 0"));
        final JLabel st = new JLabel();
        p3.add(st);
        p2.add(p3);
        p.add(new JLabel(" \u0414\u0430\u043d\u043d\u044b\u0435 \u043a\u0430\u0440\u0442\u044b "));
        JLabel l = new JLabel("<html><a href=\"http://map.trans-monitor.ru/\">Infor</a></html>");
        l.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    Desktop.getDesktop().browse(new URI("http://map.trans-monitor.ru/"));
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                e.getComponent().setCursor(Cursor.getPredefinedCursor(12));
                st.setText("<html><font size=-2>http://map.trans-monitor.ru/</font>");
            }

            @Override
            public void mouseExited(MouseEvent e) {
                super.mouseExited(e);
                st.setText("");
            }
        });
        p.add(l);
        p2.add((Component)p, "align right");
        this.main.add((Component)p2, "South");
        this.add(this.main);
        this.initMap();
    }

    protected void initMap() {
        SysProperties.reloadProperties();
        String ll = SysProperties.getProperty((String)"map.lat", null);
        this.lat = ll == null ? Double.valueOf(latc) : Double.valueOf(Double.parseDouble(ll));
        ll = SysProperties.getProperty((String)"map.lon", null);
        this.lon = ll == null ? Double.valueOf(lonc) : Double.valueOf(Double.parseDouble(ll));
        ll = SysProperties.getProperty((String)"map.zoom", null);
        Integer zoom = 5;
        if (ll != null) {
            zoom = Integer.parseInt(ll);
        }
        this.map.getMainMap().setCenterPosition(new GeoPosition(this.lat.doubleValue(), this.lon.doubleValue()));
        this.map.setZoom(zoom.intValue());
        this.rectanglePainter = new RectanglePainter();
        this.map.getMainMap().setOverlayPainter((Painter)this.rectanglePainter);
        this.map.repaint();
    }
}

