/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.route.kpmap;

import javax.swing.JComponent;
import org.jxmapviewer.JXMapViewer;
import org.postgis.Point;
import ru.blok.common.core.CurrentProxyFactory;
import ru.blok.vms.ui.mapviewer.mapviewerwithtrack.view.RoutePainter;
import ru.blok.vms.ui.route.kpmap.RoutePainterState;
import ru.infor.beanviewer.core.UIFactory;
import ru.infor.client.soap.proxy.vms.Route2CheckPointLinkWSProxy;
import ru.infor.ws.objects.vms.entities.CheckPoint;
import ru.infor.ws.objects.vms.entities.Route2CheckPointLink;
import ru.infor.ws.objects.vms.entities.ext.Route2CheckPointLinkExt;
import ru.infor.ws.objects.vms.entities.ext.RouteExt;

public class MapViewer
extends ru.blok.vms.ui.mapviewer.MapViewer {
    RoutePainterState<JXMapViewer> routePainter;
    RoutePainter<JXMapViewer> routePainter2;
    RouteExt routeExt;
    Route2CheckPointLinkWSProxy linkWSProxy = (Route2CheckPointLinkWSProxy)CurrentProxyFactory.getProxy(Route2CheckPointLink.class);

    public MapViewer(UIFactory<JComponent> factory) {
        super(factory);
    }

    @Override
    protected void init() {
        super.init();
        this.routePainter2 = new RoutePainter();
        this.painter.addPainter(this.routePainter2);
        this.routePainter = new RoutePainterState();
        this.painter.addPainter(this.routePainter);
    }

    @Override
    protected boolean canGoToData() {
        return true;
    }

    @Override
    protected Double[] getMinMax() {
        Double minLat = null;
        Double maxLat = null;
        Double minLon = null;
        Double maxLon = null;
        if (this.routePainter != null && this.routePainter.getLinks() != null) {
            for (Route2CheckPointLinkExt route2CheckPointLinkExt : this.routePainter.getLinks()) {
                if (route2CheckPointLinkExt == null || route2CheckPointLinkExt.getPoint() == null) continue;
                CheckPoint d = route2CheckPointLinkExt.getPoint();
                if (minLat == null || d.getLat() < minLat) {
                    minLat = d.getLat();
                }
                if (maxLat == null || d.getLat() > maxLat) {
                    maxLat = d.getLat();
                }
                if (minLon == null || d.getLon() < minLon) {
                    minLon = d.getLon();
                }
                if (maxLon != null && !(d.getLon() > maxLon)) continue;
                maxLon = d.getLon();
            }
        }
        if (this.routePainter2 != null && this.routePainter2.getRoutes() != null) {
            for (RouteExt routeExt : this.routePainter2.getRoutes()) {
                if (routeExt.getLineString() == null) continue;
                int i = 0;
                while (i < routeExt.getLineString().numPoints()) {
                    Point d = routeExt.getLineString().getPoint(i);
                    if (minLat == null || d.getY() < minLat) {
                        minLat = d.getY();
                    }
                    if (maxLat == null || d.getY() > maxLat) {
                        maxLat = d.getY();
                    }
                    if (minLon == null || d.getX() < minLon) {
                        minLon = d.getX();
                    }
                    if (maxLon == null || d.getX() > maxLon) {
                        maxLon = d.getX();
                    }
                    ++i;
                }
            }
        }
        if (minLat == null) {
            return null;
        }
        return new Double[]{minLat, maxLat, minLon, maxLon};
    }

    @Override
    public Object getValue() {
        return null;
    }

    @Override
    public void setValue(Object arg0) {
        this.routeExt = (RouteExt)((Object)arg0);
        if (this.routeExt != null) {
            if (this.routeExt.getDir() == 0) {
                this.routePainter.setLinks(this.routeExt.getList2());
            } else {
                this.routePainter.setLinks(this.routeExt.getList3());
            }
            this.routePainter2.setRoute(this.routeExt);
            this.zoomToTracks();
        }
    }
}

