/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.route.kpmap;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.text.SimpleDateFormat;
import java.util.List;
import org.jxmapviewer.JXMapViewer;
import org.jxmapviewer.viewer.GeoPosition;
import ru.blok.vms.ui.mapviewer.imap.IMapValue;
import ru.blok.vms.ui.mapviewer.mapviewerwithtrack.view.MapViewPainter;
import ru.infor.ws.objects.vms.entities.ext.Route2CheckPointLinkExt;

public class RoutePainterState<T extends JXMapViewer>
extends MapViewPainter<T> {
    List<Route2CheckPointLinkExt> links;
    public static final SimpleDateFormat timeFormat = new SimpleDateFormat("HH:mm:ss");

    public RoutePainterState() {
        this.setAntialiasing(true);
        this.setCacheable(false);
    }

    public List<Route2CheckPointLinkExt> getLinks() {
        return this.links;
    }

    public void setLinks(List<Route2CheckPointLinkExt> links) {
        this.links = links;
    }

    @Override
    public synchronized void doPaint(Graphics2D g, T map, int width, int height) {
        Rectangle viewportBounds = map.getViewportBounds();
        int zoom = map.getZoom();
        Dimension sizeInTiles = map.getTileFactory().getMapSize(zoom);
        int tileSize = map.getTileFactory().getTileSize(zoom);
        Dimension sizeInPixels = new Dimension(sizeInTiles.width * tileSize, sizeInTiles.height * tileSize);
        double vpx = viewportBounds.getX();
        while (vpx < 0.0) {
            vpx += sizeInPixels.getWidth();
        }
        while (vpx > sizeInPixels.getWidth()) {
            vpx -= sizeInPixels.getWidth();
        }
        Rectangle2D.Double vp2 = new Rectangle2D.Double(vpx, viewportBounds.getY(), viewportBounds.getWidth(), viewportBounds.getHeight());
        Rectangle2D.Double vp3 = new Rectangle2D.Double(vpx - sizeInPixels.getWidth(), viewportBounds.getY(), viewportBounds.getWidth(), viewportBounds.getHeight());
        for (Route2CheckPointLinkExt r : this.getLinks()) {
            this.paintLink(r, map, g, vp2, vp3);
        }
    }

    private void paintLink(Route2CheckPointLinkExt r, T map, Graphics2D g, Rectangle2D vp2, Rectangle2D vp3) {
        Point2D pointFrom;
        if (r != null && r.getPoint() != null && vp2.contains(pointFrom = map.getTileFactory().geoToPixel(new GeoPosition(r.getPoint().getLat().doubleValue(), r.getPoint().getLon().doubleValue()), map.getZoom()))) {
            int x = (int)(pointFrom.getX() - vp2.getX());
            int y = (int)(pointFrom.getY() - vp2.getY());
            g.translate(x, y);
            this.paint(r, g);
            g.translate(-x, -y);
        }
    }

    private void paint(Route2CheckPointLinkExt r, Graphics2D g) {
        g.setColor(Color.RED);
        g.fillOval(-2, -2, 2, 2);
        String[] hint = new String[]{r.getPoint().getName()};
        int l = hint.length;
        FontMetrics f = g.getFontMetrics();
        int h = f.getHeight();
        int w = 0;
        int i = 0;
        while (i < l) {
            int w1 = f.stringWidth(hint[i]);
            if (w1 > w) {
                w = w1;
            }
            ++i;
        }
        Rectangle2D.Double bounds = new Rectangle2D.Double(-w + w / 2, -h * l - 20, w + 10, h * l + 3);
        Polygon p = new Polygon();
        p.addPoint((int)bounds.getMinX(), (int)bounds.getMinY());
        p.addPoint((int)bounds.getMinX(), (int)bounds.getMaxY());
        p.addPoint((int)(bounds.getMinX() + ((RectangularShape)bounds).getWidth() / 3.0), (int)bounds.getMaxY());
        p.addPoint(0, 0);
        p.addPoint((int)(bounds.getMinX() + 2.0 * ((RectangularShape)bounds).getWidth() / 3.0), (int)bounds.getMaxY());
        p.addPoint((int)bounds.getMaxX(), (int)bounds.getMaxY());
        p.addPoint((int)bounds.getMaxX(), (int)bounds.getMinY());
        g.setColor(Color.WHITE);
        g.fillPolygon(p);
        g.setColor(Color.BLACK);
        g.drawPolygon(p);
        int i2 = 0;
        while (i2 < l) {
            g.drawString(hint[i2], (int)bounds.getMinX() + 5, (int)bounds.getMinY() + h + i2 * h);
            ++i2;
        }
    }

    @Override
    public void setValue(IMapValue mapValueWithTrack) {
    }
}

