/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.route.routegeom;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.io.WKTWriter;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.geotools.geometry.GeneralDirectPosition;
import org.geotools.geometry.jts.JTS;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.postgis.Geometry;
import org.postgis.LineString;
import org.postgis.MultiLineString;
import org.postgis.Point;
import ru.blok.common.core.InitializedVariable;
import ru.blok.vms.ui.geo.GeoUtils;
import ru.blok.vms.ui.route.routegeom.RouteGeomBuilder;
import ru.infor.beanviewer.dialog.MessageOKButton;
import ru.infor.beanviewer.dialog.WarningMessage;
import ru.infor.beanviewer.viewer.BeanViewerAction;
import ru.infor.ws.objects.vms.NavigationPoint;
import ru.infor.ws.objects.vms.entities.RouteElement;
import ru.infor.ws.objects.vms.entities.ext.RouteElementExt;

public class CreateGeomRoute {
    private static MathTransform polar2flat;
    private static MathTransform flat2polar;
    private static WKTWriter wkt;
    List<RouteElement> lists = null;
    Double widthRoute = 20.0;
    Double speed = 0.0;
    Geometry currentPolygon = null;
    MultiLineString currentLine = null;
    private static Logger logger;

    static {
        wkt = new WKTWriter();
        try {
            polar2flat = CRS.findMathTransform((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, (CoordinateReferenceSystem)CRS.decode((String)"EPSG:3857"), (boolean)true);
            flat2polar = CRS.findMathTransform((CoordinateReferenceSystem)CRS.decode((String)"EPSG:3857"), (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, (boolean)true);
        }
        catch (FactoryException e) {
            e.printStackTrace();
        }
        logger = Logger.getLogger(CreateGeomRoute.class);
    }

    public List<RouteElement> getLists() {
        return this.lists;
    }

    public Double getWidthRoute() {
        return this.widthRoute;
    }

    public void setWidthRoute(Double widthRoute) {
        this.widthRoute = widthRoute;
    }

    public Double getSpeed() {
        return this.speed;
    }

    public void setSpeed(Double speed) {
        this.speed = speed;
    }

    public Geometry getCurrentPolygon() {
        return this.currentPolygon;
    }

    public MultiLineString getCurrentLine() {
        return this.currentLine;
    }

    public void create(NavigationPoint[] points) {
        long b = System.currentTimeMillis();
        this.lists = new ArrayList<RouteElement>();
        GeometryFactory f = new GeometryFactory();
        try {
            CoordinateReferenceSystem sourceCRS = CRS.parseWKT((String)GeoUtils.wkt4326);
            CoordinateReferenceSystem targetCRS = CRS.parseWKT((String)GeoUtils.wkt3395);
            MathTransform math = CRS.findMathTransform((CoordinateReferenceSystem)sourceCRS, (CoordinateReferenceSystem)targetCRS);
            MathTransform math2 = CRS.findMathTransform((CoordinateReferenceSystem)targetCRS, (CoordinateReferenceSystem)sourceCRS);
            double speed = 0.0;
            if (this.getSpeed() != null) {
                speed = this.getSpeed();
            }
            if (this.lists.size() > 0) {
                this.lists.get(this.lists.size() - 1).setLength(Double.valueOf(0.0));
            }
            if (this.getWidthRoute() == null || this.getWidthRoute() == 0.0) {
                this.widthRoute = 20.0;
            }
            if (points != null && points.length > 0) {
                NavigationPoint p0 = points[0];
                RouteElementExt e0 = new RouteElementExt();
                e0.setLat(p0.getLat());
                e0.setLon(p0.getLon());
                e0.setType(0);
                e0.setSpeed(speed);
                this.lists.add(e0);
                GeneralDirectPosition pt1 = new GeneralDirectPosition(p0.getLon().doubleValue(), p0.getLat().doubleValue());
                DirectPosition pt2 = math.transform((DirectPosition)pt1, null);
                Coordinate c = new Coordinate(pt2.getCoordinate()[0], pt2.getCoordinate()[1]);
                com.vividsolutions.jts.geom.Point p_old = f.createPoint(c);
                Coordinate c_old = c;
                Coordinate[] cc = new Coordinate[points.length];
                Coordinate[] src = new Coordinate[points.length];
                cc[0] = c;
                src[0] = c = new Coordinate(p0.getLon().doubleValue(), p0.getLat().doubleValue());
                ArrayList<Polygon> listsP = new ArrayList<Polygon>();
                int i = 1;
                while (i < points.length) {
                    NavigationPoint p = points[i];
                    RouteElementExt e = new RouteElementExt();
                    e.setLat(p.getLat());
                    e.setLon(p.getLon());
                    e.setType(0);
                    e.setSpeed(speed);
                    src[i] = c = new Coordinate(e.getLon().doubleValue(), e.getLat().doubleValue());
                    pt1 = new GeneralDirectPosition(p.getLon().doubleValue(), p.getLat().doubleValue());
                    pt2 = math.transform((DirectPosition)pt1, null);
                    cc[i] = c = new Coordinate(pt2.getCoordinate()[0], pt2.getCoordinate()[1]);
                    com.vividsolutions.jts.geom.Point pp = f.createPoint(c);
                    this.lists.get(i - 1).setLength(Double.valueOf(p_old.distance((com.vividsolutions.jts.geom.Geometry)pp) / 1000.0 / 2.0));
                    if (this.getWidthRoute() != null && this.getWidthRoute() > 0.0) {
                        Object[] oo = RouteGeomBuilder.createPolygonByCoordinate3395(new Coordinate[]{c_old, c}, f, math2, this.getWidthRoute());
                        org.postgis.Polygon p2 = (org.postgis.Polygon)oo[0];
                        this.lists.get(i - 1).setAreaGeom(p2.toString());
                        listsP.add((Polygon)oo[1]);
                    }
                    if (this.lists.get(i - 1).getSpeed() > 0.0) {
                        double time = this.lists.get(i - 1).getLength() / this.lists.get(i - 1).getSpeed();
                        Double d = time * 60.0 * 60.0 * 1000.0;
                        this.lists.get(i - 1).setTime(Long.valueOf(d.longValue()));
                    }
                    this.lists.add(e);
                    p_old = pp;
                    c_old = c;
                    ++i;
                }
                com.vividsolutions.jts.geom.LineString s = f.createLineString(src);
                this.currentLine = new MultiLineString(new LineString[]{new LineString(s.toString())});
                this.currentLine.setSrid(4326);
                this.currentPolygon = null;
                if (this.getWidthRoute() != null && this.getWidthRoute() > 0.0) {
                    org.postgis.Polygon p1 = new org.postgis.Polygon(wkt.write(JTS.transform((com.vividsolutions.jts.geom.Geometry)JTS.transform((com.vividsolutions.jts.geom.Geometry)s, (MathTransform)polar2flat).buffer(this.getWidthRoute().doubleValue()), (MathTransform)flat2polar)));
                    this.currentPolygon = p1;
                    this.currentPolygon.setSrid(4326);
                    if (this.currentPolygon == null) {
                        InitializedVariable.factory.runMessageEx((Object)new WarningMessage("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u043e\u0441\u0442\u0440\u043e\u0435\u043d\u0438\u0438 \u043f\u043e\u043b\u0438\u0433\u043e\u043d\u0430. \u0412\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043f\u0440\u043e\u0431\u043b\u0435\u043c\u0430 \u0441\u0432\u044f\u0437\u0430\u043d\u044b \u0441 \u043f\u043e\u0440\u044f\u0434\u043a\u043e\u043c \u043f\u0440\u043e\u0445\u043e\u0436\u0434\u0435\u043d\u0438\u044f \u0442\u043e\u0447\u0435\u043a"), new BeanViewerAction[]{new MessageOKButton()});
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        logger.debug((Object)String.format("Total time of route creating %d ms", System.currentTimeMillis() - b));
    }

    public String createPolygon(String geom) {
        GeometryFactory f = new GeometryFactory();
        try {
            MultiLineString p;
            CoordinateReferenceSystem sourceCRS = CRS.parseWKT((String)GeoUtils.wkt4326);
            CoordinateReferenceSystem targetCRS = CRS.parseWKT((String)GeoUtils.wkt3395);
            MathTransform math = CRS.findMathTransform((CoordinateReferenceSystem)sourceCRS, (CoordinateReferenceSystem)targetCRS);
            MathTransform math2 = CRS.findMathTransform((CoordinateReferenceSystem)targetCRS, (CoordinateReferenceSystem)sourceCRS);
            if (this.getWidthRoute() == null || this.getWidthRoute() == 0.0) {
                this.widthRoute = 20.0;
            }
            if ((p = new MultiLineString(geom)).numPoints() > 0) {
                Coordinate[] cc = new Coordinate[p.numPoints()];
                int i = 0;
                while (i < p.numPoints()) {
                    Coordinate c;
                    Point p1 = p.getPoint(i);
                    GeneralDirectPosition pt1 = new GeneralDirectPosition(p1.getX(), p1.getY());
                    DirectPosition pt2 = math.transform((DirectPosition)pt1, null);
                    cc[i] = c = new Coordinate(pt2.getCoordinate()[0], pt2.getCoordinate()[1]);
                    ++i;
                }
                if (this.getWidthRoute() != null && this.getWidthRoute() > 0.0) {
                    Object[] oo = RouteGeomBuilder.createPolygonByCoordinate3395(cc, f, math2, this.getWidthRoute());
                    if (oo != null) {
                        this.currentPolygon = (Geometry)oo[0];
                        return this.currentPolygon.toString();
                    }
                    return null;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}

