/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.route.routegeom;

import java.util.ArrayList;
import java.util.List;
import org.postgis.Geometry;
import org.postgis.MultiLineString;
import ru.blok.vms.ui.route.routegeom.CreateGeomRoute;
import ru.blok.vms.ui.route.routegeom.RouteGeomBuilder;
import ru.blok.vms.ui.tracks.json.LoaderFromInternet;
import ru.infor.ws.objects.InvocationContext;
import ru.infor.ws.objects.vms.NavigationPoint;
import ru.infor.ws.objects.vms.RouteNavigationParam;
import ru.infor.ws.objects.vms.entities.RouteElement;

public class CreateRouteOnPoints {
    InvocationContext context;
    List<RouteElement> lists = null;
    Double speed = 0.0;
    Double width = 0.0;
    Integer defaultRadius = 50;
    Geometry currentPolygon = null;
    MultiLineString currentLine = null;

    public CreateRouteOnPoints(InvocationContext context, List<RouteElement> lists) {
        this.context = context;
        this.lists = lists;
        this.speed = 40.0;
        this.width = 20.0;
    }

    public CreateRouteOnPoints(InvocationContext context, List<RouteElement> lists, Double speed, Double width) {
        this.context = context;
        this.lists = lists;
        this.speed = speed;
        this.width = width;
    }

    public RouteWithElements createRoute() {
        ArrayList<NavigationPoint> list = new ArrayList<NavigationPoint>();
        ArrayList<RouteElement> listStat = new ArrayList<RouteElement>();
        if (this.lists != null) {
            for (RouteElement r : this.lists) {
                if (r.getType() <= 0 || r.getType() == 5 || r.getType() == 6) continue;
                NavigationPoint p = new NavigationPoint();
                p.setLat(r.getLat());
                p.setLon(r.getLon());
                list.add(p);
                listStat.add(r);
            }
        }
        NavigationPoint from = new NavigationPoint();
        from.setLat(this.lists.get(0).getLat());
        from.setLon(this.lists.get(0).getLon());
        NavigationPoint to = new NavigationPoint();
        to.setLat(this.lists.get(this.lists.size() - 1).getLat());
        to.setLon(this.lists.get(this.lists.size() - 1).getLon());
        RouteElement beginS = this.lists.get(0);
        RouteElement endS = this.lists.get(this.lists.size() - 1);
        RouteNavigationParam param = new RouteNavigationParam();
        param.setFrom(from);
        param.setTo(to);
        param.setLimitRange(null);
        param.setFintessID(Long.valueOf(1L));
        NavigationPoint[] points = LoaderFromInternet.getRouteWithPoints(this.context, param, LoaderFromInternet.MapQuest_API_KEY, list.toArray(new NavigationPoint[0]));
        CreateGeomRoute createGeomRoute = new CreateGeomRoute();
        createGeomRoute.setSpeed(this.speed);
        createGeomRoute.setWidthRoute(this.width);
        createGeomRoute.create(points);
        this.lists = createGeomRoute.getLists();
        this.currentLine = createGeomRoute.getCurrentLine();
        this.currentPolygon = createGeomRoute.getCurrentPolygon();
        this.width = createGeomRoute.getWidthRoute();
        this.speed = createGeomRoute.getSpeed();
        for (RouteElement e : listStat) {
            double d = Double.MAX_VALUE;
            int k = -1;
            int i = 0;
            while (i < this.lists.size()) {
                double dd;
                if (this.lists.get(i).getType() == 0 && (dd = Math.sqrt(Math.pow(this.lists.get(i).getLon() - e.getLon(), 2.0) + Math.pow(this.lists.get(i).getLat() - e.getLat(), 2.0))) < d) {
                    k = i;
                    d = dd;
                }
                ++i;
            }
            this.lists.add(k, e);
            if (e.getType() != 1 || e.getAreaGeom() != null) continue;
            e.setAreaGeom(RouteGeomBuilder.getDefaultPolygonStation(e, this.defaultRadius).toString());
        }
        this.lists.add(0, beginS);
        this.lists.add(endS);
        int i = 0;
        while (i < this.lists.size()) {
            this.lists.get(i).setNum(Integer.valueOf(i + 1));
            ++i;
        }
        RouteWithElements r = new RouteWithElements();
        r.setAreaRouteGeom(null);
        if (this.currentPolygon != null) {
            r.setAreaRouteGeom(this.currentPolygon.toString());
        }
        r.setRouteGeom(null);
        if (this.currentLine != null) {
            r.setRouteGeom(this.currentLine.toString());
        }
        r.setWidthRoute(this.width);
        if (r.getWidthRoute() == null || r.getWidthRoute() == 0.0) {
            r.setWidthRoute(20.0);
        }
        r.setElements(this.lists);
        return r;
    }

    public class RouteWithElements {
        private String routeGeom;
        private String areaRouteGeom;
        private Double widthRoute;
        private List<RouteElement> elements;

        public String getRouteGeom() {
            return this.routeGeom;
        }

        public void setRouteGeom(String routeGeom) {
            this.routeGeom = routeGeom;
        }

        public String getAreaRouteGeom() {
            return this.areaRouteGeom;
        }

        public void setAreaRouteGeom(String areaRouteGeom) {
            this.areaRouteGeom = areaRouteGeom;
        }

        public Double getWidthRoute() {
            return this.widthRoute;
        }

        public void setWidthRoute(Double widthRoute) {
            this.widthRoute = widthRoute;
        }

        public List<RouteElement> getElements() {
            return this.elements;
        }

        public void setElements(List<RouteElement> elements) {
            this.elements = elements;
        }
    }
}

