/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.route.routegeom;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jxmapviewer.JXMapViewer;
import org.jxmapviewer.viewer.GeoPosition;
import org.postgis.Geometry;
import org.postgis.MultiLineString;
import ru.blok.vms.ui.mapviewer.mapviewerwithtrack.view.RoutePainter;
import ru.blok.vms.ui.route.routegeom.MapValue;
import ru.blok.vms.ui.route.routegeom.RouteGeomBuilder;
import ru.infor.ws.objects.vms.entities.Route;
import ru.infor.ws.objects.vms.entities.RouteElement;
import ru.infor.ws.objects.vms.entities.VehicleFleet;

public class NewRoutePainter<T extends JXMapViewer>
extends RoutePainter<JXMapViewer> {
    private static final Logger logger = Logger.getLogger(NewRoutePainter.class);
    MultiLineString lineString;
    private static Map<Long, com.vividsolutions.jts.geom.Geometry> path_cache = new HashMap<Long, com.vividsolutions.jts.geom.Geometry>();
    private static GeometryFactory gf = new GeometryFactory();
    MapValue value;

    public MultiLineString getLineString() {
        return this.lineString;
    }

    @Override
    public void setRoute(Route route) {
        super.setRoute(route);
        if (route != null && route.getRouteGeom() != null) {
            try {
                this.lineString = new MultiLineString(route.getRouteGeom());
            }
            catch (SQLException e) {
                this.lineString = null;
                e.printStackTrace();
            }
        } else {
            this.lineString = null;
        }
    }

    @Override
    public void doPaint(Graphics2D g, JXMapViewer map, int width, int height) {
        VehicleFleet c;
        Rectangle viewportBounds = map.getViewportBounds();
        int zoom = map.getZoom();
        Dimension sizeInTiles = map.getTileFactory().getMapSize(zoom);
        int tileSize = map.getTileFactory().getTileSize(zoom);
        Dimension sizeInPixels = new Dimension(sizeInTiles.width * tileSize, sizeInTiles.height * tileSize);
        double vpx = viewportBounds.getX();
        while (vpx < 0.0) {
            vpx += sizeInPixels.getWidth();
        }
        while (vpx > sizeInPixels.getWidth()) {
            vpx -= sizeInPixels.getWidth();
        }
        Rectangle2D.Double vp2 = new Rectangle2D.Double(vpx, viewportBounds.getY(), viewportBounds.getWidth(), viewportBounds.getHeight());
        Rectangle2D.Double vp3 = new Rectangle2D.Double(vpx - sizeInPixels.getWidth(), viewportBounds.getY(), viewportBounds.getWidth(), viewportBounds.getHeight());
        if (this.value.getRouteGeomBuilder() != null && this.value.getRouteGeomBuilder().getCurrentPolygon() != null) {
            NewRoutePainter.paintPolygon(this.value.getRouteGeomBuilder().getCurrentPolygon(), map, g, (Rectangle2D)vp2, Color.RED, 50);
        }
        if (this.value != null && this.value.getRouteGeomBuilder() != null && this.value.getRouteGeomBuilder().getLists() != null && this.value.getRouteGeomBuilder().getLists().size() > 0) {
            RouteElement select = this.value.getRouteGeomBuilder().getSelect();
            List<RouteElement> lists = this.value.getRouteGeomBuilder().getLists();
            boolean pathExists = false;
            int from = 0;
            while (from < lists.size()) {
                if (lists.get(from).getType() > 0) {
                    Point2D point = map.getTileFactory().geoToPixel(new GeoPosition(lists.get(from).getLat().doubleValue(), lists.get(from).getLon().doubleValue()), map.getZoom());
                    boolean sel = select != null && select.getNum().equals(lists.get(from).getNum());
                    this.paintPoint(g, map, vp2, vp3, point, lists.get(from), sel);
                } else {
                    pathExists = true;
                }
                ++from;
            }
            if (pathExists) {
                com.vividsolutions.jts.geom.Geometry path;
                if (path_cache.containsKey(this.value.getRouteGeomBuilder().getTimestamp())) {
                    logger.debug((Object)"Path was found");
                    path = path_cache.get(this.value.getRouteGeomBuilder().getTimestamp());
                } else {
                    logger.debug((Object)"Path was not found, calculate it");
                    Coordinate[] coordinates = new Coordinate[lists.size()];
                    int i = 0;
                    while (i < lists.size()) {
                        coordinates[i] = new Coordinate(lists.get(i).getLon().doubleValue(), lists.get(i).getLat().doubleValue());
                        ++i;
                    }
                    path = gf.createLineString(coordinates);
                    path_cache.put(this.value.getRouteGeomBuilder().getTimestamp(), path);
                }
                this.paint(path, map, g, vp2, vp3, Color.RED, false);
                if (select != null) {
                    int i = 0;
                    while (i < lists.size() - 1) {
                        if (select.getNum().equals(lists.get(i).getNum()) && i != 0) {
                            LineString selected = gf.createLineString(new Coordinate[]{new Coordinate(lists.get(i).getLon().doubleValue(), lists.get(i).getLat().doubleValue()), new Coordinate(lists.get(i + 1).getLon().doubleValue(), lists.get(i + 1).getLat().doubleValue())});
                            this.paint((com.vividsolutions.jts.geom.Geometry)selected, map, g, vp2, vp3, Color.BLUE.darker(), true);
                            break;
                        }
                        ++i;
                    }
                }
            }
        }
        if (this.value.getRouteGeomBuilder() != null && this.value.getRouteGeomBuilder().getCurrentContractor() != null && (c = this.value.getRouteGeomBuilder().getCurrentContractor()).getCheckPoint() != null) {
            this.paintPark(g, map, vp2, vp3, c.getCheckPoint().getLat(), c.getCheckPoint().getLon());
        }
    }

    public void paintPark(Graphics2D g, JXMapViewer map, Rectangle2D vp2, Rectangle2D vp3, double lat, double lon) {
        Polygon p;
        int h;
        int y;
        int x;
        Point2D point = map.getTileFactory().geoToPixel(new GeoPosition(lat, lon), map.getZoom());
        if (vp2.contains(point)) {
            x = (int)(point.getX() - vp2.getX());
            y = (int)(point.getY() - vp2.getY());
            g.translate(x, y);
            h = g.getFontMetrics().getHeight();
            g.setColor(Color.WHITE);
            p = new Polygon();
            p.addPoint(0, 0);
            p.addPoint(-h / 3, -h * 2);
            p.addPoint(h / 3, -h * 2);
            g.fillPolygon(p);
            g.setColor(Color.black);
            g.drawPolygon(p);
            g.setColor(Color.WHITE);
            g.fillOval(-h, -h * 4, h * 2, h * 2);
            g.setColor(Color.black);
            g.drawOval(-h, -h * 4, h * 2, h * 2);
            g.drawString("\u041f", -h / 3, -h * 3 + 5);
            g.translate(-x, -y);
        }
        if (vp3.contains(point)) {
            x = (int)(point.getX() - vp3.getX());
            y = (int)(point.getY() - vp3.getY());
            g.translate(x, y);
            h = g.getFontMetrics().getHeight();
            g.setColor(Color.WHITE);
            p = new Polygon();
            p.addPoint(0, 0);
            p.addPoint(-h / 3, -h * 2);
            p.addPoint(h / 3, -h * 2);
            g.fillPolygon(p);
            g.setColor(Color.black);
            g.drawPolygon(p);
            g.setColor(Color.WHITE);
            g.fillOval(-h, -h * 4, h * 2, h * 2);
            g.setColor(Color.black);
            g.drawOval(-h, -h * 4, h * 2, h * 2);
            g.drawString("\u041f", -h / 3, -h * 3 + 5);
            g.translate(-x, -y);
        }
    }

    protected void paintPoint(Graphics2D g, JXMapViewer map, Rectangle2D vp2, Rectangle2D vp3, Point2D point, RouteElement element, boolean select) {
        if (element != null && element.getType() == 1) {
            Color cc = Color.RED;
            if (select) {
                cc = Color.BLUE;
            }
            if (element.getAreaGeom() != null) {
                try {
                    org.postgis.Polygon pp = new org.postgis.Polygon(element.getAreaGeom());
                    NewRoutePainter.paintPolygon((Geometry)pp, map, g, vp2, cc, 200);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            } else {
                NewRoutePainter.paintPolygon((Geometry)RouteGeomBuilder.getDefaultPolygonStation(element, RouteGeomBuilder.defaultRadius), map, g, vp2, cc, 200);
            }
        } else if (element.getType() == 2 || element.getType() == 5 || element.getType() == 6) {
            int y;
            int x;
            if (vp2.contains(point)) {
                x = (int)(point.getX() - vp2.getX());
                y = (int)(point.getY() - vp2.getY());
                g.translate(x, y);
                this.paintNode(g, map, element, select);
                g.translate(-x, -y);
            }
            if (vp3.contains(point)) {
                x = (int)(point.getX() - vp3.getX());
                y = (int)(point.getY() - vp3.getY());
                g.translate(x, y);
                this.paintNode(g, map, element, select);
                g.translate(-x, -y);
            }
        }
    }

    private boolean paintNode(Graphics2D g, JXMapViewer ma, RouteElement element, boolean select) {
        if (element.getType() > 4) {
            String text = "";
            text = element.getType() == 5 ? "\u0421\u0442\u0430\u0440\u0442" : "\u0424\u0438\u043d\u0438\u0448";
            FontMetrics metrics = g.getFontMetrics();
            int h = metrics.getHeight();
            int tw = metrics.stringWidth(text);
            Color cc = new Color(255, 255, 255, 170);
            g.setColor(cc);
            g.fillRect(-2, 4, tw + 6, h);
            if (select) {
                g.setStroke(defaultStrokeSelect);
                g.setColor(Color.BLUE);
            } else {
                g.setStroke(defaultStroke);
                g.setColor(Color.RED);
            }
            g.fillOval(-1, -1, 3, 3);
            g.drawLine(-h / 2, 0, h / 2, 0);
            g.drawLine(0, -h / 2, 0, h / 2);
            g.drawString(text, 2, h);
            return false;
        }
        if (element.getType() == 2) {
            if (!select) {
                g.setColor(Color.RED);
                g.fillOval(-3, -3, 6, 6);
            } else {
                g.setColor(Color.BLUE);
                g.fillOval(-5, -5, 10, 10);
            }
        }
        return false;
    }

    public MapValue getValue1() {
        return this.value;
    }

    public void setValue1(MapValue value) {
        this.value = value;
    }
}

