/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.route.routegeom;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import edu.emory.mathcs.backport.java.util.Arrays;
import edu.emory.mathcs.backport.java.util.Collections;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.geotools.geometry.GeneralDirectPosition;
import org.geotools.referencing.CRS;
import org.jxmapviewer.viewer.GeoPosition;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.postgis.Geometry;
import org.postgis.MultiLineString;
import org.postgis.MultiPolygon;
import ru.blok.common.core.CommonObjectWithKey;
import ru.blok.common.core.CurrentProxyFactory;
import ru.blok.common.core.InitializedVariable;
import ru.blok.common.report.RunReport;
import ru.blok.common.ui.buttons.AdderButton;
import ru.blok.common.ui.buttons.EditorButton;
import ru.blok.common.ui.buttons.RemoverButton;
import ru.blok.common.utils.CoordinatesDownTown;
import ru.blok.vms.core.ResourceStrings;
import ru.blok.vms.ui.checkpoint.CheckPointList;
import ru.blok.vms.ui.geo.GeoUtils;
import ru.blok.vms.ui.mapviewer.MapViewer;
import ru.blok.vms.ui.police.operationalinformation.Routes;
import ru.blok.vms.ui.route.RouteDirectoryViewer;
import ru.blok.vms.ui.route.routegeom.ChangeGeomElement;
import ru.blok.vms.ui.route.routegeom.ChangeSpeedPanel;
import ru.blok.vms.ui.route.routegeom.CreateGeomRoute;
import ru.blok.vms.ui.route.routegeom.EditorCheckPointInJosm;
import ru.blok.vms.ui.route.routegeom.MapValue;
import ru.blok.vms.ui.route.routegeom.MapViewerPeriods;
import ru.blok.vms.ui.route.routegeom.TimeFormatLongViewer;
import ru.blok.vms.ui.tracks.json.LoaderFromInternet;
import ru.infor.beanviewer.annotation.ActionField;
import ru.infor.beanviewer.annotation.ClassView;
import ru.infor.beanviewer.annotation.Field;
import ru.infor.beanviewer.annotation.ListField;
import ru.infor.beanviewer.annotation.ListView;
import ru.infor.beanviewer.annotation.PanelField;
import ru.infor.beanviewer.annotation.View;
import ru.infor.beanviewer.core.ActionCalculatedObject;
import ru.infor.beanviewer.core.FieldPresentation;
import ru.infor.beanviewer.core.ResourceString;
import ru.infor.beanviewer.core.UIFactory;
import ru.infor.beanviewer.core.UISetter;
import ru.infor.beanviewer.dialog.MessageOKButton;
import ru.infor.beanviewer.dialog.WarningMessage;
import ru.infor.beanviewer.swing.viewers.ListActionViewer;
import ru.infor.beanviewer.viewer.ActionButton;
import ru.infor.beanviewer.viewer.AsyncBVAWithErrorInfo;
import ru.infor.beanviewer.viewer.BeanViewerAction;
import ru.infor.beanviewer.viewer.BigContentViewer;
import ru.infor.beanviewer.viewer.action.PanelContext;
import ru.infor.beanviewer.viewer.action.ViewerContext;
import ru.infor.beanviewer.viewer.list.ListViewer;
import ru.infor.client.soap.proxy.vms.CheckPointWSProxy;
import ru.infor.client.soap.proxy.vms.Route2ColorConditionLinkWSProxy;
import ru.infor.client.soap.proxy.vms.RouteWSProxy;
import ru.infor.ws.objects.draw.entities.ColorCondition;
import ru.infor.ws.objects.vms.NavigationPoint;
import ru.infor.ws.objects.vms.Route2ColorConditionLinkSearchCriteria;
import ru.infor.ws.objects.vms.RouteElementSearchCriteria;
import ru.infor.ws.objects.vms.RouteNavigationParam;
import ru.infor.ws.objects.vms.entities.CheckPoint;
import ru.infor.ws.objects.vms.entities.Route;
import ru.infor.ws.objects.vms.entities.Route2ColorConditionLink;
import ru.infor.ws.objects.vms.entities.RouteElement;
import ru.infor.ws.objects.vms.entities.VehicleFleet;
import ru.infor.ws.objects.vms.entities.ext.Route2ColorConditionLinkExt;
import ru.infor.ws.objects.vms.entities.ext.RouteElementExt;
import ru.infor.ws.proxy.UniversalProxy;
import ru.infor.ws.proxy.interfaces.InvocationContext;

@ListView(views={@View(title="\u041f\u043e\u0441\u0442\u0440\u043e\u0438\u0442\u0435\u043b\u044c \u0433\u0435\u043e\u043c\u0435\u0442\u0440\u0438\u0438 \u043c\u0430\u0440\u0448\u0440\u0443\u0442\u0430", actions={}, layoutKeys={"tabSplitPercentLayoutManager"})})
public class RouteGeomBuilder
extends CommonObjectWithKey {
    static Logger logger = Logger.getLogger(RouteGeomBuilder.class);
    private long timestamp = System.nanoTime();
    HashMap<String, String> sp = null;
    private Route route;
    public static Integer defaultRadius = 50;
    private Double speed = 40.0;
    Double widthRoute = 20.0;
    String apiKeyForMapQuest = null;
    String transportType4CalcPathKey = null;
    MapValue value;
    public Double[] coord;
    boolean innerRoute = false;
    VehicleFleet currentContractor;
    String routeNum = "";
    String routeName = "";
    String state = "";
    private long begin;
    private long time = 0L;
    private long end = 0L;
    private Double length;
    List<RouteElement> lists = new ArrayList<RouteElement>();
    RouteElement select = null;
    static CheckPointWSProxy pointWSProxy = (CheckPointWSProxy)CurrentProxyFactory.getProxy(CheckPoint.class);
    private List<Route2ColorConditionLinkExt> listCondition = new ArrayList<Route2ColorConditionLinkExt>();
    private List<Route2ColorConditionLinkExt> listRemove = new ArrayList<Route2ColorConditionLinkExt>();
    Geometry currentPolygon = null;
    MultiLineString currentLine = null;
    private AsyncBVAWithErrorInfo<String, ViewerContext> buildRoute2 = new AsyncBVAWithErrorInfo<String, ViewerContext>((m, c) -> {
        ((PanelContext)c.getParentContext()).getPanel().updateMainObject();
        if (this.lists.size() < 2) {
            ((PanelContext)c.getParentContext()).getPanel().getFactory().runMessageEx((Object)new WarningMessage("\u041d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0434\u0432\u043e\u0439\u043d\u044b\u043c \u0449\u0435\u043b\u0447\u043a\u043e\u043c c \u043d\u0430\u0436\u0430\u0442\u044b\u043c CTRL \u043d\u0430 \u043a\u0430\u0440\u0442\u0435 \u0437\u0430\u0434\u0430\u0442\u044c \u043d\u0430\u0447\u0430\u043b\u044c\u043d\u044b\u0435 \u0438 \u043a\u043e\u043d\u0435\u0447\u043d\u044b\u0435 \u0442\u043e\u0447\u043a\u0438"), new BeanViewerAction[]{new MessageOKButton()});
        } else {
            this.buildRoute();
        }
        return "";
    }, (s, c) -> {
        ((PanelContext)c.getParentContext()).getPanel().updateUI();
        ((MapViewer)((PanelContext)c.getParentContext()).getPanel().getPresentatorForName("value").getViewer()).zoomToTracks();
        logger.debug((Object)"Route was completed");
    }, "\u041d\u0435 \u043c\u043e\u0433\u0443 \u043f\u043e\u0441\u0442\u0440\u043e\u0438\u0442\u044c \u043c\u0430\u0440\u0448\u0440\u0443\u0442"){

        public String getIcon() {
            return ResourceStrings.btBuildRoute;
        }

        public String getHint() {
            return "\u041f\u043e\u0441\u0442\u0440\u043e\u0438\u0442\u044c \u043c\u0430\u0440\u0448\u0440\u0443\u0442";
        }
    };
    private AsyncBVAWithErrorInfo<String, ViewerContext> buildRoute3 = new AsyncBVAWithErrorInfo<String, ViewerContext>((m, c) -> {
        ((PanelContext)c.getParentContext()).getPanel().updateMainObject();
        if (this.lists.size() < 2) {
            ((PanelContext)c.getParentContext()).getPanel().getFactory().runMessageEx((Object)new WarningMessage("\u041d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0434\u0432\u043e\u0439\u043d\u044b\u043c \u0449\u0435\u043b\u0447\u043a\u043e\u043c c \u043d\u0430\u0436\u0430\u0442\u044b\u043c CTRL \u043d\u0430 \u043a\u0430\u0440\u0442\u0435 \u0437\u0430\u0434\u0430\u0442\u044c \u043d\u0430\u0447\u0430\u043b\u044c\u043d\u044b\u0435 \u0438 \u043a\u043e\u043d\u0435\u0447\u043d\u044b\u0435 \u0442\u043e\u0447\u043a\u0438"), new BeanViewerAction[]{new MessageOKButton()});
        } else {
            this.buildRoute2();
        }
        return "";
    }, (s, c) -> {
        ((PanelContext)c.getParentContext()).getPanel().updateUI();
        ((MapViewer)((PanelContext)c.getParentContext()).getPanel().getPresentatorForName("value").getViewer()).zoomToTracks();
        logger.debug((Object)"Route was completed");
    }, "\u041d\u0435 \u043c\u043e\u0433\u0443 \u043f\u043e\u0441\u0442\u0440\u043e\u0438\u0442\u044c \u043c\u0430\u0440\u0448\u0440\u0443\u0442"){

        public String getIcon() {
            return ResourceStrings.btBuildPoint;
        }

        public String getHint() {
            return "\u041f\u043e\u0441\u0442\u0440\u043e\u0438\u0442\u044c \u043c\u0430\u0440\u0448\u0440\u0443\u0442 \u0447\u0435\u0440\u0435\u0437 \u0442\u043e\u0447\u043a\u0438 \u043f\u0440\u043e\u0445\u043e\u0436\u0434\u0435\u043d\u0438\u044f";
        }
    };
    RouteWSProxy proxy = (RouteWSProxy)CurrentProxyFactory.getProxy(Route.class);
    Route2ColorConditionLinkWSProxy conditionLinkWSProxy = (Route2ColorConditionLinkWSProxy)CurrentProxyFactory.getProxy(Route2ColorConditionLink.class);
    UniversalProxy condProxy = CurrentProxyFactory.getProxy(ColorCondition.class);
    private BeanViewerAction<ViewerContext> loadDateRoute = new BeanViewerAction<ViewerContext>(){

        public String getName() {
            return "\u041f\u0440\u043e\u0447\u0438\u0442\u0430\u0442\u044c \u0433\u0435\u043e\u043c\u0435\u0442\u0440\u0438\u044e \u043c\u0430\u0440\u0448\u0440\u0443\u0442\u0430";
        }

        public void actionPerformed(Object message) {
            ((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getPanel().updateMainObject();
            if (RouteGeomBuilder.this.route == null) {
                InitializedVariable.factory.runMessageEx((Object)new WarningMessage("\u041d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0432\u044b\u0431\u0440\u0430\u0442\u044c \u043c\u0430\u0440\u0448\u0440\u0443\u0442"), new BeanViewerAction[]{new MessageOKButton()});
                return;
            }
            RouteGeomBuilder.this.route = RouteGeomBuilder.this.proxy.getCurrentObject(InitializedVariable.context, RouteGeomBuilder.this.route.getId());
            RouteGeomBuilder.this.loadR();
            ((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getPanel().updateUI();
        }
    };
    private BeanViewerAction<ViewerContext> saveDateRoute = new AsyncBVAWithErrorInfo<String, ViewerContext>((o, c) -> {
        ((PanelContext)c.getParentContext()).getPanel().updateMainObject();
        if (this.route == null) {
            if (this.getRouteName() == null || "".equals(this.getRouteName()) || this.getRouteNum() == null || "".equals(this.getRouteNum())) {
                throw new Error();
            }
            Route r = new Route();
            r.setName(this.routeName);
            r.setNum(this.routeNum);
            this.route = this.proxy.save(InitializedVariable.context, r);
        }
        this.route.setAreaRouteGeom(null);
        if (this.currentPolygon != null) {
            this.route.setAreaRouteGeom(this.currentPolygon.toString());
        }
        this.route.setRouteGeom(null);
        if (this.currentLine != null) {
            this.route.setRouteGeom(this.currentLine.toString());
        }
        this.route.setWidthRoute(this.getWidthRoute());
        if (this.route.getWidthRoute() == null || this.route.getWidthRoute() == 0.0) {
            this.route.setWidthRoute(Double.valueOf(20.0));
            this.widthRoute = 20.0;
        }
        this.proxy.saveRouteElements(InitializedVariable.context, this.route, this.lists.toArray(new RouteElement[0]));
        for (Route2ColorConditionLinkExt l : this.listRemove) {
            if (l.getCondition().getId() != null) {
                this.condProxy._universalDelete((InvocationContext)InitializedVariable.context, l.getCondition().getId());
            }
            if (l.getId() == null) continue;
            this.conditionLinkWSProxy.delete(InitializedVariable.context, l.getId());
        }
        for (Route2ColorConditionLinkExt l : this.listCondition) {
            ColorCondition cc = (ColorCondition)this.condProxy._universalSave((InvocationContext)InitializedVariable.context, (Object)l.getCondition());
            l.setCondition(cc);
            l.setRoute(this.route);
            this.conditionLinkWSProxy.save(InitializedVariable.context, (Route2ColorConditionLink)l);
        }
        return "";
    }, (s, c) -> {
        ((PanelContext)c.getParentContext()).getPanel().updateUI();
        ((PanelContext)c.getParentContext()).getPanel().getPresentatorForName("routeNum").getViewer().setEditable(false);
        ((PanelContext)c.getParentContext()).getPanel().getPresentatorForName("routeName").getViewer().setEditable(false);
    }, "\u041e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u044f \u043c\u0430\u0440\u0448\u0440\u0443\u0442\u0430"){

        public String getHint() {
            return "\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u0433\u0435\u043e\u043c\u0435\u0442\u0440\u0438\u044e \u043c\u0430\u0440\u0448\u0440\u0443\u0442\u0430";
        }

        public String getIcon() {
            return ResourceString.btSavetoDBImage;
        }
    };
    private BeanViewerAction<ViewerContext> clearDataRoute = new BeanViewerAction<ViewerContext>(){

        public String getHint() {
            return "\u041e\u0447\u0438\u0441\u0442\u0438\u0442\u044c \u0433\u0435\u043e\u043c\u0435\u0442\u0440\u0438\u044e \u043c\u0430\u0440\u0448\u0440\u0443\u0442\u0430";
        }

        public String getIcon() {
            return ResourceString.btCross;
        }

        public void actionPerformed(Object message) {
            ((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getPanel().updateMainObject();
            ((RouteGeomBuilder)((Object)((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getPanel().getObject())).clearData();
            ((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getPanel().updateUI();
        }
    };
    private BeanViewerAction<ViewerContext> clearDataRoutePath = new BeanViewerAction<ViewerContext>(){

        public String getHint() {
            return "\u041e\u0447\u0438\u0441\u0442\u0438\u0442\u044c \u0442\u043e\u043b\u044c\u043a\u043e \u043e\u0442\u0440\u0435\u0437\u043a\u0438 \u043c\u0430\u0440\u0448\u0440\u0443\u0442\u0430";
        }

        public String getIcon() {
            return ResourceStrings.btRemoveRoute;
        }

        public void actionPerformed(Object message) {
            ((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getPanel().updateMainObject();
            ArrayList<RouteElement> listDel = new ArrayList<RouteElement>();
            for (RouteElement r : RouteGeomBuilder.this.lists) {
                if (r.getType() != 0) continue;
                listDel.add(r);
            }
            for (RouteElement r : listDel) {
                RouteGeomBuilder.this.lists.remove(r);
            }
            RouteGeomBuilder.this.timestamp = System.nanoTime();
            RouteGeomBuilder.this.calcCommonTime();
            RouteGeomBuilder.this.currentPolygon = null;
            RouteGeomBuilder.this.currentLine = null;
            int i = 0;
            while (i < RouteGeomBuilder.this.lists.size()) {
                RouteGeomBuilder.this.lists.get(i).setNum(Integer.valueOf(i + 1));
                ++i;
            }
            ((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getPanel().updateUI();
        }
    };
    List<BeanViewerAction<ViewerContext>> listEasyBt = new ArrayList<BeanViewerAction<ViewerContext>>();

    public long getTimestamp() {
        return this.timestamp;
    }

    public void updUI(UISetter<?> panel) {
        panel.updateUIForPresentatorName("routeNum");
        panel.updateUIForPresentatorName("routeName");
    }

    public void beforeShow(PanelContext pc) {
        pc.getPanel().getPresentatorForName("routeNum").getViewer().setEditable(true);
        pc.getPanel().getPresentatorForName("routeName").getViewer().setEditable(true);
    }

    public RouteGeomBuilder(String keyPage) {
        super(keyPage);
        if (InitializedVariable.getWorkplaceId((String)keyPage) != null) {
            String s2;
            this.sp = InitializedVariable.runtimeParameters((Long)InitializedVariable.getWorkplaceId((String)keyPage));
            if (this.sp.get("DefaultRadiusStation") != null) {
                defaultRadius = Integer.parseInt(this.sp.get("DefaultRadiusStation"));
            }
            if (this.sp.get("DefaultSpeedRoute") != null) {
                this.speed = Double.parseDouble(this.sp.get("DefaultSpeedRoute"));
            }
            if (this.sp.get("DefaultWidthRoute") != null) {
                this.widthRoute = Double.parseDouble(this.sp.get("DefaultWidthRoute"));
            }
            if (this.sp.get("ApiKeyForMapQuest") != null) {
                this.apiKeyForMapQuest = this.sp.get("ApiKeyForMapQuest");
            }
            if (this.sp.get("TransportType4CalcPathKey") != null) {
                this.transportType4CalcPathKey = this.sp.get("TransportType4CalcPathKey");
            }
            if (this.sp.get("InnerRoute") != null && ("1".equals(s2 = this.sp.get("InnerRoute")) || "true".equals(s2))) {
                this.innerRoute = true;
            }
            this.coord = CoordinatesDownTown.getCoordinatesDownTown(this.sp);
        } else {
            this.coord = CoordinatesDownTown.getCoordinatesDownTown((Long)InitializedVariable.getWorkplaceId((String)keyPage));
        }
        this.value = new MapValue(this.coord[0], this.coord[1], this.coord[2].intValue());
        this.value.setRouteGeomBuilder(this);
        this.addListEasyBt((BeanViewerAction<ViewerContext>)new RunReport());
    }

    @ListField(fields={@Field(title="\u041c\u0430\u0440\u0448\u0440\u0443\u0442", order=100, viewer={RouteDirectoryViewer.class}, propertiesLayout="Split1/h/l/0.3:0/wrap 1, fillx:m1/wrap 4/\u041c\u0430\u0440\u0448\u0440\u0443\u0442/growx#w 300, spanx 3", changeAction={ChangeRouter.class})})
    public Route getRoute() {
        return this.route;
    }

    public VehicleFleet getCurrentContractor() {
        return this.currentContractor;
    }

    public void setRoute(Route route) {
        if (route == null && this.route != null || route != null && this.route == null || route != null && !route.equals((Object)this.route)) {
            this.clearData();
            this.route = route;
            if (route != null) {
                this.setRouteNum(route.getNum());
                this.setRouteName(route.getName());
                if (route.getCoordination() != null && route.getCoordination() == 1) {
                    this.setState("\u0421\u043e\u0433\u043b\u0430\u0441\u043e\u0432\u0430\u043d");
                } else {
                    this.setState("\u041d\u0435 \u0441\u043e\u0433\u043b\u0430\u0441\u043e\u0432\u0430\u043d");
                }
                this.currentContractor = route.getFleet();
            } else {
                this.setRouteNum("");
                this.setRouteName("");
                this.setState("");
                this.currentContractor = null;
            }
        }
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public void setRouteNum(String routeNum) {
        this.routeNum = routeNum;
    }

    public void setRouteName(String routeName) {
        this.routeName = routeName;
    }

    @ListField(fields={@Field(title="\u041d\u043e\u043c\u0435\u0440", order=200, propertiesLayout="Split1/h/l/0.3:0:m1")})
    public String getRouteNum() {
        return this.routeNum;
    }

    @ListField(fields={@Field(title="\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", order=400, propertiesLayout="Split1/h/l/0.3:0:m1# spanx 3")})
    public String getRouteName() {
        return this.routeName;
    }

    @ListField(fields={@Field(title="", order=1000, propertiesLayout="Split1/h/r/0.3", viewer={MapViewerPeriods.class})})
    public MapValue getValue() {
        return this.value;
    }

    public void setValue(MapValue value) {
    }

    @ListField(fields={@Field(title="\u0421\u043a\u043e\u0440\u043e\u0441\u0442\u044c", order=900, propertiesLayout="Split1/h/l/0.3:0:m2/wrap 4//growx")})
    public Double getSpeed() {
        return this.speed;
    }

    public void setSpeed(Double speed) {
        this.speed = speed;
    }

    public void UpdateUIForCommon(PanelContext pc) {
        pc.getPanel().updateUIForPresentatorName("end");
        pc.getPanel().updateUIForPresentatorName("time");
        pc.getPanel().updateUIForPresentatorName("length");
        pc.getPanel().updateUIForPresentatorName("speed");
    }

    @ListField(fields={@Field(title="\u041d\u0430\u0447\u0430\u043b\u043e", order=950, propertiesLayout="Split1/h/l/0.3:0:m2", viewer={TimeFormatLongViewer.class}, changeAction={ChangeBegin.class})})
    public long getBegin() {
        return this.begin;
    }

    public void setBegin(long begin) {
        this.begin = begin;
    }

    @ListField(fields={@Field(title="\u041f\u0440\u043e\u0434-\u0442\u044c", order=950, readOnly=true, propertiesLayout="Split1/h/l/0.3:0:m2", viewer={TimeFormatLongViewer.class})})
    public long getTime() {
        return this.time;
    }

    public void setTime(long time) {
        this.time = time;
    }

    @ListField(fields={@Field(title="\u041e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u0435", order=950, readOnly=true, propertiesLayout="Split1/h/l/0.3:0:m2", viewer={TimeFormatLongViewer.class})})
    public long getEnd() {
        return this.end;
    }

    public void setEnd(long end) {
        this.end = end;
    }

    @ListField(fields={@Field(title="\u041e\u0431\u0449\u0430\u044f \u0434\u043b\u0438\u043d\u0430 \u043f\u0443\u0442\u0438 (\u043a\u043c)", order=970, readOnly=true, propertiesLayout="Split1/h/l/0.3:0:m2#spanx 2#spanx 2")})
    public String getLength() {
        if (this.length == null) {
            return "";
        }
        return RouteElementExt.convertSpeedToString(this.length);
    }

    @ListField(fields={@Field(title="\u0428\u0438\u0440\u0438\u043d\u0430 \u0432\u043e\u043a\u0440\u0443\u0433 \u043c\u0430\u0440\u0448\u0440\u0443\u0442\u0430, \u043c", order=980, propertiesLayout="Split1/h/l/0.3:0:m2#spanx 2#spanx 2")})
    public Double getWidthRoute() {
        return this.widthRoute;
    }

    public void setWidthRoute(Double widthRoute) {
        this.widthRoute = widthRoute;
    }

    public RouteElement getSelect() {
        return this.select;
    }

    public void setSelect(RouteElement select) {
        this.select = select;
    }

    public void setSelect(RouteElement select, PanelContext pc) {
        this.setSelect(select);
        if (select != null) {
            ((MapViewer)pc.getPanel().getPresentatorForName("value").getViewer()).setCenterPosition(new double[]{select.getLat(), select.getLon()});
        } else {
            ((MapViewer)pc.getPanel().getPresentatorForName("value").getViewer()).repaint();
        }
    }

    public static void findKT(RouteElementExt r) {
        if (r.getCheckpoint_id() == null) {
            r.setNameKT("");
            r.setCurrent(null);
        } else {
            CheckPoint p = pointWSProxy.getCurrentObject(InitializedVariable.context, r.getCheckpoint_id());
            r.setNameKT(p.getName());
            r.setCurrent(p);
        }
    }

    public void moveUp(PanelContext pc) {
        if (this.select != null && (this.select.getType() == 1 || this.select.getType() == 2)) {
            int k = this.lists.indexOf(this.select);
            if (k > 0) {
                this.select.setNum(Integer.valueOf(k));
                this.lists.get(k - 1).setNum(Integer.valueOf(k + 1));
                this.lists.set(k, this.lists.get(k - 1));
                this.lists.set(k - 1, this.select);
            }
            pc.getPanel().updateUIForPresentatorName("lists");
            ((ListViewerT)pc.getPanel().getPresentatorForName("lists").getViewer()).getTM().setSelectedRows(new int[]{k - 1});
        }
    }

    public void moveDown(PanelContext pc) {
        if (this.select != null && (this.select.getType() == 1 || this.select.getType() == 2)) {
            int k = this.lists.indexOf(this.select);
            if (k < this.lists.size() - 1) {
                this.select.setNum(Integer.valueOf(k + 2));
                this.lists.get(k + 1).setNum(Integer.valueOf(k + 1));
                this.lists.set(k, this.lists.get(k + 1));
                this.lists.set(k + 1, this.select);
            }
            pc.getPanel().updateUIForPresentatorName("lists");
            ((ListViewerT)pc.getPanel().getPresentatorForName("lists").getViewer()).getTM().setSelectedRows(new int[]{k + 1});
        }
    }

    @ListField(fields={@Field(title="", order=1200, content=Route2ColorConditionLinkExt.class, propertiesLayout="Split1/h/l/0.3:0:Tab1/\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0438 \u0446\u0432\u0435\u0442\u0430 \u043e\u0442 \u0441\u043a\u043e\u0440\u043e\u0441\u0442\u0438:m3/wrap 1,fillx//growx", viewer={ListViewer.class}, panels={@PanelField(actions={@ActionField(clazz=AdderButton.class), @ActionField(clazz=EditorButton.class), @ActionField(clazz=RemoverButton.class)})})})
    public List<Route2ColorConditionLinkExt> getListCondition() {
        return this.listCondition;
    }

    public void setListCondition(List<Route2ColorConditionLinkExt> listCondition) {
        this.listCondition = listCondition;
    }

    public Route2ColorConditionLinkExt createListCondition() {
        Route2ColorConditionLinkExt e = new Route2ColorConditionLinkExt();
        e.setCondition(new ColorCondition());
        return e;
    }

    public void removeListCondition(Route2ColorConditionLinkExt e) {
        this.listRemove.add(e);
    }

    @ListField(fields={@Field(title="", order=1100, content=RouteElementExt.class, propertiesLayout="Split1/h/l/0.3:0:Tab1/\u0423\u0447\u0430\u0441\u0442\u043a\u0438 \u043c\u0430\u0440\u0448\u0440\u0443\u0442\u0430:m3/wrap 1,fillx//growx", viewer={ListViewerT.class}, panels={@PanelField(actions={@ActionField(clazz=AdderStateFromList.class), @ActionField(clazz=Editor.class), @ActionField(clazz=EditorCheckPointInJosm.class), @ActionField(clazz=BeanViewerAction.Remover.class), @ActionField(clazz=Up.class), @ActionField(clazz=Down.class)}, classView={@ClassView(clazz=ChangeSpeedPanel.class, name="\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0430 \u0441\u043a\u043e\u0440\u043e\u0441\u0442\u0438", order=1000), @ClassView(clazz=ChangeGeomElement.class, name="\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0430 \u0433\u0435\u043e\u043c\u0435\u0442\u0440\u0438\u0438", order=1010)})})})
    public List<RouteElement> getLists() {
        return this.lists;
    }

    public void removeLists(RouteElement e) {
        int k;
        int i = k = this.lists.indexOf(e) + 1;
        while (i < this.lists.size()) {
            this.lists.get(i).setNum(Integer.valueOf(i));
            ++i;
        }
        this.calcCommonTime();
        this.UpdateUIForCommon((PanelContext)((ViewerContext)this.getBuildRoute2().getContext()).getParentContext());
    }

    public static org.postgis.Polygon getDefaultPolygonStation(RouteElement e, int r) {
        return RouteGeomBuilder.getDefaultPolygonStation(e.getLat(), e.getLon(), r);
    }

    public static org.postgis.Polygon getDefaultPolygonStation(double lat, double lon, int r) {
        GeometryFactory f = new GeometryFactory();
        org.postgis.Polygon p3 = null;
        try {
            CoordinateReferenceSystem sourceCRS = CRS.parseWKT((String)GeoUtils.wkt4326);
            CoordinateReferenceSystem targetCRS = CRS.parseWKT((String)GeoUtils.wkt3395);
            MathTransform math = CRS.findMathTransform((CoordinateReferenceSystem)sourceCRS, (CoordinateReferenceSystem)targetCRS);
            GeneralDirectPosition pt1 = new GeneralDirectPosition(lon, lat);
            DirectPosition pt2 = math.transform((DirectPosition)pt1, null);
            Coordinate c = new Coordinate(pt2.getCoordinate()[0], pt2.getCoordinate()[1]);
            Point pp = f.createPoint(c);
            com.vividsolutions.jts.geom.Geometry buffer = pp.buffer((double)r);
            MathTransform math2 = CRS.findMathTransform((CoordinateReferenceSystem)targetCRS, (CoordinateReferenceSystem)sourceCRS);
            if (buffer instanceof Polygon) {
                Polygon p = (Polygon)buffer;
                Coordinate[] cc1 = new Coordinate[p.getCoordinates().length];
                int i = 0;
                while (i < p.getCoordinates().length) {
                    c = p.getCoordinates()[i];
                    pt1 = new GeneralDirectPosition(c.x, c.y);
                    pt2 = math2.transform((DirectPosition)pt1, null);
                    cc1[i] = new Coordinate(pt2.getCoordinate()[0], pt2.getCoordinate()[1]);
                    ++i;
                }
                Polygon p2 = f.createPolygon(f.createLinearRing(cc1), null);
                p3 = new org.postgis.Polygon(p2.toString());
                p3.setSrid(4326);
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        return p3;
    }

    public static Object[] createPolygonByCoordinate3395(Coordinate[] cc, GeometryFactory f, MathTransform math2, Double width) throws MismatchedDimensionException, TransformException {
        LineString s = f.createLineString(cc);
        com.vividsolutions.jts.geom.Geometry buffer = s.buffer(width.doubleValue());
        if (buffer instanceof Polygon) {
            Polygon p = (Polygon)buffer;
            Coordinate[] cc1 = new Coordinate[p.getCoordinates().length + 1];
            int i = 0;
            while (i < p.getCoordinates().length) {
                Coordinate c = p.getCoordinates()[i];
                GeneralDirectPosition pt1 = new GeneralDirectPosition(c.x, c.y);
                DirectPosition pt2 = math2.transform((DirectPosition)pt1, null);
                cc1[i] = new Coordinate(pt2.getCoordinate()[0], pt2.getCoordinate()[1]);
                ++i;
            }
            cc1[cc1.length - 1] = cc1[0];
            try {
                Polygon p2 = f.createPolygon(f.createLinearRing(cc1), null);
                org.postgis.Polygon currentPolygon = new org.postgis.Polygon(p2.toString());
                currentPolygon.setSrid(4326);
                return new Object[]{currentPolygon, p2};
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        return null;
    }

    public void buildRoute() {
        ArrayList<NavigationPoint> list = new ArrayList<NavigationPoint>();
        ArrayList<RouteElement> listStat = new ArrayList<RouteElement>();
        if (this.lists != null) {
            for (RouteElement r : this.lists) {
                if (r.getType() <= 0 || r.getType() == 5 || r.getType() == 6) continue;
                NavigationPoint p = new NavigationPoint();
                p.setLat(r.getLat());
                p.setLon(r.getLon());
                list.add(p);
                listStat.add(r);
            }
        }
        this.value.setRouteGeomMap(null);
        RouteElement beginS = this.lists.get(0);
        RouteElement endS = this.lists.get(this.lists.size() - 1);
        NavigationPoint[] points = null;
        if (this.innerRoute) {
            ArrayList rez = new ArrayList();
            int i = 0;
            while (i < this.lists.size() - 1) {
                GeoPosition from = new GeoPosition(this.lists.get(i).getLat().doubleValue(), this.lists.get(i).getLon().doubleValue());
                GeoPosition to = new GeoPosition(this.lists.get(i + 1).getLat().doubleValue(), this.lists.get(i + 1).getLon().doubleValue());
                Object[] point = Routes.caclPath(from, to, this.innerRoute, this.transportType4CalcPathKey);
                rez.addAll(Arrays.asList((Object[])point));
                ++i;
            }
            points = rez.toArray(new NavigationPoint[rez.size()]);
        } else {
            NavigationPoint from = new NavigationPoint();
            from.setLat(this.lists.get(0).getLat());
            from.setLon(this.lists.get(0).getLon());
            NavigationPoint to = new NavigationPoint();
            to.setLat(this.lists.get(this.lists.size() - 1).getLat());
            to.setLon(this.lists.get(this.lists.size() - 1).getLon());
            RouteNavigationParam param = new RouteNavigationParam();
            param.setFrom(from);
            param.setTo(to);
            param.setLimitRange(null);
            param.setFintessID(Long.valueOf(1L));
            if (this.apiKeyForMapQuest == null) {
                this.apiKeyForMapQuest = LoaderFromInternet.MapQuest_API_KEY;
            }
            points = LoaderFromInternet.getRouteWithPoints(InitializedVariable.context, param, this.apiKeyForMapQuest, list.toArray(new NavigationPoint[0]));
        }
        CreateGeomRoute createGeomRoute = new CreateGeomRoute();
        createGeomRoute.setSpeed(this.getSpeed());
        createGeomRoute.setWidthRoute(this.getWidthRoute());
        createGeomRoute.create(points);
        this.lists = createGeomRoute.getLists();
        this.timestamp = System.currentTimeMillis();
        this.currentLine = createGeomRoute.getCurrentLine();
        this.currentPolygon = createGeomRoute.getCurrentPolygon();
        this.widthRoute = createGeomRoute.getWidthRoute();
        this.speed = createGeomRoute.getSpeed();
        for (RouteElement e : listStat) {
            double d = Double.MAX_VALUE;
            int k = -1;
            int i = 0;
            while (i < this.lists.size()) {
                double dd;
                if (this.lists.get(i).getType() == 0 && (dd = Math.sqrt(Math.pow(this.lists.get(i).getLon() - e.getLon(), 2.0) + Math.pow(this.lists.get(i).getLat() - e.getLat(), 2.0))) < d) {
                    k = i;
                    d = dd;
                }
                ++i;
            }
            this.lists.add(k, e);
            if (e.getType() != 1 || e.getAreaGeom() != null) continue;
            e.setAreaGeom(RouteGeomBuilder.getDefaultPolygonStation(e, defaultRadius).toString());
        }
        this.lists.add(0, beginS);
        this.lists.add(endS);
        int i = 0;
        while (i < this.lists.size()) {
            this.lists.get(i).setNum(Integer.valueOf(i + 1));
            ++i;
        }
        this.calcCommonTime();
    }

    public void buildRoute2() {
        ArrayList<NavigationPoint> list = new ArrayList<NavigationPoint>();
        ArrayList<RouteElement> listStat = new ArrayList<RouteElement>();
        if (this.lists != null) {
            for (RouteElement r : this.lists) {
                if (r.getType() <= 0) continue;
                NavigationPoint p = new NavigationPoint();
                p.setLat(r.getLat());
                p.setLon(r.getLon());
                list.add(p);
                listStat.add(r);
            }
        }
        this.value.setRouteGeomMap(null);
        RouteElement beginS = this.lists.get(0);
        RouteElement endS = this.lists.get(this.lists.size() - 1);
        NavigationPoint[] points = list.toArray(new NavigationPoint[list.size()]);
        CreateGeomRoute createGeomRoute = new CreateGeomRoute();
        createGeomRoute.setSpeed(this.getSpeed());
        createGeomRoute.setWidthRoute(this.getWidthRoute());
        createGeomRoute.create(points);
        this.lists = createGeomRoute.getLists();
        this.timestamp = System.currentTimeMillis();
        this.currentLine = createGeomRoute.getCurrentLine();
        this.currentPolygon = createGeomRoute.getCurrentPolygon();
        this.widthRoute = createGeomRoute.getWidthRoute();
        this.speed = createGeomRoute.getSpeed();
        for (RouteElement e : listStat) {
            double d = Double.MAX_VALUE;
            int k = -1;
            int i = 0;
            while (i < this.lists.size()) {
                double dd;
                if (this.lists.get(i).getType() == 0 && (dd = Math.sqrt(Math.pow(this.lists.get(i).getLon() - e.getLon(), 2.0) + Math.pow(this.lists.get(i).getLat() - e.getLat(), 2.0))) < d) {
                    k = i;
                    d = dd;
                }
                ++i;
            }
            this.lists.add(k, e);
            if (e.getType() != 1 || e.getAreaGeom() != null) continue;
            e.setAreaGeom(RouteGeomBuilder.getDefaultPolygonStation(e, defaultRadius).toString());
        }
        this.lists.add(0, beginS);
        this.lists.add(endS);
        int i = 0;
        while (i < this.lists.size()) {
            this.lists.get(i).setNum(Integer.valueOf(i + 1));
            ++i;
        }
        this.calcCommonTime();
    }

    public Geometry getCurrentPolygon() {
        return this.currentPolygon;
    }

    public void setCurrentPolygon(Geometry currentPolygon) {
        this.currentPolygon = currentPolygon;
    }

    public void calcCommonTime() {
        Long l = 0L;
        this.length = 0.0;
        double speed = 0.0;
        int k = 0;
        if (this.lists != null) {
            for (RouteElement e : this.lists) {
                if (e.getTime() != null) {
                    l = l + e.getTime();
                }
                if (e.getLength() != null) {
                    this.length = this.length + e.getLength();
                }
                if (e.getType() != 0 || e.getSpeed() == null) continue;
                speed += e.getSpeed().doubleValue();
                ++k;
            }
        }
        this.time = l;
        this.end = this.begin + this.time;
        if (this.speed == null && k > 0) {
            this.speed = (double)Math.round(speed / (double)k * 100.0) / 100.0;
        }
    }

    public void addState(GeoPosition gp, PanelContext pc, boolean ost, CheckPoint p) {
        if (this.lists == null) {
            this.lists = new ArrayList<RouteElement>();
        }
        RouteElementExt e = new RouteElementExt();
        e.setLat(gp.getLatitude());
        e.setLon(gp.getLongitude());
        e.setType(ost ? 1 : 2);
        if (ost) {
            e.setAreaGeom(RouteGeomBuilder.getDefaultPolygonStation(e, defaultRadius).toString());
        }
        if (p != null) {
            e.setCheckpoint_id(p.getId());
            e.setAreaGeom(p.getGeom());
        }
        int k = this.lists.size();
        if (this.select == null) {
            if (k == this.lists.size() && this.lists.size() > 0 && this.lists.get(k - 1).getType() == 6) {
                --k;
            }
            e.setNum(k + 1);
        } else {
            k = this.lists.indexOf(this.select) + 1;
            if (k == this.lists.size() && this.lists.get(k - 1).getType() == 6) {
                --k;
            }
            e.setNum(k + 1);
            int i = k;
            while (i < this.lists.size()) {
                this.lists.get(i).setNum(Integer.valueOf(i + 2));
                ++i;
            }
        }
        this.lists.add(k, e);
        pc.getPanel().updateUIForPresentatorName("lists");
        ((ListViewerT)pc.getPanel().getPresentatorForName("lists").getViewer()).getTM().setSelectedRows(new int[]{k});
    }

    @ListField(fields={@Field(title="", order=1050, propertiesLayout="Split1/h/l/0.3:0:m4/fillx//growx", viewer={ActionButton.class})})
    public BeanViewerAction<ViewerContext> getBuildRoute2() {
        return this.buildRoute2;
    }

    @ListField(fields={@Field(title="", order=1051, propertiesLayout="Split1/h/l/0.3:0:m4/fillx//growx", viewer={ActionButton.class})})
    public BeanViewerAction<ViewerContext> getBuildRoute3() {
        return this.buildRoute3;
    }

    public void loadR() {
        RouteElementSearchCriteria sc = new RouteElementSearchCriteria();
        sc.setCount(Integer.valueOf(Integer.MAX_VALUE));
        sc.setRouteIdList(new Long[]{this.route.getId()});
        RouteElement[] rr = this.proxy.getRouteElements(InitializedVariable.context, sc);
        this.lists = new ArrayList<RouteElement>();
        RouteElement[] routeElementArray = rr;
        int n = rr.length;
        int n2 = 0;
        while (n2 < n) {
            RouteElement e = routeElementArray[n2];
            this.lists.add(e);
            ++n2;
        }
        Collections.sort(this.lists);
        if (this.lists.size() > 0) {
            int k;
            if (this.lists.get(0).getType() != 5) {
                this.lists.get(0).setType(Integer.valueOf(5));
                this.lists.get(0).setTime(Long.valueOf(0L));
            }
            if (this.lists.get(k = this.lists.size() - 1).getType() != 6) {
                this.lists.get(k).setType(Integer.valueOf(6));
                this.lists.get(k).setTime(Long.valueOf(0L));
            }
        }
        this.calcCommonTime();
        this.setWidthRoute(this.route.getWidthRoute());
        this.currentPolygon = null;
        this.currentLine = null;
        try {
            if (this.route.getRouteGeom() != null && !"".equals(this.route.getRouteGeom())) {
                this.currentLine = new MultiLineString(this.route.getRouteGeom());
            }
            if (this.route.getAreaRouteGeom() != null && !"".equals(this.route.getAreaRouteGeom())) {
                this.currentPolygon = this.route.getAreaRouteGeom().contains("MULTIPOLYGON") ? new MultiPolygon(this.route.getAreaRouteGeom()) : new org.postgis.Polygon(this.route.getAreaRouteGeom());
            }
        }
        catch (SQLException e1) {
            e1.printStackTrace();
        }
        this.listCondition = new ArrayList<Route2ColorConditionLinkExt>();
        this.listRemove = new ArrayList<Route2ColorConditionLinkExt>();
        Route2ColorConditionLinkSearchCriteria sc2 = new Route2ColorConditionLinkSearchCriteria();
        sc2.setRouteIdList(new Long[]{this.route.getId()});
        try {
            Object[] oo = this.conditionLinkWSProxy.getList(InitializedVariable.context, sc2).getObjList();
            if (oo != null) {
                Object[] objectArray = oo;
                int n3 = oo.length;
                int n4 = 0;
                while (n4 < n3) {
                    Object o = objectArray[n4];
                    this.listCondition.add((Route2ColorConditionLinkExt)((Object)o));
                    ++n4;
                }
            }
        }
        catch (Exception exception) {
            logger.debug((Object)"No objects for Route2ColorCondition");
        }
    }

    @ListField(fields={@Field(title="", order=1300, propertiesLayout="Split1/h/l/0.3:0:m1#spanx 4", viewer={ActionButton.class})})
    public BeanViewerAction<ViewerContext> getLoadDateRoute() {
        return this.loadDateRoute;
    }

    @ListField(fields={@Field(title="", order=1400, propertiesLayout="Split1/h/l/0.3:0:m4", viewer={ActionButton.class})})
    public BeanViewerAction<ViewerContext> getSaveDateRoute() {
        return this.saveDateRoute;
    }

    public void clearData() {
        this.lists = new ArrayList<RouteElement>();
        this.timestamp = System.nanoTime();
        this.calcCommonTime();
        this.currentPolygon = null;
        this.currentLine = null;
    }

    @ListField(fields={@Field(title="", order=1700, propertiesLayout="Split1/h/l/0.3:0:m4", viewer={ActionButton.class})})
    public BeanViewerAction<ViewerContext> getClearDataRoute() {
        return this.clearDataRoute;
    }

    @ListField(fields={@Field(title="", order=1700, propertiesLayout="Split1/h/l/0.3:0:m4", viewer={ActionButton.class})})
    public BeanViewerAction<ViewerContext> getClearDataRoutePath() {
        return this.clearDataRoutePath;
    }

    @ListField(fields={@Field(title="", propertiesUI={"onlyOnePressed=false"}, order=5, propertiesLayout="Split1/h/l/0.3:0/wrap 1, fillx:m1/wrap 4/\u041c\u0430\u0440\u0448\u0440\u0443\u0442/growx#w 300, spanx 3", viewer={ListActionViewer.class})})
    public List<BeanViewerAction<ViewerContext>> getListEasyBt() {
        return this.listEasyBt;
    }

    public void addListEasyBt(BeanViewerAction<ViewerContext> newA) {
        this.listEasyBt.add(newA);
    }

    public static class AdderStateFromList
    extends BeanViewerAction<ViewerContext> {
        public String getIcon() {
            return ResourceStrings.btAddStation;
        }

        public String getHint() {
            return "\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0443 \u0438\u0437 \u0441\u043f\u0438\u0441\u043a\u0430";
        }

        public void actionPerformed(Object message) {
            CheckPointList list = new CheckPointList();
            InitializedVariable.factory.newPage(CheckPointList.class, CheckPointList.class, (Object)list, (ViewerContext)this.getContext(), "selectInBuildRoute");
        }
    }

    public static class ChangeBegin
    extends ActionCalculatedObject {
        public void actionPerformed(Object message) {
            if (!initializing) {
                RouteGeomBuilder e = (RouteGeomBuilder)((Object)((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getObject());
                FieldPresentation fp = ((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getPanel().getPresentatorForName("begin");
                ((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getPanel().updateField(fp);
                e.calcCommonTime();
                e.UpdateUIForCommon((PanelContext)((ViewerContext)this.getContext()).getParentContext());
            }
        }
    }

    public static class ChangeRouter
    extends ActionCalculatedObject {
        RouteWSProxy routeWSProxy = (RouteWSProxy)CurrentProxyFactory.getProxy(Route.class);

        public void actionPerformed(Object message) {
            if (!initializing) {
                FieldPresentation fp = ((ViewerContext)this.getContext()).getPresentator();
                Route r = (Route)fp.getViewer().getValue();
                RouteGeomBuilder rr = (RouteGeomBuilder)((Object)((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getObject());
                if (r != null) {
                    Route r2 = this.routeWSProxy.getCurrentObject(InitializedVariable.context, r.getId());
                    rr.setRoute(r2);
                    ((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getPanel().getPresentatorForName("routeNum").getViewer().setEditable(false);
                    ((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getPanel().getPresentatorForName("routeName").getViewer().setEditable(false);
                } else {
                    rr.setRoute(null);
                    ((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getPanel().getPresentatorForName("routeNum").getViewer().setEditable(true);
                    ((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getPanel().getPresentatorForName("routeName").getViewer().setEditable(true);
                }
                rr.updUI(((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getPanel());
            }
        }
    }

    public static class Down
    extends BeanViewerAction<ViewerContext> {
        public String getHint() {
            return "\u041f\u0435\u0440\u0435\u043c\u0435\u0441\u0442\u0438\u0442\u044c \u0432\u043d\u0438\u0437";
        }

        public String getIcon() {
            return ResourceString.btDownImage;
        }

        public void actionPerformed(Object message) {
            ((RouteGeomBuilder)((Object)((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getObject())).moveDown((PanelContext)((ViewerContext)this.getContext()).getParentContext());
        }
    }

    public static class Editor
    extends EditorButton {
        public void actionPerformed(Object arg0) {
            try {
                if (((ViewerContext)this.getContext()).getPresentator().getViewer() instanceof BigContentViewer) {
                    ((ViewerContext)this.getContext()).setActionID(this.getActionID());
                    BigContentViewer bg = (BigContentViewer)((ViewerContext)this.getContext()).getPresentator().getViewer();
                    Object o = bg.getEditInstance();
                    if (o != null) {
                        if (((RouteElement)o).getType() == 0) {
                            this.setKeyView("editPath");
                        } else if (((RouteElement)o).getType() == 1 || ((RouteElement)o).getType() == 5 || ((RouteElement)o).getType() == 6) {
                            RouteGeomBuilder.findKT((RouteElementExt)o);
                            this.setKeyView("editStation");
                        } else {
                            this.setKeyView("editPoint");
                        }
                        ((ViewerContext)this.getContext()).getPresentator().getViewer().getFactory().newPage(null, o.getClass(), o, (ViewerContext)this.getContext(), this.getKeyView(), (BeanViewerAction)this);
                    }
                }
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }

        public void afterShowForm(PanelContext pc) {
            RouteElementExt e = (RouteElementExt)pc.getPanel().getObject();
            if (e.getCheckpoint_id() != null) {
                pc.getPanel().getPresentatorForName("nameKT").getViewer().setEditable(false);
                pc.getPanel().getPresentatorForName("saveCheckPoint").getViewer().setEditable(false);
            } else {
                FieldPresentation fp = pc.getPanel().getPresentatorForName("nameKT");
                if (fp != null) {
                    pc.getPanel().getPresentatorForName("nameKT").getViewer().setEditable(true);
                    pc.getPanel().getPresentatorForName("saveCheckPoint").getViewer().setEditable(true);
                }
            }
            super.afterShowForm(pc);
        }
    }

    public static class ListViewerT<T>
    extends ListViewer<T> {
        public ListViewerT(UIFactory<T> factory) {
            super(factory);
            this.addActionOnSelect();
        }

        protected void actionOnSelect() {
            List l = this.getSelectedItems();
            RouteElement sel = null;
            if (l != null && l.size() > 0) {
                sel = (RouteElement)l.get(0);
            }
            boolean cenRemove = sel != null && sel.getType() > 0 && sel.getType() < 5;
            boolean cenEG = sel != null && sel.getType() == 1;
            for (BeanViewerAction bva : this.getActions()) {
                if (bva instanceof BeanViewerAction.Remover || bva instanceof Up || bva instanceof Down) {
                    this.getFactory().setComponentEditable(this.getActionsMap().get(bva), cenRemove && bva.isRightForEnable());
                    bva.setEnable(cenRemove && bva.isRightForEnable());
                }
                if (!(bva instanceof EditorCheckPointInJosm)) continue;
                this.getFactory().setComponentEditable(this.getActionsMap().get(bva), cenEG && bva.isRightForEnable());
                bva.setEnable(cenEG && bva.isRightForEnable());
            }
            if (this.getViewerContext() != null) {
                ((RouteGeomBuilder)((Object)((PanelContext)this.getViewerContext().getParentContext()).getObject())).setSelect(sel, (PanelContext)this.getViewerContext().getParentContext());
            }
        }
    }

    public static class Up
    extends BeanViewerAction<ViewerContext> {
        public String getHint() {
            return "\u041f\u0435\u0440\u0435\u043c\u0435\u0441\u0442\u0438\u0442\u044c \u0432\u0432\u0435\u0440\u0445";
        }

        public String getIcon() {
            return ResourceString.btUpImage;
        }

        public void actionPerformed(Object message) {
            ((RouteGeomBuilder)((Object)((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getObject())).moveUp((PanelContext)((ViewerContext)this.getContext()).getParentContext());
        }
    }
}

