/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.route.routegeom;

import java.util.Calendar;
import java.util.Date;
import javax.swing.JComponent;
import ru.infor.beanviewer.core.UIFactory;
import ru.infor.beanviewer.swing.viewers.TimeFormatViewer;
import ru.infor.beanviewer.viewer.simple.DateViewer;

public class TimeFormatLongViewer
extends TimeFormatViewer {
    public TimeFormatLongViewer(UIFactory<JComponent> factory) {
        super(factory);
    }

    public static Date getDateForLong(long l) {
        if (l == 0L) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(new Date());
        int hour = (int)(l / 3600000L);
        c.set(11, hour);
        int min = (int)((l -= (long)(hour * 60 * 60 * 1000)) / 60000L);
        c.set(12, min);
        int sec = (int)((l -= (long)(min * 60 * 1000)) / 1000L);
        c.set(13, sec);
        c.set(14, (int)(l -= (long)(sec * 1000)));
        return c.getTime();
    }

    public static long getLongForDate(Date d) {
        long l = 0L;
        if (d != null) {
            Calendar c = Calendar.getInstance();
            c.setTime(d);
            int hour = c.get(11);
            int min = c.get(12);
            int sec = c.get(13);
            int mil = c.get(14);
            l = (long)mil + (long)sec * 1000L + (long)(min * 60 * 1000) + (long)(hour * 60 * 60 * 1000);
        }
        return l;
    }

    public Object getValue() {
        Date d = (Date)super.getValue();
        return TimeFormatLongViewer.getLongForDate(d);
    }

    public void setValue(Object object) {
        if (object == null) {
            super.setValue(null);
        } else if (object instanceof Date) {
            super.setValue(object);
        } else {
            super.setValue((Object)TimeFormatLongViewer.getDateForLong((Long)object));
        }
    }

    public Class getTableCellViewerClass() {
        return DateLongLiewer.class;
    }

    public static class DateLongLiewer<T>
    extends DateViewer<T> {
        public DateLongLiewer(UIFactory<T> factory) {
            super(factory);
        }

        public Object getValue() {
            Date d = (Date)super.getValue();
            return TimeFormatLongViewer.getLongForDate(d);
        }

        public void setValue(Object object) {
            if (object == null) {
                super.setValue(null);
            } else {
                super.setValue((Object)TimeFormatLongViewer.getDateForLong((Long)object));
            }
        }
    }
}

