/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.route.routeinjosm;

import java.sql.SQLException;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import ru.blok.common.core.CurrentProxyFactory;
import ru.blok.common.core.InitializedVariable;
import ru.blok.common.ui.list.ObjectUIList;
import ru.blok.vms.ui.josm.CommonDataSet;
import ru.blok.vms.ui.route.routegeom.CreateGeomRoute;
import ru.infor.client.soap.proxy.vms.Route2CheckPointLinkWSProxy;
import ru.infor.client.soap.proxy.vms.RouteWSProxy;
import ru.infor.ws.objects.core.SortObject;
import ru.infor.ws.objects.vms.Route2CheckPointLinkSearchCriteria;
import ru.infor.ws.objects.vms.entities.Route;
import ru.infor.ws.objects.vms.entities.Route2CheckPointLink;
import ru.infor.ws.objects.vms.entities.ext.Route2CheckPointLinkExt;
import ru.infor.ws.proxy.interfaces.ISearchCriteria;
import ru.infor.ws.proxy.interfaces.InvocationContext;

public class RouteDataSet
extends CommonDataSet {
    RouteWSProxy proxy = (RouteWSProxy)CurrentProxyFactory.getProxy(Route.class);
    Route2CheckPointLinkWSProxy linkWSProxy = (Route2CheckPointLinkWSProxy)CurrentProxyFactory.getProxy(Route2CheckPointLink.class);
    Route route;
    Way track;

    public RouteDataSet(Route r, String keyPage) throws SQLException {
        super(keyPage);
        this.route = this.proxy.getCurrentObject(InitializedVariable.context, r.getId());
        String geom = this.route.getRouteGeom();
        this.analysGeom(geom);
        ObjectUIList list = new ObjectUIList(Route2CheckPointLinkExt.class);
        list.setTotalFill(true);
        Route2CheckPointLinkSearchCriteria sc = (Route2CheckPointLinkSearchCriteria)list.getSearchCriteria();
        sc.setRouteIdList(new Long[]{this.route.getId()});
        sc.setDirection(Integer.valueOf(0));
        SortObject so = new SortObject();
        so.setDirection(SortObject.DIRECTION_ASC);
        so.setName("minOffsetInSec");
        sc.setListSort(new SortObject[]{so});
        sc.setCount(this.linkWSProxy._universalGetCount((InvocationContext)InitializedVariable.context, (ISearchCriteria)sc));
        for (Route2CheckPointLinkExt rr : list) {
            Node n = new Node(new LatLon(rr.getPoint().getLat().doubleValue(), rr.getPoint().getLon().doubleValue()));
            n.put("CheckPoint", "yes");
            n.put("Name", rr.getPoint().getName());
            this.addPrimitive((OsmPrimitive)n);
        }
    }

    @Override
    protected boolean saveObject(String geom) {
        this.route.setRouteGeom(geom);
        CreateGeomRoute createGeomRoute = new CreateGeomRoute();
        createGeomRoute.setWidthRoute(this.route.getWidthRoute());
        this.route.setAreaRouteGeom(createGeomRoute.createPolygon(geom));
        boolean ok = true;
        if (this.route.getAreaRouteGeom() == null) {
            ok = false;
        }
        this.route = this.proxy.save(InitializedVariable.context, this.route);
        if (!ok) {
            JOptionPane.showMessageDialog(null, "\u041f\u0440\u0438 \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u0433\u0435\u043e\u043c\u0435\u0442\u0440\u0438\u0438 \u043f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u043e\u0441\u0442\u0440\u043e\u0435\u043d\u0438\u0438 \u043f\u043e\u043b\u0438\u0433\u043e\u043d\u0430", "\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0430", 1);
        } else {
            JOptionPane.showMessageDialog(null, "\u0421\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u0435 \u0433\u0435\u043e\u043c\u0435\u0442\u0440\u0438\u0438 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u043e \u0443\u0441\u043f\u0435\u0448\u043d\u043e", "\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0430", 1);
        }
        return false;
    }
}

