/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.routesshow;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import io.advantageous.boon.core.value.CharSequenceValue;
import io.advantageous.boon.core.value.NumberValue;
import io.advantageous.boon.core.value.ValueContainer;
import io.advantageous.boon.core.value.ValueMap;
import io.advantageous.qbit.boon.spi.BoonJsonMapper;
import io.advantageous.qbit.http.client.HttpClient;
import io.advantageous.qbit.http.client.HttpClientBuilder;
import io.advantageous.qbit.http.request.HttpTextResponse;
import io.advantageous.qbit.http.websocket.WebSocket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import ru.blok.common.core.CommonObjectWithKey;
import ru.blok.common.core.InitializedVariable;
import ru.blok.common.utils.CoordinatesDownTown;
import ru.blok.vms.core.ResourceStrings;
import ru.blok.vms.ui.routesshow.Car;
import ru.blok.vms.ui.routesshow.Route;
import ru.blok.vms.ui.routesshow.map.MapValueRoute;
import ru.blok.vms.ui.routesshow.map.MapViewer;
import ru.infor.beanviewer.annotation.Field;
import ru.infor.beanviewer.annotation.ListField;
import ru.infor.beanviewer.annotation.ListView;
import ru.infor.beanviewer.annotation.View;
import ru.infor.beanviewer.core.FieldPresentation;
import ru.infor.beanviewer.core.UIFactory;
import ru.infor.beanviewer.viewer.ActionButton;
import ru.infor.beanviewer.viewer.BeanViewerAction;
import ru.infor.beanviewer.viewer.action.PanelContext;
import ru.infor.beanviewer.viewer.action.ViewerContext;
import ru.infor.beanviewer.viewer.list.ListViewer;

@ListView(views={@View(title="\u041c\u0430\u0440\u0448\u0440\u0443\u0442\u044b", actions={}, layoutKeys={"tabSplitPercentLayoutManager"})})
public class RoutesWithTransportList
extends CommonObjectWithKey {
    private static ScheduledExecutorService connector;
    private HttpClient httpClient;
    private HttpClient wsClient;
    WebSocket webSocket;
    HashMap<String, Car> maps = new HashMap();
    private static BoonJsonMapper b;
    private static GeometryFactory gf;
    List<Route> list;
    List<Route> selectList;
    MapValueRoute valueRoute;
    Double[] coord;
    PanelContext pc;
    String findString;
    BeanViewerAction<ViewerContext> find = new BeanViewerAction<ViewerContext>(){

        public String getName() {
            return "\u041d\u0430\u0439\u0442\u0438";
        }

        public String getIcon() {
            return ResourceStrings.btArrowDown;
        }

        public void actionPerformed(Object message) {
            FieldPresentation fp = ((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getPanel().getPresentatorForName("findString");
            ((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getPanel().updateField(fp);
            for (Route r : RoutesWithTransportList.this.selectList) {
                for (Integer p : r.getPoints()) {
                    if (!p.toString().contains(RoutesWithTransportList.this.findString)) continue;
                    r.getSelectPoinst().add(p);
                    RoutesWithTransportList.this.valueRoute.zoomToStop(r, p);
                    return;
                }
                for (Car c : r.getCars()) {
                    if (!c.getId().contains(RoutesWithTransportList.this.findString)) continue;
                    c.setSelect(true);
                    RoutesWithTransportList.this.valueRoute.zoomToCar(r, c);
                    return;
                }
            }
        }
    };
    List<String> currentConnect = null;
    String currentW;
    private static final ExecutorService threadpool;

    static {
        b = new BoonJsonMapper();
        gf = new GeometryFactory();
        threadpool = Executors.newCachedThreadPool();
    }

    public RoutesWithTransportList(String keyPage) {
        super(keyPage);
        this.coord = CoordinatesDownTown.getCoordinatesDownTown((Long)InitializedVariable.getWorkplaceId((String)this.getKeyPage()));
        this.valueRoute = new MapValueRoute(this, this.coord[0], this.coord[1], this.coord[2].intValue());
    }

    public void beforeShow(PanelContext pc) {
        this.pc = pc;
        this.connectionsTestAndReconnect();
        this.loadlistroute();
        if (connector == null) {
            connector = Executors.newScheduledThreadPool(1);
            connector.scheduleAtFixedRate(() -> {
                try {
                    Set<String> result = this.connectionsTestAndReconnect();
                    List sel = this.getSelectList().stream().map(r -> r.getNum()).collect(Collectors.toList());
                    if (result.contains("http")) {
                        this.loadlistroute();
                    }
                    if (result.contains("ws") || result.contains("http")) {
                        List l = sel.stream().map(s -> this.list.indexOf(this.list.stream().anyMatch(r -> r.getNum().equals(s)))).collect(Collectors.toList());
                        int[] ind = new int[l.size()];
                        int i = 0;
                        while (i < l.size()) {
                            ind[i] = (Integer)l.get(i);
                            ++i;
                        }
                        ((ListViewer)pc.getPanel().getPresentatorForName("list").getViewer()).getTM().setSelectedRows(ind);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }, 10L, 1L, TimeUnit.SECONDS);
        }
    }

    private Set<String> connectionsTestAndReconnect() {
        TreeSet<String> result = new TreeSet<String>();
        if (this.httpClient == null || this.httpClient.isClosed()) {
            this.httpClient = HttpClientBuilder.httpClientBuilder().setPoolSize(300).setHost("62.33.234.118").setPort(3301).setTimeOutInMilliseconds(60000).build();
            this.httpClient.start();
            result.add("http");
        }
        if (this.wsClient == null || this.wsClient.isClosed()) {
            this.wsClient = HttpClientBuilder.httpClientBuilder().setPoolSize(100).setHost("62.33.234.118").setPort(5556).setTimeOutInMilliseconds(60000).build();
            this.wsClient.start();
            result.add("ws");
        }
        if (this.webSocket == null || this.webSocket.isClosed()) {
            this.wsConnect();
            result.add("ws");
        }
        return result;
    }

    public void beforeDestroy(PanelContext pc) {
        this.httpClient.stop();
        this.disconnect();
        this.webSocket.close();
        this.wsClient.stop();
    }

    private void loadlistroute() {
        this.httpClient.getAsync("/fc/dp/routes", (code, contentType, body) -> {
            if (code == 200) {
                this.maps.clear();
                this.list = ((List)b.fromJson(body)).stream().map(s -> new Route(s.stringValue())).collect(Collectors.toList());
                this.pc.getPanel().updateUI();
            } else {
                System.out.println("\u041e\u0448\u0438\u0431\u043a\u0430: \u043a\u043e\u0434 " + code + " " + body);
            }
        });
    }

    @ListField(fields={@Field(title="", order=5, propertiesLayout="Split1/h/l/0.3:1/fill,wrap 1:1/fill/n/grow#growy , spanx#growy 0,spanx", content=Route.class, viewer={ListViewerT.class})})
    public List<Route> getList() {
        return this.list;
    }

    public List<Route> getSelectList() {
        return this.selectList;
    }

    @ListField(fields={@Field(title="\u041f\u043e\u0438\u0441\u043a:", order=0, propertiesLayout="Split1/h/l/0.3:1/fill,wrap 1:3/fillx#growx")})
    public String getFindString() {
        return this.findString;
    }

    public void setFindString(String findString) {
        this.findString = findString;
    }

    @ListField(fields={@Field(title="", order=1, propertiesLayout="Split1/h/l/0.3:1:3", viewer={ActionButton.class})})
    public BeanViewerAction<ViewerContext> getFind() {
        return this.find;
    }

    @ListField(fields={@Field(title="\u0412\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0445 \u043c\u0430\u0440\u0448\u0440\u0443\u0442\u043e\u0432:", order=15, propertiesLayout="Split1/h/l/0.3:1:2")})
    public Integer getSelRoutes() {
        return this.selectList == null ? 0 : this.selectList.size();
    }

    @ListField(fields={@Field(title="\u0412\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0445 \u0422\u0421:", order=16, propertiesLayout="Split1/h/l/0.3:1:2")})
    public Integer getSelCars() {
        return this.selectList == null ? 0 : this.selectList.stream().map(r -> r.getCountCar()).reduce(0, (a, b) -> a + b);
    }

    public void setSelectList(List<Route> selectList) {
        this.selectList = selectList;
        if (selectList != null) {
            ExecutorService executor = Executors.newWorkStealingPool();
            executor.submit(() -> {
                ForkJoinPool forkJoinPool = new ForkJoinPool(2);
                try {
                    ((ForkJoinTask)forkJoinPool.submit(() -> selectList.parallelStream().forEach(r -> {
                        if (r.getCoord() == null) {
                            HttpTextResponse resp = this.httpClient.get("/fc/dp/geom/" + r.getNum());
                            if (resp.code() == 200) {
                                Stream<Object> l = ((List)b.fromJson((String)resp.body())).stream().map(vc -> (List)((ValueContainer)vc).toValue());
                                Coordinate[] coords = (Coordinate[])l.map(ll -> new Coordinate(((NumberValue)ll.get(1)).doubleValue(), ((NumberValue)ll.get(0)).doubleValue())).toArray(Coordinate[]::new);
                                r.setCoord(coords);
                                LineString rg = gf.createLineString(coords);
                                r.setPath(rg);
                                ((MapViewer)this.pc.getPanel().getPresentatorForName("valueRoute").getViewer()).zoomToTracks();
                            } else {
                                System.out.println("\u041e\u0448\u0438\u0431\u043a\u0430: \u043a\u043e\u0434 " + resp.code() + " " + (String)resp.body());
                            }
                        }
                        if (r.getPoints() == null || r.getPoints().size() == 0) {
                            this.httpClient.getAsync("/fc/dp/stops/" + r.getNum(), (code, contentType, body) -> {
                                if (code == 200) {
                                    List<Integer> stop = ((List)b.fromJson(body)).stream().map(s -> s.intValue()).collect(Collectors.toList());
                                    r.setPoints(stop);
                                    ((MapViewer)this.pc.getPanel().getPresentatorForName("valueRoute").getViewer()).repaint();
                                } else {
                                    System.out.println("\u041e\u0448\u0438\u0431\u043a\u0430: \u043a\u043e\u0434 " + code + " " + body);
                                }
                            });
                        }
                        if (r.getCars() == null || r.getCars().size() == 0) {
                            this.httpClient.getAsync("/fc/dp/orders/" + r.getNum(), (code, contentType, body) -> {
                                if (code == 200) {
                                    List<Car> cars = ((List)b.fromJson(body)).stream().map(s -> {
                                        Car c = new Car(s.stringValue());
                                        this.maps.put(c.getId(), c);
                                        return c;
                                    }).collect(Collectors.toList());
                                    r.setCars(cars);
                                    this.reconnect();
                                    ((ListViewerT)this.pc.getPanel().getPresentatorForName("list").getViewer()).updateTable((Route)r);
                                    this.pc.getPanel().updateUIForPresentatorName("selRoutes");
                                    this.pc.getPanel().updateUIForPresentatorName("selCars");
                                } else {
                                    System.out.println("\u041e\u0448\u0438\u0431\u043a\u0430: \u043a\u043e\u0434 " + code + " " + body);
                                }
                            });
                        }
                    }))).get();
                }
                catch (InterruptedException | ExecutionException e) {
                    e.printStackTrace();
                }
            });
            this.reconnect();
            if (this.pc != null) {
                ((MapViewer)this.pc.getPanel().getPresentatorForName("valueRoute").getViewer()).repaint();
                ((MapViewer)this.pc.getPanel().getPresentatorForName("valueRoute").getViewer()).zoomToTracks();
                this.pc.getPanel().updateUIForPresentatorName("selRoutes");
                this.pc.getPanel().updateUIForPresentatorName("selCars");
            }
        }
    }

    @ListField(fields={@Field(title="", order=100, propertiesLayout="Split1/h/r/0.3", viewer={MapViewer.class})})
    public MapValueRoute getValueRoute() {
        return this.valueRoute;
    }

    public void disconnect() {
        if (this.currentConnect != null && this.currentConnect.size() > 0) {
            this.webSocket.sendText(this.currentConnect.stream().collect(Collectors.joining(",", "REMOVE:", "")));
            this.currentConnect = null;
        }
    }

    public void reconnect() {
        ArrayList<String> connect = new ArrayList<String>();
        if (this.selectList != null) {
            for (Route r : this.selectList) {
                if (r.getCars() == null) continue;
                connect.addAll(r.getCars().stream().map(c -> c.getId()).collect(Collectors.toList()));
            }
        }
        if (this.currentConnect != null && this.currentConnect.size() == connect.size() && this.currentConnect.stream().map(c -> connect.contains(c)).filter(b -> b == false).count() == 0L) {
            return;
        }
        this.disconnect();
        this.currentConnect = connect;
        if (this.currentConnect.size() > 0) {
            this.webSocket.sendText(this.currentConnect.stream().collect(Collectors.joining(",", "ADD:", "")));
        }
    }

    public void changeWindow(double maxLat, double maxLon, double minLat, double minlon, double r) {
        String c = "WINDOW:" + maxLat + "," + maxLon + "," + minLat + "," + minlon + "," + r;
        if (this.webSocket != null && this.webSocket.isOpen() && !c.equals(this.currentW)) {
            this.webSocket.sendText(c);
            this.currentW = c;
        }
    }

    private void wsConnect() {
        this.webSocket = this.wsClient.createWebSocket("/nddata/nddata/");
        this.webSocket.setTextMessageConsumer(message -> {
            FutureTask<String> future = new FutureTask<String>(new Callable<String>(){

                @Override
                public String call() {
                    if (message.startsWith("{")) {
                        ValueMap o = (ValueMap)b.fromJson(message);
                        String id = ((CharSequenceValue)o.get((Object)"i")).stringValue();
                        long t = ((NumberValue)o.get((Object)"t")).longValue();
                        Car c = RoutesWithTransportList.this.maps.get(id);
                        if (c.getT() < t) {
                            ValueMap p = (ValueMap)((ValueContainer)o.get((Object)"p")).toValue();
                            double lat = ((NumberValue)p.get((Object)"1")).doubleValue();
                            double lon = ((NumberValue)p.get((Object)"0")).doubleValue();
                            double speed = ((NumberValue)p.get((Object)"2")).doubleValue();
                            double azimuth = ((NumberValue)p.get((Object)"3")).doubleValue();
                            int direction = (int)Math.round(((NumberValue)p.get((Object)"6")).doubleValue());
                            c.setT(t);
                            c.setAzimuth(azimuth);
                            c.setLat(lat);
                            c.setLon(lon);
                            c.setSpeed(speed);
                            c.setDirection(direction - 1);
                            RoutesWithTransportList.this.valueRoute.Change();
                        }
                    }
                    return "";
                }
            });
            threadpool.execute(future);
        });
        try {
            this.webSocket.openAndWait();
        }
        catch (Exception exception) {}
    }

    public static class ListViewerT
    extends ListViewer {
        public ListViewerT(UIFactory factory) {
            super(factory);
            this.addActionOnSelect();
        }

        protected void actionOnSelect() {
            super.actionOnSelect();
            RoutesWithTransportList t = (RoutesWithTransportList)((Object)((PanelContext)this.getViewerContext().getParentContext()).getObject());
            List l = this.getSelectedItems();
            t.setSelectList(l);
        }

        public void updateTable(Route t) {
            if (t != null) {
                int i;
                JTable table = (JTable)this.getTM().getTableComponent();
                int k = this.getTM().list.indexOf(t);
                if (k >= 0 && k < ((DefaultTableModel)table.getModel()).getRowCount() && (i = table.getRowSorter().convertRowIndexToView(k)) >= 0 && i < table.getRowCount()) {
                    ((DefaultTableModel)table.getModel()).fireTableRowsUpdated(i, i);
                }
            }
        }
    }
}

