/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.routesshow.map;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;
import org.jxmapviewer.JXMapViewer;
import org.jxmapviewer.viewer.GeoPosition;
import ru.blok.vms.ui.mapviewer.imap.IMapValue;
import ru.blok.vms.ui.mapviewer.mapviewerwithtrack.view.MapViewPainter;
import ru.blok.vms.ui.mapviewer.mapviewerwithtrack.view.NodePainterData;
import ru.blok.vms.ui.routesshow.Car;
import ru.blok.vms.ui.routesshow.Route;
import ru.blok.vms.ui.routesshow.map.MapValueRoute;

public class CarPainter<T extends JXMapViewer>
extends MapViewPainter<T> {
    protected static Color c = Color.GREEN;
    public static Stroke stStroke = new BasicStroke(1.0f, 1, 1);
    static Polygon p = CarPainter.getPolygon();
    DecimalFormat format = new DecimalFormat("#0.00");
    MapValueRoute value;

    public Object[] include(Point2D pClick, T map) {
        if (this.value != null && this.value.getSelectList() != null) {
            for (Route r : this.value.getSelectList()) {
                if (r.getCars() == null) continue;
                for (Car p : r.getCars()) {
                    GeoPosition point1 = new GeoPosition(p.getLat(), p.getLon());
                    Point2D point = map.getTileFactory().geoToPixel(point1, map.getZoom());
                    Point2D.Double p2 = new Point2D.Double(pClick.getX() - point.getX(), pClick.getY() - point.getY());
                    double dx = Math.abs(((Point2D)p2).getX());
                    double dy = Math.abs(((Point2D)p2).getY());
                    if (!(dx < 7.0) || !(dy < 7.0)) continue;
                    return new Object[]{r, p};
                }
            }
        }
        return null;
    }

    public static Polygon getPolygon() {
        Polygon p = new Polygon();
        p.addPoint(0, 15);
        p.addPoint(-5, 10);
        p.addPoint(-5, -5);
        p.addPoint(0, 0);
        p.addPoint(5, -5);
        p.addPoint(5, 10);
        return p;
    }

    protected void paintCars(Route r, T map, Graphics2D g, Rectangle2D vp2, Rectangle2D vp3, Color c, boolean select) {
        g.setStroke(stStroke);
        if (r.getCars() != null && r.getCoord() != null) {
            int half = r.getCoord().length / 2;
            for (Car p : r.getCars()) {
                GeoPosition point1 = new GeoPosition(p.getLat(), p.getLon());
                Point2D point = map.getTileFactory().geoToPixel(point1, map.getZoom());
                if (!vp2.contains(point)) continue;
                int x = (int)(point.getX() - vp2.getX());
                int y = (int)(point.getY() - vp2.getY());
                g.translate(x, y);
                Color cc = (p.getDirection() < half ? Color.BLUE : Color.GREEN).darker();
                this.paintS(p, map, g, vp2, vp3, cc, select);
                g.translate(-x, -y);
                if (!p.isSelect()) continue;
                this.paint(map, g, vp2, vp3, c, p, r);
            }
        }
    }

    private void paint(T map, Graphics2D g, Rectangle2D vp2, Rectangle2D vp3, Color c, Car p, Route r) {
        GeoPosition point1 = new GeoPosition(p.getLat(), p.getLon());
        Point2D point = map.getTileFactory().geoToPixel(point1, map.getZoom());
        if (vp2.contains(point)) {
            int x = (int)(point.getX() - vp2.getX());
            int y = (int)(point.getY() - vp2.getY());
            g.translate(x, y);
            Integer half = r.getCoord().length / 2;
            String[] hint = new String[]{"\u041d\u043e\u043c\u0435\u0440: " + p.getId(), "\u0421\u043a\u043e\u0440\u043e\u0441\u0442\u044c: " + this.format.format(p.getSpeed())};
            FontMetrics f = g.getFontMetrics();
            Object[] pp = NodePainterData.getPolygonForHint(hint, f);
            int h = f.getHeight();
            int l = hint.length;
            if (pp != null) {
                Polygon p1 = (Polygon)pp[0];
                Rectangle2D bounds = (Rectangle2D)pp[1];
                Color cc = (p.getDirection() < half ? Color.BLUE : Color.GREEN).brighter();
                g.setColor(new Color(cc.getRed(), cc.getGreen(), cc.getBlue(), 150).brighter());
                g.fillPolygon(p1);
                Stroke s = g.getStroke();
                g.setColor(Color.black);
                g.drawPolygon(p1);
                g.setStroke(s);
                int i = 0;
                while (i < l) {
                    g.drawString(hint[i], (int)bounds.getMinX() + 5, (int)bounds.getMinY() + h + i * h);
                    ++i;
                }
            }
            g.translate(-x, -y);
        }
    }

    protected void paintS(Car car, T map, Graphics2D g, Rectangle2D vp2, Rectangle2D vp3, Color c, boolean select) {
        if (car.getAzimuth() == 0.0) {
            g.setColor(c);
            g.fillOval(-2, -2, 5, 5);
            g.setColor(Color.BLACK);
            g.drawOval(-2, -2, 5, 5);
        } else {
            int k = 180;
            g.rotate(Math.toRadians(car.getAzimuth() + (double)k));
            g.setColor(c);
            g.fillPolygon(p);
            g.setColor(c.darker().darker());
            g.drawPolygon(p);
            g.rotate(-Math.toRadians(car.getAzimuth() + (double)k));
        }
    }

    @Override
    public void doPaint(Graphics2D g, T map, int width, int height) {
        Rectangle viewportBounds = map.getViewportBounds();
        int zoom = map.getZoom();
        Dimension sizeInTiles = map.getTileFactory().getMapSize(zoom);
        int tileSize = map.getTileFactory().getTileSize(zoom);
        Dimension sizeInPixels = new Dimension(sizeInTiles.width * tileSize, sizeInTiles.height * tileSize);
        double vpx = viewportBounds.getX();
        while (vpx < 0.0) {
            vpx += sizeInPixels.getWidth();
        }
        while (vpx > sizeInPixels.getWidth()) {
            vpx -= sizeInPixels.getWidth();
        }
        Rectangle2D.Double vp2 = new Rectangle2D.Double(vpx, viewportBounds.getY(), viewportBounds.getWidth(), viewportBounds.getHeight());
        Rectangle2D.Double vp3 = new Rectangle2D.Double(vpx - sizeInPixels.getWidth(), viewportBounds.getY(), viewportBounds.getWidth(), viewportBounds.getHeight());
        if (this.value != null && this.value.getSelectList() != null) {
            for (Route r : this.value.getSelectList()) {
                this.paintCars(r, map, g, vp2, vp3, c, false);
            }
        }
    }

    @Override
    public void setValue(IMapValue mapValueWithTrack) {
        this.value = (MapValueRoute)mapValueWithTrack;
    }
}

