/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.routesshow.map;

import com.vividsolutions.jts.geom.Coordinate;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.Point2D;
import javax.swing.JComponent;
import org.jxmapviewer.JXMapViewer;
import org.jxmapviewer.viewer.GeoPosition;
import ru.blok.vms.ui.mapviewer.imap.IMapValue;
import ru.blok.vms.ui.routesshow.Car;
import ru.blok.vms.ui.routesshow.Route;
import ru.blok.vms.ui.routesshow.map.CarPainter;
import ru.blok.vms.ui.routesshow.map.MapValueRoute;
import ru.blok.vms.ui.routesshow.map.RoutePainter;
import ru.infor.beanviewer.core.UIFactory;

public class MapViewer
extends ru.blok.vms.ui.mapviewer.MapViewer {
    RoutePainter<JXMapViewer> routePainter;
    CarPainter<JXMapViewer> carPainter;
    MapValueRoute value;

    public MapViewer(UIFactory<JComponent> factory) {
        super(factory);
    }

    @Override
    protected void init() {
        super.init();
        this.routePainter = new RoutePainter();
        this.painter.addPainter(this.routePainter);
        this.carPainter = new CarPainter();
        this.painter.addPainter(this.carPainter);
    }

    @Override
    protected void mouseClickedOnMap(double x, double y, GeoPosition gp, MouseEvent e) {
        super.mouseClickedOnMap(x, y, gp, e);
        Point2D.Double pClick = new Point2D.Double(x, y);
        Object[] oo = this.carPainter.include(pClick, this.map.getMainMap());
        if (oo != null) {
            ((Car)oo[1]).setSelect(!((Car)oo[1]).isSelect());
        } else {
            oo = this.routePainter.include(pClick, this.map.getMainMap());
            if (oo != null) {
                if (((Route)oo[0]).getSelectPoinst().contains(oo[1])) {
                    ((Route)oo[0]).getSelectPoinst().remove(oo[1]);
                } else {
                    ((Route)oo[0]).getSelectPoinst().add((Integer)oo[1]);
                }
            }
        }
        this.repaint();
    }

    @Override
    protected void mouseMovedN(MouseEvent e) {
    }

    @Override
    protected void mouseWheelMovedN(MouseWheelEvent e) {
    }

    @Override
    protected boolean canGoToData() {
        return true;
    }

    @Override
    protected Double[] getMinMax() {
        Double minLat = null;
        Double maxLat = null;
        Double minLon = null;
        Double maxLon = null;
        if (this.value != null && this.value.getSelectList() != null) {
            for (Route r : this.value.getSelectList()) {
                if (r.getCoord() == null) continue;
                Coordinate[] coordinateArray = r.getCoord();
                int n = coordinateArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Coordinate c = coordinateArray[n2];
                    if (minLat == null || c.x < minLat) {
                        minLat = c.x;
                    }
                    if (maxLat == null || c.x > maxLat) {
                        maxLat = c.x;
                    }
                    if (minLon == null || c.y < minLon) {
                        minLon = c.y;
                    }
                    if (maxLon == null || c.y > maxLon) {
                        maxLon = c.y;
                    }
                    ++n2;
                }
            }
        }
        if (minLat == null) {
            return null;
        }
        return new Double[]{minLat, maxLat, minLon, maxLon};
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public void setValue(Object value) {
        if (value != null) {
            ((MapValueRoute)value).mapViewer = this;
        }
        super.setValue(value);
        this.value = (MapValueRoute)value;
        this.routePainter.setValue((IMapValue)value);
        this.carPainter.setValue((IMapValue)value);
        this.zoomToTracks();
    }
}

