/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.routesshow.map;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.simplify.DouglasPeuckerSimplifier;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import org.jxmapviewer.JXMapViewer;
import org.jxmapviewer.viewer.GeoPosition;
import ru.blok.vms.ui.mapviewer.imap.IMapValue;
import ru.blok.vms.ui.mapviewer.mapviewerwithtrack.view.MapViewPainter;
import ru.blok.vms.ui.mapviewer.mapviewerwithtrack.view.NodePainterData;
import ru.blok.vms.ui.routesshow.Route;
import ru.blok.vms.ui.routesshow.map.MapValueRoute;

public class RoutePainter<T extends JXMapViewer>
extends MapViewPainter<T> {
    protected static Color c = Color.GREEN;
    public static Stroke defaultStroke = new BasicStroke(3.0f, 1, 1);
    public static Stroke defaultStrokeSelect = new BasicStroke(8.0f, 1, 1);
    public static Stroke stStroke = new BasicStroke(1.0f, 1, 1);
    MapValueRoute value;

    public void changeWindow(JXMapViewer map, RectangularShape vp2) {
        GeoPosition p1 = map.getTileFactory().pixelToGeo((Point2D)new Point2D.Double(vp2.getMinX() - 50.0, vp2.getMinY() - 50.0), map.getZoom());
        GeoPosition p2 = map.getTileFactory().pixelToGeo((Point2D)new Point2D.Double(vp2.getMaxX() + 50.0, vp2.getMaxY() + 50.0), map.getZoom());
        if (this.value != null) {
            this.value.a.changeWindow(Math.max(p1.getLatitude(), p2.getLatitude()), Math.max(p1.getLongitude(), p2.getLongitude()), Math.min(p1.getLatitude(), p2.getLatitude()), Math.min(p1.getLongitude(), p2.getLongitude()), Math.max(map.getWidth() * 2, map.getHeight() * 2));
        }
    }

    public static double getScale(JXMapViewer map, RectangularShape vp2) {
        GeoPosition p1 = map.getTileFactory().pixelToGeo((Point2D)new Point2D.Double(vp2.getMinX(), vp2.getMinY()), map.getZoom());
        GeoPosition p2 = map.getTileFactory().pixelToGeo((Point2D)new Point2D.Double(vp2.getMaxX(), vp2.getMaxY()), map.getZoom());
        double p1scale = (p2.getLatitude() - p1.getLatitude()) / vp2.getHeight();
        double p2scale = (p2.getLatitude() - p1.getLatitude()) / vp2.getHeight();
        double p_scale = 3.0 * Math.min(Math.abs(p1scale), Math.abs(p2scale));
        return p_scale;
    }

    protected void paint(Geometry geometry, T map, Graphics2D g, Rectangle2D vp2, Rectangle2D vp3, Color c, boolean select) {
        Geometry simplifyedGeometry = DouglasPeuckerSimplifier.simplify((Geometry)geometry, (double)RoutePainter.getScale(map, vp2));
        GeneralPath shape = new GeneralPath();
        int i = 0;
        while (i < simplifyedGeometry.getNumGeometries()) {
            Geometry gg = simplifyedGeometry.getGeometryN(i);
            int j = 0;
            while (j < gg.getCoordinates().length) {
                Point2D cp = map.getTileFactory().geoToPixel(new GeoPosition(gg.getCoordinates()[j].x, gg.getCoordinates()[j].y), map.getZoom());
                if (j == 0) {
                    shape.moveTo(cp.getX() - vp2.getX(), cp.getY() - vp2.getY());
                } else {
                    shape.lineTo(cp.getX() - vp2.getX(), cp.getY() - vp2.getY());
                }
                ++j;
            }
            ++i;
        }
        g.setColor(c);
        g.setStroke(select ? defaultStrokeSelect : defaultStroke);
        g.draw(shape);
    }

    protected void paintStops(Route r, T map, Graphics2D g, Rectangle2D vp2, Rectangle2D vp3, Color c, boolean select) {
        g.setStroke(stStroke);
        if (r.getPoints() != null && r.getCoord() != null) {
            Integer half = r.getCoord().length / 2;
            for (Integer p : r.getPoints()) {
                Coordinate cd = r.getCoord()[p];
                GeoPosition point1 = new GeoPosition(cd.x, p == 0 ? cd.y + 1.0E-4 : cd.y);
                Point2D point = map.getTileFactory().geoToPixel(point1, map.getZoom());
                if (!vp2.contains(point)) continue;
                int x = (int)(point.getX() - vp2.getX());
                int y = (int)(point.getY() - vp2.getY());
                Color cc = p < half ? Color.BLUE : Color.GREEN;
                cc = new Color(cc.getRed(), cc.getGreen(), cc.getBlue(), 180);
                g.setColor(cc);
                g.fillOval(x - 8, y - 8, 16, 16);
                g.setColor(Color.BLACK);
                g.drawOval(x - 8, y - 8, 16, 16);
                if (!r.getSelectPoinst().contains(p)) continue;
                this.paint(map, g, vp2, vp3, cc, r, p);
            }
        }
    }

    @Override
    public void doPaint(Graphics2D g, T map, int width, int height) {
        Rectangle viewportBounds = map.getViewportBounds();
        int zoom = map.getZoom();
        Dimension sizeInTiles = map.getTileFactory().getMapSize(zoom);
        int tileSize = map.getTileFactory().getTileSize(zoom);
        Dimension sizeInPixels = new Dimension(sizeInTiles.width * tileSize, sizeInTiles.height * tileSize);
        double vpx = viewportBounds.getX();
        while (vpx < 0.0) {
            vpx += sizeInPixels.getWidth();
        }
        while (vpx > sizeInPixels.getWidth()) {
            vpx -= sizeInPixels.getWidth();
        }
        Rectangle2D.Double vp2 = new Rectangle2D.Double(vpx, viewportBounds.getY(), viewportBounds.getWidth(), viewportBounds.getHeight());
        Rectangle2D.Double vp3 = new Rectangle2D.Double(vpx - sizeInPixels.getWidth(), viewportBounds.getY(), viewportBounds.getWidth(), viewportBounds.getHeight());
        this.changeWindow((JXMapViewer)map, vp2);
        if (this.value != null && this.value.getSelectList() != null) {
            for (Route r : this.value.getSelectList()) {
                if (r.getPath() != null) {
                    this.paint(r.getPath(), map, g, (Rectangle2D)vp2, vp3, Color.RED, false);
                }
                this.paintStops(r, map, g, vp2, vp3, Color.RED, false);
            }
        }
    }

    public Object[] include(Point2D pClick, T map) {
        if (this.value != null && this.value.getSelectList() != null) {
            for (Route r : this.value.getSelectList()) {
                if (r.getPoints() == null) continue;
                for (Integer p : r.getPoints()) {
                    Coordinate cd = r.getCoord()[p];
                    GeoPosition point1 = new GeoPosition(cd.x, p == 0 ? cd.y + 1.0E-4 : cd.y);
                    Point2D point = map.getTileFactory().geoToPixel(point1, map.getZoom());
                    Point2D.Double p2 = new Point2D.Double(pClick.getX() - point.getX(), pClick.getY() - point.getY());
                    double dx = Math.abs(((Point2D)p2).getX());
                    double dy = Math.abs(((Point2D)p2).getY());
                    if (!(dx < 7.0) || !(dy < 7.0)) continue;
                    return new Object[]{r, p};
                }
            }
        }
        return null;
    }

    private void paint(T map, Graphics2D g, Rectangle2D vp2, Rectangle2D vp3, Color c, Route r, Integer p) {
        Coordinate cd = r.getCoord()[p];
        GeoPosition point1 = new GeoPosition(cd.x, p == 0 ? cd.y + 1.0E-4 : cd.y);
        Point2D point = map.getTileFactory().geoToPixel(point1, map.getZoom());
        if (vp2.contains(point)) {
            int x = (int)(point.getX() - vp2.getX());
            int y = (int)(point.getY() - vp2.getY());
            g.translate(x, y);
            String[] hint = new String[]{"\u041c\u0430\u0440\u0448\u0440\u0443\u0442: " + r.getNum(), "\u041d\u043e\u043c\u0435\u0440: " + p};
            FontMetrics f = g.getFontMetrics();
            Object[] pp = NodePainterData.getPolygonForHint(hint, f);
            int h = f.getHeight();
            int l = hint.length;
            if (pp != null) {
                Polygon p1 = (Polygon)pp[0];
                Rectangle2D bounds = (Rectangle2D)pp[1];
                Color cc = c.brighter().brighter();
                g.setColor(new Color(cc.getRed(), cc.getGreen(), cc.getBlue(), 150));
                g.fillPolygon(p1);
                Stroke s = g.getStroke();
                g.setColor(Color.black);
                g.drawPolygon(p1);
                g.setStroke(s);
                int i = 0;
                while (i < l) {
                    g.drawString(hint[i], (int)bounds.getMinX() + 5, (int)bounds.getMinY() + h + i * h);
                    ++i;
                }
            }
            g.translate(-x, -y);
        }
    }

    @Override
    public void setValue(IMapValue mapValueWithTrack) {
        this.value = (MapValueRoute)mapValueWithTrack;
    }
}

