/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.routesshow.tablo;

import java.awt.Color;
import java.awt.FontMetrics;
import java.util.Arrays;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.JLabel;

public class InformationPanel
extends JLabel {
    private static final long serialVersionUID = -7070569836887401310L;
    private int lines;
    private Line[] text;

    public InformationPanel(int num, int lines) {
        this.lines = lines;
        this.text = new Line[lines];
        this.setBorder(BorderFactory.createLineBorder(Color.black));
        this.setFont(this.getFont().deriveFont(8.0f));
        this.setToolTipText("\u041f\u0430\u043d\u0435\u043b\u044c " + num);
        new Thread(() -> {
            while (true) {
                this.screen();
                try {
                    Thread.sleep(400 + ThreadLocalRandom.current().nextInt(200));
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }).start();
    }

    public void addInfo(String info) {
        int i = 1;
        while (i < this.lines) {
            this.text[i - 1] = this.text[i];
            ++i;
        }
        this.text[this.lines - 1] = new Line();
        this.text[this.lines - 1].line = info;
    }

    public void screen() {
        FontMetrics m = this.getFontMetrics(this.getFont());
        this.setText(Arrays.stream(this.text).map(s -> {
            String ret = "";
            if (s != null) {
                ret = s.line.substring(s.pos);
                while (m.stringWidth(ret) > this.getWidth() - 2 && ret.length() != 0) {
                    ret = ret.substring(0, ret.length() - 1);
                }
            }
            return ret;
        }).collect(Collectors.joining("<br>", "<html>", "</html>")));
        int i = 0;
        while (i < this.lines) {
            if (this.text[i] != null) {
                ++this.text[i].pos;
                if (this.text[i].pos > this.text[i].line.length() - 1 || (double)m.stringWidth(this.text[i].line) < this.getSize().getWidth()) {
                    this.text[i].pos = 0;
                }
            }
            ++i;
        }
    }

    private static class Line {
        public String line;
        public int pos = 0;

        private Line() {
        }
    }
}

