/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.schoolbus;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.batik.swing.JSVGCanvas;
import org.jxmapviewer.viewer.GeoPosition;
import org.w3c.dom.svg.SVGDocument;
import ru.blok.common.core.CurrentProxyFactory;
import ru.blok.common.core.InitializedVariable;
import ru.blok.vms.ui.controlddh.CloseTrackAll;
import ru.blok.vms.ui.controlddh.map.TransportToView;
import ru.blok.vms.ui.controlddh.tree.TransportTreeNode;
import ru.blok.vms.ui.mapviewer.mapviewerwithtrack.MapValueWithTrack;
import ru.blok.vms.ui.schoolbus.map.MapViewerWithOneTrackBus;
import ru.blok.vms.ui.schoolbus.prop.MapPropertiesUISchoolBus;
import ru.blok.vms.ui.tracks.ChangeDeviceInTrackAll;
import ru.blok.vms.ui.tracks.TrackAll;
import ru.blok.vms.ui.transport.TransportDirectoryViewer;
import ru.infor.beanviewer.annotation.ActionViewer;
import ru.infor.beanviewer.annotation.Field;
import ru.infor.beanviewer.annotation.ListField;
import ru.infor.beanviewer.annotation.ListView;
import ru.infor.beanviewer.annotation.View;
import ru.infor.beanviewer.core.ActionCalculatedObject;
import ru.infor.beanviewer.core.UIFactory;
import ru.infor.beanviewer.viewer.action.PanelContext;
import ru.infor.beanviewer.viewer.action.ViewerContext;
import ru.infor.beanviewer.viewer.simple.RadioButtonViewer;
import ru.infor.beanviewer.viewer.simple.date.DateWithoutButton;
import ru.infor.client.soap.proxy.vms.Request4PlannedReroutingWSProxy;
import ru.infor.ws.objects.vms.Request4PlannedReroutingSearchCriteria;
import ru.infor.ws.objects.vms.entities.AbstractNDData;
import ru.infor.ws.objects.vms.entities.Request4PlannedRerouting;
import ru.infor.ws.objects.vms.entities.Transport;

@ListView(views={@View(title="\u041e\u0442\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u0435 \u0432\u0441\u0435\u0433\u043e \u043f\u0443\u0442\u0438", actions={@ActionViewer(clazz=CloseTrackAll.class)}, layoutKeys={"tabSplitPercentLayoutManager"}, properties={"minsize=1200x600"})})
public class TrackAllBus
extends TrackAll {
    TransportTreeNode node;
    static String day = "\u0414\u0435\u043d\u044c";
    static String period = "\u041f\u0435\u0440\u0438\u043e\u0434";
    private String type = day;
    private Date date = new Date();
    public List<SVGDocument> docH2 = new ArrayList<SVGDocument>();
    public List<JSVGCanvas> canvasH2 = new ArrayList<JSVGCanvas>();
    public List<GeoPosition> target = new ArrayList<GeoPosition>();
    MapPropertiesUISchoolBus mapPropertiesUISchoolBus;

    public TrackAllBus(String keyPage, TransportTreeNode transport) {
        super(keyPage);
        this.setTransportUI(transport.getTransportUI());
        this.getValue().setMain((Object)this);
        this.node = transport;
    }

    public TransportTreeNode getNode() {
        return this.node;
    }

    public void setNode(TransportTreeNode node) {
        this.node = node;
    }

    @ListField(fields={@Field(title="\u0414\u0430\u0442\u0430", order=9, viewer={DateWithoutButton.class}, propertiesLayout="Scroll1:Split1/h/l/0.3:m1:Tab1/\u0418\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f:m/wrap 1:Tab2/\u041e\u0431\u0449\u0430\u044f:00/fillx/n/#wrap", propertiesUI={"format=dd.MM.yyyy"})})
    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    @ListField(fields={@Field(title="", order=5, viewer={TypeViewer.class}, propertiesLayout="Scroll1:Split1/h/l/0.3:m1:Tab1/\u0418\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f:m/wrap 1:Tab2/\u041e\u0431\u0449\u0430\u044f:00/fillx/n/#spanx,wrap#spanx, wrap", changeAction={ChangeType.class})})
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Override
    protected synchronized void loadData() {
        if (!period.equals(this.type)) {
            Calendar c = Calendar.getInstance();
            c.setTime(this.date);
            c.set(11, 0);
            c.set(12, 0);
            c.set(13, 0);
            c.set(14, 0);
            this.dateFrom = c.getTime();
            c.set(11, 23);
            c.set(12, 59);
            c.set(13, 59);
            c.set(14, 999);
            this.dateTill = c.getTime();
        }
        super.loadData();
    }

    @Override
    @ListField(fields={@Field(title="", order=500, viewer={MapViewerWithOneTrackBus.class}, propertiesLayout="Scroll1:Split1/h/r/0.2:Scroll1:Split1/v/l/0.8")})
    public MapValueWithTrack getValue() {
        return super.getValue();
    }

    @Override
    @ListField(fields={@Field(title="\u0422\u0440\u0430\u043d\u0441\u043f\u043e\u0440\u0442 ", readOnly=true, content=Transport.class, order=50, propertiesLayout="Scroll1:Split1/h/l/0.3:m1:Tab1/\u0418\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f:m:Tab2/\u041e\u0431\u0449\u0430\u044f:2///#w 300, wrap", viewer={TransportDirectoryViewer.class}, changeAction={ChangeDeviceInTrackAll.class})})
    public Transport getTransport() {
        return super.getTransport();
    }

    public List<JSVGCanvas> getCanvasH2() {
        return this.canvasH2;
    }

    public List<GeoPosition> getTarget() {
        return this.target;
    }

    @Override
    public synchronized void reload(List<AbstractNDData> list1) {
        super.reload(list1);
        this.canvasH2.stream().forEach(o -> {
            o.dispose();
            if (o.getParent() != null) {
                o.getParent().remove((Component)o);
            }
        });
        this.docH2 = new ArrayList<SVGDocument>();
        this.canvasH2 = new ArrayList<JSVGCanvas>();
        this.target = new ArrayList<GeoPosition>();
        Request4PlannedReroutingWSProxy reroutingWSProxy = (Request4PlannedReroutingWSProxy)CurrentProxyFactory.getProxy(Request4PlannedRerouting.class);
        Request4PlannedReroutingSearchCriteria sc2 = new Request4PlannedReroutingSearchCriteria();
        sc2.setCount(Integer.valueOf(Integer.MAX_VALUE));
        sc2.setBeginDateTill(this.dateTill);
        sc2.setEndDateFrom(this.dateFrom);
        sc2.setCancellationRequest(Integer.valueOf(0));
        sc2.setTransportIdList(new Long[]{this.getTransport().getId()});
        Object[] oo = reroutingWSProxy.getList(InitializedVariable.context, sc2).getObjList();
        if (oo != null && oo.length > 0) {
            Arrays.stream(oo).forEach(o -> {
                Request4PlannedRerouting b = (Request4PlannedRerouting)o;
                TransportToView.initTargetR(b, this.docH2, this.canvasH2, this.target);
            });
        }
    }

    public MapPropertiesUISchoolBus getMapPropertiesUISchoolBus() {
        return this.mapPropertiesUISchoolBus;
    }

    public void setMapPropertiesUISchoolBus(MapPropertiesUISchoolBus mapPropertiesUISchoolBus) {
        this.mapPropertiesUISchoolBus = mapPropertiesUISchoolBus;
    }

    public static class ChangeType
    extends ActionCalculatedObject {
        public void actionPerformed(Object message) {
            ((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getPanel().updateField(((ViewerContext)this.getContext()).getPresentator());
            Object o = ((ViewerContext)this.getContext()).getPresentator().getViewer().getValue();
            boolean rt = true;
            if (period.equals(o)) {
                rt = false;
            }
            ((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getPanel().getPresentatorForName("dateFrom").getViewer().setEditable(!rt);
            ((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getPanel().getPresentatorForName("timeFrom").getViewer().setEditable(!rt);
            ((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getPanel().getPresentatorForName("dateTill").getViewer().setEditable(!rt);
            ((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getPanel().getPresentatorForName("timeTill").getViewer().setEditable(!rt);
            ((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getPanel().getPresentatorForName("date").getViewer().setEditable(rt);
        }
    }

    public static class TypeViewer<T>
    extends RadioButtonViewer<T> {
        List<String> l;

        public TypeViewer(UIFactory<T> factory) {
            super(factory);
        }

        public List<?> getRadioElement() {
            this.l = new ArrayList<String>();
            this.l.add(day);
            this.l.add(period);
            return this.l;
        }
    }
}

