/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.schoolbus.map;

import com.vividsolutions.jts.geom.Polygon;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.sql.SQLException;
import org.apache.batik.swing.JSVGCanvas;
import org.jxmapviewer.JXMapViewer;
import org.jxmapviewer.viewer.GeoPosition;
import org.postgis.Geometry;
import org.postgis.MultiPolygon;
import ru.blok.common.core.CurrentProxyFactory;
import ru.blok.common.core.InitializedVariable;
import ru.blok.vms.ui.mapviewer.mapviewerwithtrack.view.NodePainterDataTraclAll;
import ru.blok.vms.ui.mapviewer.mapviewerwithtrack.view.RoutePainter;
import ru.blok.vms.ui.schoolbus.TrackAllBus;
import ru.blok.vms.ui.schoolbus.prop.MapPropertiesUISchoolBus;
import ru.infor.client.soap.proxy.vms.RouteWSProxy;
import ru.infor.ws.objects.vms.entities.Route;
import ru.infor.ws.objects.vms.entities.ext.RouteExt;

public class NodePainterDataTraclAllBus<T extends JXMapViewer>
extends NodePainterDataTraclAll<T> {
    RouteWSProxy routeWSProxy = (RouteWSProxy)CurrentProxyFactory.getProxy(Route.class);

    @Override
    public synchronized void doPaint(Graphics2D g, T map, int width, int height) {
        super.doPaint(g, map, width, height);
        Rectangle viewportBounds = map.getViewportBounds();
        int zoom = map.getZoom();
        Dimension sizeInTiles = map.getTileFactory().getMapSize(zoom);
        int tileSize = map.getTileFactory().getTileSize(zoom);
        Dimension sizeInPixels = new Dimension(sizeInTiles.width * tileSize, sizeInTiles.height * tileSize);
        double vpx = viewportBounds.getX();
        while (vpx < 0.0) {
            vpx += sizeInPixels.getWidth();
        }
        while (vpx > sizeInPixels.getWidth()) {
            vpx -= sizeInPixels.getWidth();
        }
        Rectangle2D.Double vp2 = new Rectangle2D.Double(vpx, viewportBounds.getY(), viewportBounds.getWidth(), viewportBounds.getHeight());
        new Rectangle2D.Double(vpx - sizeInPixels.getWidth(), viewportBounds.getY(), viewportBounds.getWidth(), viewportBounds.getHeight());
        TrackAllBus bus = (TrackAllBus)((Object)this.value.getMain());
        MapPropertiesUISchoolBus prop = bus.getMapPropertiesUISchoolBus();
        for (JSVGCanvas s : bus.getCanvasH2()) {
            if (s.getParent() != null) continue;
            map.add((Component)s);
        }
        int i = 0;
        while (i < bus.getTarget().size()) {
            GeoPosition t = bus.getTarget().get(i);
            Point2D point2 = map.getTileFactory().geoToPixel(t, map.getZoom());
            int x2 = (int)(point2.getX() - ((RectangularShape)vp2).getX());
            int y2 = (int)(point2.getY() - ((RectangularShape)vp2).getY());
            Color c = new Color(prop.getColorPoint());
            g.setColor(new Color(c.getRed(), c.getGreen(), c.getBlue(), prop.getAlphaPoint()));
            g.fillOval(x2 - 3, y2 - 3, 7, 7);
            JSVGCanvas canvas3 = bus.getCanvasH2().get(i);
            Point pt = new Point(x2 - 7, y2 - canvas3.getHeight() + 20);
            canvas3.setLocation(pt);
            canvas3.setVisible(true);
            ++i;
        }
        if (bus.getNode().getRouteId() != null) {
            if (bus.getNode().getTransportToView().getRoute() == null) {
                RouteExt r2 = (RouteExt)this.routeWSProxy.getCurrentObject(InitializedVariable.context, bus.getNode().getRouteId());
                bus.getNode().getTransportToView().setRoute(r2);
                if (r2.getAreaRouteGeom() != null) {
                    try {
                        Object currentPolygon = null;
                        currentPolygon = r2.getAreaRouteGeom().contains("MULTIPOLYGON") ? new MultiPolygon(r2.getAreaRouteGeom()) : new org.postgis.Polygon(r2.getAreaRouteGeom());
                        r2.setCurrentPolygon((Geometry)currentPolygon);
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                }
            }
            Color c = new Color(prop.getColorPoint());
            if (bus.getNode().getTransportToView().getRoute().getCurrentPolygon() != null) {
                Polygon window = RoutePainter.getLatLonWindow(map, vp2);
                RoutePainter.paintArea(bus.getNode().getTransportToView().getRoute(), window, g, map, vp2, c, prop.getAlphaPoint());
            }
        }
    }
}

