/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.schoolbus.map;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.geom.impl.CoordinateArraySequence;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.sql.SQLException;
import org.apache.batik.swing.JSVGCanvas;
import org.apache.batik.transcoder.TranscoderException;
import org.jxmapviewer.JXMapViewer;
import org.jxmapviewer.viewer.GeoPosition;
import org.postgis.Geometry;
import org.postgis.MultiPolygon;
import org.postgis.Point;
import ru.blok.common.core.CurrentProxyFactory;
import ru.blok.common.core.InitializedVariable;
import ru.blok.vms.ui.controlddh.map.MapValueTransport;
import ru.blok.vms.ui.controlddh.map.TransportToView;
import ru.blok.vms.ui.mapviewer.imap.IMapValue;
import ru.blok.vms.ui.mapviewer.mapviewerwithtrack.view.MapViewPainter;
import ru.blok.vms.ui.mapviewer.mapviewerwithtrack.view.RoutePainter;
import ru.blok.vms.ui.route.routegeom.RouteGeomBuilder;
import ru.blok.vms.ui.schoolbus.prop.MapPropertiesUISchoolBus;
import ru.infor.client.soap.proxy.vms.RouteWSProxy;
import ru.infor.ws.objects.vms.entities.Route;
import ru.infor.ws.objects.vms.entities.ext.RouteExt;

public class PainterData<T extends JXMapViewer>
extends MapViewPainter<T> {
    RouteWSProxy routeWSProxy = (RouteWSProxy)CurrentProxyFactory.getProxy(Route.class);
    MapValueTransport value;

    @Override
    public void doPaint(Graphics2D g, T map, int width, int height) {
        Rectangle viewportBounds = map.getViewportBounds();
        int zoom = map.getZoom();
        Dimension sizeInTiles = map.getTileFactory().getMapSize(zoom);
        int tileSize = map.getTileFactory().getTileSize(zoom);
        Dimension sizeInPixels = new Dimension(sizeInTiles.width * tileSize, sizeInTiles.height * tileSize);
        double vpx = viewportBounds.getX();
        while (vpx < 0.0) {
            vpx += sizeInPixels.getWidth();
        }
        while (vpx > sizeInPixels.getWidth()) {
            vpx -= sizeInPixels.getWidth();
        }
        Rectangle2D.Double vp2 = new Rectangle2D.Double(vpx, viewportBounds.getY(), viewportBounds.getWidth(), viewportBounds.getHeight());
        TransportToView wsel = null;
        if (this.value != null) {
            for (TransportToView w : this.value.getInformation().view.values()) {
                if (w.isSelect()) {
                    wsel = w;
                    continue;
                }
                if (w.getData() == null) continue;
                try {
                    if (w.getComponent().getParent() == null) {
                        map.add((Component)w.getComponent());
                        if (w.getData() != null && w.getData().getData().getDirection() != null) {
                            w.setAngle(w.getData().getData().getDirection());
                        }
                    }
                    this.paintImage(g, map, w, w.getH(), w.getW(), vp2);
                }
                catch (TranscoderException e) {
                    e.printStackTrace();
                }
            }
        }
        if (wsel != null && wsel.getData() != null) {
            try {
                if (wsel.getComponent().getParent() == null) {
                    map.add((Component)wsel.getComponent());
                    if (wsel.getData() != null && wsel.getData().getData().getDirection() != null) {
                        wsel.setAngle(wsel.getData().getData().getDirection());
                    }
                }
                if (wsel.getComponentH().getParent() == null) {
                    map.add((Component)wsel.getComponentH());
                }
                for (JSVGCanvas s : wsel.getComponentH2()) {
                    if (s.getParent() != null) continue;
                    map.add((Component)s);
                }
                this.paintImage(g, map, wsel, wsel.getH(), wsel.getW(), vp2);
            }
            catch (TranscoderException e) {
                e.printStackTrace();
            }
        }
    }

    public void paintImage(Graphics2D g, T map, TransportToView wv, int h, int w, Rectangle2D vp2) throws TranscoderException {
        block8: {
            JSVGCanvas canvas2;
            block7: {
                GeoPosition gp = wv.getGeoposition();
                Point2D point = map.getTileFactory().geoToPixel(gp, map.getZoom());
                int x = (int)(point.getX() - vp2.getX());
                int y = (int)(point.getY() - vp2.getY());
                JSVGCanvas canvas = (JSVGCanvas)wv.getComponent();
                Dimension2D d = canvas.getSVGDocumentSize();
                if (d == null) {
                    d = canvas.getSize();
                }
                wv.resize();
                java.awt.Point pt = new java.awt.Point(x - (int)d.getWidth() / 2, y - (int)d.getHeight() / 2);
                canvas.setLocation(pt);
                map.setComponentZOrder((Component)canvas, map.getComponentCount() - 1);
                canvas2 = (JSVGCanvas)wv.getComponentH();
                if (!wv.isSelect()) break block7;
                map.setComponentZOrder((Component)canvas, 0);
                wv.resize2();
                wv.resize3();
                pt = new java.awt.Point(x - wv.getComponent().getWidth() / 2, y - wv.getComponentH().getHeight() + 20);
                MapPropertiesUISchoolBus prop = (MapPropertiesUISchoolBus)this.value.mapViewer.getUIProperties();
                canvas2.setLocation(pt);
                canvas2.setVisible(true);
                map.setComponentZOrder((Component)canvas2, 1);
                int i = 0;
                while (i < wv.getTarget().size()) {
                    GeoPosition t = wv.getTarget().get(i);
                    Point2D point2 = map.getTileFactory().geoToPixel(t, map.getZoom());
                    int x2 = (int)(point2.getX() - vp2.getX());
                    int y2 = (int)(point2.getY() - vp2.getY());
                    Color c = new Color(prop.getColorPoint());
                    g.setColor(new Color(c.getRed(), c.getGreen(), c.getBlue(), prop.getAlphaPoint()));
                    BasicStroke s = new BasicStroke(3.0f, 1, 0, 3.0f, new float[]{10.0f, 5.0f}, 0.0f);
                    Stroke old = g.getStroke();
                    g.setStroke(s);
                    g.drawLine(x, y, x2, y2);
                    g.setStroke(old);
                    g.fillOval(x2 - 3, y2 - 3, 7, 7);
                    org.postgis.Polygon p = RouteGeomBuilder.getDefaultPolygonStation(t.getLatitude(), t.getLongitude(), prop.getRadius());
                    RoutePainter.paintPolygon((Geometry)p, map, g, vp2, c, 100);
                    JSVGCanvas canvas3 = wv.getComponentH2().get(i);
                    map.setComponentZOrder((Component)canvas3, 2);
                    pt = new java.awt.Point(x2 - 7, y2 - canvas3.getHeight() + 20);
                    canvas3.setLocation(pt);
                    canvas3.setVisible(true);
                    ++i;
                }
                if (wv.getRouteId() == null) break block8;
                if (wv.getRoute() == null) {
                    RouteExt r2 = (RouteExt)this.routeWSProxy.getCurrentObject(InitializedVariable.context, wv.getRouteId());
                    wv.setRoute(r2);
                    if (r2.getAreaRouteGeom() != null) {
                        try {
                            Object currentPolygon = null;
                            currentPolygon = r2.getAreaRouteGeom().contains("MULTIPOLYGON") ? new MultiPolygon(r2.getAreaRouteGeom()) : new org.postgis.Polygon(r2.getAreaRouteGeom());
                            r2.setCurrentPolygon((Geometry)currentPolygon);
                        }
                        catch (SQLException e) {
                            e.printStackTrace();
                        }
                    }
                }
                Color c = new Color(prop.getColorPoint());
                if (wv.getRoute().getCurrentPolygon() == null) break block8;
                Polygon window = RoutePainter.getLatLonWindow(map, vp2);
                com.vividsolutions.jts.geom.Geometry jtsp = RoutePainter.paintArea(wv.getRoute(), window, g, map, vp2, c, prop.getAlphaPoint());
                Point p = wv.getRoute().getCurrentPolygon().getFirstPoint();
                Point2D point2 = map.getTileFactory().geoToPixel(new GeoPosition(p.getY(), p.getX()), map.getZoom());
                int x2 = (int)(point2.getX() - vp2.getX());
                int y2 = (int)(point2.getY() - vp2.getY());
                GeometryFactory f = new GeometryFactory(new PrecisionModel(PrecisionModel.FLOATING), 4326);
                com.vividsolutions.jts.geom.Point pd = new com.vividsolutions.jts.geom.Point((CoordinateSequence)new CoordinateArraySequence(new Coordinate[]{new Coordinate(gp.getLongitude(), gp.getLatitude())}), f);
                if (jtsp.contains((com.vividsolutions.jts.geom.Geometry)pd)) break block8;
                g.setColor(new Color(c.getRed(), c.getGreen(), c.getBlue(), prop.getAlphaPoint()));
                BasicStroke s = new BasicStroke(3.0f, 1, 0, 3.0f, new float[]{10.0f, 5.0f}, 0.0f);
                Stroke old = g.getStroke();
                g.setStroke(s);
                g.drawLine(x, y, x2, y2);
                g.setStroke(old);
                break block8;
            }
            canvas2.setVisible(false);
            for (JSVGCanvas s : wv.getComponentH2()) {
                s.setVisible(false);
            }
        }
    }

    @Override
    public void setValue(IMapValue mapValueWithTrack) {
        this.value = (MapValueTransport)mapValueWithTrack;
    }
}

