/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.sownarea.geom;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.Point2D;
import java.util.List;
import javax.swing.JComponent;
import org.jxmapviewer.JXMapViewer;
import org.jxmapviewer.viewer.GeoPosition;
import org.postgis.Point;
import ru.blok.vms.ui.mapviewer.MapViewer;
import ru.blok.vms.ui.sownarea.geom.LinePainter;
import ru.blok.vms.ui.sownarea.geom.PainterArea;
import ru.infor.beanviewer.core.UIFactory;
import ru.infor.ws.objects.vms.entities.ext.SownAreaExt;

public class AreaViewer
extends MapViewer {
    LinePainter<JXMapViewer> aPainter;
    PainterArea<JXMapViewer> pRoad;

    public AreaViewer(UIFactory<JComponent> factory) {
        super(factory);
    }

    public void repaint(List<SownAreaExt> lists) {
        this.pRoad.setLists(lists);
        this.zoomToTracks();
    }

    @Override
    public void setValue(Object arg0) {
        super.setValue(arg0);
        this.aPainter.listCoord.clear();
        this.zoomToTracks();
    }

    @Override
    protected void init() {
        super.init();
        this.aPainter = new LinePainter();
        this.painter.addPainter(this.aPainter);
        this.pRoad = new PainterArea();
        this.painter.addPainter(this.pRoad);
        this.map.getMainMap().addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                AreaViewer.this.mouseClickedOnMap(e);
            }
        });
    }

    @Override
    protected boolean canGoToData() {
        return true;
    }

    @Override
    protected void mouseMovedN(MouseEvent e) {
    }

    @Override
    protected void mouseWheelMovedN(MouseWheelEvent e) {
    }

    protected void mouseClickedOnMap(MouseEvent e) {
        if (e.isShiftDown()) {
            double x = this.map.getMainMap().getCenter().getX() + e.getPoint().getX() - (double)(this.map.getMainMap().getWidth() / 2);
            double y = this.map.getMainMap().getCenter().getY() + e.getPoint().getY() - (double)(this.map.getMainMap().getHeight() / 2);
            GeoPosition gp = this.map.getMainMap().getTileFactory().pixelToGeo((Point2D)new Point2D.Double(x, y), this.map.getMainMap().getZoom());
            if (e.isControlDown()) {
                this.aPainter.listCoord.clear();
            }
            this.aPainter.listCoord.add(gp);
            this.repaint();
        }
    }

    @Override
    protected Double[] getMinMax() {
        Double minLat = null;
        Double maxLat = null;
        Double minLon = null;
        Double maxLon = null;
        if (this.pRoad != null && this.pRoad.getLists() != null) {
            for (SownAreaExt p : this.pRoad.getLists()) {
                if (p.getCurrentPolygon() == null) continue;
                int i = 0;
                while (i < p.getCurrentPolygon().numPoints()) {
                    Point d = p.getCurrentPolygon().getPoint(i);
                    if (minLat == null || d.getY() < minLat) {
                        minLat = d.getY();
                    }
                    if (maxLat == null || d.getY() > maxLat) {
                        maxLat = d.getY();
                    }
                    if (minLon == null || d.getX() < minLon) {
                        minLon = d.getX();
                    }
                    if (maxLon == null || d.getX() > maxLon) {
                        maxLon = d.getX();
                    }
                    ++i;
                }
            }
        }
        if (minLat == null) {
            return null;
        }
        return new Double[]{minLat, maxLat, minLon, maxLon};
    }
}

