/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.sownarea.geom;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import org.jxmapviewer.JXMapViewer;
import org.jxmapviewer.viewer.GeoPosition;
import ru.blok.vms.ui.mapviewer.imap.IMapValue;
import ru.blok.vms.ui.mapviewer.mapviewerwithtrack.view.MapViewPainter;

public class LinePainter<T extends JXMapViewer>
extends MapViewPainter<T> {
    List<GeoPosition> listCoord = new ArrayList<GeoPosition>();

    @Override
    public void doPaint(Graphics2D g, T map, int width, int height) {
        Rectangle viewportBounds = map.getViewportBounds();
        int zoom = map.getZoom();
        Dimension sizeInTiles = map.getTileFactory().getMapSize(zoom);
        int tileSize = map.getTileFactory().getTileSize(zoom);
        Dimension sizeInPixels = new Dimension(sizeInTiles.width * tileSize, sizeInTiles.height * tileSize);
        double vpx = viewportBounds.getX();
        while (vpx < 0.0) {
            vpx += sizeInPixels.getWidth();
        }
        while (vpx > sizeInPixels.getWidth()) {
            vpx -= sizeInPixels.getWidth();
        }
        Rectangle2D.Double vp2 = new Rectangle2D.Double(vpx, viewportBounds.getY(), viewportBounds.getWidth(), viewportBounds.getHeight());
        Rectangle2D.Double vp3 = new Rectangle2D.Double(vpx - sizeInPixels.getWidth(), viewportBounds.getY(), viewportBounds.getWidth(), viewportBounds.getHeight());
        Color w = new Color(Color.RED.getRed(), Color.RED.getGreen(), Color.RED.getBlue(), 70);
        Color w1 = new Color(Color.RED.getRed(), Color.RED.getGreen(), Color.RED.getBlue(), 250);
        if (this.listCoord.size() > 0) {
            this.paintCoordn(this.listCoord, map, g, vp2, vp3, w, w1);
        }
    }

    protected void paintCoordn(List<GeoPosition> l, T map, Graphics2D g, Rectangle2D vp2, Rectangle2D vp3, Color w, Color w1) {
        Polygon pp = new Polygon();
        int[] xPoints = new int[l.size()];
        int[] yPoints = new int[l.size()];
        int i = 0;
        while (i < l.size()) {
            Point2D point = map.getTileFactory().geoToPixel(l.get(i), map.getZoom());
            int x = (int)(point.getX() - vp2.getX());
            int y = (int)(point.getY() - vp2.getY());
            pp.addPoint(x, y);
            xPoints[i] = x;
            yPoints[i] = y;
            ++i;
        }
        g.setColor(w1);
        g.drawPolyline(xPoints, yPoints, l.size());
    }

    @Override
    public void setValue(IMapValue mapValueWithTrack) {
    }
}

