/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.sownarea.geom;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.util.List;
import org.jxmapviewer.JXMapViewer;
import ru.blok.vms.ui.mapviewer.imap.IMapValue;
import ru.blok.vms.ui.mapviewer.mapviewerwithtrack.view.MapViewPainter;
import ru.blok.vms.ui.mapviewer.mapviewerwithtrack.view.RoutePainter;
import ru.blok.vms.ui.sownarea.geom.SownAreaGeom;
import ru.infor.ws.objects.vms.entities.ext.SownAreaExt;

public class PainterArea<T extends JXMapViewer>
extends MapViewPainter<T> {
    List<SownAreaExt> lists;

    public List<SownAreaExt> getLists() {
        return this.lists;
    }

    public void setLists(List<SownAreaExt> lists) {
        this.lists = lists;
        if (lists != null) {
            for (SownAreaExt s : lists) {
                if (s.getCurrentPolygon() != null) continue;
                SownAreaGeom.init(s);
            }
        }
    }

    @Override
    public void doPaint(Graphics2D g, T map, int width, int height) {
        Rectangle viewportBounds = map.getViewportBounds();
        int zoom = map.getZoom();
        Dimension sizeInTiles = map.getTileFactory().getMapSize(zoom);
        int tileSize = map.getTileFactory().getTileSize(zoom);
        Dimension sizeInPixels = new Dimension(sizeInTiles.width * tileSize, sizeInTiles.height * tileSize);
        double vpx = viewportBounds.getX();
        while (vpx < 0.0) {
            vpx += sizeInPixels.getWidth();
        }
        while (vpx > sizeInPixels.getWidth()) {
            vpx -= sizeInPixels.getWidth();
        }
        Rectangle2D.Double vp2 = new Rectangle2D.Double(vpx, viewportBounds.getY(), viewportBounds.getWidth(), viewportBounds.getHeight());
        new Rectangle2D.Double(vpx - sizeInPixels.getWidth(), viewportBounds.getY(), viewportBounds.getWidth(), viewportBounds.getHeight());
        if (this.lists != null) {
            for (SownAreaExt r : this.lists) {
                if (r.getCurrentPolygon() == null) continue;
                Color c = new Color(r.getColor());
                RoutePainter.paintPolygon(r.getCurrentPolygon(), map, g, (Rectangle2D)vp2, c, (int)r.getTransparency());
            }
        }
    }

    @Override
    public void setValue(IMapValue mapValueWithTrack) {
    }
}

