/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.statusdevice;

import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import ru.blok.common.core.CommonMethods;
import ru.blok.common.core.CommonObjectWithKey;
import ru.blok.common.core.CurrentProxyFactory;
import ru.blok.common.core.InitializedVariable;
import ru.blok.common.core.PeriodDateClass;
import ru.blok.common.report.RunReport;
import ru.blok.common.ui.list.ObjectUIList;
import ru.blok.common.utils.CoordinatesDownTown;
import ru.blok.vms.ui.event.ListEventsViewer;
import ru.blok.vms.ui.event.ObjectUIListWithAutoRefresh;
import ru.blok.vms.ui.mapviewer.mapviewerwithtrack.MapValueWithTrack;
import ru.blok.vms.ui.mapviewer.mapviewerwithtrack.MapViewerWithOneTrack;
import ru.blok.vms.ui.statusdevice.ListStatusDeviceViewer;
import ru.blok.vms.ui.statusdevice.StatusDevicePanelBtn;
import ru.blok.vms.ui.tracks.TrackAll;
import ru.blok.vms.ui.tracks.cache.CacheForStatusDevice;
import ru.infor.beanviewer.annotation.ActionField;
import ru.infor.beanviewer.annotation.ClassView;
import ru.infor.beanviewer.annotation.Field;
import ru.infor.beanviewer.annotation.ListField;
import ru.infor.beanviewer.annotation.ListView;
import ru.infor.beanviewer.annotation.PanelField;
import ru.infor.beanviewer.annotation.View;
import ru.infor.beanviewer.core.FieldPresentation;
import ru.infor.beanviewer.core.ManagerBeanPanel;
import ru.infor.beanviewer.viewer.BigContentViewer;
import ru.infor.beanviewer.viewer.action.PanelContext;
import ru.infor.client.soap.proxy.vms.EventUIWSProxy;
import ru.infor.client.soap.proxy.vms.NDDataWSProxy;
import ru.infor.client.soap.proxy.vms.NavigationDeviceWSProxy;
import ru.infor.client.soap.proxy.vms.TransportGroupWSProxy;
import ru.infor.client.soap.proxy.vms.TransportWSProxy;
import ru.infor.ws.objects.core.SortObject;
import ru.infor.ws.objects.events.EventSearchCriteria;
import ru.infor.ws.objects.events.EventUI;
import ru.infor.ws.objects.vms.MileageSearchCriteria;
import ru.infor.ws.objects.vms.NDDataSearchCriteria;
import ru.infor.ws.objects.vms.NDDataThin;
import ru.infor.ws.objects.vms.TransportSearchCriteria;
import ru.infor.ws.objects.vms.entities.AbstractNDData;
import ru.infor.ws.objects.vms.entities.NDData;
import ru.infor.ws.objects.vms.entities.NavigationDevice;
import ru.infor.ws.objects.vms.entities.Transport;
import ru.infor.ws.objects.vms.entities.TransportGroup;
import ru.infor.ws.objects.vms.entities.ext.TransportExt;
import ru.infor.ws.objects.vms.ext.StatusDeviceExt;
import ru.infor.ws.proxy.UniversalListProxy;
import ru.infor.ws.proxy.interfaces.InvocationContext;

@Deprecated
@ListView(views={@View(title="", actions={}, layoutKeys={"tabSplitPercentLayoutManager"})})
public class StatusDeviceList
extends CommonObjectWithKey {
    EventUIWSProxy eventProxy = (EventUIWSProxy)CurrentProxyFactory.getProxy(EventUI.class);
    EventSearchCriteria eventSC = new EventSearchCriteria();
    NavigationDeviceWSProxy ndProxy = (NavigationDeviceWSProxy)CurrentProxyFactory.getProxy(NavigationDevice.class);
    NDDataWSProxy ndDataWSProxy = (NDDataWSProxy)CurrentProxyFactory.getProxy(NDData.class);
    TransportWSProxy transportWSProxy = (TransportWSProxy)CurrentProxyFactory.getProxy(Transport.class);
    MapValueWithTrack value;
    private List<EventUI> events;
    private List<StatusDeviceExt> ndItems;
    HashMap<String, String> sp = null;
    List<Long> initiatorIdList = new ArrayList<Long>();
    Date dateFrom;
    Date dateTill;
    Integer dependentEL = 1;
    Integer displayMap = 0;
    Integer tailInMinute = 10;
    HashMap<Long, Date> mapLastDate = new HashMap();
    TransportGroup group = null;
    private CacheForStatusDevice cache = new CacheForStatusDevice();
    boolean refreshData = true;
    boolean changedLastDate = true;
    PanelContext currentPC;
    Double[] coord = null;
    static Long periodOutside = 86400000L;
    static Long timeRepeat = 10000L;
    static Long timeRepeatOccurence = 0L;
    static Long monthLength = 2592000000L;
    static int countMonthLength = 2;
    static int countEvents = 5;
    Double minSpeed = 5.4;
    Long periodDays4Track = 7776000000L;
    List<Object> selDetP;
    List<Object> selDetV;

    public void beforeShow(PanelContext pc) {
        this.setCurrentPC(pc);
        FieldPresentation fp = pc.getPanel().getPresentatorForName("ndItems");
        ManagerBeanPanel pp = ((BigContentViewer)fp.getViewer()).getManagerBeanPanelForName("Update");
        StatusDevicePanelBtn panBtn = (StatusDevicePanelBtn)pp.getObject();
        panBtn.setDateFrom(this.getDateFrom());
        panBtn.setDateTill(this.getDateTill());
        panBtn.setDependentEL(1);
        panBtn.setDisplayMap(0);
        if (this.getGroup() != null) {
            panBtn.setGroup(this.getGroup());
        }
        pp.updateUI();
    }

    public void beforeDestroy(PanelContext pc) {
        this.setRefreshData(false);
        ((ObjectUIListWithAutoRefresh)((Object)this.events)).stopAutoRefresh();
    }

    public StatusDeviceList(String keyPage) {
        super(keyPage);
        if (InitializedVariable.getWorkplaceId((String)keyPage) != null) {
            this.sp = InitializedVariable.runtimeParameters((Long)InitializedVariable.getWorkplaceId((String)keyPage));
        }
        PeriodDateClass pd = new PeriodDateClass(this.sp);
        this.setDateFrom(pd.getFirstDate());
        this.setDateTill(pd.getLastDate());
        String codeTransportGroup = "01";
        if (this.sp.get("CodeTransportGroup") != null) {
            codeTransportGroup = this.sp.get("CodeTransportGroup");
        }
        if (this.sp.get("MinSpeedForMileage") != null) {
            this.minSpeed = Double.valueOf(this.sp.get("MinSpeedForMileage"));
        }
        if (this.sp.get("PeriodInDaysForTrack") != null) {
            this.periodDays4Track = Long.valueOf(this.sp.get("PeriodInDaysForTrack"));
        }
        TransportGroupWSProxy transportGWSProxy = (TransportGroupWSProxy)CurrentProxyFactory.getProxy(TransportGroup.class);
        this.setGroup((TransportGroup)CommonMethods.checkDirectories((String)codeTransportGroup, (UniversalListProxy)transportGWSProxy, (String)""));
        this.coord = CoordinatesDownTown.getCoordinatesDownTown(this.sp);
        this.value = new MapValueWithTrack(this.coord[0], this.coord[1], this.coord[2].intValue(), null);
        this.init();
    }

    public void init() {
        this.setRefreshData(false);
        this.initData();
        this.initEvents();
        this.startCycle();
    }

    private void initData() {
        this.ndItems = new ArrayList<StatusDeviceExt>();
        this.initiatorIdList.clear();
        TransportSearchCriteria transportSC = new TransportSearchCriteria();
        if (this.getGroup() != null) {
            transportSC.setGroupIdList(new Long[]{this.getGroup().getId()});
        }
        transportSC.setCount(Integer.valueOf(Integer.MAX_VALUE));
        TransportWSProxy.SearchResultListTransport sr = this.transportWSProxy.getList(InitializedVariable.context, transportSC);
        if (sr.isEmpty()) {
            return;
        }
        int i = 0;
        while (i < sr.getObjList().length) {
            TransportExt trans = (TransportExt)((Object)sr.getObjList()[i]);
            trans.setCurrentDate(this.getDateFrom());
            NavigationDevice nd = trans.getCurrentDevice();
            StatusDeviceExt sd1 = new StatusDeviceExt();
            sd1.setName(trans.getMarkaGosNomer());
            sd1.setOccurence(0);
            sd1.setTransportId(trans.getId());
            if (nd != null) {
                sd1.setDeviceId(nd.getId());
                sd1.setCode(nd.getCode());
                sd1.setLevelMissing(5L);
                sd1.setCommunication("\u0437\u0430\u043f\u0440\u043e\u0441 \u0434\u0430\u043d\u043d\u044b\u0445...");
                this.initiatorIdList.add(nd.getId());
            } else {
                sd1.setCode("\u043d\u0435 \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d \u043f\u0440\u0438\u0431\u043e\u0440");
            }
            this.ndItems.add(sd1);
            ++i;
        }
        i = 0;
        while (i < this.ndItems.size()) {
            this.calcLastData(i);
            ++i;
        }
    }

    public void startCycle() {
        new Thread(){

            @Override
            public void run() {
                System.out.println("beginning startCycle - " + new SimpleDateFormat("dd.MM.yyyy HH:mm:ss").format(new Date()));
                StatusDeviceList.this.setRefreshData(true);
                if (StatusDeviceList.this.getDateTill().compareTo(new Date()) < 0) {
                    StatusDeviceList.this.setRefreshData(false);
                }
                while (StatusDeviceList.this.ndItems.size() > 0) {
                    if (!StatusDeviceList.this.isRefreshData()) break;
                    System.out.println(" start repeat....");
                    StatusDeviceList.this.setChangedLastDate(false);
                    int i = 0;
                    while (i < StatusDeviceList.this.ndItems.size()) {
                        if (!StatusDeviceList.this.isRefreshData()) break;
                        StatusDeviceExt sde = (StatusDeviceExt)StatusDeviceList.this.ndItems.get(i);
                        if (sde.getOccurence() != 0) {
                            TransportExt trans;
                            if (sde.getDeviceId() == null && (trans = (TransportExt)((Object)StatusDeviceList.this.transportWSProxy._universalGetCurrentObject((InvocationContext)InitializedVariable.context, sde.getTransportId()))) != null) {
                                trans.setCurrentDate(StatusDeviceList.this.getDateFrom());
                                NavigationDevice nd = trans.getCurrentDevice();
                                if (nd != null) {
                                    sde.setDeviceId(nd.getId());
                                    sde.setCode(nd.getCode());
                                    StatusDeviceList.this.initiatorIdList.add(nd.getId());
                                    StatusDeviceList.this.setChangedLastDate(true);
                                }
                            }
                            if (sde.getDeviceId() != null) {
                                Date lastDate = StatusDeviceList.this.mapLastDate.get(sde.getDeviceId());
                                if (lastDate == null) {
                                    lastDate = StatusDeviceList.this.getDateFrom();
                                }
                                if (StatusDeviceList.this.mapLastDate.get((sde = StatusDeviceList.this.calcStatusDevice(lastDate, sde.getDeviceId(), sde)).getDeviceId()) != null && lastDate.compareTo(StatusDeviceList.this.mapLastDate.get(sde.getDeviceId())) < 0) {
                                    StatusDeviceList.this.setChangedLastDate(true);
                                    System.out.println("   --- \u0438\u0437\u043c\u0435\u043d\u0438\u043b\u0430\u0441\u044c \u0434\u043b\u044f " + sde.getCode());
                                }
                            } else {
                                sde.setOccurence(0);
                                sde.setCode("\u043d\u0435 \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d \u043f\u0440\u0438\u0431\u043e\u0440");
                            }
                        }
                        ++i;
                    }
                    if (StatusDeviceList.this.isChangedLastDate()) {
                        StatusDeviceList.this.setChangedLastDate(false);
                        StatusDeviceList.this.updateStatusDevice();
                    }
                    try {
                        Thread.sleep(timeRepeat);
                        timeRepeatOccurence = timeRepeatOccurence + timeRepeat;
                        if (timeRepeatOccurence % (10L * timeRepeat) != 0L) continue;
                        i = 0;
                        while (i < StatusDeviceList.this.ndItems.size()) {
                            StatusDeviceExt sd1 = (StatusDeviceExt)StatusDeviceList.this.ndItems.get(i);
                            sd1.setOccurence(1);
                            ++i;
                        }
                        timeRepeatOccurence = 0L;
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        }.start();
    }

    private void updateStatusDevice() {
        if (this.getCurrentPC() == null || this.getCurrentPC().getPanel() == null) {
            return;
        }
        this.getCurrentPC().getPanel().updateUI();
    }

    private void calcLastData(final int i) {
        new Thread(){

            @Override
            public void run() {
                StatusDeviceExt sd1 = (StatusDeviceExt)StatusDeviceList.this.ndItems.get(i);
                if (sd1.getDeviceId() != null) {
                    Long deviceId = sd1.getDeviceId();
                    NDData nddata = null;
                    NDDataThin nddThin = StatusDeviceList.this.loadListLastPoint(deviceId);
                    if (nddThin == null) {
                        int j = 0;
                        while (j < countMonthLength) {
                            nddata = StatusDeviceList.this.loadLastPoint(deviceId, j + 1);
                            if (nddata == null) {
                                ++j;
                                continue;
                            }
                            break;
                        }
                    } else {
                        nddata = StatusDeviceList.this.loadCurrentPoint(nddThin.getId());
                    }
                    if (nddata != null && (sd1.getLastDate() == null || StatusDeviceList.this.mapLastDate.get(deviceId).compareTo(sd1.getLastDate()) < 0)) {
                        sd1.setLastDate(nddata.getCreatedDateTime());
                        sd1.setLat(nddata.getLat());
                        sd1.setLon(nddata.getLon());
                        sd1.setPowerValue(nddata.getPowerValue());
                        sd1.setOccurence(1);
                    }
                    sd1.setLevelMissing(StatusDeviceList.this.calcLevelMissing(sd1.getLastDate()));
                    sd1 = StatusDeviceList.this.fillFields(sd1, nddata);
                    StatusDeviceList.this.updateStatusDevice();
                    if (sd1.getLastDate() != null && (StatusDeviceList.this.mapLastDate.get(deviceId) == null || StatusDeviceList.this.mapLastDate.get(deviceId).compareTo(sd1.getLastDate()) < 0)) {
                        StatusDeviceList.this.mapLastDate.put(deviceId, sd1.getLastDate());
                    }
                }
            }
        }.start();
    }

    private StatusDeviceExt fillFields(StatusDeviceExt sd1, NDData nddata) {
        if (nddata == null) {
            if (sd1.getCommunication() == null || "".equals(sd1.getCommunication()) || "\u0437\u0430\u043f\u0440\u043e\u0441 \u0434\u0430\u043d\u043d\u044b\u0445...".equals(sd1.getCommunication())) {
                sd1.setCommunication("\u043d\u0435\u0442 \u0434\u0430\u043d\u043d\u044b\u0445");
                sd1.setGpssignal("---");
                sd1.setGsmSignalLevel("---");
                sd1.setSpeed("---");
                sd1.setIgnition("---");
                sd1.setState("---");
                sd1.setPower("---");
                sd1.setMileageKM(0.0);
                sd1.setMileage("---");
            }
        } else {
            if (sd1.getLevelMissing() > 0L) {
                sd1.setCommunication("\u043d\u0435\u0442 \u0441\u0432\u044f\u0437\u0438");
            } else {
                sd1.setCommunication("\u043d\u0430 \u0441\u0432\u044f\u0437\u0438");
            }
            sd1.setGpssignal(nddata.getGpsSatCount() == null ? "" : new DecimalFormat("#0").format(nddata.getGpsSatCount()));
            sd1.setGsmSignalLevel(nddata.getGsmSignalLevel() == null ? "" : new DecimalFormat("###0").format(nddata.getGsmSignalLevel()));
            sd1.setSpeed(new DecimalFormat("##0.00").format(nddata.getSpeed()));
            if (sd1.getLastDate().compareTo(this.getDateFrom()) > 0) {
                sd1.setIgnition("\u0432\u044b\u043a\u043b\u044e\u0447\u0435\u043d\u043e");
                if (this.calcIgnition(nddata) == 1) {
                    sd1.setIgnition("\u0432\u043a\u043b\u044e\u0447\u0435\u043d\u043e");
                }
                sd1.setState("\u0434\u0432\u0438\u0436\u0435\u043d\u0438\u0435");
                if (nddata.getSpeed() < this.minSpeed) {
                    sd1.setState("\u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0430");
                }
                sd1.setPower("\u0432\u044b\u043a\u043b\u044e\u0447\u0435\u043d\u043e");
                if (nddata.getPowerValue() != null && nddata.getPowerValue().compareTo(new Double("0.00")) > 0) {
                    sd1.setPower("\u0432\u043a\u043b\u044e\u0447\u0435\u043d\u043e");
                }
                sd1.setMileageKM(this.calcMileage(this.getDateFrom(), sd1.getLastDate(), sd1.getDeviceId()) / 1000.0);
                sd1.setMileage(new DecimalFormat("####0.00").format(sd1.getMileageKM()));
            } else {
                sd1.setIgnition("---");
                sd1.setState("---");
                sd1.setPower("---");
            }
        }
        return sd1;
    }

    private int calcIgnition(NDData nddata) {
        return 0;
    }

    private NDData loadCurrentPoint(Long id) {
        return this.ndDataWSProxy.getCurrentObject(InitializedVariable.context, id);
    }

    public NDDataThin loadListLastPoint(Long deviceId) {
        NDDataSearchCriteria sc = new NDDataSearchCriteria();
        sc.setDeviceIdList(new Long[]{deviceId});
        if (new Date().after(this.getDateTill())) {
            sc.setCreatedDateTimeFrom(this.getDateFrom());
            sc.setCreatedDateTimeTill(this.getDateTill());
        }
        sc.appendSorting(SortObject.getInstance((String)"createdDateTime", (String)SortObject.DIRECTION_DESC));
        NDDataThin[] listLastPoint = this.ndDataWSProxy.getLastDataThin(InitializedVariable.context, sc);
        if (listLastPoint.length > 0) {
            return listLastPoint[0];
        }
        return null;
    }

    public NDData loadLastPoint(Long deviceId, int countML) {
        Object[] listLastPoint;
        if (TrackAll.checkPeriod(new Date(this.getDateFrom().getTime() - (long)countML * monthLength), this.getDateTill(), this.periodDays4Track, "")) {
            return null;
        }
        NDDataSearchCriteria sc = new NDDataSearchCriteria();
        sc.setDeviceIdList(new Long[]{deviceId});
        sc.appendSorting(SortObject.getInstance((String)"createdDateTime", (String)SortObject.DIRECTION_DESC));
        sc.setCreatedDateTimeFrom(new Date(this.getDateFrom().getTime() - (long)countML * monthLength));
        sc.setCreatedDateTimeTill(this.getDateTill());
        sc.setCount(Integer.valueOf(1));
        NDDataWSProxy.SearchResultListNDData sr = this.ndDataWSProxy.getList(InitializedVariable.context, sc);
        if (!sr.isEmpty() && (listLastPoint = sr.getObjList()).length > 0) {
            return (NDData)listLastPoint[0];
        }
        return null;
    }

    private StatusDeviceExt calcStatusDevice(Date dateFrom, Long deviceId, StatusDeviceExt sd1) {
        NDData nddata = null;
        NDDataThin nddThin = this.loadListLastPoint(deviceId);
        if (nddThin != null) {
            nddata = this.loadCurrentPoint(nddThin.getId());
        }
        sd1.setOccurence(0);
        if (nddata != null && (sd1.getLastDate() == null || this.mapLastDate.get(deviceId).compareTo(nddata.getCreatedDateTime()) < 0)) {
            sd1.setLastDate(nddata.getCreatedDateTime());
            sd1.setLat(nddata.getLat());
            sd1.setLon(nddata.getLon());
            sd1.setPowerValue(nddata.getPowerValue());
            sd1.setOccurence(1);
        }
        sd1.setLevelMissing(this.calcLevelMissing(sd1.getLastDate()));
        sd1 = this.fillFields(sd1, nddata);
        if (sd1.getLastDate() != null && (this.mapLastDate.get(deviceId) == null || this.mapLastDate.get(deviceId).compareTo(sd1.getLastDate()) < 0)) {
            this.mapLastDate.put(deviceId, sd1.getLastDate());
        }
        return sd1;
    }

    public Double calcMileage(Date dateFrom, Date dateTill, Long deviceId) {
        MileageSearchCriteria sc = new MileageSearchCriteria();
        sc.setCreatedDateTimeFrom(dateFrom);
        sc.setCreatedDateTimeTill(dateTill);
        sc.setDeviceId(deviceId);
        Double mil = this.ndDataWSProxy.getMileage(InitializedVariable.context, sc);
        if (mil == null) {
            mil = 0.0;
        }
        return mil;
    }

    private void initEvents() {
        this.events = new ObjectUIListWithAutoRefresh<EventUI>(EventUI.class, "");
        this.eventSC = (EventSearchCriteria)((ObjectUIList)this.events).getSearchCriteria();
        this.eventSC.appendSorting(SortObject.getInstance((String)"importanceEvent.code", (String)SortObject.DIRECTION_DESC));
        this.eventSC.appendSorting(SortObject.getInstance((String)"eventDate", (String)SortObject.DIRECTION_DESC));
        this.eventSC.setEventDateFrom(this.getDateFrom());
        this.eventSC.setEventDateTill(this.getDateTill());
        this.eventSC.setCount(Integer.valueOf(countEvents));
        this.getEvents();
        ((ObjectUIListWithAutoRefresh)((Object)this.events)).setTotalFill(true);
    }

    private Long calcLevelMissing(Date createdDateTime) {
        if (createdDateTime == null) {
            return 2L;
        }
        Long period = new Date().getTime() - createdDateTime.getTime();
        if (period < periodOutside) {
            return 0L;
        }
        if (period < 2L * periodOutside) {
            return 1L;
        }
        return 2L;
    }

    @ListField(fields={@Field(title="", order=100, propertiesField={"className=ru.infor.ws.objects.vms.ext.StatusDeviceExt"}, viewer={ListStatusDeviceViewer.class}, propertiesLayout="Split1/v/l/0.3", panels={@PanelField(name="\u041e\u0441\u043d\u043e\u0432\u043d\u043e\u0435 \u043c\u0435\u043d\u044e", order=10, actions={@ActionField(clazz=RunReport.class)}), @PanelField(name="\u041e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435", order=20, classView={@ClassView(clazz=StatusDevicePanelBtn.class, order=20, name="Update")})}, content=StatusDeviceExt.class)})
    public List<StatusDeviceExt> getNdItems() {
        return this.ndItems;
    }

    public void updateSettingEvents() {
        this.eventSC = (EventSearchCriteria)((ObjectUIList)this.events).getSearchCriteria();
        this.eventSC.setEventDateFrom(this.getDateFrom());
        this.eventSC.setEventDateTill(this.getDateTill());
        ArrayList<Long> ll = new ArrayList<Long>();
        if (this.getDependentEL() == 1) {
            if (this.getInitiatorIdList() == null || this.getInitiatorIdList().size() == 0) {
                ll.add(-1L);
                this.setInitiatorIdList(ll);
            }
        } else {
            int i = 0;
            while (i < this.getNdItems().size()) {
                if (this.getNdItems().get(i).getDeviceId() != null) {
                    ll.add(this.getNdItems().get(i).getDeviceId());
                }
                ++i;
            }
            if (ll == null || ll.size() == 0) {
                ll.add(-1L);
            }
            this.setInitiatorIdList(ll);
        }
        this.eventSC.setInitiatorIdList(this.getInitiatorIdList().toArray(new Long[this.getInitiatorIdList().size()]));
        this.eventSC.setCount(Integer.valueOf(countEvents));
        ((ObjectUIListWithAutoRefresh)((Object)this.events)).compromateAllData();
    }

    public void setNdItems(List<StatusDeviceExt> ndItems) {
        this.ndItems = ndItems;
    }

    public void setMasterObjectsEvents(List<Object> selDetP) {
        this.selDetP = selDetP;
    }

    @ListField(fields={@Field(title="\u0416\u0443\u0440\u043d\u0430\u043b \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0439", master="ndItems", order=300, propertiesField={"className=ru.infor.ws.objects.events.entities.ext.EventExt"}, viewer={ListEventsViewer.class}, propertiesLayout="Split1/v/r/0.7:Split2/h/l/0.3", panels={}, content=EventUI.class)})
    public List<EventUI> getEvents() {
        if (this.getDependentEL() == 1) {
            this.changeInitiator();
            this.updateSettingEvents();
        }
        return this.events;
    }

    public void changeInitiator() {
        if (this.getDependentEL() == 1) {
            ArrayList<Long> idDocList = new ArrayList<Long>();
            if (this.selDetP != null) {
                int i = 0;
                while (i < this.selDetP.size()) {
                    if (((StatusDeviceExt)this.selDetP.get(i)).getDeviceId() != null) {
                        idDocList.add(((StatusDeviceExt)this.selDetP.get(i)).getDeviceId());
                    }
                    ++i;
                }
            } else if (this.getInitiatorIdList() != null && this.getInitiatorIdList().size() > 0) {
                idDocList.add(this.getInitiatorIdList().get(0));
            }
            this.setInitiatorIdList(idDocList);
        }
    }

    public void setEvents(List<EventUI> events) {
        this.events = events;
    }

    public void setMasterObjectsValue(List<Object> selDetV) {
        this.selDetV = selDetV;
    }

    @ListField(fields={@Field(title="", master="ndItems", order=500, viewer={MapViewerWithOneTrack.class}, propertiesLayout="Split1/v/r/0.7:Split2/h/r/0.7")})
    public MapValueWithTrack getValue() {
        if (this.value != null && this.value.mapViewerWithTrack != null && this.selDetV != null) {
            this.displayMap((StatusDeviceExt)this.selDetV.get(0));
        }
        return this.value;
    }

    public void displayMap(StatusDeviceExt obj) {
        List<AbstractNDData> list = new ArrayList<AbstractNDData>();
        if (obj.getDeviceId() != null) {
            if (this.getDisplayMap() == 1) {
                Date dTill = this.mapLastDate.get(obj.getDeviceId());
                if (dTill == null) {
                    dTill = this.getDateTill();
                }
                list = this.cache.getData(this.calcDateFrom(dTill), dTill, new Long[]{obj.getDeviceId()}, null);
            } else {
                NDData nd = new NDData();
                nd.setDeviceId(obj.getDeviceId());
                nd.setCreatedDateTime(obj.getLastDate());
                nd.setLat(obj.getLat());
                nd.setLon(obj.getLon());
                list.add((AbstractNDData)nd);
            }
        }
        this.viewPart(list);
    }

    private Date calcDateFrom(Date dTill) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(dTill);
        cal.add(12, -this.getTailInMinute().intValue());
        return cal.getTime();
    }

    public void viewPart(List<AbstractNDData> list) {
        this.value.getTracksNDData().clear();
        if (list != null && list.size() != 0 && list.get(0).getLat() != null && list.get(0).getLon() != null) {
            int i = 0;
            this.value.eventAll(list.get(i).getDeviceId(), list, i, i + list.size() - 1, false, null);
            AbstractNDData nd = list.get(list.size() - 1);
            Double[] dd = this.getMinMax(list);
            this.value.setCenterPosition(new double[]{nd.getLat(), nd.getLon()});
            int zoom = this.value.mapViewerWithTrack.getZoom(dd);
            if (zoom < 5) {
                zoom = 5;
            }
            this.value.setZoomValue(zoom + 1);
        } else {
            this.value.setCenterPosition(new double[]{this.coord[0], this.coord[1]});
            this.value.setZoomValue(6);
        }
    }

    public Double[] getMinMax(List<AbstractNDData> list) {
        if (list != null && list.size() > 0) {
            Double minLat = Math.min(list.get(0).getLat(), list.get(list.size() - 1).getLat());
            Double maxLat = Math.max(list.get(0).getLat(), list.get(list.size() - 1).getLat());
            Double minLon = Math.min(list.get(0).getLon(), list.get(list.size() - 1).getLon());
            Double maxLon = Math.max(list.get(0).getLon(), list.get(list.size() - 1).getLon());
            return new Double[]{minLat, maxLat, minLon, maxLon};
        }
        return null;
    }

    public List<Long> getInitiatorIdList() {
        return this.initiatorIdList;
    }

    public void setInitiatorIdList(List<Long> initiatorIdList) {
        this.initiatorIdList = initiatorIdList;
    }

    public Date getDateFrom() {
        return this.dateFrom;
    }

    public void setDateFrom(Date dateFrom) {
        this.dateFrom = dateFrom;
    }

    public Date getDateTill() {
        return this.dateTill;
    }

    public void setDateTill(Date dateTill) {
        this.dateTill = dateTill;
    }

    public void setPeriodDate(Date dateFrom, Date dateTill) {
        this.dateFrom = dateFrom;
        this.dateTill = dateTill;
    }

    public Integer getDependentEL() {
        return this.dependentEL;
    }

    public void setDependentEL(Integer dependentEL) {
        this.dependentEL = dependentEL;
    }

    public Integer getDisplayMap() {
        return this.displayMap;
    }

    public void setDisplayMap(Integer displayMap) {
        this.displayMap = displayMap;
    }

    public TransportGroup getGroup() {
        return this.group;
    }

    public void setGroup(TransportGroup group) {
        this.group = group;
    }

    public boolean isRefreshData() {
        return this.refreshData;
    }

    public void setRefreshData(boolean refreshData) {
        this.refreshData = refreshData;
    }

    public boolean isChangedLastDate() {
        return this.changedLastDate;
    }

    public void setChangedLastDate(boolean changedLastDate) {
        this.changedLastDate = changedLastDate;
    }

    public PanelContext getCurrentPC() {
        return this.currentPC;
    }

    public void setCurrentPC(PanelContext currentPC) {
        this.currentPC = currentPC;
    }

    public Integer getTailInMinute() {
        if (this.tailInMinute != null && this.tailInMinute > 0) {
            return this.tailInMinute;
        }
        return 10;
    }

    public void setTailInMinute(Integer tailInMinute) {
        this.tailInMinute = tailInMinute;
    }
}

